/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.checks.moving;

import cc.co.evenprime.bukkit.nocheat.NoCheat;
import cc.co.evenprime.bukkit.nocheat.actions.ActionExecutor;
import cc.co.evenprime.bukkit.nocheat.actions.ActionExecutorWithHistory;
import cc.co.evenprime.bukkit.nocheat.checks.moving.MovingEventHelper;
import cc.co.evenprime.bukkit.nocheat.config.cache.ConfigurationCache;
import cc.co.evenprime.bukkit.nocheat.data.MovingData;
import java.util.HashMap;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class NoclipCheck {
    private final double bodyHeight = 1.1;
    private final ActionExecutor action;

    public NoclipCheck(NoCheat plugin) {
        this.action = new ActionExecutorWithHistory(plugin);
    }

    public Location check(Player player, Location from, Location to, MovingEventHelper helper, ConfigurationCache cc, MovingData data) {
        int oldZ;
        int newZ;
        int oldY;
        int newY;
        int oldX;
        int newX;
        Location current = from.clone();
        double distanceX = to.getX() - current.getX();
        double distanceY = to.getY() - current.getY();
        double distanceZ = to.getZ() - current.getZ();
        current.setY(current.getY() + 1.1);
        double distance = Math.abs(distanceX) > Math.abs(distanceY) ? (Math.abs(distanceX) > Math.abs(distanceZ) ? Math.abs(distanceX) : Math.abs(distanceZ)) : (Math.abs(distanceY) > Math.abs(distanceZ) ? Math.abs(distanceY) : Math.abs(distanceZ));
        int steps = (int)(distance / 0.1) + 1;
        double divideBy = distance * 10.0;
        double stepX = distanceX / divideBy;
        double stepY = distanceY / divideBy;
        double stepZ = distanceZ / divideBy;
        World world = from.getWorld();
        if (Math.abs(data.noclipX - current.getBlockX()) > 1 || Math.abs(data.noclipY - current.getBlockY()) > 1 || Math.abs(data.noclipZ - current.getBlockZ()) > 1) {
            oldX = newX = current.getBlockX();
            oldY = newY = current.getBlockY();
            oldZ = newZ = current.getBlockZ();
        } else {
            oldX = newX = data.noclipX;
            oldY = newY = data.noclipY;
            oldZ = newZ = data.noclipZ;
        }
        int violationLevel = 0;
        int i = 0;
        while (i < steps) {
            newX = current.getBlockX();
            newY = current.getBlockY();
            newZ = current.getBlockZ();
            boolean xChanged = newX != oldX;
            boolean yChanged = newY != oldY;
            boolean zChanged = newZ != oldZ;
            boolean failed = false;
            if (!failed && (xChanged || yChanged || zChanged)) {
                failed = this.check(helper, world, newX, newY, newZ);
                if (!failed && xChanged && (yChanged || zChanged)) {
                    failed = this.check(helper, world, oldX, newY, newZ);
                }
                if (!failed && yChanged && (xChanged || zChanged)) {
                    failed = this.check(helper, world, newX, oldY, newZ);
                }
                if (!failed && zChanged && (xChanged || yChanged)) {
                    failed = this.check(helper, world, newX, newY, oldZ);
                }
                oldX = newX;
                oldY = newY;
                oldZ = newZ;
            }
            if (failed) {
                ++violationLevel;
            }
            current.add(stepX, stepY, stepZ);
            ++i;
        }
        if (violationLevel > 0) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("\\[distance\\]", String.format(Locale.US, "%.2f,%.2f,%.2f", to.getX() - from.getX(), to.getY() - from.getY(), to.getZ() - from.getZ()));
            params.put("\\[locationto\\]", String.format(Locale.US, "%.2f,%.2f,%.2f", to.getX(), to.getY(), to.getZ()));
            params.put("\\[check\\]", "noclip");
            boolean bl = this.action.executeActions(player, cc.moving.noclipActions, violationLevel, params, cc);
        }
        data.noclipX = newX;
        data.noclipY = newY;
        data.noclipZ = newZ;
        return null;
    }

    private final boolean check(MovingEventHelper helper, World world, int x, int y, int z) {
        if (y < 0 || y > 127) {
            return false;
        }
        return !helper.isNonSolid(helper.types[world.getBlockAt(x, y, z).getTypeId()]);
    }
}

