/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.log;

import java.util.logging.Level;

public enum LogLevel {
    OFF("off", "never", Level.OFF),
    LOW("low", "all messages", Level.INFO),
    MED("med", "important messages", Level.WARNING),
    HIGH("high", "very important messages", Level.SEVERE);

    public final String name;
    private final String description;
    public final Level level;

    private LogLevel(String name, String description, Level level) {
        this.name = name;
        this.description = description;
        this.level = level;
    }

    public static LogLevel getLogLevelFromString(String s) {
        if (s == null) {
            return OFF;
        }
        if ("off".equals(s)) {
            return OFF;
        }
        if ("low".equals(s)) {
            return LOW;
        }
        if ("med".equals(s)) {
            return MED;
        }
        if ("high".equals(s)) {
            return HIGH;
        }
        return OFF;
    }

    public String toString() {
        return String.valueOf(this.name()) + ": " + this.description;
    }

    public boolean matches(LogLevel level) {
        if (this == OFF || level == OFF) {
            return false;
        }
        return this.level.intValue() <= level.level.intValue();
    }
}

