/*
 * Decompiled with CFR 0.152.
 */
package cc.co.evenprime.bukkit.nocheat.log;

import cc.co.evenprime.bukkit.nocheat.NoCheat;
import cc.co.evenprime.bukkit.nocheat.config.cache.ConfigurationCache;
import cc.co.evenprime.bukkit.nocheat.log.LogLevel;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class LogManager {
    private final NoCheat plugin;

    public LogManager(NoCheat plugin) {
        this.plugin = plugin;
    }

    public void log(LogLevel level, String message, ConfigurationCache cc) {
        if (!cc.logging.active) {
            return;
        }
        if (cc.logging.fileLevel.matches(level)) {
            this.logToFile(level, message, cc.logging.filelogger);
        }
        if (cc.logging.consoleLevel.matches(level)) {
            this.logToConsole(level, message);
        }
        if (cc.logging.chatLevel.matches(level)) {
            this.logToChat(level, message);
        }
    }

    public void logToConsole(LogLevel level, String message) {
        Logger.getLogger("Minecraft").log(level.level, message);
    }

    public void logToChat(LogLevel level, String message) {
        Player[] playerArray = Bukkit.getServer().getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            if (player.hasPermission("nocheat.admin.chatlog")) {
                player.sendMessage(message);
            }
            ++n2;
        }
    }

    public void logToFile(LogLevel level, String message, Logger fileLogger) {
        fileLogger.log(level.level, message);
    }
}

