/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Config;
import de.diddiz.LogBlock.Consumer;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.LookupCacheElement;
import de.diddiz.LogBlock.LookupCacheElementFactory;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.Session;
import de.diddiz.LogBlock.Tool;
import de.diddiz.LogBlock.ToolData;
import de.diddiz.LogBlock.ToolMode;
import de.diddiz.LogBlock.WorldConfig;
import de.diddiz.LogBlock.WorldEditor;
import de.diddiz.LogBlockQuestioner.LogBlockQuestioner;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class CommandsHandler
implements CommandExecutor {
    private final Logger log;
    private final LogBlock logblock;
    private final Config config;
    private final BukkitScheduler scheduler;
    private final LogBlockQuestioner questioner;

    CommandsHandler(LogBlock logBlock) {
        this.logblock = logBlock;
        this.log = logBlock.getServer().getLogger();
        this.config = logBlock.getConfig();
        this.scheduler = logBlock.getServer().getScheduler();
        this.questioner = (LogBlockQuestioner)logBlock.getServer().getPluginManager().getPlugin("LogBlockQuestioner");
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        block110: {
            if (!command.getName().equalsIgnoreCase("lb")) {
                return false;
            }
            try {
                if (stringArray.length == 0) {
                    commandSender.sendMessage(ChatColor.LIGHT_PURPLE + "LogBlock v" + this.logblock.getDescription().getVersion() + " by DiddiZ");
                    if (this.config.checkVersion) {
                        commandSender.sendMessage(ChatColor.LIGHT_PURPLE + this.logblock.getUpdater().checkVersion());
                    }
                    commandSender.sendMessage(ChatColor.LIGHT_PURPLE + "Type /lb help for help");
                    break block110;
                }
                String string2 = stringArray[0].toLowerCase();
                if (string2.equals("help")) {
                    commandSender.sendMessage(ChatColor.DARK_AQUA + "LogBlock Help:");
                    commandSender.sendMessage(ChatColor.GOLD + "For the commands list type '/lb commands'");
                    commandSender.sendMessage(ChatColor.GOLD + "For the parameters list type '/lb params'");
                    commandSender.sendMessage(ChatColor.GOLD + "For the list of permissions you got type '/lb permissions'");
                    break block110;
                }
                if (string2.equals("commands")) {
                    commandSender.sendMessage(ChatColor.DARK_AQUA + "LogBlock Commands:");
                    commandSender.sendMessage(ChatColor.GOLD + "/lb tool -- Gives you the lb tool");
                    commandSender.sendMessage(ChatColor.GOLD + "/lb tool [on|off] -- Enables/Disables tool");
                    commandSender.sendMessage(ChatColor.GOLD + "/lb tool [params] -- Sets the tool lookup query");
                    commandSender.sendMessage(ChatColor.GOLD + "/lb tool default -- Sets the tool lookup query to default");
                    commandSender.sendMessage(ChatColor.GOLD + "/lb toolblock -- Analog to tool");
                    commandSender.sendMessage(ChatColor.GOLD + "/lb hide -- Hides you from log");
                    commandSender.sendMessage(ChatColor.GOLD + "/lb rollback [params] -- Rollback");
                    commandSender.sendMessage(ChatColor.GOLD + "/lb redo [params] -- Redo");
                    commandSender.sendMessage(ChatColor.GOLD + "/lb tp [params] -- Teleports you to the location of griefing");
                    commandSender.sendMessage(ChatColor.GOLD + "/lb writelogfile [params] -- Writes a log file");
                    commandSender.sendMessage(ChatColor.GOLD + "/lb lookup [params] -- Lookup");
                    commandSender.sendMessage(ChatColor.GOLD + "/lb prev|next -- Browse lookup result pages");
                    commandSender.sendMessage(ChatColor.GOLD + "/lb page -- Shows a specific lookup result page");
                    commandSender.sendMessage(ChatColor.GOLD + "/lb me -- Displays your stats");
                    commandSender.sendMessage(ChatColor.GOLD + "Look at github.com/DiddiZ/LogBlock/wiki/Commands for the full commands reference");
                    break block110;
                }
                if (string2.equals("params")) {
                    commandSender.sendMessage(ChatColor.DARK_AQUA + "LogBlock Query Parameters:");
                    commandSender.sendMessage(ChatColor.GOLD + "Use doublequotes to escape a keyword: world \"world\"");
                    commandSender.sendMessage(ChatColor.GOLD + "player [name1] <name2> <name3> -- List of players");
                    commandSender.sendMessage(ChatColor.GOLD + "block [type1] <type2> <type3> -- List of block types");
                    commandSender.sendMessage(ChatColor.GOLD + "created, destroyed -- Show only created/destroyed blocks");
                    commandSender.sendMessage(ChatColor.GOLD + "chestaccess -- Show only chest accesses");
                    commandSender.sendMessage(ChatColor.GOLD + "area <radius> -- Area around you");
                    commandSender.sendMessage(ChatColor.GOLD + "selection, sel -- Inside current WorldEdit selection");
                    commandSender.sendMessage(ChatColor.GOLD + "world [worldname] -- Changes the world");
                    commandSender.sendMessage(ChatColor.GOLD + "time [number] [minutes|hours|days] -- Limits time");
                    commandSender.sendMessage(ChatColor.GOLD + "since <dd.MM.yyyy> <HH:mm:ss> -- Limits time to a fixed point");
                    commandSender.sendMessage(ChatColor.GOLD + "before <dd.MM.yyyy> <HH:mm:ss> -- Affects only blocks before a fixed time");
                    commandSender.sendMessage(ChatColor.GOLD + "limit <row count> -- Limits the result to count of rows");
                    commandSender.sendMessage(ChatColor.GOLD + "sum [none|blocks|players] -- Sums the result");
                    commandSender.sendMessage(ChatColor.GOLD + "asc, desc -- Changes the order of the displayed log");
                    commandSender.sendMessage(ChatColor.GOLD + "coords -- Shows coordinates for each block");
                    commandSender.sendMessage(ChatColor.GOLD + "silent -- Displays lesser messages");
                    break block110;
                }
                if (string2.equals("permissions")) {
                    String[] stringArray2 = new String[]{"me", "lookup", "tp", "rollback", "clearlog", "hide", "ignoreRestrictions"};
                    commandSender.sendMessage(ChatColor.DARK_AQUA + "You've got the following permissions:");
                    for (String string3 : stringArray2) {
                        if (!this.logblock.hasPermission(commandSender, "logblock." + string3)) continue;
                        commandSender.sendMessage(ChatColor.GOLD + "logblock." + string3);
                    }
                    for (Tool tool : this.config.toolsByType.values()) {
                        if (!this.logblock.hasPermission(commandSender, "logblock.tools." + tool.name)) continue;
                        commandSender.sendMessage(ChatColor.GOLD + "logblock.tools." + tool.name);
                    }
                    break block110;
                }
                if (string2.equals("logging")) {
                    if (commandSender instanceof Player) {
                        String string4 = ((Player)commandSender).getWorld().getName();
                        WorldConfig worldConfig = this.config.worlds.get(string4.hashCode());
                        commandSender.sendMessage(ChatColor.DARK_AQUA + "Currently logging in " + string4 + ":");
                        String string5 = "";
                        if (worldConfig.logBlockPlacings) {
                            string5 = string5 + ", BlockPlacings";
                        }
                        if (worldConfig.logBlockBreaks) {
                            string5 = string5 + ", BlockBreaks";
                        }
                        if (worldConfig.logSignTexts) {
                            string5 = string5 + ", SignTexts";
                        }
                        if (worldConfig.logExplosions) {
                            string5 = string5 + ", Explosions";
                        }
                        if (worldConfig.logFire) {
                            string5 = string5 + ", Fire";
                        }
                        if (worldConfig.logLeavesDecay) {
                            string5 = string5 + ", LeavesDecay";
                        }
                        if (worldConfig.logLavaFlow) {
                            string5 = string5 + ", LavaFlow";
                        }
                        if (worldConfig.logWaterFlow) {
                            string5 = string5 + ", WaterFlow";
                        }
                        if (worldConfig.logChestAccess) {
                            string5 = string5 + ", ChestAccess";
                        }
                        if (worldConfig.logButtonsAndLevers) {
                            string5 = string5 + ", ButtonsAndLevers";
                        }
                        if (worldConfig.logKills) {
                            string5 = string5 + ", Kills";
                        }
                        if (worldConfig.logChat) {
                            string5 = string5 + ", Chat";
                        }
                        commandSender.sendMessage(ChatColor.GOLD + string5.substring(2));
                    }
                    break block110;
                }
                if (this.config.toolsByName.get(string2) != null) {
                    if (commandSender instanceof Player) {
                        Player player = (Player)commandSender;
                        Session session = this.logblock.getSession(player.getName());
                        Tool tool = this.config.toolsByName.get(string2);
                        ToolData toolData = session.toolData.get(tool);
                        if (stringArray.length == 1) {
                            if (this.logblock.hasPermission((CommandSender)player, "logblock.tools." + tool.name)) {
                                BukkitUtils.giveTool(player, tool.item);
                                session.toolData.get((Object)tool).enabled = true;
                            } else {
                                commandSender.sendMessage(ChatColor.RED + "You aren't allowed to do this.");
                            }
                            break block110;
                        }
                        if (stringArray[1].equalsIgnoreCase("enable") || stringArray[1].equalsIgnoreCase("on")) {
                            toolData.enabled = true;
                            player.sendMessage(ChatColor.GREEN + "Tool enabled.");
                            break block110;
                        }
                        if (stringArray[1].equalsIgnoreCase("disable") || stringArray[1].equalsIgnoreCase("off")) {
                            toolData.enabled = false;
                            player.getInventory().removeItem(new ItemStack[]{new ItemStack(tool.item, 1)});
                            player.sendMessage(ChatColor.GREEN + "Tool disabled.");
                            break block110;
                        }
                        if (stringArray[1].equalsIgnoreCase("mode")) {
                            if (stringArray.length == 3) {
                                ToolMode toolMode;
                                try {
                                    toolMode = ToolMode.valueOf(stringArray[2].toUpperCase());
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    commandSender.sendMessage(ChatColor.RED + "Can't find mode " + stringArray[2]);
                                    return true;
                                }
                                if (this.logblock.hasPermission((CommandSender)player, toolMode.getPermission())) {
                                    toolData.mode = toolMode;
                                    commandSender.sendMessage(ChatColor.GREEN + "Tool mode set to " + stringArray[2]);
                                } else {
                                    commandSender.sendMessage(ChatColor.RED + "You aren't allowed to use mode " + stringArray[2]);
                                }
                                break block110;
                            }
                            player.sendMessage(ChatColor.RED + "No mode specified");
                            break block110;
                        }
                        if (stringArray[1].equalsIgnoreCase("default")) {
                            toolData.params = tool.params.clone();
                            toolData.mode = tool.mode;
                            commandSender.sendMessage(ChatColor.GREEN + "Tool set to default.");
                        } else if (this.logblock.hasPermission((CommandSender)player, "logblock.lookup")) {
                            try {
                                QueryParams queryParams = tool.params.clone();
                                queryParams.parseArgs(commandSender, CommandsHandler.argsToList(stringArray, 1));
                                toolData.params = queryParams;
                                commandSender.sendMessage(ChatColor.GREEN + "Set tool query to: " + queryParams.getTitle());
                            }
                            catch (Exception exception) {
                                commandSender.sendMessage(ChatColor.RED + exception.getMessage());
                            }
                        } else {
                            commandSender.sendMessage(ChatColor.RED + "You aren't allowed to do this.");
                        }
                        break block110;
                    }
                    commandSender.sendMessage(ChatColor.RED + "You have to be a player.");
                    break block110;
                }
                if (string2.equals("hide")) {
                    if (commandSender instanceof Player) {
                        if (this.logblock.hasPermission(commandSender, "logblock.hide")) {
                            if (this.logblock.getConsumer().hide((Player)commandSender)) {
                                commandSender.sendMessage(ChatColor.GREEN + "You are now hidden and aren't logged. Type '/lb hide' again to unhide");
                            } else {
                                commandSender.sendMessage(ChatColor.GREEN + "You aren't hidden anylonger.");
                            }
                        } else {
                            commandSender.sendMessage(ChatColor.RED + "You aren't allowed to do this.");
                        }
                    } else {
                        commandSender.sendMessage(ChatColor.RED + "You have to be a player.");
                    }
                } else if (string2.equals("page")) {
                    if (stringArray.length == 2 && Utils.isInt(stringArray[1])) {
                        this.showPage(commandSender, Integer.valueOf(stringArray[1]));
                    } else {
                        commandSender.sendMessage(ChatColor.RED + "You have to specify a page");
                    }
                } else if (string2.equals("next") || string2.equals("+")) {
                    this.showPage(commandSender, this.logblock.getSession((String)BukkitUtils.senderName((CommandSender)commandSender)).page + 1);
                } else if (string2.equals("prev") || string2.equals("-")) {
                    this.showPage(commandSender, this.logblock.getSession((String)BukkitUtils.senderName((CommandSender)commandSender)).page - 1);
                } else if (stringArray[0].equalsIgnoreCase("savequeue")) {
                    if (this.logblock.hasPermission(commandSender, "logblock.rollback")) {
                        new CommandSaveQueue(commandSender, null, true);
                    } else {
                        commandSender.sendMessage(ChatColor.RED + "You aren't allowed to do this.");
                    }
                } else if (stringArray[0].equalsIgnoreCase("queuesize")) {
                    if (this.logblock.hasPermission(commandSender, "logblock.rollback")) {
                        commandSender.sendMessage("Current queue size: " + this.logblock.getConsumer().getQueueSize());
                    } else {
                        commandSender.sendMessage(ChatColor.RED + "You aren't allowed to do this.");
                    }
                } else if (string2.equals("rollback") || string2.equals("undo") || string2.equals("rb")) {
                    if (this.logblock.hasPermission(commandSender, "logblock.rollback")) {
                        QueryParams queryParams = new QueryParams(this.logblock);
                        queryParams.since = this.logblock.getConfig().defaultTime;
                        queryParams.bct = QueryParams.BlockChangeType.ALL;
                        queryParams.parseArgs(commandSender, CommandsHandler.argsToList(stringArray, 1));
                        new CommandRollback(commandSender, queryParams, true);
                    } else {
                        commandSender.sendMessage(ChatColor.RED + "You aren't allowed to do this.");
                    }
                } else if (string2.equals("redo")) {
                    if (this.logblock.hasPermission(commandSender, "logblock.rollback")) {
                        QueryParams queryParams = new QueryParams(this.logblock);
                        queryParams.since = this.logblock.getConfig().defaultTime;
                        queryParams.bct = QueryParams.BlockChangeType.ALL;
                        queryParams.parseArgs(commandSender, CommandsHandler.argsToList(stringArray, 1));
                        new CommandRedo(commandSender, queryParams, true);
                    } else {
                        commandSender.sendMessage(ChatColor.RED + "You aren't allowed to do this.");
                    }
                } else if (string2.equals("me")) {
                    if (commandSender instanceof Player) {
                        if (this.logblock.hasPermission(commandSender, "logblock.me")) {
                            Player player = (Player)commandSender;
                            QueryParams queryParams = new QueryParams(this.logblock);
                            queryParams.setPlayer(player.getName());
                            queryParams.sum = QueryParams.SummarizationMode.TYPES;
                            queryParams.world = player.getWorld();
                            new CommandLookup(commandSender, queryParams, true);
                        } else {
                            commandSender.sendMessage(ChatColor.RED + "You aren't allowed to do this.");
                        }
                    } else {
                        commandSender.sendMessage(ChatColor.RED + "You have to be a player.");
                    }
                } else if (string2.equals("writelogfile")) {
                    if (this.logblock.hasPermission(commandSender, "logblock.rollback")) {
                        QueryParams queryParams = new QueryParams(this.logblock);
                        queryParams.limit = -1;
                        queryParams.bct = QueryParams.BlockChangeType.ALL;
                        queryParams.parseArgs(commandSender, CommandsHandler.argsToList(stringArray, 1));
                        new CommandWriteLogFile(commandSender, queryParams, true);
                    } else {
                        commandSender.sendMessage(ChatColor.RED + "You aren't allowed to do this");
                    }
                } else if (string2.equals("clearlog")) {
                    if (this.logblock.hasPermission(commandSender, "logblock.clearlog")) {
                        QueryParams queryParams = new QueryParams(this.logblock, commandSender, CommandsHandler.argsToList(stringArray, 1));
                        queryParams.bct = QueryParams.BlockChangeType.ALL;
                        queryParams.limit = -1;
                        new CommandClearLog(commandSender, queryParams, true);
                    } else {
                        commandSender.sendMessage(ChatColor.RED + "You aren't allowed to do this");
                    }
                } else if (string2.equals("tp")) {
                    if (commandSender instanceof Player) {
                        if (this.logblock.hasPermission(commandSender, "logblock.tp")) {
                            if (stringArray.length == 2 || Utils.isInt(stringArray[1])) {
                                int n = Integer.parseInt(stringArray[1]) - 1;
                                Player player = (Player)commandSender;
                                Session session = this.logblock.getSession(player.getName());
                                if (session.lookupCache != null) {
                                    if (n >= 0 && n < session.lookupCache.length) {
                                        Location location = session.lookupCache[n].getLocation();
                                        if (location != null) {
                                            player.teleport(new Location(location.getWorld(), location.getX() + 0.5, (double)BukkitUtils.saveSpawnHeight(location), location.getZ() + 0.5, player.getLocation().getYaw(), 90.0f));
                                            player.sendMessage(ChatColor.LIGHT_PURPLE + "Teleported to " + location.getBlockX() + ":" + location.getBlockY() + ":" + location.getBlockZ());
                                        } else {
                                            commandSender.sendMessage(ChatColor.RED + "There is no location associated with that. Did you forget coords parameter?");
                                        }
                                    } else {
                                        commandSender.sendMessage(ChatColor.RED + "'" + stringArray[1] + " is out of range");
                                    }
                                } else {
                                    commandSender.sendMessage(ChatColor.RED + "You havn't done a lookup yet");
                                }
                            } else {
                                new CommandTeleport(commandSender, new QueryParams(this.logblock, commandSender, CommandsHandler.argsToList(stringArray, 1)), true);
                            }
                        } else {
                            commandSender.sendMessage(ChatColor.RED + "You aren't allowed to do this");
                        }
                    } else {
                        commandSender.sendMessage(ChatColor.RED + "You have to be a player.");
                    }
                } else if (string2.equals("lookup") || QueryParams.isKeyWord(stringArray[0])) {
                    if (this.logblock.hasPermission(commandSender, "logblock.lookup")) {
                        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
                        if (string2.equals("lookup")) {
                            arrayList.remove(0);
                        }
                        new CommandLookup(commandSender, new QueryParams(this.logblock, commandSender, arrayList), true);
                    } else {
                        commandSender.sendMessage(ChatColor.RED + "You aren't allowed to do this");
                    }
                } else {
                    commandSender.sendMessage(ChatColor.RED + "Unknown command '" + stringArray[0] + "'");
                }
            }
            catch (NullPointerException nullPointerException) {
                commandSender.sendMessage(ChatColor.RED + "Error, check log");
                this.log.log(Level.WARNING, "[LogBlock] NPE in commandshandler: ", nullPointerException);
            }
            catch (Exception exception) {
                commandSender.sendMessage(ChatColor.RED + exception.getMessage());
            }
        }
        return true;
    }

    private void showPage(CommandSender commandSender, int n) {
        Session session = this.logblock.getSession(BukkitUtils.senderName(commandSender));
        if (session.lookupCache != null && session.lookupCache.length > 0) {
            int n2 = (n - 1) * this.config.linesPerPage;
            if (n > 0 && n2 <= session.lookupCache.length - 1) {
                int n3 = n2 + this.config.linesPerPage >= session.lookupCache.length ? session.lookupCache.length - 1 : n2 + this.config.linesPerPage - 1;
                int n4 = (int)Math.ceil((double)session.lookupCache.length / (double)this.config.linesPerPage);
                if (n4 != 1) {
                    commandSender.sendMessage(ChatColor.DARK_AQUA + "Page " + n + "/" + n4);
                }
                for (int i = n2; i <= n3; ++i) {
                    commandSender.sendMessage(ChatColor.GOLD + (session.lookupCache[i].getLocation() != null ? "(" + (i + 1) + ") " : "") + session.lookupCache[i].getMessage());
                }
                session.page = n;
            } else {
                commandSender.sendMessage(ChatColor.RED + "There isn't a page '" + n + "'");
            }
        } else {
            commandSender.sendMessage(ChatColor.RED + "No blocks in lookup cache");
        }
    }

    private boolean checkRestrictions(CommandSender commandSender, QueryParams queryParams) {
        if (this.logblock.hasPermission(commandSender, "logblock.ignoreRestrictions")) {
            return true;
        }
        if (this.config.rollbackMaxTime > 0 && (queryParams.before > 0 || queryParams.since > this.config.rollbackMaxTime)) {
            commandSender.sendMessage(ChatColor.RED + "You are not allowed to rollback more than " + this.config.rollbackMaxTime + " minutes");
            return false;
        }
        if (this.config.rollbackMaxArea > 0 && (queryParams.sel == null && queryParams.loc == null || queryParams.radius > this.config.rollbackMaxArea || queryParams.sel != null && (queryParams.sel.getLength() > this.config.rollbackMaxArea || queryParams.sel.getWidth() > this.config.rollbackMaxArea))) {
            commandSender.sendMessage(ChatColor.RED + "You are not allowed to rollback an area larger than " + this.config.rollbackMaxArea + " blocks");
            return false;
        }
        return true;
    }

    private static List<String> argsToList(String[] stringArray, int n) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        for (int i = 0; i < n; ++i) {
            arrayList.remove(0);
        }
        return arrayList;
    }

    public class CommandClearLog
    extends AbstractCommand {
        public CommandClearLog(CommandSender commandSender, QueryParams queryParams, boolean bl) throws Exception {
            super(commandSender, queryParams, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.conn = CommandsHandler.this.logblock.getConnection();
                this.state = this.conn.createStatement();
                if (!CommandsHandler.this.checkRestrictions(this.sender, this.params)) {
                    return;
                }
                File file = new File(CommandsHandler.this.logblock.getDataFolder(), "dump");
                if (!file.exists()) {
                    file.mkdirs();
                }
                String string = new SimpleDateFormat("yyMMddHHmmss").format(System.currentTimeMillis());
                String string2 = this.params.getTable();
                String string3 = this.params.players.size() > 0 ? "INNER JOIN `lb-players` USING (playerid) " : "";
                this.rs = this.state.executeQuery("SELECT count(*) FROM `" + string2 + "` " + string3 + this.params.getWhere());
                this.rs.next();
                int n = this.rs.getInt(1);
                if (n > 0) {
                    if (!this.params.silent && ((CommandsHandler)CommandsHandler.this).config.askClearLogs && this.sender instanceof Player && CommandsHandler.this.questioner != null) {
                        this.sender.sendMessage(ChatColor.DARK_AQUA + "Searching " + this.params.getTitle() + ":");
                        this.sender.sendMessage(ChatColor.GREEN.toString() + n + " blocks found.");
                        if (!CommandsHandler.this.questioner.ask((Player)this.sender, "Are you sure you want to continue?", "yes", "no").equals("yes")) {
                            this.sender.sendMessage(ChatColor.RED + "ClearLog aborted");
                            return;
                        }
                    }
                    if (((CommandsHandler)CommandsHandler.this).config.dumpDeletedLog) {
                        try {
                            this.state.execute("SELECT * FROM `" + string2 + "` " + string3 + this.params.getWhere() + "INTO OUTFILE '" + new File(file, string + " " + string2 + " " + this.params.getTitle().replace(":", ".") + ".csv").getAbsolutePath().replace("\\", "\\\\") + "' FIELDS TERMINATED BY ',' OPTIONALLY ENCLOSED BY '\"'  LINES TERMINATED BY '\n'");
                        }
                        catch (SQLException sQLException) {
                            this.sender.sendMessage(ChatColor.RED + "Error while dumping log. Make sure your MySQL user has access to the LogBlock folder, or disable clearlog.dumpDeletedLog");
                            CommandsHandler.this.log.log(Level.SEVERE, "[LogBlock ClearLog] Exception while dumping log: ", sQLException);
                            this.close();
                            return;
                        }
                    }
                    this.state.execute("DELETE `" + string2 + "` FROM `" + string2 + "` " + string3 + this.params.getWhere());
                    this.sender.sendMessage(ChatColor.GREEN + "Cleared out table " + string2 + ". Deleted " + n + " entries.");
                }
                this.rs = this.state.executeQuery("SELECT COUNT(*) FROM `" + string2 + "-sign` LEFT JOIN `" + string2 + "` USING (id) WHERE `" + string2 + "`.id IS NULL");
                this.rs.next();
                n = this.rs.getInt(1);
                if (n > 0) {
                    if (((CommandsHandler)CommandsHandler.this).config.dumpDeletedLog) {
                        this.state.execute("SELECT id, signtext FROM `" + string2 + "-sign` LEFT JOIN `" + string2 + "` USING (id) WHERE `" + string2 + "`.id IS NULL INTO OUTFILE '" + new File(file, string + " " + string2 + "-sign " + this.params.getTitle() + ".csv").getAbsolutePath().replace("\\", "\\\\") + "' FIELDS TERMINATED BY ',' OPTIONALLY ENCLOSED BY '\"'  LINES TERMINATED BY '\n'");
                    }
                    this.state.execute("DELETE `" + string2 + "-sign` FROM `" + string2 + "-sign` LEFT JOIN `" + string2 + "` USING (id) WHERE `" + string2 + "`.id IS NULL;");
                    this.sender.sendMessage(ChatColor.GREEN + "Cleared out table " + string2 + "-sign. Deleted " + n + " entries.");
                }
                this.rs = this.state.executeQuery("SELECT COUNT(*) FROM `" + string2 + "-chest` LEFT JOIN `" + string2 + "` USING (id) WHERE `" + string2 + "`.id IS NULL");
                this.rs.next();
                n = this.rs.getInt(1);
                if (n > 0) {
                    if (((CommandsHandler)CommandsHandler.this).config.dumpDeletedLog) {
                        this.state.execute("SELECT id, itemtype, itemamount, itemdata FROM `" + string2 + "-chest` LEFT JOIN `" + string2 + "` USING (id) WHERE `" + string2 + "`.id IS NULL INTO OUTFILE '" + new File(file, string + " " + string2 + "-chest " + this.params.getTitle() + ".csv").getAbsolutePath().replace("\\", "\\\\") + "' FIELDS TERMINATED BY ',' OPTIONALLY ENCLOSED BY '\"'  LINES TERMINATED BY '\n'");
                    }
                    this.state.execute("DELETE `" + string2 + "-chest` FROM `" + string2 + "-chest` LEFT JOIN `" + string2 + "` USING (id) WHERE `" + string2 + "`.id IS NULL;");
                    this.sender.sendMessage(ChatColor.GREEN + "Cleared out table " + string2 + "-chest. Deleted " + n + " entries.");
                }
            }
            catch (Exception exception) {
                this.sender.sendMessage(ChatColor.RED + "Exception, check error log");
                CommandsHandler.this.log.log(Level.SEVERE, "[LogBlock ClearLog] Exception: ", exception);
            }
            finally {
                this.close();
            }
        }
    }

    public class CommandRedo
    extends AbstractCommand {
        public CommandRedo(CommandSender commandSender, QueryParams queryParams, boolean bl) throws Exception {
            super(commandSender, queryParams, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.params.needCoords = true;
                this.params.needType = true;
                this.params.needData = true;
                this.params.needSignText = true;
                this.params.needChestAccess = true;
                this.params.order = QueryParams.Order.ASC;
                this.params.sum = QueryParams.SummarizationMode.NONE;
                this.conn = CommandsHandler.this.logblock.getConnection();
                this.state = this.conn.createStatement();
                if (!CommandsHandler.this.checkRestrictions(this.sender, this.params)) {
                    return;
                }
                this.rs = this.state.executeQuery(this.params.getQuery());
                if (!this.params.silent) {
                    this.sender.sendMessage(ChatColor.DARK_AQUA + "Searching " + this.params.getTitle() + ":");
                }
                WorldEditor worldEditor = new WorldEditor(CommandsHandler.this.logblock, this.params.world);
                while (this.rs.next()) {
                    worldEditor.queueEdit(this.rs.getInt("x"), this.rs.getInt("y"), this.rs.getInt("z"), this.rs.getInt("type"), this.rs.getInt("replaced"), this.rs.getByte("data"), this.rs.getString("signtext"), this.rs.getShort("itemtype"), -this.rs.getShort("itemamount"), this.rs.getByte("itemdata"));
                }
                int n = worldEditor.getSize();
                if (!this.params.silent) {
                    this.sender.sendMessage(ChatColor.GREEN.toString() + n + " blocks found.");
                }
                if (n == 0) {
                    if (!this.params.silent) {
                        this.sender.sendMessage(ChatColor.RED + "Redo aborted");
                    }
                    return;
                }
                if (!this.params.silent && ((CommandsHandler)CommandsHandler.this).config.askRedos && CommandsHandler.this.questioner != null && this.sender instanceof Player && !CommandsHandler.this.questioner.ask((Player)this.sender, "Are you sure you want to continue?", "yes", "no").equals("yes")) {
                    this.sender.sendMessage(ChatColor.RED + "Redo aborted");
                    return;
                }
                worldEditor.start();
                this.sender.sendMessage(ChatColor.GREEN + "Redo finished successfully (" + worldEditor.getElapsedTime() + " ms, " + worldEditor.getSuccesses() + "/" + n + " blocks" + (worldEditor.getErrors() > 0 ? ", " + ChatColor.RED + worldEditor.getErrors() + " errors" + ChatColor.GREEN : "") + (worldEditor.getBlacklistCollisions() > 0 ? ", " + worldEditor.getBlacklistCollisions() + " blacklist collisions" : "") + ")");
            }
            catch (Exception exception) {
                this.sender.sendMessage(ChatColor.RED + "Exception, check error log");
                CommandsHandler.this.log.log(Level.SEVERE, "[LogBlock Redo] " + this.params.getQuery() + ": ", exception);
            }
            finally {
                this.close();
            }
        }
    }

    public class CommandRollback
    extends AbstractCommand {
        public CommandRollback(CommandSender commandSender, QueryParams queryParams, boolean bl) throws Exception {
            super(commandSender, queryParams, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.params.needCoords = true;
                this.params.needType = true;
                this.params.needData = true;
                this.params.needSignText = true;
                this.params.needChestAccess = true;
                this.params.order = QueryParams.Order.DESC;
                this.params.sum = QueryParams.SummarizationMode.NONE;
                this.conn = CommandsHandler.this.logblock.getConnection();
                this.state = this.conn.createStatement();
                if (!CommandsHandler.this.checkRestrictions(this.sender, this.params)) {
                    return;
                }
                if (CommandsHandler.this.logblock.getConsumer().getQueueSize() > 0) {
                    new CommandSaveQueue(this.sender, null, false);
                }
                if (!this.params.silent) {
                    this.sender.sendMessage(ChatColor.DARK_AQUA + "Searching " + this.params.getTitle() + ":");
                }
                this.rs = this.state.executeQuery(this.params.getQuery());
                WorldEditor worldEditor = new WorldEditor(CommandsHandler.this.logblock, this.params.world);
                while (this.rs.next()) {
                    worldEditor.queueEdit(this.rs.getInt("x"), this.rs.getInt("y"), this.rs.getInt("z"), this.rs.getInt("replaced"), this.rs.getInt("type"), this.rs.getByte("data"), this.rs.getString("signtext"), this.rs.getShort("itemtype"), this.rs.getShort("itemamount"), this.rs.getByte("itemdata"));
                }
                int n = worldEditor.getSize();
                if (!this.params.silent) {
                    this.sender.sendMessage(ChatColor.GREEN.toString() + n + " blocks found.");
                }
                if (n == 0) {
                    if (!this.params.silent) {
                        this.sender.sendMessage(ChatColor.RED + "Rollback aborted");
                    }
                    return;
                }
                if (!this.params.silent && ((CommandsHandler)CommandsHandler.this).config.askRollbacks && CommandsHandler.this.questioner != null && this.sender instanceof Player && !CommandsHandler.this.questioner.ask((Player)this.sender, "Are you sure you want to continue?", "yes", "no").equals("yes")) {
                    this.sender.sendMessage(ChatColor.RED + "Rollback aborted");
                    return;
                }
                worldEditor.start();
                ((CommandsHandler)CommandsHandler.this).logblock.getSession((String)BukkitUtils.senderName((CommandSender)this.sender)).lookupCache = worldEditor.errors;
                this.sender.sendMessage(ChatColor.GREEN + "Rollback finished successfully (" + worldEditor.getElapsedTime() + " ms, " + worldEditor.getSuccesses() + "/" + n + " blocks" + (worldEditor.getErrors() > 0 ? ", " + ChatColor.RED + worldEditor.getErrors() + " errors" + ChatColor.GREEN : "") + (worldEditor.getBlacklistCollisions() > 0 ? ", " + worldEditor.getBlacklistCollisions() + " blacklist collisions" : "") + ")");
                if (!this.params.silent && ((CommandsHandler)CommandsHandler.this).config.askClearLogAfterRollback && CommandsHandler.this.logblock.hasPermission(this.sender, "logblock.clearlog") && CommandsHandler.this.questioner != null && this.sender instanceof Player) {
                    Thread.sleep(1000L);
                    if (CommandsHandler.this.questioner.ask((Player)this.sender, "Do you want to delete the rollbacked log?", "yes", "no").equals("yes")) {
                        this.params.silent = true;
                        new CommandClearLog(this.sender, this.params, false);
                    } else {
                        this.sender.sendMessage(ChatColor.LIGHT_PURPLE + "Clearlog cancelled");
                    }
                }
            }
            catch (Exception exception) {
                this.sender.sendMessage(ChatColor.RED + "Exception, check error log");
                CommandsHandler.this.log.log(Level.SEVERE, "[LogBlock Rollback] " + this.params.getQuery() + ": ", exception);
            }
            finally {
                this.close();
            }
        }
    }

    public class CommandTeleport
    extends AbstractCommand {
        public CommandTeleport(CommandSender commandSender, QueryParams queryParams, boolean bl) throws Exception {
            super(commandSender, queryParams, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.params.needCoords = true;
                this.params.limit = 1;
                this.params.sum = QueryParams.SummarizationMode.NONE;
                this.conn = CommandsHandler.this.logblock.getConnection();
                this.state = this.conn.createStatement();
                this.rs = this.state.executeQuery(this.params.getQuery());
                if (this.rs.next()) {
                    Player player = (Player)this.sender;
                    int n = this.rs.getInt(2);
                    Location location = new Location(this.params.world, (double)this.rs.getInt(1) + 0.5, (double)n, (double)this.rs.getInt(3) + 0.5, player.getLocation().getYaw(), 90.0f);
                    int n2 = BukkitUtils.saveSpawnHeight(location);
                    location.setY((double)n2);
                    player.teleport(location);
                    this.sender.sendMessage(ChatColor.GREEN + "You were teleported " + Math.abs(n2 - n) + " blocks " + (n2 - n > 0 ? "above" : "below"));
                } else {
                    this.sender.sendMessage(ChatColor.RED + "No block change found to teleport to");
                }
            }
            catch (Exception exception) {
                this.sender.sendMessage(ChatColor.RED + "Exception, check error log");
                CommandsHandler.this.log.log(Level.SEVERE, "[LogBlock Teleport] " + this.params.getQuery() + ": ", exception);
            }
            finally {
                this.close();
            }
        }
    }

    public class CommandSaveQueue
    extends AbstractCommand {
        public CommandSaveQueue(CommandSender commandSender, QueryParams queryParams, boolean bl) throws Exception {
            super(commandSender, queryParams, bl);
        }

        @Override
        public void run() {
            Consumer consumer = CommandsHandler.this.logblock.getConsumer();
            if (consumer.getQueueSize() > 0) {
                this.sender.sendMessage(ChatColor.DARK_AQUA + "Current queue size: " + consumer.getQueueSize());
                int n = -1;
                int n2 = 0;
                while (consumer.getQueueSize() > 0) {
                    int n3 = n2 = n == consumer.getQueueSize() ? n2 + 1 : 0;
                    if (n2 > 10) {
                        this.sender.sendMessage(ChatColor.RED + "Unable to save queue");
                        return;
                    }
                    n = consumer.getQueueSize();
                    consumer.run();
                }
                this.sender.sendMessage(ChatColor.GREEN + "Queue saved successfully");
            }
        }
    }

    public class CommandWriteLogFile
    extends AbstractCommand {
        CommandWriteLogFile(CommandSender commandSender, QueryParams queryParams, boolean bl) throws Exception {
            super(commandSender, queryParams, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File file = null;
            try {
                if (this.params.bct == QueryParams.BlockChangeType.CHAT) {
                    this.params.needDate = true;
                    this.params.needPlayer = true;
                    this.params.needMessage = true;
                } else {
                    this.params.needDate = true;
                    this.params.needType = true;
                    this.params.needData = true;
                    this.params.needPlayer = true;
                    if (this.params.types.size() == 0 || this.params.types.contains(63) || this.params.types.contains(68)) {
                        this.params.needSignText = true;
                    }
                    if (this.params.types.size() == 0 || this.params.types.contains(23) || this.params.types.contains(54) || this.params.types.contains(61) || this.params.types.contains(62)) {
                        this.params.needChestAccess = true;
                    }
                }
                this.conn = CommandsHandler.this.logblock.getConnection();
                this.state = this.conn.createStatement();
                file = new File("plugins/LogBlock/log/" + this.params.getTitle().replace(":", ".") + ".log");
                this.sender.sendMessage(ChatColor.GREEN + "Creating " + file.getName());
                this.rs = this.state.executeQuery(this.params.getQuery());
                file.getParentFile().mkdirs();
                file.createNewFile();
                FileWriter fileWriter = new FileWriter(file);
                String string = System.getProperty("line.separator");
                file.getParentFile().mkdirs();
                int n = 0;
                if (this.params.sum != QueryParams.SummarizationMode.NONE) {
                    fileWriter.write("Created - Destroyed - " + (this.params.sum == QueryParams.SummarizationMode.TYPES ? "Block" : "Player") + string);
                }
                LookupCacheElementFactory lookupCacheElementFactory = new LookupCacheElementFactory(this.params, this.sender instanceof Player ? 0.6666667f : 1.0f);
                while (this.rs.next()) {
                    fileWriter.write(lookupCacheElementFactory.getLookupCacheElement(this.rs).getMessage() + string);
                    ++n;
                }
                fileWriter.close();
                this.sender.sendMessage(ChatColor.GREEN + "Wrote " + n + " lines.");
            }
            catch (Exception exception) {
                this.sender.sendMessage(ChatColor.RED + "Exception, check error log");
                CommandsHandler.this.log.log(Level.SEVERE, "[LogBlock WriteLogFile] " + this.params.getQuery() + " (file was " + file.getAbsolutePath() + "): ", exception);
            }
            finally {
                this.close();
            }
        }
    }

    public class CommandLookup
    extends AbstractCommand {
        public CommandLookup(CommandSender commandSender, QueryParams queryParams, boolean bl) throws Exception {
            super(commandSender, queryParams, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.params.bct == QueryParams.BlockChangeType.CHAT) {
                    this.params.needDate = true;
                    this.params.needPlayer = true;
                    this.params.needMessage = true;
                } else {
                    this.params.needDate = true;
                    this.params.needType = true;
                    this.params.needData = true;
                    this.params.needPlayer = true;
                    if (this.params.types.size() == 0 || this.params.types.contains(63) || this.params.types.contains(68)) {
                        this.params.needSignText = true;
                    }
                    if (this.params.types.size() == 0 || this.params.types.contains(23) || this.params.types.contains(54) || this.params.types.contains(61) || this.params.types.contains(62)) {
                        this.params.needChestAccess = true;
                    }
                }
                this.conn = CommandsHandler.this.logblock.getConnection();
                this.state = this.conn.createStatement();
                this.rs = this.state.executeQuery(this.params.getQuery());
                this.sender.sendMessage(ChatColor.DARK_AQUA + this.params.getTitle() + ":");
                if (this.rs.next()) {
                    this.rs.beforeFirst();
                    ArrayList<LookupCacheElement> arrayList = new ArrayList<LookupCacheElement>();
                    LookupCacheElementFactory lookupCacheElementFactory = new LookupCacheElementFactory(this.params, this.sender instanceof Player ? 0.6666667f : 1.0f);
                    while (this.rs.next()) {
                        arrayList.add(lookupCacheElementFactory.getLookupCacheElement(this.rs));
                    }
                    ((CommandsHandler)CommandsHandler.this).logblock.getSession((String)BukkitUtils.senderName((CommandSender)this.sender)).lookupCache = arrayList.toArray(new LookupCacheElement[arrayList.size()]);
                    if (arrayList.size() > ((CommandsHandler)CommandsHandler.this).config.linesPerPage) {
                        this.sender.sendMessage(ChatColor.DARK_AQUA.toString() + arrayList.size() + " changes found." + (arrayList.size() == ((CommandsHandler)CommandsHandler.this).config.linesLimit ? " Use 'limit -1' to see all changes." : ""));
                    }
                    if (this.params.sum != QueryParams.SummarizationMode.NONE) {
                        this.sender.sendMessage(ChatColor.GOLD + "Created - Destroyed - " + (this.params.sum == QueryParams.SummarizationMode.TYPES ? "Block" : "Player"));
                    }
                    CommandsHandler.this.showPage(this.sender, 1);
                } else {
                    this.sender.sendMessage(ChatColor.DARK_AQUA + "No results found.");
                    ((CommandsHandler)CommandsHandler.this).logblock.getSession((String)BukkitUtils.senderName((CommandSender)this.sender)).lookupCache = null;
                }
            }
            catch (Exception exception) {
                this.sender.sendMessage(ChatColor.RED + "Exception, check error log");
                CommandsHandler.this.log.log(Level.SEVERE, "[LogBlock Lookup] " + this.params.getQuery() + ": ", exception);
            }
            finally {
                this.close();
            }
        }
    }

    public abstract class AbstractCommand
    implements Runnable,
    Closeable {
        protected CommandSender sender;
        protected QueryParams params;
        protected Connection conn = null;
        protected Statement state = null;
        protected ResultSet rs = null;

        protected AbstractCommand(CommandSender commandSender, QueryParams queryParams, boolean bl) throws Exception {
            this.sender = commandSender;
            this.params = queryParams;
            if (bl) {
                if (CommandsHandler.this.scheduler.scheduleAsyncDelayedTask((Plugin)CommandsHandler.this.logblock, (Runnable)this) == -1) {
                    throw new Exception("Failed to schedule the command");
                }
            } else {
                this.run();
            }
        }

        @Override
        public final void close() {
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
                if (this.state != null) {
                    this.state.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException sQLException) {
                CommandsHandler.this.log.log(Level.SEVERE, "[LogBlock CommandsHandler] SQL exception on close", sQLException);
            }
        }
    }
}

