/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.Tool;
import de.diddiz.LogBlock.ToolBehavior;
import de.diddiz.LogBlock.ToolMode;
import de.diddiz.LogBlock.WorldConfig;
import de.diddiz.util.BukkitUtils;
import de.diddiz.util.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.DataFormatException;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.util.config.Configuration;

public class Config {
    public final Map<Integer, WorldConfig> worlds;
    public final String url;
    public final String user;
    public final String password;
    public final int delayBetweenRuns;
    public final int forceToProcessAtLeast;
    public final int timePerRun;
    public final boolean useBukkitScheduler;
    public final int keepLogDays;
    public final boolean dumpDeletedLog;
    public boolean logBlockPlacings;
    public boolean logBlockBreaks;
    public boolean logSignTexts;
    public boolean logExplosions;
    public boolean logFire;
    public boolean logLeavesDecay;
    public boolean logLavaFlow;
    public boolean logWaterFlow;
    public boolean logChestAccess;
    public boolean logButtonsAndLevers;
    public boolean logKills;
    public boolean logChat;
    public boolean logSnowForm;
    public boolean logSnowFade;
    public boolean logDoors;
    public boolean logCakes;
    public boolean logEndermen;
    public final boolean logCreeperExplosionsAsPlayerWhoTriggeredThese;
    public final boolean logPlayerInfo;
    public final LogKillsLevel logKillsLevel;
    public final Set<Integer> dontRollback;
    public final Set<Integer> replaceAnyway;
    public final int rollbackMaxTime;
    public final int rollbackMaxArea;
    public final HashMap<String, Tool> toolsByName;
    public final HashMap<Integer, Tool> toolsByType;
    public final int defaultDist;
    public final int defaultTime;
    public final int linesPerPage;
    public final int linesLimit;
    public final boolean askRollbacks;
    public final boolean askRedos;
    public final boolean askClearLogs;
    public final boolean askClearLogAfterRollback;
    public final boolean askRollbackAfterBan;
    public final String banPermission;
    public final boolean installSpout;
    public final boolean checkVersion;
    public final Set<Integer> hiddenPlayers;
    public final Set<Integer> hiddenBlocks;

    Config(LogBlock logBlock) throws DataFormatException, IOException {
        Iterator<Object> iterator2;
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap hashMap2 = new HashMap();
        HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
        HashMap<String, Object> hashMap4 = new HashMap<String, Object>();
        hashMap.put("version", logBlock.getDescription().getVersion());
        hashMap.put("loggedWorlds", Arrays.asList("world", "world_nether"));
        hashMap.put("mysql.host", "localhost");
        hashMap.put("mysql.port", 3306);
        hashMap.put("mysql.database", "minecraft");
        hashMap.put("mysql.user", "username");
        hashMap.put("mysql.password", "pass");
        hashMap.put("consumer.delayBetweenRuns", 6);
        hashMap.put("consumer.forceToProcessAtLeast", 20);
        hashMap.put("consumer.timePerRun", 200);
        hashMap.put("consumer.useBukkitScheduler", true);
        hashMap.put("clearlog.dumpDeletedLog", false);
        hashMap.put("clearlog.keepLogDays", -1);
        hashMap.put("logging.logCreeperExplosionsAsPlayerWhoTriggeredThese", false);
        hashMap.put("logging.logKillsLevel", "PLAYERS");
        hashMap.put("logging.logPlayerInfo", true);
        hashMap.put("logging.hiddenPlayers", new ArrayList());
        hashMap.put("logging.hiddenBlocks", Arrays.asList(0));
        hashMap.put("rollback.dontRollback", Arrays.asList(10, 11, 46, 51));
        hashMap.put("rollback.replaceAnyway", Arrays.asList(8, 9, 10, 11, 51));
        hashMap.put("rollback.maxTime", "2 days");
        hashMap.put("rollback.maxArea", 50);
        hashMap.put("lookup.defaultDist", 20);
        hashMap.put("lookup.defaultTime", "30 minutes");
        hashMap.put("lookup.linesPerPage", 15);
        hashMap.put("lookup.linesLimit", 1500);
        hashMap.put("questioner.askRollbacks", true);
        hashMap.put("questioner.askRedos", true);
        hashMap.put("questioner.askClearLogs", true);
        hashMap.put("questioner.askClearLogAfterRollback", true);
        hashMap.put("questioner.askRollbackAfterBan", false);
        hashMap.put("questioner.banPermission", "mcbans.ban.local");
        hashMap.put("updater.installSpout", true);
        hashMap.put("updater.checkVersion", true);
        hashMap4.put("aliases", Arrays.asList("t"));
        hashMap4.put("leftClickBehavior", "NONE");
        hashMap4.put("rightClickBehavior", "TOOL");
        hashMap4.put("defaultEnabled", true);
        hashMap4.put("item", 270);
        hashMap4.put("params", "area 0 all sum none limit 15 desc silent");
        hashMap4.put("mode", "LOOKUP");
        hashMap4.put("permissionDefault", "TRUE");
        hashMap3.put("aliases", Arrays.asList("tb"));
        hashMap3.put("leftClickBehavior", "TOOL");
        hashMap3.put("rightClickBehavior", "BLOCK");
        hashMap3.put("defaultEnabled", true);
        hashMap3.put("item", 7);
        hashMap3.put("params", "area 0 all sum none limit 15 desc silent");
        hashMap3.put("mode", "LOOKUP");
        hashMap3.put("permissionDefault", "TRUE");
        hashMap2.put("tool", hashMap4);
        hashMap2.put("toolblock", hashMap3);
        hashMap.put("tools", hashMap2);
        Configuration configuration = logBlock.getConfiguration();
        configuration.load();
        for (Map.Entry object32 : hashMap.entrySet()) {
            if (configuration.getProperty((String)object32.getKey()) != null) continue;
            configuration.setProperty((String)object32.getKey(), object32.getValue());
        }
        if (!configuration.save()) {
            throw new IOException("Error while writing to config.yml");
        }
        this.url = "jdbc:mysql://" + configuration.getString("mysql.host") + ":" + configuration.getString("mysql.port") + "/" + configuration.getString("mysql.database");
        this.user = configuration.getString("mysql.user");
        this.password = configuration.getString("mysql.password");
        this.delayBetweenRuns = configuration.getInt("consumer.delayBetweenRuns", 6);
        this.forceToProcessAtLeast = configuration.getInt("consumer.forceToProcessAtLeast", 0);
        this.timePerRun = configuration.getInt("consumer.timePerRun", 100);
        this.useBukkitScheduler = configuration.getBoolean("consumer.useBukkitScheduler", true);
        this.keepLogDays = configuration.getInt("clearlog.keepLogDays", -1);
        if ((long)this.keepLogDays * 86400000L > System.currentTimeMillis()) {
            throw new DataFormatException("Too large timespan for keepLogDays. Must be shorter than " + (int)(System.currentTimeMillis() / 86400000L) + " days.");
        }
        this.dumpDeletedLog = configuration.getBoolean("clearlog.dumpDeletedLog", false);
        this.logCreeperExplosionsAsPlayerWhoTriggeredThese = configuration.getBoolean("logging.logCreeperExplosionsAsPlayerWhoTriggeredThese", false);
        this.logPlayerInfo = configuration.getBoolean("logging.logPlayerInfo", true);
        try {
            this.logKillsLevel = LogKillsLevel.valueOf(configuration.getString("logging.logKillsLevel").toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataFormatException("lookup.toolblockID doesn't appear to be a valid log level. Allowed are 'PLAYERS', 'MONSTERS' and 'ANIMALS'");
        }
        this.hiddenPlayers = new HashSet<Integer>();
        for (String string : configuration.getStringList("logging.hiddenPlayers", new ArrayList())) {
            this.hiddenPlayers.add(string.hashCode());
        }
        this.hiddenBlocks = new HashSet<Integer>();
        for (String string : configuration.getStringList("logging.hiddenBlocks", new ArrayList())) {
            object = Material.matchMaterial((String)string);
            if (object != null) {
                this.hiddenBlocks.add(object.getId());
                continue;
            }
            throw new DataFormatException("Not a valid material: '" + string + "'");
        }
        this.dontRollback = new HashSet<Integer>(configuration.getIntList("rollback.dontRollback", null));
        this.replaceAnyway = new HashSet<Integer>(configuration.getIntList("rollback.replaceAnyway", null));
        this.rollbackMaxTime = Utils.parseTimeSpec(configuration.getString("rollback.maxTime").split(" "));
        this.rollbackMaxArea = configuration.getInt("rollback.maxArea", 50);
        this.defaultDist = configuration.getInt("lookup.defaultDist", 20);
        this.defaultTime = Utils.parseTimeSpec(configuration.getString("lookup.defaultTime").split(" "));
        this.linesPerPage = configuration.getInt("lookup.linesPerPage", 15);
        this.linesLimit = configuration.getInt("lookup.linesLimit", 1500);
        this.askRollbacks = configuration.getBoolean("questioner.askRollbacks", true);
        this.askRedos = configuration.getBoolean("questioner.askRedos", true);
        this.askClearLogs = configuration.getBoolean("questioner.askClearLogs", true);
        this.askClearLogAfterRollback = configuration.getBoolean("questioner.askClearLogAfterRollback", true);
        this.askRollbackAfterBan = configuration.getBoolean("questioner.askRollbackAfterBan", false);
        this.banPermission = configuration.getString("questioner.banPermission");
        this.installSpout = configuration.getBoolean("updater.installSpout", true);
        this.checkVersion = configuration.getBoolean("updater.checkVersion", true);
        List list = configuration.getKeys("tools");
        ArrayList<Tool> arrayList = new ArrayList<Tool>();
        object = list.iterator();
        while (object.hasNext()) {
            iterator2 = (String)object.next();
            try {
                String string = "tools." + (String)((Object)iterator2);
                List list2 = configuration.getStringList(string + ".aliases", null);
                ToolBehavior toolBehavior = ToolBehavior.valueOf(configuration.getString(string + ".leftClickBehavior").toUpperCase());
                ToolBehavior toolBehavior2 = ToolBehavior.valueOf(configuration.getString(string + ".rightClickBehavior").toUpperCase());
                boolean bl = configuration.getBoolean(string + ".defaultEnabled", false);
                int n = configuration.getInt(string + ".item", 0);
                QueryParams queryParams = new QueryParams(logBlock);
                queryParams.prepareToolQuery = true;
                queryParams.parseArgs((CommandSender)Bukkit.getConsoleSender(), Arrays.asList(configuration.getString(string + ".params").split(" ")));
                ToolMode toolMode = ToolMode.valueOf(configuration.getString(string + ".mode").toUpperCase());
                PermissionDefault permissionDefault = PermissionDefault.valueOf((String)configuration.getString(string + ".permissionDefault").toUpperCase());
                arrayList.add(new Tool((String)((Object)iterator2), list2, toolBehavior, toolBehavior2, bl, n, queryParams, toolMode, permissionDefault));
            }
            catch (Exception exception) {
                Bukkit.getLogger().log(Level.WARNING, "Error at parsing tool '" + (String)((Object)iterator2) + "':)", exception);
            }
        }
        this.toolsByName = new HashMap();
        this.toolsByType = new HashMap();
        for (Iterator<Object> iterator2 : arrayList) {
            this.toolsByType.put(((Tool)((Object)iterator2)).item, (Tool)((Object)iterator2));
            this.toolsByName.put(((Tool)((Object)iterator2)).name, (Tool)((Object)iterator2));
            for (String string : ((Tool)((Object)iterator2)).aliases) {
                this.toolsByName.put(string, (Tool)((Object)iterator2));
            }
        }
        object = configuration.getStringList("loggedWorlds", null);
        this.worlds = new HashMap<Integer, WorldConfig>();
        if (object == null || object.size() == 0) {
            throw new DataFormatException("No worlds configured");
        }
        iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            String string = (String)iterator2.next();
            this.worlds.put(string.hashCode(), new WorldConfig(new File("plugins/LogBlock/" + BukkitUtils.friendlyWorldname(string) + ".yml")));
        }
        for (WorldConfig worldConfig : this.worlds.values()) {
            if (worldConfig.logBlockPlacings) {
                this.logBlockPlacings = true;
            }
            if (worldConfig.logBlockBreaks) {
                this.logBlockBreaks = true;
            }
            if (worldConfig.logSignTexts) {
                this.logSignTexts = true;
            }
            if (worldConfig.logExplosions) {
                this.logExplosions = true;
            }
            if (worldConfig.logFire) {
                this.logFire = true;
            }
            if (worldConfig.logLeavesDecay) {
                this.logLeavesDecay = true;
            }
            if (worldConfig.logLavaFlow) {
                this.logLavaFlow = true;
            }
            if (worldConfig.logWaterFlow) {
                this.logWaterFlow = true;
            }
            if (worldConfig.logChestAccess) {
                this.logChestAccess = true;
            }
            if (worldConfig.logButtonsAndLevers) {
                this.logButtonsAndLevers = true;
            }
            if (worldConfig.logKills) {
                this.logKills = true;
            }
            if (worldConfig.logChat) {
                this.logChat = true;
            }
            if (worldConfig.logSnowForm) {
                this.logSnowForm = true;
            }
            if (worldConfig.logSnowFade) {
                this.logSnowFade = true;
            }
            if (worldConfig.logDoors) {
                this.logDoors = true;
            }
            if (worldConfig.logCakes) {
                this.logCakes = true;
            }
            if (!worldConfig.logEndermen) continue;
            this.logEndermen = true;
        }
    }

    public static enum LogKillsLevel {
        PLAYERS,
        MONSTERS,
        ANIMALS;

    }
}

