/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.BlockChange;
import de.diddiz.LogBlock.ChatMessage;
import de.diddiz.LogBlock.ChestAccess;
import de.diddiz.LogBlock.Config;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.WorldConfig;
import de.diddiz.util.BukkitUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.ContainerBlock;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Consumer
extends TimerTask {
    private final Queue<Row> queue = new LinkedBlockingQueue<Row>();
    private final Config config;
    private final Map<Integer, WorldConfig> worlds;
    private final Set<Integer> hiddenPlayers;
    private final Set<Integer> hiddenBlocks;
    private final Set<String> failedPlayers = new HashSet<String>();
    private final Logger log;
    private final LogBlock logblock;
    private final Map<Integer, Integer> players = new HashMap<Integer, Integer>();
    private final Lock lock = new ReentrantLock();

    Consumer(LogBlock logBlock) {
        this.logblock = logBlock;
        this.log = logBlock.getServer().getLogger();
        this.config = logBlock.getConfig();
        this.hiddenPlayers = this.config.hiddenPlayers;
        this.hiddenBlocks = this.config.hiddenBlocks;
        this.worlds = this.config.worlds;
    }

    public void queueBlock(String string, Location location, int n, int n2, byte by) {
        this.queueBlock(string, location, n, n2, by, null, null);
    }

    public void queueBlockBreak(String string, BlockState blockState) {
        this.queueBlockBreak(string, new Location(blockState.getWorld(), (double)blockState.getX(), (double)blockState.getY(), (double)blockState.getZ()), blockState.getTypeId(), blockState.getRawData());
    }

    public void queueBlockBreak(String string, Location location, int n, byte by) {
        this.queueBlock(string, location, n, 0, by);
    }

    public void queueBlockPlace(String string, BlockState blockState) {
        this.queueBlockPlace(string, new Location(blockState.getWorld(), (double)blockState.getX(), (double)blockState.getY(), (double)blockState.getZ()), blockState.getTypeId(), blockState.getRawData());
    }

    public void queueBlockPlace(String string, Location location, int n, byte by) {
        this.queueBlock(string, location, 0, n, by);
    }

    public void queueBlockReplace(String string, BlockState blockState, BlockState blockState2) {
        this.queueBlockReplace(string, new Location(blockState.getWorld(), (double)blockState.getX(), (double)blockState.getY(), (double)blockState.getZ()), blockState.getTypeId(), blockState.getRawData(), blockState2.getTypeId(), blockState2.getRawData());
    }

    public void queueBlockReplace(String string, BlockState blockState, int n, byte by) {
        this.queueBlockReplace(string, new Location(blockState.getWorld(), (double)blockState.getX(), (double)blockState.getY(), (double)blockState.getZ()), blockState.getTypeId(), blockState.getRawData(), n, by);
    }

    public void queueBlockReplace(String string, int n, byte by, BlockState blockState) {
        this.queueBlockReplace(string, new Location(blockState.getWorld(), (double)blockState.getX(), (double)blockState.getY(), (double)blockState.getZ()), n, by, blockState.getTypeId(), blockState.getRawData());
    }

    public void queueBlockReplace(String string, Location location, int n, byte by, int n2, byte by2) {
        if (by == 0) {
            this.queueBlock(string, location, n, n2, by2);
        } else {
            this.queueBlockBreak(string, location, n, by);
            this.queueBlockPlace(string, location, n2, by2);
        }
    }

    public void queueChestAccess(String string, BlockState blockState, short s, short s2, byte by) {
        if (!(blockState instanceof ContainerBlock)) {
            return;
        }
        this.queueChestAccess(string, new Location(blockState.getWorld(), (double)blockState.getX(), (double)blockState.getY(), (double)blockState.getZ()), blockState.getTypeId(), s, s2, by);
    }

    public void queueChestAccess(String string, Location location, int n, short s, short s2, byte by) {
        this.queueBlock(string, location, n, n, (byte)0, null, new ChestAccess(s, s2, by));
    }

    public void queueContainerBreak(String string, BlockState blockState) {
        if (!(blockState instanceof ContainerBlock)) {
            return;
        }
        this.queueContainerBreak(string, new Location(blockState.getWorld(), (double)blockState.getX(), (double)blockState.getY(), (double)blockState.getZ()), blockState.getTypeId(), blockState.getRawData(), ((ContainerBlock)blockState).getInventory());
    }

    public void queueContainerBreak(String string, Location location, int n, byte by, Inventory inventory) {
        ItemStack[] itemStackArray;
        for (ItemStack itemStack : itemStackArray = BukkitUtils.compressInventory(inventory.getContents())) {
            this.queueChestAccess(string, location, n, (short)itemStack.getTypeId(), (short)(itemStack.getAmount() * -1), BukkitUtils.rawData(itemStack));
        }
        this.queueBlockBreak(string, location, n, by);
    }

    public void queueKill(Entity entity, Entity entity2) {
        if (entity == null || entity2 == null) {
            return;
        }
        int n = 0;
        if (entity instanceof Player && ((Player)entity).getItemInHand() != null) {
            n = ((Player)entity).getItemInHand().getTypeId();
        }
        this.queueKill(entity2.getWorld(), BukkitUtils.entityName(entity), BukkitUtils.entityName(entity2), n);
    }

    public void queueKill(World world, String string, String string2, int n) {
        if (string2 == null || !this.worlds.containsKey(world.getName().hashCode())) {
            return;
        }
        string = string.replaceAll("[^a-zA-Z0-9_]", "");
        string2 = string2.replaceAll("[^a-zA-Z0-9_]", "");
        this.queue.add(new KillRow(world.getName().hashCode(), string, string2, n));
    }

    public void queueSignBreak(String string, Location location, int n, byte by, String[] stringArray) {
        if (n != 63 && n != 68 || stringArray == null || stringArray.length != 4) {
            return;
        }
        this.queueBlock(string, location, n, 0, by, stringArray[0] + "\u0000" + stringArray[1] + "\u0000" + stringArray[2] + "\u0000" + stringArray[3], null);
    }

    public void queueSignBreak(String string, Sign sign) {
        this.queueSignBreak(string, new Location(sign.getWorld(), (double)sign.getX(), (double)sign.getY(), (double)sign.getZ()), sign.getTypeId(), sign.getRawData(), sign.getLines());
    }

    public void queueSignPlace(String string, Location location, int n, byte by, String[] stringArray) {
        if (n != 63 && n != 68 || stringArray == null || stringArray.length != 4) {
            return;
        }
        this.queueBlock(string, location, 0, n, by, stringArray[0] + "\u0000" + stringArray[1] + "\u0000" + stringArray[2] + "\u0000" + stringArray[3], null);
    }

    public void queueSignPlace(String string, Sign sign) {
        this.queueSignPlace(string, new Location(sign.getWorld(), (double)sign.getX(), (double)sign.getY(), (double)sign.getZ()), sign.getTypeId(), sign.getRawData(), sign.getLines());
    }

    public void queueChat(String string, String string2) {
        this.queue.add(new ChatRow(string, string2.replace("\\", "\\\\").replace("'", "\\'")));
    }

    public void queueJoin(Player player) {
        this.queue.add(new PlayerJoinRow(player));
    }

    public void queueLeave(Player player) {
        this.queue.add(new PlayerLeaveRow(player));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.queue.isEmpty() || !this.lock.tryLock()) {
            return;
        }
        Connection connection = this.logblock.getConnection();
        Statement statement = null;
        if (this.getQueueSize() > 1000) {
            this.log.info("[LogBlock Consumer] Queue overloaded. Size: " + this.getQueueSize());
        }
        try {
            if (connection == null) {
                return;
            }
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            long l = System.currentTimeMillis();
            int n = 0;
            block16: while (!(this.queue.isEmpty() || System.currentTimeMillis() - l >= (long)this.config.timePerRun && n >= this.config.forceToProcessAtLeast)) {
                Row row = this.queue.poll();
                if (row == null) continue;
                for (String string : row.getPlayers()) {
                    if (this.players.containsKey(string.hashCode()) || this.addPlayer(statement, string)) continue;
                    if (this.failedPlayers.contains(string)) continue block16;
                    this.failedPlayers.add(string);
                    this.log.warning("[LogBlock Consumer] Failed to add player " + string);
                    continue block16;
                }
                for (String string : row.getInserts()) {
                    try {
                        statement.execute(string);
                    }
                    catch (SQLException sQLException) {
                        this.log.log(Level.SEVERE, "[LogBlock Consumer] SQL exception on " + string + ": ", sQLException);
                        break block16;
                    }
                }
                ++n;
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            this.log.log(Level.SEVERE, "[LogBlock Consumer] SQL exception", sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {
                this.log.log(Level.SEVERE, "[LogBlock Consumer] SQL exception on close", sQLException);
            }
            this.lock.unlock();
        }
    }

    public void writeToFile() throws FileNotFoundException {
        long l = System.currentTimeMillis();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = 0;
        new File("plugins/LogBlock/import/").mkdirs();
        PrintWriter printWriter = new PrintWriter(new File("plugins/LogBlock/import/queue-" + l + "-0.sql"));
        while (!this.queue.isEmpty()) {
            Row row = this.queue.poll();
            if (row == null) continue;
            for (String string : row.getPlayers()) {
                if (this.players.containsKey(string.hashCode()) || hashSet.contains(string.hashCode())) continue;
                printWriter.println("INSERT IGNORE INTO `lb-players` (playername) VALUES ('" + string + "');");
                hashSet.add(string.hashCode());
            }
            for (String string : row.getInserts()) {
                printWriter.println(string);
            }
            if (++n % 1000 != 0) continue;
            printWriter.close();
            printWriter = new PrintWriter(new File("plugins/LogBlock/import/queue-" + l + "-" + n / 1000 + ".sql"));
        }
        printWriter.close();
    }

    int getQueueSize() {
        return this.queue.size();
    }

    boolean hide(Player player) {
        int n = player.getName().hashCode();
        if (this.hiddenPlayers.contains(n)) {
            this.hiddenPlayers.remove(n);
            return false;
        }
        this.hiddenPlayers.add(n);
        return true;
    }

    private boolean addPlayer(Statement statement, String string) throws SQLException {
        statement.execute("INSERT IGNORE INTO `lb-players` (playername) VALUES ('" + string + "')");
        ResultSet resultSet = statement.executeQuery("SELECT playerid FROM `lb-players` WHERE playername = '" + string + "'");
        if (resultSet.next()) {
            this.players.put(string.hashCode(), resultSet.getInt(1));
        }
        resultSet.close();
        return this.players.containsKey(string.hashCode());
    }

    private void queueBlock(String string, Location location, int n, int n2, byte by, String string2, ChestAccess chestAccess) {
        if (string == null || location == null || n < 0 || n2 < 0 || n > 127 || n2 > 127 || this.hiddenPlayers.contains(string.hashCode()) || !this.worlds.containsKey(location.getWorld().getName().hashCode()) || n != n2 && this.hiddenBlocks.contains(n) && this.hiddenBlocks.contains(n2)) {
            return;
        }
        string = string.replaceAll("[^a-zA-Z0-9_]", "");
        if (string2 != null) {
            string2 = string2.replace("\\", "\\\\").replace("'", "\\'");
        }
        this.queue.add(new BlockRow(location, string, n, n2, by, string2, chestAccess));
    }

    private String playerID(String string) {
        if (string == null) {
            return "NULL";
        }
        Integer n = this.players.get(string.hashCode());
        if (n != null) {
            return n.toString();
        }
        return "(SELECT playerid FROM `lb-players` WHERE playername = '" + string + "')";
    }

    private class PlayerLeaveRow
    implements Row {
        private final String playerName;
        private final long leaveTime;

        PlayerLeaveRow(Player player) {
            this.playerName = player.getName();
            this.leaveTime = System.currentTimeMillis() / 1000L;
        }

        @Override
        public String[] getInserts() {
            return new String[]{"UPDATE `lb-players` SET onlinetime = ADDTIME(onlinetime, TIMEDIFF(FROM_UNIXTIME(" + this.leaveTime + "), lastlogin)) WHERE playerid = " + Consumer.this.playerID(this.playerName) + ";"};
        }

        @Override
        public String[] getPlayers() {
            return new String[]{this.playerName};
        }
    }

    private class PlayerJoinRow
    implements Row {
        private final String playerName;
        private final long lastLogin;
        private final String ip;

        PlayerJoinRow(Player player) {
            this.playerName = player.getName();
            this.lastLogin = System.currentTimeMillis() / 1000L;
            this.ip = player.getAddress().toString().replace("'", "\\'");
        }

        @Override
        public String[] getInserts() {
            return new String[]{"UPDATE `lb-players` SET lastlogin = FROM_UNIXTIME(" + this.lastLogin + "), firstlogin = IF(firstlogin = 0, FROM_UNIXTIME(" + this.lastLogin + "), firstlogin), ip = '" + this.ip + "' WHERE playerid = " + Consumer.this.playerID(this.playerName) + ";"};
        }

        @Override
        public String[] getPlayers() {
            return new String[]{this.playerName};
        }
    }

    private class ChatRow
    extends ChatMessage
    implements Row {
        ChatRow(String string, String string2) {
            super(string, string2);
        }

        @Override
        public String[] getInserts() {
            return new String[]{"INSERT INTO `lb-chat` (date, playerid, message) VALUES (FROM_UNIXTIME(" + this.date + "), " + Consumer.this.playerID(this.playerName) + ", '" + this.message + "');"};
        }

        @Override
        public String[] getPlayers() {
            return new String[]{this.playerName};
        }
    }

    private class KillRow
    implements Row {
        final long date = System.currentTimeMillis() / 1000L;
        final String killer;
        final String victim;
        final int weapon;
        final int worldHash;

        KillRow(int n, String string, String string2, int n2) {
            this.worldHash = n;
            this.killer = string;
            this.victim = string2;
            this.weapon = n2;
        }

        @Override
        public String[] getInserts() {
            return new String[]{"INSERT INTO `" + ((WorldConfig)((Consumer)Consumer.this).worlds.get((Object)Integer.valueOf((int)this.worldHash))).table + "-kills` (date, killer, victim, weapon) VALUES (FROM_UNIXTIME(" + this.date + "), " + Consumer.this.playerID(this.killer) + ", " + Consumer.this.playerID(this.victim) + ", " + this.weapon + ");"};
        }

        @Override
        public String[] getPlayers() {
            return new String[]{this.killer, this.victim};
        }
    }

    private class BlockRow
    extends BlockChange
    implements Row {
        public BlockRow(Location location, String string, int n, int n2, byte by, String string2, ChestAccess chestAccess) {
            super(System.currentTimeMillis() / 1000L, location, string, n, n2, by, string2, chestAccess);
        }

        @Override
        public String[] getInserts() {
            String string = ((WorldConfig)((Consumer)Consumer.this).worlds.get((Object)Integer.valueOf((int)this.loc.getWorld().getName().hashCode()))).table;
            String[] stringArray = new String[this.ca != null || this.signtext != null ? 2 : 1];
            stringArray[0] = "INSERT INTO `" + string + "` (date, playerid, replaced, type, data, x, y, z) VALUES (FROM_UNIXTIME(" + this.date + "), " + Consumer.this.playerID(this.playerName) + ", " + this.replaced + ", " + this.type + ", " + this.data + ", '" + this.loc.getBlockX() + "', " + this.loc.getBlockY() + ", '" + this.loc.getBlockZ() + "');";
            if (this.signtext != null) {
                stringArray[1] = "INSERT INTO `" + string + "-sign` (id, signtext) values (LAST_INSERT_ID(), '" + this.signtext + "');";
            } else if (this.ca != null) {
                stringArray[1] = "INSERT INTO `" + string + "-chest` (id, itemtype, itemamount, itemdata) values (LAST_INSERT_ID(), " + this.ca.itemType + ", " + this.ca.itemAmount + ", " + this.ca.itemData + ");";
            }
            return stringArray;
        }

        @Override
        public String[] getPlayers() {
            return new String[]{this.playerName};
        }
    }

    private static interface Row {
        public String[] getInserts();

        public String[] getPlayers();
    }
}

