/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Consumer;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.WorldConfig;
import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockListener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.material.MaterialData;

class LBBlockListener
extends BlockListener {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd HH:mm:ss");
    private static final Set<Integer> nonFluidProofBlocks = new HashSet<Integer>(Arrays.asList(27, 28, 31, 32, 37, 38, 39, 40, 50, 51, 55, 59, 66, 69, 70, 75, 76, 78, 93, 94, 104, 105, 106));
    private final Consumer consumer;
    private final Map<Integer, WorldConfig> worlds;
    private final List<String> errors = new ArrayList<String>(20);

    LBBlockListener(LogBlock logBlock) {
        this.consumer = logBlock.getConsumer();
        this.worlds = logBlock.getConfig().worlds;
    }

    public void onBlockBreak(BlockBreakEvent blockBreakEvent) {
        WorldConfig worldConfig = this.worlds.get(blockBreakEvent.getBlock().getWorld().getName().hashCode());
        if (!blockBreakEvent.isCancelled() && worldConfig != null && worldConfig.logBlockBreaks) {
            int n = blockBreakEvent.getBlock().getTypeId();
            if (n == 0) {
                Location location = blockBreakEvent.getBlock().getLocation();
                this.addError(dateFormat.format(System.currentTimeMillis()) + " Bukkit provided no block type for the block broken by " + blockBreakEvent.getPlayer().getName() + " at " + location.getWorld().getName() + ":" + location.getBlockX() + ":" + location.getBlockY() + ":" + location.getBlockZ() + ".");
            }
            if (worldConfig.logSignTexts && (n == 63 || n == 68)) {
                this.consumer.queueSignBreak(blockBreakEvent.getPlayer().getName(), (Sign)blockBreakEvent.getBlock().getState());
            } else if (worldConfig.logChestAccess && (n == 23 || n == 54 || n == 61)) {
                this.consumer.queueContainerBreak(blockBreakEvent.getPlayer().getName(), blockBreakEvent.getBlock().getState());
            } else if (n == 79) {
                this.consumer.queueBlockReplace(blockBreakEvent.getPlayer().getName(), blockBreakEvent.getBlock().getState(), 9, (byte)0);
            } else {
                this.consumer.queueBlockBreak(blockBreakEvent.getPlayer().getName(), blockBreakEvent.getBlock().getState());
            }
        }
    }

    public void onBlockBurn(BlockBurnEvent blockBurnEvent) {
        WorldConfig worldConfig = this.worlds.get(blockBurnEvent.getBlock().getWorld().getName().hashCode());
        if (!blockBurnEvent.isCancelled() && worldConfig != null && worldConfig.logFire) {
            this.consumer.queueBlockBreak("Fire", blockBurnEvent.getBlock().getState());
        }
    }

    public void onBlockFromTo(BlockFromToEvent blockFromToEvent) {
        WorldConfig worldConfig = this.worlds.get(blockFromToEvent.getBlock().getWorld().getName().hashCode());
        if (!blockFromToEvent.isCancelled() && worldConfig != null) {
            int n = blockFromToEvent.getBlock().getTypeId();
            int n2 = blockFromToEvent.getToBlock().getTypeId();
            if (n == 10 || n == 11) {
                if (n2 == 0) {
                    if (worldConfig.logLavaFlow) {
                        this.consumer.queueBlockPlace("LavaFlow", blockFromToEvent.getToBlock().getLocation(), 10, (byte)(blockFromToEvent.getBlock().getData() + 1));
                    }
                } else if (nonFluidProofBlocks.contains(n2)) {
                    this.consumer.queueBlockReplace("LavaFlow", blockFromToEvent.getToBlock().getState(), 10, (byte)(blockFromToEvent.getBlock().getData() + 1));
                } else if (n2 == 8 || n2 == 9) {
                    if (blockFromToEvent.getFace() == BlockFace.DOWN) {
                        this.consumer.queueBlockReplace("LavaFlow", blockFromToEvent.getToBlock().getState(), 10, (byte)0);
                    } else {
                        this.consumer.queueBlockReplace("LavaFlow", blockFromToEvent.getToBlock().getState(), 4, (byte)0);
                    }
                }
            } else if (!(n != 8 && n != 9 || n2 != 0 && !nonFluidProofBlocks.contains(n2))) {
                Block block;
                if (n2 == 0) {
                    if (worldConfig.logWaterFlow) {
                        this.consumer.queueBlockPlace("WaterFlow", blockFromToEvent.getToBlock().getLocation(), 8, (byte)(blockFromToEvent.getBlock().getData() + 1));
                    }
                } else {
                    this.consumer.queueBlockReplace("WaterFlow", blockFromToEvent.getToBlock().getState(), 8, (byte)(blockFromToEvent.getBlock().getData() + 1));
                }
                if ((block = blockFromToEvent.getToBlock().getRelative(BlockFace.DOWN)).getTypeId() == 10 || block.getTypeId() == 11) {
                    this.consumer.queueBlockReplace("WaterFlow", block.getState(), block.getData() == 0 ? 49 : 4, (byte)0);
                }
            }
        }
    }

    public void onBlockPlace(BlockPlaceEvent blockPlaceEvent) {
        WorldConfig worldConfig = this.worlds.get(blockPlaceEvent.getBlock().getWorld().getName().hashCode());
        if (!blockPlaceEvent.isCancelled() && worldConfig != null && worldConfig.logBlockPlacings) {
            int n = blockPlaceEvent.getBlock().getTypeId();
            BlockState blockState = blockPlaceEvent.getBlockReplacedState();
            BlockState blockState2 = blockPlaceEvent.getBlockPlaced().getState();
            if (n == 0 && blockPlaceEvent.getItemInHand() != null) {
                if (blockPlaceEvent.getItemInHand().getTypeId() == 51) {
                    return;
                }
                Location location = blockPlaceEvent.getBlock().getLocation();
                this.addError(dateFormat.format(System.currentTimeMillis()) + " Bukkit provided no block type for the block placed by " + blockPlaceEvent.getPlayer().getName() + " at " + location.getWorld().getName() + ":" + location.getBlockX() + ":" + location.getBlockY() + ":" + location.getBlockZ() + ". Item in hand was: " + blockPlaceEvent.getItemInHand().getType() + ".");
                blockState2.setTypeId(blockPlaceEvent.getItemInHand().getTypeId());
                blockState2.setData(new MaterialData(blockPlaceEvent.getItemInHand().getTypeId()));
            }
            if (worldConfig.logSignTexts && (n == 63 || n == 68)) {
                return;
            }
            if (blockState.getTypeId() == 0) {
                this.consumer.queueBlockPlace(blockPlaceEvent.getPlayer().getName(), blockState2);
            } else {
                this.consumer.queueBlockReplace(blockPlaceEvent.getPlayer().getName(), blockState, blockState2);
            }
        }
    }

    public void onLeavesDecay(LeavesDecayEvent leavesDecayEvent) {
        WorldConfig worldConfig = this.worlds.get(leavesDecayEvent.getBlock().getWorld().getName().hashCode());
        if (!leavesDecayEvent.isCancelled() && worldConfig != null && worldConfig.logLeavesDecay) {
            this.consumer.queueBlockBreak("LeavesDecay", leavesDecayEvent.getBlock().getState());
        }
    }

    public void onSignChange(SignChangeEvent signChangeEvent) {
        WorldConfig worldConfig = this.worlds.get(signChangeEvent.getBlock().getWorld().getName().hashCode());
        if (!signChangeEvent.isCancelled() && worldConfig != null && worldConfig.logSignTexts) {
            this.consumer.queueSignPlace(signChangeEvent.getPlayer().getName(), signChangeEvent.getBlock().getLocation(), signChangeEvent.getBlock().getTypeId(), signChangeEvent.getBlock().getData(), signChangeEvent.getLines());
        }
    }

    public void onBlockForm(BlockFormEvent blockFormEvent) {
        WorldConfig worldConfig = this.worlds.get(blockFormEvent.getBlock().getWorld().getName().hashCode());
        if (!blockFormEvent.isCancelled() && worldConfig != null) {
            int n = blockFormEvent.getNewState().getTypeId();
            if (worldConfig.logSnowForm && (n == 78 || n == 79)) {
                this.consumer.queueBlockReplace("SnowForm", blockFormEvent.getBlock().getState(), blockFormEvent.getNewState());
            }
        }
    }

    public void onBlockFade(BlockFadeEvent blockFadeEvent) {
        WorldConfig worldConfig = this.worlds.get(blockFadeEvent.getBlock().getWorld().getName().hashCode());
        if (!blockFadeEvent.isCancelled() && worldConfig != null) {
            int n = blockFadeEvent.getBlock().getTypeId();
            if (worldConfig.logSnowFade && (n == 78 || n == 79)) {
                this.consumer.queueBlockReplace("SnowFade", blockFadeEvent.getBlock().getState(), blockFadeEvent.getNewState());
            }
        }
    }

    private void addError(String string) {
        this.errors.add(string);
        if (this.errors.size() == 20) {
            try {
                File file = new File("plugins/LogBlock/error/BlockListener.log");
                file.getParentFile().mkdirs();
                PrintWriter printWriter = new PrintWriter(file);
                for (String string2 : this.errors) {
                    printWriter.println(string2);
                }
                printWriter.close();
                this.errors.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

