/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import de.diddiz.LogBlock.Config;
import de.diddiz.LogBlock.Consumer;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.WorldConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.EntityEnderman;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.craftbukkit.entity.CraftEnderman;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.entity.EndermanPickupEvent;
import org.bukkit.event.entity.EndermanPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityListener;

class LBEntityListener
extends EntityListener {
    private final Consumer consumer;
    private final boolean logCreeperExplosionsAsPlayer;
    private final Config.LogKillsLevel logKillsLevel;
    private final Map<Integer, WorldConfig> worlds;
    private final Map<Integer, Integer> lastAttackedEntity = new HashMap<Integer, Integer>();
    private final Map<Integer, Long> lastAttackTime = new HashMap<Integer, Long>();

    LBEntityListener(LogBlock logBlock) {
        this.consumer = logBlock.getConsumer();
        this.worlds = logBlock.getConfig().worlds;
        this.logCreeperExplosionsAsPlayer = logBlock.getConfig().logCreeperExplosionsAsPlayerWhoTriggeredThese;
        this.logKillsLevel = logBlock.getConfig().logKillsLevel;
    }

    public void onEntityDamage(EntityDamageEvent entityDamageEvent) {
        WorldConfig worldConfig = this.worlds.get(entityDamageEvent.getEntity().getWorld().getName().hashCode());
        if (!entityDamageEvent.isCancelled() && worldConfig != null && worldConfig.logKills && entityDamageEvent instanceof EntityDamageByEntityEvent && entityDamageEvent.getEntity() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entityDamageEvent.getEntity();
            Entity entity = ((EntityDamageByEntityEvent)entityDamageEvent).getDamager();
            if (livingEntity.getHealth() - entityDamageEvent.getDamage() > 0 || livingEntity.getHealth() <= 0) {
                return;
            }
            if (!(this.logKillsLevel != Config.LogKillsLevel.PLAYERS || livingEntity instanceof Player && entity instanceof Player)) {
                return;
            }
            if (!(this.logKillsLevel != Config.LogKillsLevel.MONSTERS || (livingEntity instanceof Player || livingEntity instanceof Monster) && entity instanceof Player || entity instanceof Monster)) {
                return;
            }
            if (this.lastAttackedEntity.containsKey(entity.getEntityId()) && this.lastAttackedEntity.get(entity.getEntityId()).intValue() == livingEntity.getEntityId() && System.currentTimeMillis() - this.lastAttackTime.get(entity.getEntityId()) < 5000L) {
                return;
            }
            this.consumer.queueKill(entity, (Entity)livingEntity);
            this.lastAttackedEntity.put(entity.getEntityId(), livingEntity.getEntityId());
            this.lastAttackTime.put(entity.getEntityId(), System.currentTimeMillis());
        }
    }

    public void onEntityExplode(EntityExplodeEvent entityExplodeEvent) {
        WorldConfig worldConfig = this.worlds.get(entityExplodeEvent.getLocation().getWorld().getName().hashCode());
        if (!entityExplodeEvent.isCancelled() && worldConfig != null && worldConfig.logExplosions) {
            LivingEntity livingEntity;
            String string = entityExplodeEvent.getEntity() == null ? "Explosion" : (entityExplodeEvent.getEntity() instanceof TNTPrimed ? "TNT" : (entityExplodeEvent.getEntity() instanceof Creeper ? (this.logCreeperExplosionsAsPlayer ? ((livingEntity = ((Creeper)entityExplodeEvent.getEntity()).getTarget()) instanceof Player ? ((Player)livingEntity).getName() : "Creeper") : "Creeper") : (entityExplodeEvent.getEntity() instanceof Fireball ? "Ghast" : "Explosion")));
            for (Block block : entityExplodeEvent.blockList()) {
                int n = block.getTypeId();
                if (worldConfig.logSignTexts & (n == 63 || n == 68)) {
                    this.consumer.queueSignBreak(string, (Sign)block.getState());
                    continue;
                }
                if (worldConfig.logChestAccess && (n == 23 || n == 54 || n == 61)) {
                    this.consumer.queueContainerBreak(string, block.getState());
                    continue;
                }
                this.consumer.queueBlockBreak(string, block.getState());
            }
        }
    }

    public void onEndermanPickup(EndermanPickupEvent endermanPickupEvent) {
        WorldConfig worldConfig = this.worlds.get(endermanPickupEvent.getBlock().getWorld().getName().hashCode());
        if (!endermanPickupEvent.isCancelled() && worldConfig != null && worldConfig.logEndermen) {
            this.consumer.queueBlockBreak("Enderman", endermanPickupEvent.getBlock().getState());
        }
    }

    public void onEndermanPlace(EndermanPlaceEvent endermanPlaceEvent) {
        WorldConfig worldConfig = this.worlds.get(endermanPlaceEvent.getLocation().getWorld().getName().hashCode());
        if (!endermanPlaceEvent.isCancelled() && worldConfig != null && worldConfig.logEndermen && endermanPlaceEvent.getEntity() instanceof Enderman) {
            EntityEnderman entityEnderman = ((CraftEnderman)endermanPlaceEvent.getEntity()).getHandle();
            this.consumer.queueBlockPlace("Enderman", endermanPlaceEvent.getLocation(), entityEnderman.getCarriedId(), (byte)entityEnderman.getCarriedData());
        }
    }
}

