/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import com.sk89q.worldedit.bukkit.selections.CuboidSelection;
import de.diddiz.LogBlock.CommandsHandler;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.Session;
import de.diddiz.LogBlock.Tool;
import de.diddiz.LogBlock.ToolBehavior;
import de.diddiz.LogBlock.ToolData;
import de.diddiz.LogBlock.ToolMode;
import de.diddiz.LogBlock.WorldConfig;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

class LBToolListener
extends PlayerListener {
    private final CommandsHandler handler;
    private final LogBlock logblock;
    private final Map<Integer, Tool> toolsByType;
    private final Map<Integer, WorldConfig> worlds;

    LBToolListener(LogBlock logBlock) {
        this.logblock = logBlock;
        this.handler = logBlock.getCommandsHandler();
        this.worlds = logBlock.getConfig().worlds;
        this.toolsByType = logBlock.getConfig().toolsByType;
    }

    public void onPlayerInteract(PlayerInteractEvent playerInteractEvent) {
        if (!playerInteractEvent.isCancelled() && playerInteractEvent.getMaterial() != null) {
            Action action = playerInteractEvent.getAction();
            int n = playerInteractEvent.getMaterial().getId();
            Tool tool = this.toolsByType.get(n);
            Player player = playerInteractEvent.getPlayer();
            if (tool != null && (action == Action.RIGHT_CLICK_BLOCK || action == Action.LEFT_CLICK_BLOCK) && this.worlds.containsKey(player.getWorld().getName().hashCode()) && this.logblock.hasPermission((CommandSender)player, "logblock.tools." + tool.name)) {
                ToolBehavior toolBehavior = action == Action.RIGHT_CLICK_BLOCK ? tool.rightClickBehavior : tool.leftClickBehavior;
                ToolData toolData = this.logblock.getSession((String)player.getName()).toolData.get(tool);
                if (toolBehavior != ToolBehavior.NONE && toolData.enabled) {
                    Block block = playerInteractEvent.getClickedBlock();
                    QueryParams queryParams = toolData.params;
                    queryParams.loc = null;
                    queryParams.sel = null;
                    if (toolBehavior == ToolBehavior.BLOCK) {
                        queryParams.setLocation(block.getRelative(playerInteractEvent.getBlockFace()).getLocation());
                    } else if (block.getTypeId() != 54 || tool.params.radius != 0) {
                        queryParams.setLocation(block.getLocation());
                    } else {
                        for (BlockFace blockFace : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
                            if (block.getRelative(blockFace).getTypeId() != 54) continue;
                            queryParams.setSelection(new CuboidSelection(playerInteractEvent.getPlayer().getWorld(), block.getLocation(), block.getRelative(blockFace).getLocation()));
                        }
                        if (queryParams.sel == null) {
                            queryParams.setLocation(block.getLocation());
                        }
                    }
                    try {
                        if (toolData.mode == ToolMode.ROLLBACK) {
                            CommandsHandler commandsHandler = this.handler;
                            commandsHandler.getClass();
                            commandsHandler.new CommandsHandler.CommandRollback((CommandSender)player, queryParams, true);
                        } else if (toolData.mode == ToolMode.REDO) {
                            CommandsHandler commandsHandler = this.handler;
                            commandsHandler.getClass();
                            commandsHandler.new CommandsHandler.CommandRedo((CommandSender)player, queryParams, true);
                        } else if (toolData.mode == ToolMode.CLEARLOG) {
                            CommandsHandler commandsHandler = this.handler;
                            commandsHandler.getClass();
                            commandsHandler.new CommandsHandler.CommandClearLog((CommandSender)player, queryParams, true);
                        } else if (toolData.mode == ToolMode.WRITELOGFILE) {
                            CommandsHandler commandsHandler = this.handler;
                            commandsHandler.getClass();
                            commandsHandler.new CommandsHandler.CommandWriteLogFile((CommandSender)player, queryParams, true);
                        } else {
                            CommandsHandler commandsHandler = this.handler;
                            commandsHandler.getClass();
                            commandsHandler.new CommandsHandler.CommandLookup((CommandSender)player, queryParams, true);
                        }
                    }
                    catch (Exception exception) {
                        player.sendMessage(ChatColor.RED + exception.getMessage());
                    }
                    playerInteractEvent.setCancelled(true);
                }
            }
        }
    }

    public void onPlayerCommandPreprocess(final PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        String[] stringArray = playerCommandPreprocessEvent.getMessage().split(" ");
        if (stringArray.length > 1 && stringArray[0].equalsIgnoreCase("/ban") && this.logblock.hasPermission((CommandSender)playerCommandPreprocessEvent.getPlayer(), this.logblock.getConfig().banPermission)) {
            final QueryParams queryParams = new QueryParams(this.logblock);
            queryParams.setPlayer(stringArray[1].equalsIgnoreCase("g") ? stringArray[2] : stringArray[1]);
            queryParams.since = 0;
            queryParams.silent = false;
            this.logblock.getServer().getScheduler().scheduleAsyncDelayedTask((Plugin)this.logblock, new Runnable(){

                @Override
                public void run() {
                    for (World world : LBToolListener.this.logblock.getServer().getWorlds()) {
                        if (((LBToolListener)LBToolListener.this).logblock.getConfig().worlds.get(world.getName().hashCode()) == null) continue;
                        queryParams.world = world;
                        try {
                            CommandsHandler commandsHandler = LBToolListener.this.handler;
                            commandsHandler.getClass();
                            commandsHandler.new CommandsHandler.CommandRollback((CommandSender)playerCommandPreprocessEvent.getPlayer(), queryParams, false);
                        }
                        catch (Exception exception) {}
                    }
                }
            });
        }
    }

    public void onPlayerChangedWorld(PlayerChangedWorldEvent playerChangedWorldEvent) {
        Player player = playerChangedWorldEvent.getPlayer();
        Session session = this.logblock.getSessions().get(player.getName().hashCode());
        if (session != null) {
            for (Map.Entry<Tool, ToolData> entry : session.toolData.entrySet()) {
                Tool tool = entry.getKey();
                ToolData toolData = entry.getValue();
                if (!toolData.enabled || this.logblock.hasPermission((CommandSender)player, "logblock.tools." + tool.name)) continue;
                toolData.enabled = false;
                player.getInventory().removeItem(new ItemStack[]{new ItemStack(tool.item, 1)});
                player.sendMessage(ChatColor.GREEN + "Tool disabled.");
            }
        }
    }
}

