/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.LogBlock;

import com.nijiko.permissions.PermissionHandler;
import com.nijikokun.bukkit.Permissions.Permissions;
import de.diddiz.LogBlock.BlockChange;
import de.diddiz.LogBlock.CommandsHandler;
import de.diddiz.LogBlock.Config;
import de.diddiz.LogBlock.Consumer;
import de.diddiz.LogBlock.LBBlockListener;
import de.diddiz.LogBlock.LBChestAccessListener;
import de.diddiz.LogBlock.LBEntityListener;
import de.diddiz.LogBlock.LBPlayerListener;
import de.diddiz.LogBlock.LBServerListener;
import de.diddiz.LogBlock.LBToolListener;
import de.diddiz.LogBlock.QueryParams;
import de.diddiz.LogBlock.Session;
import de.diddiz.LogBlock.Tool;
import de.diddiz.LogBlock.Updater;
import de.diddiz.util.MySQLConnectionPool;
import de.diddiz.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class LogBlock
extends JavaPlugin {
    private Logger log;
    private Config config;
    private MySQLConnectionPool pool;
    private Consumer consumer = null;
    private CommandsHandler commandsHandler;
    private Updater updater = null;
    private Timer timer = null;
    private PermissionHandler permissions = null;
    private boolean errorAtLoading = false;
    private final Map<Integer, Session> sessions = new HashMap<Integer, Session>();

    public Config getConfig() {
        return this.config;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public CommandsHandler getCommandsHandler() {
        return this.commandsHandler;
    }

    Updater getUpdater() {
        return this.updater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoad() {
        block16: {
            this.log = this.getServer().getLogger();
            try {
                File file;
                this.updater = new Updater(this);
                this.config = new Config(this);
                if (this.config.checkVersion) {
                    this.log.info("[LogBlock] Version check: " + this.updater.checkVersion());
                }
                if (!(file = new File("lib/mysql-connector-java-bin.jar")).exists() || file.length() == 0L) {
                    Utils.download(this.log, new URL("http://diddiz.insane-architects.net/download/mysql-connector-java-bin.jar"), file);
                }
                if (!file.exists() || file.length() == 0L) {
                    throw new FileNotFoundException(file.getAbsolutePath() + file.getName());
                }
                this.log.info("[LogBlock] Connecting to " + this.config.user + "@" + this.config.url + "...");
                this.pool = new MySQLConnectionPool(this.config.url, this.config.user, this.config.password);
                this.getConnection().close();
                if (this.updater.update()) {
                    this.config = new Config(this);
                }
                this.updater.checkTables();
                File[] fileArray = new File("plugins/LogBlock/import/").listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.toLowerCase().endsWith(".sql");
                    }
                });
                if (fileArray == null || fileArray.length <= 0) break block16;
                this.log.info("[LogBlock] Found " + fileArray.length + "imports.");
                Connection connection = null;
                try {
                    connection = this.getConnection();
                    connection.setAutoCommit(false);
                    Statement statement = connection.createStatement();
                    for (File file2 : fileArray) {
                        try {
                            this.log.info("[LogBlock] Trying to import " + file2.getName() + " ...");
                            BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                            String string = null;
                            while ((string = bufferedReader.readLine()) != null) {
                                statement.addBatch(string);
                            }
                            statement.executeBatch();
                            connection.commit();
                            bufferedReader.close();
                            file2.delete();
                            this.log.info("[LogBlock] Successfully imported " + file2.getName() + ".");
                        }
                        catch (Exception exception) {
                            this.log.log(Level.WARNING, "[LogBlock] Failed to import " + file2.getName() + ": ", exception);
                            file.renameTo(new File("plugins/LogBlock/import/" + file2.getName() + ".failed"));
                        }
                    }
                    statement.close();
                    this.log.info("[LogBlock] Successfully imported stored queue.");
                }
                catch (Exception exception) {
                    this.log.log(Level.WARNING, "[LogBlock] Error while importing: ", exception);
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (Exception exception) {
                this.log.log(Level.SEVERE, "[LogBlock] Error while loading: ", exception);
                this.errorAtLoading = true;
                return;
            }
        }
        this.consumer = new Consumer(this);
    }

    public void onEnable() {
        LBEntityListener lBEntityListener2;
        Object object;
        PluginManager pluginManager = this.getServer().getPluginManager();
        if (this.errorAtLoading) {
            pluginManager.disablePlugin((Plugin)this);
            return;
        }
        if (pluginManager.getPlugin("WorldEdit") == null && !new File("lib/WorldEdit.jar").exists() && !new File("WorldEdit.jar").exists()) {
            try {
                Utils.download(this.log, new URL("http://diddiz.insane-architects.net/download/WorldEdit.jar"), new File("lib/WorldEdit.jar"));
                this.log.info("[LogBlock] You've to restart/reload your server now.");
                pluginManager.disablePlugin((Plugin)this);
                return;
            }
            catch (Exception exception) {
                this.log.warning("[LogBlock] Failed to download WorldEdit. You may have to download it manually. You don't have to install it, just place the jar in the lib folder.");
            }
        }
        if (this.config.logChestAccess && pluginManager.getPlugin("Spout") == null) {
            if (this.config.installSpout) {
                try {
                    Utils.download(this.log, new URL("http://ci.getspout.org/job/Spout/Recommended/artifact/target/spout-dev-SNAPSHOT.jar"), new File("plugins/Spout.jar"));
                    pluginManager.loadPlugin(new File("plugins/Spout.jar"));
                    pluginManager.enablePlugin(pluginManager.getPlugin("Spout"));
                }
                catch (Exception exception) {
                    this.config.logChestAccess = false;
                    this.log.warning("[LogBlock] Failed to install Spout, you may have to restart your server or install it manually.");
                }
            } else {
                this.config.logChestAccess = false;
                this.log.warning("[LogBlock] Spout is not installed. Disabling chest logging.");
            }
        }
        this.commandsHandler = new CommandsHandler(this);
        this.getCommand("lb").setExecutor((CommandExecutor)this.commandsHandler);
        if (pluginManager.getPlugin("Permissions") != null) {
            this.permissions = ((Permissions)pluginManager.getPlugin("Permissions")).getHandler();
            this.log.info("[LogBlock] Permissions plugin found.");
        } else {
            this.log.info("[LogBlock] Permissions plugin not found. Using Bukkit Permissions.");
        }
        if (this.config.keepLogDays >= 0) {
            object = new QueryParams(this);
            ((QueryParams)object).before = this.config.keepLogDays * 1440;
            ((QueryParams)object).bct = QueryParams.BlockChangeType.ALL;
            for (LBEntityListener lBEntityListener2 : this.getServer().getWorlds()) {
                if (!this.config.worlds.containsKey(lBEntityListener2.getName().hashCode())) continue;
                ((QueryParams)object).world = lBEntityListener2;
                try {
                    CommandsHandler commandsHandler = this.commandsHandler;
                    commandsHandler.getClass();
                    commandsHandler.new CommandsHandler.CommandClearLog((CommandSender)this.getServer().getConsoleSender(), ((QueryParams)object).clone(), true);
                }
                catch (Exception exception) {
                    this.log.severe("Failed to schedule ClearLog: " + exception.getMessage());
                }
            }
        }
        object = new LBBlockListener(this);
        LBPlayerListener lBPlayerListener = new LBPlayerListener(this);
        lBEntityListener2 = new LBEntityListener(this);
        LBToolListener lBToolListener = new LBToolListener(this);
        pluginManager.registerEvent(Event.Type.PLAYER_INTERACT, (Listener)lBToolListener, Event.Priority.Normal, (Plugin)this);
        pluginManager.registerEvent(Event.Type.PLAYER_CHANGED_WORLD, (Listener)lBToolListener, Event.Priority.Normal, (Plugin)this);
        if (this.config.askRollbackAfterBan) {
            pluginManager.registerEvent(Event.Type.PLAYER_COMMAND_PREPROCESS, (Listener)lBToolListener, Event.Priority.Normal, (Plugin)this);
        }
        if (this.config.logBlockPlacings) {
            pluginManager.registerEvent(Event.Type.BLOCK_PLACE, (Listener)object, Event.Priority.Monitor, (Plugin)this);
            pluginManager.registerEvent(Event.Type.PLAYER_BUCKET_EMPTY, (Listener)lBPlayerListener, Event.Priority.Monitor, (Plugin)this);
        }
        if (this.config.logBlockBreaks) {
            pluginManager.registerEvent(Event.Type.BLOCK_BREAK, (Listener)object, Event.Priority.Monitor, (Plugin)this);
            pluginManager.registerEvent(Event.Type.PLAYER_BUCKET_FILL, (Listener)lBPlayerListener, Event.Priority.Monitor, (Plugin)this);
            pluginManager.registerEvent(Event.Type.BLOCK_FROMTO, (Listener)object, Event.Priority.Monitor, (Plugin)this);
        }
        if (this.config.logSignTexts) {
            pluginManager.registerEvent(Event.Type.SIGN_CHANGE, (Listener)object, Event.Priority.Monitor, (Plugin)this);
        }
        if (this.config.logFire) {
            pluginManager.registerEvent(Event.Type.BLOCK_BURN, (Listener)object, Event.Priority.Monitor, (Plugin)this);
        }
        if (this.config.logSnowForm) {
            pluginManager.registerEvent(Event.Type.BLOCK_FORM, (Listener)object, Event.Priority.Monitor, (Plugin)this);
        }
        if (this.config.logSnowFade) {
            pluginManager.registerEvent(Event.Type.BLOCK_FADE, (Listener)object, Event.Priority.Monitor, (Plugin)this);
        }
        if (this.config.logExplosions) {
            pluginManager.registerEvent(Event.Type.ENTITY_EXPLODE, (Listener)lBEntityListener2, Event.Priority.Monitor, (Plugin)this);
        }
        if (this.config.logLeavesDecay) {
            pluginManager.registerEvent(Event.Type.LEAVES_DECAY, (Listener)object, Event.Priority.Monitor, (Plugin)this);
        }
        if (this.config.logChestAccess) {
            if (pluginManager.getPlugin("Spout") != null) {
                pluginManager.registerEvent(Event.Type.CUSTOM_EVENT, (Listener)new LBChestAccessListener(this), Event.Priority.Monitor, (Plugin)this);
            } else {
                this.log.warning("[LogBlock] BukkitContrib not found. Can't log chest accesses.");
            }
        }
        if (this.config.logButtonsAndLevers || this.config.logDoors || this.config.logCakes) {
            pluginManager.registerEvent(Event.Type.PLAYER_INTERACT, (Listener)lBPlayerListener, Event.Priority.Monitor, (Plugin)this);
        }
        if (this.config.logKills) {
            pluginManager.registerEvent(Event.Type.ENTITY_DAMAGE, (Listener)lBEntityListener2, Event.Priority.Monitor, (Plugin)this);
        }
        if (this.config.logChat) {
            pluginManager.registerEvent(Event.Type.PLAYER_CHAT, (Listener)lBPlayerListener, Event.Priority.Monitor, (Plugin)this);
            pluginManager.registerEvent(Event.Type.PLAYER_COMMAND_PREPROCESS, (Listener)lBPlayerListener, Event.Priority.Monitor, (Plugin)this);
            pluginManager.registerEvent(Event.Type.SERVER_COMMAND, (Listener)new LBServerListener(this), Event.Priority.Monitor, (Plugin)this);
        }
        if (this.config.logEndermen) {
            pluginManager.registerEvent(Event.Type.ENDERMAN_PICKUP, (Listener)lBEntityListener2, Event.Priority.Monitor, (Plugin)this);
            pluginManager.registerEvent(Event.Type.ENDERMAN_PLACE, (Listener)lBEntityListener2, Event.Priority.Monitor, (Plugin)this);
        }
        if (this.config.logPlayerInfo) {
            pluginManager.registerEvent(Event.Type.PLAYER_JOIN, (Listener)lBPlayerListener, Event.Priority.Monitor, (Plugin)this);
            pluginManager.registerEvent(Event.Type.PLAYER_QUIT, (Listener)lBPlayerListener, Event.Priority.Monitor, (Plugin)this);
        }
        if (this.config.useBukkitScheduler) {
            if (this.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this, (Runnable)this.consumer, (long)(this.config.delayBetweenRuns * 20), (long)(this.config.delayBetweenRuns * 20)) > 0) {
                this.log.info("[LogBlock] Scheduled consumer with bukkit scheduler.");
            } else {
                this.log.warning("[LogBlock] Failed to schedule consumer with bukkit scheduler. Now trying schedule with timer.");
                this.timer = new Timer();
                this.timer.scheduleAtFixedRate((TimerTask)this.consumer, this.config.delayBetweenRuns * 1000, (long)(this.config.delayBetweenRuns * 1000));
            }
        } else {
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate((TimerTask)this.consumer, this.config.delayBetweenRuns * 1000, (long)(this.config.delayBetweenRuns * 1000));
            this.log.info("[LogBlock] Scheduled consumer with timer.");
        }
        for (Tool tool : this.config.toolsByType.values()) {
            Permission permission = new Permission("logblock.tools." + tool.name, tool.permissionDefault);
            pluginManager.addPermission(permission);
        }
        this.log.info("LogBlock v" + this.getDescription().getVersion() + " by DiddiZ enabled.");
    }

    public void onDisable() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        if (this.config.logPlayerInfo) {
            for (Player player : this.getServer().getOnlinePlayers()) {
                this.consumer.queueLeave(player);
            }
        }
        if (this.consumer != null && this.consumer.getQueueSize() > 0) {
            this.log.info("[LogBlock] Waiting for consumer ...");
            int n = -1;
            int n2 = 0;
            while (this.consumer.getQueueSize() > 0) {
                this.log.info("[LogBlock] Remaining queue size: " + this.consumer.getQueueSize());
                if (n == this.consumer.getQueueSize()) {
                    this.log.info("[LogBlock] Remaining tries: " + (10 - ++n2));
                } else {
                    n2 = 0;
                }
                if (n2 == 10) {
                    this.log.info("Unable to save queue to database. Trying to write to a local file.");
                    try {
                        this.consumer.writeToFile();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.log.info("Failed to write. Given up.");
                        break;
                    }
                }
                n = this.consumer.getQueueSize();
                this.consumer.run();
            }
        }
        if (this.pool != null) {
            this.pool.close();
        }
        this.log.info("LogBlock disabled.");
    }

    boolean hasPermission(CommandSender commandSender, String string) {
        if (this.permissions != null && commandSender instanceof Player) {
            return this.permissions.has((Player)commandSender, string);
        }
        return commandSender.hasPermission(string);
    }

    public Connection getConnection() {
        try {
            return this.pool.getConnection();
        }
        catch (Exception exception) {
            this.log.log(Level.SEVERE, "[LogBlock] Error while fetching connection", exception);
            return null;
        }
    }

    public Map<Integer, Session> getSessions() {
        return this.sessions;
    }

    public Session getSession(String string) {
        Session session = this.sessions.get(string.hashCode());
        if (session == null) {
            session = new Session(this, this.getServer().getPlayer(string));
            this.sessions.put(string.hashCode(), session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BlockChange> getBlockChanges(QueryParams queryParams) throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = null;
        ResultSet resultSet = null;
        if (connection == null) {
            throw new SQLException("No connection");
        }
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(queryParams.getQuery());
            ArrayList<BlockChange> arrayList = new ArrayList<BlockChange>();
            while (resultSet.next()) {
                arrayList.add(new BlockChange(resultSet, queryParams));
            }
            ArrayList<BlockChange> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            connection.close();
        }
    }
}

