/*
 * Decompiled with CFR 0.152.
 */
package de.diddiz.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.ContainerBlock;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.material.MaterialData;

public class BukkitUtils {
    private static final Set<Set<Integer>> blockEquivalents = new HashSet<Set<Integer>>(7);

    public static ItemStack[] compareInventories(ItemStack[] itemStackArray, ItemStack[] itemStackArray2) {
        ItemStackComparator itemStackComparator = new ItemStackComparator();
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        int n = itemStackArray.length;
        int n2 = itemStackArray2.length;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n || n4 < n2) {
            if (n3 >= n) {
                arrayList.add(itemStackArray2[n4]);
                ++n4;
                continue;
            }
            if (n4 >= n2) {
                itemStackArray[n3].setAmount(itemStackArray[n3].getAmount() * -1);
                arrayList.add(itemStackArray[n3]);
                ++n3;
                continue;
            }
            int n5 = itemStackComparator.compare(itemStackArray[n3], itemStackArray2[n4]);
            if (n5 < 0) {
                itemStackArray[n3].setAmount(itemStackArray[n3].getAmount() * -1);
                arrayList.add(itemStackArray[n3]);
                ++n3;
                continue;
            }
            if (n5 > 0) {
                arrayList.add(itemStackArray2[n4]);
                ++n4;
                continue;
            }
            int n6 = itemStackArray2[n4].getAmount() - itemStackArray[n3].getAmount();
            if (n6 != 0) {
                itemStackArray[n3].setAmount(n6);
                arrayList.add(itemStackArray[n3]);
            }
            ++n3;
            ++n4;
        }
        return arrayList.toArray(new ItemStack[arrayList.size()]);
    }

    public static ItemStack[] compressInventory(ItemStack[] itemStackArray) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        for (ItemStack itemStack : itemStackArray) {
            if (itemStack == null) continue;
            int n = itemStack.getTypeId();
            byte by = BukkitUtils.rawData(itemStack);
            boolean bl = false;
            for (ItemStack itemStack2 : arrayList) {
                if (n != itemStack2.getTypeId() || by != BukkitUtils.rawData(itemStack2)) continue;
                itemStack2.setAmount(itemStack2.getAmount() + itemStack.getAmount());
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(new ItemStack(n, itemStack.getAmount(), 0, Byte.valueOf(by)));
        }
        Collections.sort(arrayList, new ItemStackComparator());
        return arrayList.toArray(new ItemStack[arrayList.size()]);
    }

    public static boolean equalTypes(int n, int n2) {
        if (n == n2) {
            return true;
        }
        for (Set<Integer> set : blockEquivalents) {
            if (!set.contains(n) || !set.contains(n2)) continue;
            return true;
        }
        return false;
    }

    public static String friendlyWorldname(String string) {
        string = string.substring(string.lastIndexOf(47) + 1);
        return string.substring(string.lastIndexOf(92) + 1);
    }

    public static Set<Set<Integer>> getBlockEquivalents() {
        return blockEquivalents;
    }

    public static String entityName(Entity entity) {
        if (entity instanceof Player) {
            return ((Player)entity).getName();
        }
        if (entity instanceof TNTPrimed) {
            return "TNT";
        }
        return entity.getClass().getSimpleName().substring(5);
    }

    public static String materialName(int n) {
        Material material = Material.getMaterial((int)n);
        return material != null ? material.toString().replace('_', ' ').toLowerCase() : String.valueOf(n);
    }

    public static String materialName(int n, byte by) {
        Material material = Material.getMaterial((int)n);
        if (material != null) {
            MaterialData materialData;
            if (((n == 6 || n == 17 || n == 18) && by > 0 || n == 35 || n == 43 || n == 44) && (materialData = material.getNewData(by)) != null) {
                return materialData.toString().toLowerCase().replace('_', ' ').replaceAll("[^a-z ]", "");
            }
            return material.toString().replace('_', ' ').toLowerCase();
        }
        return String.valueOf(n);
    }

    public static String senderName(CommandSender commandSender) {
        if (commandSender instanceof Player) {
            return ((Player)commandSender).getName();
        }
        if (commandSender instanceof ConsoleCommandSender) {
            return "console";
        }
        return commandSender.getClass().getSimpleName();
    }

    public static void giveTool(Player player, int n) {
        PlayerInventory playerInventory = player.getInventory();
        if (playerInventory.contains(n)) {
            player.sendMessage(ChatColor.RED + "You have alredy a " + BukkitUtils.materialName(n));
        } else {
            int n2 = playerInventory.firstEmpty();
            if (n2 >= 0) {
                if (player.getItemInHand() != null && player.getItemInHand().getTypeId() != 0) {
                    playerInventory.setItem(n2, player.getItemInHand());
                }
                player.setItemInHand(new ItemStack(n, 1));
                player.sendMessage(ChatColor.GREEN + "Here's your " + BukkitUtils.materialName(n));
            } else {
                player.sendMessage(ChatColor.RED + "You have no empty slot in your inventory");
            }
        }
    }

    public static byte rawData(ItemStack itemStack) {
        return itemStack.getType() != null ? (itemStack.getData() != null ? itemStack.getData().getData() : (byte)0) : (byte)0;
    }

    public static int saveSpawnHeight(Location location) {
        boolean bl;
        Chunk chunk;
        World world = location.getWorld();
        if (!world.isChunkLoaded(chunk = world.getChunkAt(location))) {
            world.loadChunk(chunk);
        }
        int n = location.getBlockX();
        int n2 = location.getBlockZ();
        int n3 = location.getBlockY();
        boolean bl2 = world.getBlockTypeIdAt(n, n3, n2) == 0;
        boolean bl3 = bl = world.getBlockTypeIdAt(n, n3 + 1, n2) == 0;
        while (!(bl2 && bl || n3 == 127)) {
            bl2 = bl;
            bl = world.getBlockTypeIdAt(n, ++n3, n2) == 0;
        }
        while (world.getBlockTypeIdAt(n, n3 - 1, n2) == 0 && n3 != 0) {
            --n3;
        }
        return n3;
    }

    public static int modifyContainer(BlockState blockState, ItemStack itemStack) {
        if (blockState instanceof ContainerBlock) {
            Inventory inventory = ((ContainerBlock)blockState).getInventory();
            if (itemStack.getAmount() < 0) {
                itemStack.setAmount(-itemStack.getAmount());
                ItemStack itemStack2 = (ItemStack)inventory.removeItem(new ItemStack[]{itemStack}).get(0);
                return itemStack2 != null ? itemStack2.getAmount() : 0;
            }
            if (itemStack.getAmount() > 0) {
                ItemStack itemStack3 = (ItemStack)inventory.addItem(new ItemStack[]{itemStack}).get(0);
                return itemStack3 != null ? itemStack3.getAmount() : 0;
            }
        }
        return 0;
    }

    static {
        blockEquivalents.add(new HashSet<Integer>(Arrays.asList(2, 3, 60)));
        blockEquivalents.add(new HashSet<Integer>(Arrays.asList(8, 9, 79)));
        blockEquivalents.add(new HashSet<Integer>(Arrays.asList(10, 11)));
        blockEquivalents.add(new HashSet<Integer>(Arrays.asList(61, 62)));
        blockEquivalents.add(new HashSet<Integer>(Arrays.asList(73, 74)));
        blockEquivalents.add(new HashSet<Integer>(Arrays.asList(75, 76)));
        blockEquivalents.add(new HashSet<Integer>(Arrays.asList(93, 94)));
    }

    public static class ItemStackComparator
    implements Comparator<ItemStack> {
        @Override
        public int compare(ItemStack itemStack, ItemStack itemStack2) {
            byte by;
            int n;
            int n2 = itemStack.getTypeId();
            if (n2 < (n = itemStack2.getTypeId())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            byte by2 = BukkitUtils.rawData(itemStack);
            if (by2 < (by = BukkitUtils.rawData(itemStack2))) {
                return -1;
            }
            if (by2 > by) {
                return 1;
            }
            return 0;
        }
    }
}

