/*
 * Decompiled with CFR 0.152.
 */
package me.taylorkelly.myhome;

import java.util.ArrayList;
import me.taylorkelly.myhome.HomeSettings;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class Home {
    public int index;
    public String name;
    public String world;
    public double x;
    public double y;
    public double z;
    public int yaw;
    public int pitch;
    public int publicAll;
    public String welcomeMessage;
    public ArrayList<String> permissions;
    public static int nextIndex = 1;
    Location getLocation;

    public Home(int index, String name, String world, double x, double y, double z, int yaw, int pitch, int publicAll, String permissions, String welcomeMessage) {
        this.index = index;
        this.name = name;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
        this.publicAll = publicAll;
        this.permissions = this.processList(permissions);
        this.welcomeMessage = welcomeMessage;
        if (index > nextIndex) {
            nextIndex = index;
        }
        ++nextIndex;
    }

    public Home(Player creator) {
        this.index = nextIndex++;
        this.name = creator.getName();
        this.world = creator.getWorld().getName();
        this.x = creator.getLocation().getX();
        this.y = creator.getLocation().getY();
        this.z = creator.getLocation().getZ();
        this.yaw = Math.round(creator.getLocation().getYaw()) % 360;
        this.pitch = Math.round(creator.getLocation().getPitch()) % 360;
        this.publicAll = HomeSettings.homesArePublic ? 1 : 0;
        this.permissions = new ArrayList();
        this.welcomeMessage = "Welcome to " + this.name + "'s home";
    }

    public Home(String name, Location location) {
        this.index = nextIndex++;
        this.name = name;
        this.world = location.getWorld().getName();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        this.yaw = Math.round(location.getYaw()) % 360;
        this.pitch = Math.round(location.getPitch()) % 360;
        this.publicAll = HomeSettings.homesArePublic ? 1 : 0;
        this.permissions = new ArrayList();
        this.welcomeMessage = "Welcome to " + name + "'s home";
    }

    private ArrayList<String> processList(String permissions) {
        String[] names = permissions.split(",");
        ArrayList<String> ret = new ArrayList<String>();
        for (String permissionee : names) {
            if (permissionee.equals("")) continue;
            ret.add(permissionee.trim());
        }
        return ret;
    }

    public String permissionsString() {
        StringBuilder ret = new StringBuilder();
        for (String permisionee : this.permissions) {
            ret.append(permisionee);
            ret.append(",");
        }
        return ret.toString();
    }

    public boolean playerCanWarp(Player player) {
        if (this.name.equals(player.getName())) {
            return true;
        }
        if (this.permissions.contains(player.getName())) {
            return true;
        }
        return this.publicAll == 1;
    }

    public void warp(Player player, Server server) {
        World currWorld = null;
        currWorld = this.world.equals("0") ? (World)server.getWorlds().get(0) : server.getWorld(this.world);
        if (currWorld == null) {
            player.sendMessage(ChatColor.RED + "Uh oh. The world with that home doesn't exist!");
        } else {
            Location location = new Location(currWorld, this.x, this.y, this.z, (float)this.yaw, (float)this.pitch);
            player.teleport(location);
            player.sendMessage(ChatColor.AQUA + this.welcomeMessage);
        }
    }

    public boolean playerIsCreator(String player) {
        return this.name.equals(player);
    }

    public void invite(String player) {
        this.permissions.add(player);
    }

    public boolean playerIsInvited(String player) {
        return this.permissions.contains(player);
    }

    public void uninvite(String inviteeName) {
        this.permissions.remove(inviteeName);
    }

    public String invitees() {
        if (this.permissions.size() == 1) {
            return this.permissions.get(0) + " is";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.permissions.size(); ++i) {
            builder.append(this.permissions.get(i));
            if (i + 2 < this.permissions.size()) {
                builder.append(", ");
                continue;
            }
            if (i + 1 >= this.permissions.size()) continue;
            builder.append(" and ");
        }
        builder.append(" are ");
        return builder.toString();
    }

    public String toString() {
        return this.name;
    }

    public void setLocation(Location location) {
        this.world = location.getWorld().getName();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        this.yaw = Math.round(location.getYaw()) % 360;
        this.pitch = Math.round(location.getPitch()) % 360;
    }

    Location getLocation(Server server) {
        World currWorld = server.getWorld(this.world);
        if (currWorld == null) {
            return null;
        }
        return new Location(currWorld, this.x, this.y, this.z, (float)this.yaw, (float)this.pitch);
    }
}

