/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.ChestBlock;
import com.sk89q.worldedit.blocks.DispenserBlock;
import com.sk89q.worldedit.blocks.FurnaceBlock;
import com.sk89q.worldedit.blocks.MobSpawnerBlock;
import com.sk89q.worldedit.blocks.NoteBlock;
import com.sk89q.worldedit.blocks.SignBlock;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.data.DataException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CuboidClipboard {
    private BaseBlock[][][] data;
    private Vector offset;
    private Vector origin;
    private Vector size;

    public CuboidClipboard(Vector size) {
        this.size = size;
        this.data = new BaseBlock[size.getBlockX()][size.getBlockY()][size.getBlockZ()];
        this.origin = new Vector();
        this.offset = new Vector();
    }

    public CuboidClipboard(Vector size, Vector origin) {
        this.size = size;
        this.data = new BaseBlock[size.getBlockX()][size.getBlockY()][size.getBlockZ()];
        this.origin = origin;
        this.offset = new Vector();
    }

    public CuboidClipboard(Vector size, Vector origin, Vector offset) {
        this.size = size;
        this.data = new BaseBlock[size.getBlockX()][size.getBlockY()][size.getBlockZ()];
        this.origin = origin;
        this.offset = offset;
    }

    public int getWidth() {
        return this.size.getBlockX();
    }

    public int getLength() {
        return this.size.getBlockZ();
    }

    public int getHeight() {
        return this.size.getBlockY();
    }

    public void rotate2D(int angle) {
        if ((angle %= 360) % 90 != 0) {
            return;
        }
        boolean reverse = angle < 0;
        int numRotations = (int)Math.floor((double)angle / 90.0);
        int width = this.getWidth();
        int length = this.getLength();
        int height = this.getHeight();
        Vector sizeRotated = this.size.transform2D(angle, 0.0, 0.0, 0.0, 0.0);
        int shiftX = sizeRotated.getX() < 0.0 ? -sizeRotated.getBlockX() - 1 : 0;
        int shiftZ = sizeRotated.getZ() < 0.0 ? -sizeRotated.getBlockZ() - 1 : 0;
        BaseBlock[][][] newData = new BaseBlock[Math.abs(sizeRotated.getBlockX())][Math.abs(sizeRotated.getBlockY())][Math.abs(sizeRotated.getBlockZ())];
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < length; ++z) {
                Vector v = new Vector(x, 0, z).transform2D(angle, 0.0, 0.0, 0.0, 0.0);
                int newX = v.getBlockX();
                int newZ = v.getBlockZ();
                for (int y = 0; y < height; ++y) {
                    int i;
                    BaseBlock block;
                    newData[shiftX + newX][y][shiftZ + newZ] = block = this.data[x][y][z];
                    if (reverse) {
                        for (i = 0; i < numRotations; ++i) {
                            block.rotate90Reverse();
                        }
                        continue;
                    }
                    for (i = 0; i < numRotations; ++i) {
                        block.rotate90();
                    }
                }
            }
        }
        this.data = newData;
        this.size = new Vector(Math.abs(sizeRotated.getBlockX()), Math.abs(sizeRotated.getBlockY()), Math.abs(sizeRotated.getBlockZ()));
        this.offset = this.offset.transform2D(angle, 0.0, 0.0, 0.0, 0.0).subtract(shiftX, 0, shiftZ);
    }

    public void flip(FlipDirection dir) {
        block10: {
            int height;
            int length;
            int width;
            block11: {
                block9: {
                    width = this.getWidth();
                    length = this.getLength();
                    height = this.getHeight();
                    if (dir != FlipDirection.NORTH_SOUTH) break block9;
                    int len = (int)Math.floor(width / 2);
                    for (int xs = 0; xs < len; ++xs) {
                        for (int z = 0; z < length; ++z) {
                            for (int y = 0; y < height; ++y) {
                                BaseBlock old = this.data[xs][y][z];
                                old.flip();
                                this.data[xs][y][z] = this.data[width - xs - 1][y][z];
                                this.data[width - xs - 1][y][z] = old;
                            }
                        }
                    }
                    break block10;
                }
                if (dir != FlipDirection.WEST_EAST) break block11;
                int len = (int)Math.floor(length / 2);
                for (int zs = 0; zs < len; ++zs) {
                    for (int x = 0; x < width; ++x) {
                        for (int y = 0; y < height; ++y) {
                            BaseBlock old = this.data[x][y][zs];
                            old.flip();
                            this.data[x][y][zs] = this.data[x][y][length - zs - 1];
                            this.data[x][y][length - zs - 1] = old;
                        }
                    }
                }
                break block10;
            }
            if (dir != FlipDirection.UP_DOWN) break block10;
            int len = (int)Math.floor(height / 2);
            for (int ys = 0; ys < len; ++ys) {
                for (int x = 0; x < width; ++x) {
                    for (int z = 0; z < length; ++z) {
                        BaseBlock old = this.data[x][ys][z];
                        this.data[x][ys][z] = this.data[x][height - ys - 1][z];
                        this.data[x][height - ys - 1][z] = old;
                    }
                }
            }
        }
    }

    public void copy(EditSession editSession) {
        for (int x = 0; x < this.size.getBlockX(); ++x) {
            for (int y = 0; y < this.size.getBlockY(); ++y) {
                for (int z = 0; z < this.size.getBlockZ(); ++z) {
                    this.data[x][y][z] = editSession.getBlock(new Vector(x, y, z).add(this.getOrigin()));
                }
            }
        }
    }

    public void paste(EditSession editSession, Vector newOrigin, boolean noAir) throws MaxChangedBlocksException {
        this.place(editSession, newOrigin.add(this.offset), noAir);
    }

    public void place(EditSession editSession, Vector pos, boolean noAir) throws MaxChangedBlocksException {
        for (int x = 0; x < this.size.getBlockX(); ++x) {
            for (int y = 0; y < this.size.getBlockY(); ++y) {
                for (int z = 0; z < this.size.getBlockZ(); ++z) {
                    if (noAir && this.data[x][y][z].isAir()) continue;
                    editSession.setBlock(new Vector(x, y, z).add(pos), this.data[x][y][z]);
                }
            }
        }
    }

    public BaseBlock getPoint(Vector pos) throws ArrayIndexOutOfBoundsException {
        return this.data[pos.getBlockX()][pos.getBlockY()][pos.getBlockZ()];
    }

    public Vector getSize() {
        return this.size;
    }

    public void saveSchematic(File path) throws IOException, DataException {
        int width = this.getWidth();
        int height = this.getHeight();
        int length = this.getLength();
        if (width > 65535) {
            throw new DataException("Width of region too large for a .schematic");
        }
        if (height > 65535) {
            throw new DataException("Height of region too large for a .schematic");
        }
        if (length > 65535) {
            throw new DataException("Length of region too large for a .schematic");
        }
        HashMap<String, Tag> schematic = new HashMap<String, Tag>();
        schematic.put("Width", new ShortTag("Width", (short)width));
        schematic.put("Length", new ShortTag("Length", (short)length));
        schematic.put("Height", new ShortTag("Height", (short)height));
        schematic.put("Materials", new StringTag("Materials", "Alpha"));
        schematic.put("WEOriginX", new IntTag("WEOriginX", this.getOrigin().getBlockX()));
        schematic.put("WEOriginY", new IntTag("WEOriginY", this.getOrigin().getBlockY()));
        schematic.put("WEOriginZ", new IntTag("WEOriginZ", this.getOrigin().getBlockZ()));
        schematic.put("WEOffsetX", new IntTag("WEOffsetX", this.getOffset().getBlockX()));
        schematic.put("WEOffsetY", new IntTag("WEOffsetY", this.getOffset().getBlockY()));
        schematic.put("WEOffsetZ", new IntTag("WEOffsetZ", this.getOffset().getBlockZ()));
        byte[] blocks = new byte[width * height * length];
        byte[] blockData = new byte[width * height * length];
        ArrayList<Tag> tileEntities = new ArrayList<Tag>();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    TileEntityBlock tileEntityBlock;
                    Map<String, Tag> values;
                    int index = y * width * length + z * width + x;
                    blocks[index] = (byte)this.data[x][y][z].getType();
                    blockData[index] = (byte)this.data[x][y][z].getData();
                    if (!(this.data[x][y][z] instanceof TileEntityBlock) || (values = (tileEntityBlock = (TileEntityBlock)((Object)this.data[x][y][z])).toTileEntityNBT()) == null) continue;
                    values.put("id", new StringTag("id", tileEntityBlock.getTileEntityID()));
                    values.put("x", new IntTag("x", x));
                    values.put("y", new IntTag("y", y));
                    values.put("z", new IntTag("z", z));
                    CompoundTag tileEntityTag = new CompoundTag("TileEntity", values);
                    tileEntities.add(tileEntityTag);
                }
            }
        }
        schematic.put("Blocks", new ByteArrayTag("Blocks", blocks));
        schematic.put("Data", new ByteArrayTag("Data", blockData));
        schematic.put("Entities", new ListTag("Entities", CompoundTag.class, new ArrayList<Tag>()));
        schematic.put("TileEntities", new ListTag("TileEntities", CompoundTag.class, tileEntities));
        CompoundTag schematicTag = new CompoundTag("Schematic", schematic);
        NBTOutputStream stream = new NBTOutputStream(new FileOutputStream(path));
        stream.writeTag(schematicTag);
        stream.close();
    }

    public static CuboidClipboard loadSchematic(File path) throws DataException, IOException {
        FileInputStream stream = new FileInputStream(path);
        NBTInputStream nbtStream = new NBTInputStream(new GZIPInputStream(stream));
        Vector origin = new Vector();
        Vector offset = new Vector();
        CompoundTag schematicTag = (CompoundTag)nbtStream.readTag();
        if (!schematicTag.getName().equals("Schematic")) {
            throw new DataException("Tag \"Schematic\" does not exist or is not first");
        }
        Object schematic = schematicTag.getValue();
        if (!schematic.containsKey("Blocks")) {
            throw new DataException("Schematic file is missing a \"Blocks\" tag");
        }
        int width = ((Short)CuboidClipboard.getChildTag((Map<String, Tag>)schematic, "Width", ShortTag.class).getValue()).shortValue();
        int length = ((Short)CuboidClipboard.getChildTag((Map<String, Tag>)schematic, "Length", ShortTag.class).getValue()).shortValue();
        int height = ((Short)CuboidClipboard.getChildTag((Map<String, Tag>)schematic, "Height", ShortTag.class).getValue()).shortValue();
        try {
            int originX = (Integer)CuboidClipboard.getChildTag((Map<String, Tag>)schematic, "WEOriginX", IntTag.class).getValue();
            int originY = (Integer)CuboidClipboard.getChildTag((Map<String, Tag>)schematic, "WEOriginY", IntTag.class).getValue();
            int originZ = (Integer)CuboidClipboard.getChildTag((Map<String, Tag>)schematic, "WEOriginZ", IntTag.class).getValue();
            origin = new Vector(originX, originY, originZ);
        }
        catch (DataException e) {
            // empty catch block
        }
        try {
            int offsetX = (Integer)CuboidClipboard.getChildTag((Map<String, Tag>)schematic, "WEOffsetX", IntTag.class).getValue();
            int offsetY = (Integer)CuboidClipboard.getChildTag((Map<String, Tag>)schematic, "WEOffsetY", IntTag.class).getValue();
            int offsetZ = (Integer)CuboidClipboard.getChildTag((Map<String, Tag>)schematic, "WEOffsetZ", IntTag.class).getValue();
            offset = new Vector(offsetX, offsetY, offsetZ);
        }
        catch (DataException e) {
            // empty catch block
        }
        String materials = (String)CuboidClipboard.getChildTag((Map<String, Tag>)schematic, "Materials", StringTag.class).getValue();
        if (!materials.equals("Alpha")) {
            throw new DataException("Schematic file is not an Alpha schematic");
        }
        byte[] blocks = (byte[])CuboidClipboard.getChildTag((Map<String, Tag>)schematic, "Blocks", ByteArrayTag.class).getValue();
        byte[] blockData = (byte[])CuboidClipboard.getChildTag((Map<String, Tag>)schematic, "Data", ByteArrayTag.class).getValue();
        Object tileEntities = ((ListTag)CuboidClipboard.getChildTag((Map<String, Tag>)schematic, "TileEntities", ListTag.class)).getValue();
        HashMap tileEntitiesMap = new HashMap();
        Iterator i$ = tileEntities.iterator();
        while (i$.hasNext()) {
            Tag tag = (Tag)i$.next();
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag t = (CompoundTag)tag;
            int x = 0;
            int y = 0;
            int z = 0;
            HashMap values = new HashMap();
            for (Map.Entry entry : t.getValue().entrySet()) {
                if (((String)entry.getKey()).equals("x")) {
                    if (entry.getValue() instanceof IntTag) {
                        x = ((IntTag)entry.getValue()).getValue();
                    }
                } else if (((String)entry.getKey()).equals("y")) {
                    if (entry.getValue() instanceof IntTag) {
                        y = ((IntTag)entry.getValue()).getValue();
                    }
                } else if (((String)entry.getKey()).equals("z") && entry.getValue() instanceof IntTag) {
                    z = ((IntTag)entry.getValue()).getValue();
                }
                values.put(entry.getKey(), entry.getValue());
            }
            BlockVector vec = new BlockVector(x, y, z);
            tileEntitiesMap.put(vec, values);
        }
        Vector size = new Vector(width, height, length);
        CuboidClipboard clipboard = new CuboidClipboard(size);
        clipboard.setOrigin(origin);
        clipboard.setOffset(offset);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    int index = y * width * length + z * width + x;
                    BlockVector pt = new BlockVector(x, y, z);
                    BaseBlock block = blocks[index] == 68 || blocks[index] == 63 ? new SignBlock(blocks[index], blockData[index]) : (blocks[index] == 54 ? new ChestBlock(blockData[index]) : (blocks[index] == 61 || blocks[index] == 62 ? new FurnaceBlock(blocks[index], blockData[index]) : (blocks[index] == 23 ? new DispenserBlock(blockData[index]) : (blocks[index] == 52 ? new MobSpawnerBlock(blockData[index]) : (blocks[index] == 25 ? new NoteBlock(blockData[index]) : new BaseBlock(blocks[index], blockData[index]))))));
                    if (block instanceof TileEntityBlock && tileEntitiesMap.containsKey(pt)) {
                        ((TileEntityBlock)((Object)block)).fromTileEntityNBT((Map)tileEntitiesMap.get(pt));
                    }
                    clipboard.data[x][y][z] = block;
                }
            }
        }
        return clipboard;
    }

    private static Tag getChildTag(Map<String, Tag> items, String key, Class<? extends Tag> expected) throws DataException {
        if (!items.containsKey(key)) {
            throw new DataException("Schematic file is missing a \"" + key + "\" tag");
        }
        Tag tag = items.get(key);
        if (!expected.isInstance(tag)) {
            throw new DataException(key + " tag is not of tag type " + expected.getName());
        }
        return tag;
    }

    public Vector getOrigin() {
        return this.origin;
    }

    public void setOrigin(Vector origin) {
        this.origin = origin;
    }

    public Vector getOffset() {
        return this.offset;
    }

    public void setOffset(Vector offset) {
        this.offset = offset;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FlipDirection {
        NORTH_SOUTH,
        WEST_EAST,
        UP_DOWN;

    }
}

