/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EntityType;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.blocks.ContainerBlock;
import com.sk89q.worldedit.blocks.FurnaceBlock;
import com.sk89q.worldedit.blocks.MobSpawnerBlock;
import com.sk89q.worldedit.blocks.NoteBlock;
import com.sk89q.worldedit.blocks.SignBlock;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.bukkit.EditSessionBlockChangeDelegate;
import com.sk89q.worldedit.regions.Region;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Furnace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Slime;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class BukkitWorld
extends LocalWorld {
    private World world;

    public BukkitWorld(World world) {
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    public boolean setBlockType(Vector pt, int type) {
        return this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).setTypeId(type);
    }

    public boolean setBlockTypeFast(Vector pt, int type) {
        return this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).setTypeId(type, false);
    }

    public int getBlockType(Vector pt) {
        return this.world.getBlockTypeIdAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
    }

    public void setBlockData(Vector pt, int data) {
        this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).setData((byte)data);
    }

    public void setBlockDataFast(Vector pt, int data) {
        this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).setData((byte)data, false);
    }

    public int getBlockData(Vector pt) {
        return this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).getData();
    }

    public int getBlockLightLevel(Vector pt) {
        return this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).getLightLevel();
    }

    public boolean regenerate(Region region, EditSession editSession) {
        BaseBlock[] history = new BaseBlock[32768];
        for (Vector2D chunk : region.getChunks()) {
            int index;
            Vector pt;
            int z;
            int y;
            int x;
            Vector min = new Vector(chunk.getBlockX() * 16, 0, chunk.getBlockZ() * 16);
            for (x = 0; x < 16; ++x) {
                for (y = 0; y < 128; ++y) {
                    for (z = 0; z < 16; ++z) {
                        pt = min.add(x, y, z);
                        index = y * 16 * 16 + z * 16 + x;
                        history[index] = editSession.getBlock(pt);
                    }
                }
            }
            try {
                this.world.regenerateChunk(chunk.getBlockX(), chunk.getBlockZ());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            for (x = 0; x < 16; ++x) {
                for (y = 0; y < 128; ++y) {
                    for (z = 0; z < 16; ++z) {
                        pt = min.add(x, y, z);
                        index = y * 16 * 16 + z * 16 + x;
                        if (!region.contains(pt)) {
                            editSession.smartSetBlock(pt, history[index]);
                            continue;
                        }
                        editSession.rememberChange(pt, history[index], editSession.rawGetBlock(pt));
                    }
                }
            }
        }
        return true;
    }

    public boolean copyToWorld(Vector pt, BaseBlock block) {
        if (block instanceof SignBlock) {
            this.setSignText(pt, ((SignBlock)block).getText());
            return true;
        }
        if (block instanceof FurnaceBlock) {
            Block bukkitBlock = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof Furnace)) {
                return false;
            }
            Furnace bukkit = (Furnace)state;
            FurnaceBlock we = (FurnaceBlock)block;
            bukkit.setBurnTime(we.getBurnTime());
            bukkit.setCookTime(we.getCookTime());
            return this.setContainerBlockContents(pt, ((ContainerBlock)((Object)block)).getItems());
        }
        if (block instanceof ContainerBlock) {
            return this.setContainerBlockContents(pt, ((ContainerBlock)((Object)block)).getItems());
        }
        if (block instanceof MobSpawnerBlock) {
            Block bukkitBlock = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof CreatureSpawner)) {
                return false;
            }
            CreatureSpawner bukkit = (CreatureSpawner)state;
            MobSpawnerBlock we = (MobSpawnerBlock)block;
            bukkit.setCreatureTypeId(we.getMobType());
            bukkit.setDelay((int)we.getDelay());
            return true;
        }
        if (block instanceof NoteBlock) {
            Block bukkitBlock = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof org.bukkit.block.NoteBlock)) {
                return false;
            }
            org.bukkit.block.NoteBlock bukkit = (org.bukkit.block.NoteBlock)state;
            NoteBlock we = (NoteBlock)block;
            bukkit.setNote(we.getNote());
            return true;
        }
        return false;
    }

    public boolean copyFromWorld(Vector pt, BaseBlock block) {
        if (block instanceof SignBlock) {
            ((SignBlock)block).setText(this.getSignText(pt));
            return true;
        }
        if (block instanceof FurnaceBlock) {
            Block bukkitBlock = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof Furnace)) {
                return false;
            }
            Furnace bukkit = (Furnace)state;
            FurnaceBlock we = (FurnaceBlock)block;
            we.setBurnTime(bukkit.getBurnTime());
            we.setCookTime(bukkit.getCookTime());
            ((ContainerBlock)((Object)block)).setItems(this.getContainerBlockContents(pt));
            return true;
        }
        if (block instanceof ContainerBlock) {
            ((ContainerBlock)((Object)block)).setItems(this.getContainerBlockContents(pt));
            return true;
        }
        if (block instanceof MobSpawnerBlock) {
            Block bukkitBlock = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof CreatureSpawner)) {
                return false;
            }
            CreatureSpawner bukkit = (CreatureSpawner)state;
            MobSpawnerBlock we = (MobSpawnerBlock)block;
            we.setMobType(bukkit.getCreatureTypeId());
            we.setDelay((short)bukkit.getDelay());
            return true;
        }
        if (block instanceof NoteBlock) {
            Block bukkitBlock = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof org.bukkit.block.NoteBlock)) {
                return false;
            }
            org.bukkit.block.NoteBlock bukkit = (org.bukkit.block.NoteBlock)state;
            NoteBlock we = (NoteBlock)block;
            we.setNote(bukkit.getNote());
        }
        return false;
    }

    public boolean clearContainerBlockContents(Vector pt) {
        Block block = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
        if (block == null) {
            return false;
        }
        BlockState state = block.getState();
        if (!(state instanceof org.bukkit.block.ContainerBlock)) {
            return false;
        }
        org.bukkit.block.ContainerBlock chest = (org.bukkit.block.ContainerBlock)state;
        Inventory inven = chest.getInventory();
        inven.clear();
        return true;
    }

    public boolean generateTree(EditSession editSession, Vector pt) {
        return this.world.generateTree(BukkitUtil.toLocation(this.world, pt), TreeType.TREE, (BlockChangeDelegate)new EditSessionBlockChangeDelegate(editSession));
    }

    public boolean generateBigTree(EditSession editSession, Vector pt) {
        return this.world.generateTree(BukkitUtil.toLocation(this.world, pt), TreeType.BIG_TREE, (BlockChangeDelegate)new EditSessionBlockChangeDelegate(editSession));
    }

    public boolean generateBirchTree(EditSession editSession, Vector pt) {
        return this.world.generateTree(BukkitUtil.toLocation(this.world, pt), TreeType.BIRCH, (BlockChangeDelegate)new EditSessionBlockChangeDelegate(editSession));
    }

    public boolean generateRedwoodTree(EditSession editSession, Vector pt) {
        return this.world.generateTree(BukkitUtil.toLocation(this.world, pt), TreeType.REDWOOD, (BlockChangeDelegate)new EditSessionBlockChangeDelegate(editSession));
    }

    public boolean generateTallRedwoodTree(EditSession editSession, Vector pt) {
        return this.world.generateTree(BukkitUtil.toLocation(this.world, pt), TreeType.TALL_REDWOOD, (BlockChangeDelegate)new EditSessionBlockChangeDelegate(editSession));
    }

    public void dropItem(Vector pt, BaseItemStack item) {
        ItemStack bukkitItem = new ItemStack(item.getType(), item.getAmount(), (short)((byte)item.getDamage()));
        this.world.dropItemNaturally(this.toLocation(pt), bukkitItem);
    }

    public int killMobs(Vector origin, int radius) {
        return this.killMobs(origin, radius, false);
    }

    public int killMobs(Vector origin, int radius, boolean killPets) {
        int num = 0;
        double radiusSq = Math.pow(radius, 2.0);
        for (LivingEntity ent : this.world.getLivingEntities()) {
            if (!killPets && ent instanceof Wolf && ((Wolf)ent).isTamed() || !(ent instanceof Creature) && !(ent instanceof Ghast) && !(ent instanceof Slime) || radius != -1 && !(origin.distanceSq(BukkitUtil.toVector(ent.getLocation())) <= radiusSq)) continue;
            ent.remove();
            ++num;
        }
        return num;
    }

    public int removeEntities(EntityType type, Vector origin, int radius) {
        int num = 0;
        double radiusSq = Math.pow(radius, 2.0);
        for (Entity ent : this.world.getEntities()) {
            if (radius != -1 && origin.distanceSq(BukkitUtil.toVector(ent.getLocation())) > radiusSq) continue;
            if (type == EntityType.ARROWS) {
                if (!(ent instanceof Arrow)) continue;
                ent.remove();
                ++num;
                continue;
            }
            if (type == EntityType.BOATS) {
                if (!(ent instanceof Boat)) continue;
                ent.remove();
                ++num;
                continue;
            }
            if (type == EntityType.ITEMS) {
                if (!(ent instanceof Item)) continue;
                ent.remove();
                ++num;
                continue;
            }
            if (type == EntityType.MINECARTS) {
                if (!(ent instanceof Minecart)) continue;
                ent.remove();
                ++num;
                continue;
            }
            if (type == EntityType.PAINTINGS) {
                if (!(ent instanceof Painting)) continue;
                ent.remove();
                ++num;
                continue;
            }
            if (type != EntityType.TNT || !(ent instanceof TNTPrimed)) continue;
            ent.remove();
            ++num;
        }
        return num;
    }

    private Location toLocation(Vector pt) {
        return new Location(this.world, pt.getX(), pt.getY(), pt.getZ());
    }

    private boolean setSignText(Vector pt, String[] text) {
        Block block = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
        if (block == null) {
            return false;
        }
        BlockState state = block.getState();
        if (state == null || !(state instanceof Sign)) {
            return false;
        }
        Sign sign = (Sign)state;
        sign.setLine(0, text[0]);
        sign.setLine(1, text[1]);
        sign.setLine(2, text[2]);
        sign.setLine(3, text[3]);
        sign.update();
        return true;
    }

    private String[] getSignText(Vector pt) {
        Block block = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
        if (block == null) {
            return new String[]{"", "", "", ""};
        }
        BlockState state = block.getState();
        if (state == null || !(state instanceof Sign)) {
            return new String[]{"", "", "", ""};
        }
        Sign sign = (Sign)state;
        String line0 = sign.getLine(0);
        String line1 = sign.getLine(1);
        String line2 = sign.getLine(2);
        String line3 = sign.getLine(3);
        return new String[]{line0 != null ? line0 : "", line1 != null ? line1 : "", line2 != null ? line2 : "", line3 != null ? line3 : ""};
    }

    private BaseItemStack[] getContainerBlockContents(Vector pt) {
        Block block = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
        if (block == null) {
            return new BaseItemStack[0];
        }
        BlockState state = block.getState();
        if (!(state instanceof org.bukkit.block.ContainerBlock)) {
            return new BaseItemStack[0];
        }
        org.bukkit.block.ContainerBlock container = (org.bukkit.block.ContainerBlock)state;
        Inventory inven = container.getInventory();
        int size = inven.getSize();
        BaseItemStack[] contents = new BaseItemStack[size];
        for (int i = 0; i < size; ++i) {
            ItemStack bukkitStack = inven.getItem(i);
            if (bukkitStack.getTypeId() <= 0) continue;
            contents[i] = new BaseItemStack(bukkitStack.getTypeId(), bukkitStack.getAmount(), bukkitStack.getDurability());
        }
        return contents;
    }

    private boolean setContainerBlockContents(Vector pt, BaseItemStack[] contents) {
        Block block = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
        if (block == null) {
            return false;
        }
        BlockState state = block.getState();
        if (!(state instanceof org.bukkit.block.ContainerBlock)) {
            return false;
        }
        org.bukkit.block.ContainerBlock chest = (org.bukkit.block.ContainerBlock)state;
        Inventory inven = chest.getInventory();
        int size = inven.getSize();
        for (int i = 0; i < size && i < contents.length; ++i) {
            if (contents[i] != null) {
                inven.setItem(i, new ItemStack(contents[i].getType(), contents[i].getAmount(), (short)((byte)contents[i].getDamage())));
                continue;
            }
            inven.setItem(i, null);
        }
        return true;
    }

    public boolean isValidBlockType(int type) {
        return Material.getMaterial((int)type) != null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof BukkitWorld)) {
            return false;
        }
        return ((BukkitWorld)other).world.equals(this.world);
    }

    public int hashCode() {
        return this.world.hashCode();
    }
}

