/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldguard.blacklist.events.BlockBreakBlacklistEvent;
import com.sk89q.worldguard.blacklist.events.ItemUseBlacklistEvent;
import com.sk89q.worldguard.bukkit.BukkitUtil;
import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Creature;
import org.bukkit.entity.CreatureType;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageByProjectileEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityListener;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.painting.PaintingBreakByEntityEvent;
import org.bukkit.event.painting.PaintingBreakEvent;
import org.bukkit.event.painting.PaintingPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class WorldGuardEntityListener
extends EntityListener {
    private static final Logger logger = Logger.getLogger("Minecraft.WorldGuard");
    private WorldGuardPlugin plugin;

    public WorldGuardEntityListener(WorldGuardPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerEvents() {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        this.registerEvent("ENTITY_DAMAGE", Event.Priority.High);
        this.registerEvent("ENTITY_COMBUST", Event.Priority.High);
        this.registerEvent("ENTITY_EXPLODE", Event.Priority.High);
        this.registerEvent("CREATURE_SPAWN", Event.Priority.High);
        this.registerEvent("ENTITY_INTERACT", Event.Priority.High);
        this.registerEvent("CREEPER_POWER", Event.Priority.High);
        this.registerEvent("PIG_ZAP", Event.Priority.High);
        this.registerEvent("PAINTING_BREAK", Event.Priority.High);
        this.registerEvent("PAINTING_PLACE", Event.Priority.High);
        this.registerEvent("ENTITY_REGAIN_HEALTH", Event.Priority.High);
    }

    private void registerEvent(String typeName, Event.Priority priority) {
        try {
            Event.Type type = Event.Type.valueOf((String)typeName);
            PluginManager pm = this.plugin.getServer().getPluginManager();
            pm.registerEvent(type, (Listener)this, priority, (Plugin)this.plugin);
        }
        catch (IllegalArgumentException e) {
            logger.info("WorldGuard: Unable to register missing event type " + typeName);
        }
    }

    public void onEntityInteract(EntityInteractEvent event) {
        Entity entity = event.getEntity();
        Block block = event.getBlock();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(entity.getWorld());
        if (block.getType() == Material.SOIL && entity instanceof Creature && wcfg.disableCreatureCropTrampling) {
            event.setCancelled(true);
        }
    }

    private void onEntityDamageByBlock(EntityDamageByBlockEvent event) {
        Entity defender = event.getEntity();
        EntityDamageEvent.DamageCause type = event.getCause();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(defender.getWorld());
        if (defender instanceof Wolf && ((Wolf)defender).isTamed()) {
            if (wcfg.antiWolfDumbness && type != EntityDamageEvent.DamageCause.VOID) {
                event.setCancelled(true);
                return;
            }
        } else if (defender instanceof Player) {
            Player player = (Player)defender;
            if (cfg.hasGodMode(player)) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableLavaDamage && type == EntityDamageEvent.DamageCause.LAVA) {
                event.setCancelled(true);
                if (cfg.hasGodMode(player)) {
                    player.setFireTicks(0);
                }
                return;
            }
            if (wcfg.disableContactDamage && type == EntityDamageEvent.DamageCause.CONTACT) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.teleportOnVoid && type == EntityDamageEvent.DamageCause.VOID) {
                BukkitUtil.findFreePosition(player);
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableVoidDamage && type == EntityDamageEvent.DamageCause.VOID) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableExplosionDamage && event.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) {
                event.setCancelled(true);
                return;
            }
        }
    }

    private void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        WorldConfiguration wcfg;
        ConfigurationManager cfg;
        Player player;
        Entity attacker = event.getDamager();
        Entity defender = event.getEntity();
        if (attacker instanceof Player) {
            player = (Player)attacker;
            cfg = this.plugin.getGlobalStateManager();
            wcfg = cfg.get(player.getWorld());
            ItemStack held = player.getInventory().getItemInHand();
            if (held != null && wcfg.getBlacklist() != null && !wcfg.getBlacklist().check(new ItemUseBlacklistEvent(this.plugin.wrapPlayer(player), BukkitUtil.toVector(player.getLocation()), held.getTypeId()), false, false)) {
                event.setCancelled(true);
                return;
            }
        }
        if (defender instanceof Player) {
            RegionManager mgr;
            Vector pt;
            player = (Player)defender;
            cfg = this.plugin.getGlobalStateManager();
            wcfg = cfg.get(player.getWorld());
            if (cfg.hasGodMode(player)) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableLightningDamage && event.getCause() == EntityDamageEvent.DamageCause.LIGHTNING) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableExplosionDamage && event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
                event.setCancelled(true);
                return;
            }
            if (attacker != null && attacker instanceof Player && wcfg.useRegions) {
                pt = BukkitUtil.toVector(defender.getLocation());
                mgr = this.plugin.getGlobalRegionManager().get(player.getWorld());
                if (!mgr.getApplicableRegions(pt).allows(DefaultFlag.PVP)) {
                    ((Player)attacker).sendMessage(ChatColor.DARK_RED + "You are in a no-PvP area.");
                    event.setCancelled(true);
                    return;
                }
            }
            if (attacker != null && attacker instanceof LivingEntity && !(attacker instanceof Player)) {
                if (attacker instanceof Creeper && wcfg.blockCreeperExplosions) {
                    event.setCancelled(true);
                    return;
                }
                if (wcfg.disableMobDamage) {
                    event.setCancelled(true);
                    return;
                }
                if (wcfg.useRegions) {
                    pt = BukkitUtil.toVector(defender.getLocation());
                    mgr = this.plugin.getGlobalRegionManager().get(player.getWorld());
                    ApplicableRegionSet set = mgr.getApplicableRegions(pt);
                    if (!set.allows(DefaultFlag.MOB_DAMAGE)) {
                        event.setCancelled(true);
                        return;
                    }
                    if (attacker instanceof Creeper && !set.allows(DefaultFlag.CREEPER_EXPLOSION)) {
                        event.setCancelled(true);
                        return;
                    }
                }
            }
        }
    }

    private void onEntityDamageByProjectile(EntityDamageByProjectileEvent event) {
        Entity defender = event.getEntity();
        Entity attacker = event.getDamager();
        if (defender instanceof Player) {
            RegionManager mgr;
            Vector pt;
            Player player = (Player)defender;
            ConfigurationManager cfg = this.plugin.getGlobalStateManager();
            WorldConfiguration wcfg = cfg.get(player.getWorld());
            if (cfg.hasGodMode(player)) {
                event.setCancelled(true);
                return;
            }
            if (attacker != null && attacker instanceof Player && wcfg.useRegions) {
                pt = BukkitUtil.toVector(defender.getLocation());
                mgr = this.plugin.getGlobalRegionManager().get(player.getWorld());
                if (!mgr.getApplicableRegions(pt).allows(DefaultFlag.PVP)) {
                    ((Player)attacker).sendMessage(ChatColor.DARK_RED + "You are in a no-PvP area.");
                    event.setCancelled(true);
                    return;
                }
            }
            if (attacker != null && attacker instanceof Skeleton) {
                if (wcfg.disableMobDamage) {
                    event.setCancelled(true);
                    return;
                }
                if (wcfg.useRegions) {
                    pt = BukkitUtil.toVector(defender.getLocation());
                    mgr = this.plugin.getGlobalRegionManager().get(player.getWorld());
                    if (!mgr.getApplicableRegions(pt).allows(DefaultFlag.MOB_DAMAGE)) {
                        event.setCancelled(true);
                        return;
                    }
                }
            }
        }
    }

    public void onEntityDamage(EntityDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event instanceof EntityDamageByProjectileEvent) {
            this.onEntityDamageByProjectile((EntityDamageByProjectileEvent)event);
            return;
        }
        if (event instanceof EntityDamageByEntityEvent) {
            this.onEntityDamageByEntity((EntityDamageByEntityEvent)event);
            return;
        }
        if (event instanceof EntityDamageByBlockEvent) {
            this.onEntityDamageByBlock((EntityDamageByBlockEvent)event);
            return;
        }
        Entity defender = event.getEntity();
        EntityDamageEvent.DamageCause type = event.getCause();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(defender.getWorld());
        if (defender instanceof Wolf && ((Wolf)defender).isTamed()) {
            if (wcfg.antiWolfDumbness) {
                event.setCancelled(true);
                return;
            }
        } else if (defender instanceof Player) {
            Player player = (Player)defender;
            if (cfg.hasGodMode(player)) {
                event.setCancelled(true);
                player.setFireTicks(0);
                return;
            }
            if (type == EntityDamageEvent.DamageCause.DROWNING && cfg.hasAmphibiousMode(player)) {
                player.setRemainingAir(player.getMaximumAir());
                event.setCancelled(true);
                return;
            }
            if (type == EntityDamageEvent.DamageCause.DROWNING && wcfg.pumpkinScuba && (player.getInventory().getHelmet().getType() == Material.PUMPKIN || player.getInventory().getHelmet().getType() == Material.JACK_O_LANTERN)) {
                player.setRemainingAir(player.getMaximumAir());
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableFallDamage && type == EntityDamageEvent.DamageCause.FALL) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableFireDamage && (type == EntityDamageEvent.DamageCause.FIRE || type == EntityDamageEvent.DamageCause.FIRE_TICK)) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableDrowningDamage && type == EntityDamageEvent.DamageCause.DROWNING) {
                player.setRemainingAir(player.getMaximumAir());
                event.setCancelled(true);
                return;
            }
            if (wcfg.teleportOnSuffocation && type == EntityDamageEvent.DamageCause.SUFFOCATION) {
                BukkitUtil.findFreePosition(player);
                event.setCancelled(true);
                return;
            }
            if (wcfg.disableSuffocationDamage && type == EntityDamageEvent.DamageCause.SUFFOCATION) {
                event.setCancelled(true);
                return;
            }
        }
    }

    public void onEntityCombust(EntityCombustEvent event) {
        Player player;
        if (event.isCancelled()) {
            return;
        }
        Entity entity = event.getEntity();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        if (entity instanceof Player && cfg.hasGodMode(player = (Player)entity)) {
            event.setCancelled(true);
            return;
        }
    }

    public void onEntityExplode(EntityExplodeEvent event) {
        RegionManager mgr;
        Vector pt;
        if (event.isCancelled()) {
            return;
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        Location l = event.getLocation();
        World world = l.getWorld();
        WorldConfiguration wcfg = cfg.get(world);
        Entity ent = event.getEntity();
        if (ent instanceof LivingEntity) {
            if (wcfg.blockCreeperBlockDamage) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.blockCreeperExplosions) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions) {
                pt = BukkitUtil.toVector(l);
                mgr = this.plugin.getGlobalRegionManager().get(world);
                if (!mgr.getApplicableRegions(pt).allows(DefaultFlag.CREEPER_EXPLOSION)) {
                    event.setCancelled(true);
                    return;
                }
            }
        } else if (ent instanceof Fireball) {
            if (wcfg.useRegions) {
                pt = BukkitUtil.toVector(l);
                mgr = this.plugin.getGlobalRegionManager().get(world);
                if (!mgr.getApplicableRegions(pt).allows(DefaultFlag.GHAST_FIREBALL)) {
                    event.setCancelled(true);
                    return;
                }
            }
        } else if (ent instanceof TNTPrimed) {
            if (cfg.activityHaltToggle) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.blockTNT) {
                event.setCancelled(true);
                return;
            }
            if (wcfg.useRegions) {
                pt = BukkitUtil.toVector(l);
                mgr = this.plugin.getGlobalRegionManager().get(world);
                if (!mgr.getApplicableRegions(pt).allows(DefaultFlag.TNT)) {
                    event.setCancelled(true);
                    return;
                }
            }
        }
        if (wcfg.signChestProtection) {
            for (Block block : event.blockList()) {
                if (!wcfg.isChestProtected(block)) continue;
                event.setCancelled(true);
                return;
            }
        }
        if (wcfg.useRegions) {
            RegionManager mgr2 = this.plugin.getGlobalRegionManager().get(world);
            for (Block block : event.blockList()) {
                BlockVector pt2 = BukkitUtil.toVector(block);
                if (mgr2.getApplicableRegions(pt2).allows(DefaultFlag.TNT)) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        if (cfg.activityHaltToggle) {
            event.setCancelled(true);
            return;
        }
        WorldConfiguration wcfg = cfg.get(event.getEntity().getWorld());
        CreatureType creaType = event.getCreatureType();
        if (wcfg.blockCreatureSpawn.contains(creaType)) {
            event.setCancelled(true);
            return;
        }
        Location eventLoc = event.getLocation();
        if (wcfg.useRegions) {
            Vector pt = BukkitUtil.toVector(eventLoc);
            RegionManager mgr = this.plugin.getGlobalRegionManager().get(eventLoc.getWorld());
            ApplicableRegionSet set = mgr.getApplicableRegions(pt);
            if (!set.allows(DefaultFlag.MOB_SPAWNING)) {
                event.setCancelled(true);
                return;
            }
            Set blockTypes = (Set)set.getFlag(DefaultFlag.DENY_SPAWN);
            if (blockTypes != null && blockTypes.contains(creaType)) {
                event.setCancelled(true);
                return;
            }
        }
    }

    public void onPigZap(PigZapEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getEntity().getWorld());
        if (wcfg.disablePigZap) {
            event.setCancelled(true);
        }
    }

    public void onCreeperPower(CreeperPowerEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(event.getEntity().getWorld());
        if (wcfg.disableCreeperPower) {
            event.setCancelled(true);
        }
    }

    public void onPaintingBreak(PaintingBreakEvent breakEvent) {
        if (breakEvent.isCancelled()) {
            return;
        }
        if (!(breakEvent instanceof PaintingBreakByEntityEvent)) {
            return;
        }
        PaintingBreakByEntityEvent event = (PaintingBreakByEntityEvent)breakEvent;
        if (!(event.getRemover() instanceof Player)) {
            return;
        }
        Painting painting = event.getPainting();
        Player player = (Player)event.getRemover();
        World world = painting.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.getBlacklist() != null && !wcfg.getBlacklist().check(new BlockBreakBlacklistEvent(this.plugin.wrapPlayer(player), BukkitUtil.toVector(player.getLocation()), 321), false, false)) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.useRegions && !this.plugin.getGlobalRegionManager().canBuild(player, painting.getLocation())) {
            player.sendMessage(ChatColor.DARK_RED + "You don't have permission for this area.");
            event.setCancelled(true);
            return;
        }
    }

    public void onPaintingPlace(PaintingPlaceEvent event) {
        Block placedOn = event.getBlock();
        Player player = event.getPlayer();
        World world = placedOn.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.getBlacklist() != null && !wcfg.getBlacklist().check(new ItemUseBlacklistEvent(this.plugin.wrapPlayer(player), BukkitUtil.toVector(player.getLocation()), 321), false, false)) {
            event.setCancelled(true);
            return;
        }
        if (wcfg.useRegions && !this.plugin.getGlobalRegionManager().canBuild(player, placedOn.getLocation())) {
            player.sendMessage(ChatColor.DARK_RED + "You don't have permission for this area.");
            event.setCancelled(true);
            return;
        }
    }

    public void onEntityRegainHealth(EntityRegainHealthEvent event) {
        Entity ent = event.getEntity();
        World world = ent.getWorld();
        ConfigurationManager cfg = this.plugin.getGlobalStateManager();
        WorldConfiguration wcfg = cfg.get(world);
        if (wcfg.disableHealthRegain) {
            event.setCancelled(true);
            return;
        }
    }
}

