/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.blocks.ItemType;
import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GeneralCommands {
    @Command(aliases={"god"}, usage="[player]", desc="Enable godmode on a player", flags="s", min=0, max=1)
    public static void god(CommandContext args, WorldGuardPlugin plugin, CommandSender sender) throws CommandException {
        ConfigurationManager config = plugin.getGlobalStateManager();
        Iterable<Player> targets = null;
        boolean included = false;
        if (args.argsLength() == 0) {
            targets = plugin.matchPlayers(plugin.checkPlayer(sender));
            plugin.checkPermission(sender, "worldguard.god");
        } else if (args.argsLength() == 1) {
            targets = plugin.matchPlayers(sender, args.getString(0));
            plugin.checkPermission(sender, "worldguard.god.other");
        }
        for (Player player : targets) {
            config.enableGodMode(player);
            player.setFireTicks(0);
            if (player.equals(sender)) {
                player.sendMessage(ChatColor.YELLOW + "God mode enabled! Use /ungod to disable.");
                included = true;
                continue;
            }
            player.sendMessage(ChatColor.YELLOW + "God enabled by " + plugin.toName(sender) + ".");
        }
        if (!included && args.hasFlag('s')) {
            sender.sendMessage(ChatColor.YELLOW.toString() + "Players now have god mode.");
        }
    }

    @Command(aliases={"ungod"}, usage="[player]", desc="Disable godmode on a player", flags="s", min=0, max=1)
    public static void ungod(CommandContext args, WorldGuardPlugin plugin, CommandSender sender) throws CommandException {
        ConfigurationManager config = plugin.getGlobalStateManager();
        Iterable<Player> targets = null;
        boolean included = false;
        if (args.argsLength() == 0) {
            targets = plugin.matchPlayers(plugin.checkPlayer(sender));
            plugin.checkPermission(sender, "worldguard.god");
        } else if (args.argsLength() == 1) {
            targets = plugin.matchPlayers(sender, args.getString(0));
            plugin.checkPermission(sender, "worldguard.god.other");
        }
        for (Player player : targets) {
            config.disableGodMode(player);
            if (player.equals(sender)) {
                player.sendMessage(ChatColor.YELLOW + "God mode disabled!");
                included = true;
                continue;
            }
            player.sendMessage(ChatColor.YELLOW + "God disabled by " + plugin.toName(sender) + ".");
        }
        if (!included && args.hasFlag('s')) {
            sender.sendMessage(ChatColor.YELLOW.toString() + "Players no longer have god mode.");
        }
    }

    @Command(aliases={"heal"}, usage="[player]", desc="Heal a player", flags="s", min=0, max=1)
    public static void heal(CommandContext args, WorldGuardPlugin plugin, CommandSender sender) throws CommandException {
        Iterable<Player> targets = null;
        boolean included = false;
        if (args.argsLength() == 0) {
            targets = plugin.matchPlayers(plugin.checkPlayer(sender));
            plugin.checkPermission(sender, "worldguard.heal");
        } else if (args.argsLength() == 1) {
            targets = plugin.matchPlayers(sender, args.getString(0));
            plugin.checkPermission(sender, "worldguard.heal.other");
        }
        for (Player player : targets) {
            player.setHealth(20);
            if (player.equals(sender)) {
                player.sendMessage(ChatColor.YELLOW + "Healed!");
                included = true;
                continue;
            }
            player.sendMessage(ChatColor.YELLOW + "Healed by " + plugin.toName(sender) + ".");
        }
        if (!included && args.hasFlag('s')) {
            sender.sendMessage(ChatColor.YELLOW.toString() + "Players healed.");
        }
    }

    @Command(aliases={"slay"}, usage="[player]", desc="Slay a player", flags="s", min=0, max=1)
    public static void slay(CommandContext args, WorldGuardPlugin plugin, CommandSender sender) throws CommandException {
        Iterable<Player> targets = null;
        boolean included = false;
        if (args.argsLength() == 0) {
            targets = plugin.matchPlayers(plugin.checkPlayer(sender));
            plugin.checkPermission(sender, "worldguard.slay");
        } else if (args.argsLength() == 1) {
            targets = plugin.matchPlayers(sender, args.getString(0));
            plugin.checkPermission(sender, "worldguard.slay.other");
        }
        for (Player player : targets) {
            player.setHealth(0);
            if (player.equals(sender)) {
                player.sendMessage(ChatColor.YELLOW + "Slain!");
                included = true;
                continue;
            }
            player.sendMessage(ChatColor.YELLOW + "Slain by " + plugin.toName(sender) + ".");
        }
        if (!included && args.hasFlag('s')) {
            sender.sendMessage(ChatColor.YELLOW.toString() + "Players slain.");
        }
    }

    @Command(aliases={"locate"}, usage="[player]", desc="Locate a player", flags="", min=0, max=1)
    @CommandPermissions(value={"worldguard.locate"})
    public static void locate(CommandContext args, WorldGuardPlugin plugin, CommandSender sender) throws CommandException {
        Player player = plugin.checkPlayer(sender);
        if (args.argsLength() == 0) {
            player.setCompassTarget(player.getWorld().getSpawnLocation());
            sender.sendMessage(ChatColor.YELLOW.toString() + "Compass reset to spawn.");
        } else {
            Player target = plugin.matchSinglePlayer(sender, args.getString(0));
            player.setCompassTarget(target.getLocation());
            sender.sendMessage(ChatColor.YELLOW.toString() + "Compass repointed.");
        }
    }

    @Command(aliases={"stack"}, usage="", desc="Stack items", flags="", min=0, max=0)
    @CommandPermissions(value={"worldguard.stack"})
    public static void stack(CommandContext args, WorldGuardPlugin plugin, CommandSender sender) throws CommandException {
        Player player = plugin.checkPlayer(sender);
        ItemStack[] items = player.getInventory().getContents();
        int len = items.length;
        int affected = 0;
        block0: for (int i = 0; i < len; ++i) {
            ItemStack item = items[i];
            if (item == null || item.getAmount() <= 0 || ItemType.shouldNotStack(item.getTypeId()) || item.getTypeId() >= 325 && item.getTypeId() <= 327 || item.getAmount() >= 64) continue;
            int needed = 64 - item.getAmount();
            for (int j = i + 1; j < len; ++j) {
                ItemStack item2 = items[j];
                if (item2 == null || item2.getAmount() <= 0 || ItemType.shouldNotStack(item.getTypeId()) || item2.getTypeId() != item.getTypeId() || ItemType.usesDamageValue(item.getTypeId()) && item.getDurability() != item2.getDurability()) continue;
                if (item2.getAmount() > needed) {
                    item.setAmount(64);
                    item2.setAmount(item2.getAmount() - needed);
                    continue block0;
                }
                items[j] = null;
                item.setAmount(item.getAmount() + item2.getAmount());
                needed = 64 - item.getAmount();
                ++affected;
            }
        }
        if (affected > 0) {
            player.getInventory().setContents(items);
        }
        player.sendMessage(ChatColor.YELLOW + "Items compacted into stacks!");
    }
}

