/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.bukkit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldguard.bukkit.LoggerToChatHandler;
import com.sk89q.worldguard.bukkit.ReportWriter;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.util.PastebinPoster;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WorldGuardCommands {
    @Command(aliases={"version"}, usage="", desc="Get the WorldGuard version", flags="", min=0, max=0)
    public static void version(CommandContext args, WorldGuardPlugin plugin, CommandSender sender) throws CommandException {
        sender.sendMessage(ChatColor.YELLOW + "WorldGuard " + plugin.getDescription().getVersion());
        sender.sendMessage(ChatColor.YELLOW + "http://www.sk89q.com");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(aliases={"reload"}, usage="", desc="Reload WorldGuard configuration", flags="", min=0, max=0)
    @CommandPermissions(value={"worldguard.reload"})
    public static void relload(CommandContext args, WorldGuardPlugin plugin, CommandSender sender) throws CommandException {
        LoggerToChatHandler handler = null;
        Logger minecraftLogger = null;
        if (sender instanceof Player) {
            handler = new LoggerToChatHandler(sender);
            handler.setLevel(Level.ALL);
            minecraftLogger = Logger.getLogger("Minecraft");
            minecraftLogger.addHandler(handler);
        }
        try {
            plugin.getGlobalStateManager().unload();
            plugin.getGlobalRegionManager().unload();
            plugin.getGlobalStateManager().load();
            plugin.getGlobalRegionManager().preload();
            sender.sendMessage("WorldGuard configuration reloaded.");
        }
        catch (Throwable t) {
            sender.sendMessage("Error while reloading: " + t.getMessage());
        }
        finally {
            if (minecraftLogger != null) {
                minecraftLogger.removeHandler(handler);
            }
        }
    }

    @Command(aliases={"report"}, usage="", desc="Writes a report on WorldGuard", flags="p", min=0, max=0)
    @CommandPermissions(value={"worldguard.report"})
    public static void report(CommandContext args, WorldGuardPlugin plugin, final CommandSender sender) throws CommandException {
        File dest = new File(plugin.getDataFolder(), "report.txt");
        ReportWriter report = new ReportWriter(plugin);
        try {
            report.write(dest);
            sender.sendMessage(ChatColor.YELLOW + "WorldGuard report written to " + dest.getAbsolutePath());
        }
        catch (IOException e) {
            throw new CommandException("Failed to write report: " + e.getMessage());
        }
        if (args.hasFlag('p')) {
            plugin.checkPermission(sender, "worldguard.report.pastebin");
            sender.sendMessage(ChatColor.YELLOW + "Now uploading to Pastebin...");
            PastebinPoster.paste(report.toString(), new PastebinPoster.PasteCallback(){

                public void handleSuccess(String url) {
                    sender.sendMessage(ChatColor.YELLOW + "WorldGuard report (1 hour): " + url);
                }

                public void handleError(String err) {
                    sender.sendMessage(ChatColor.YELLOW + "WorldGuard report pastebin error: " + err);
                }
            });
        }
    }
}

