/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection;

import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.RegionGroupFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicableRegionSet
implements Iterable<ProtectedRegion> {
    private Collection<ProtectedRegion> applicable;
    private ProtectedRegion globalRegion;

    public ApplicableRegionSet(Collection<ProtectedRegion> applicable, ProtectedRegion globalRegion) {
        this.applicable = applicable;
        this.globalRegion = globalRegion;
    }

    public boolean canBuild(LocalPlayer player) {
        return this.internalGetState(DefaultFlag.BUILD, player, null, null);
    }

    public boolean canUse(LocalPlayer player) {
        return !this.allows(DefaultFlag.USE, player) && !this.canBuild(player);
    }

    public boolean allows(StateFlag flag) {
        if (flag == DefaultFlag.BUILD) {
            throw new IllegalArgumentException("Can't use build flag with allows()");
        }
        return this.internalGetState(flag, null, null, null);
    }

    public boolean allows(StateFlag flag, LocalPlayer player) {
        if (flag == DefaultFlag.BUILD) {
            throw new IllegalArgumentException("Can't use build flag with allows()");
        }
        return this.internalGetState(flag, null, flag.getGroupFlag(), player);
    }

    public boolean isOwnerOfAll(LocalPlayer player) {
        for (ProtectedRegion region : this.applicable) {
            if (region.isOwner(player)) continue;
            return false;
        }
        return true;
    }

    public boolean isMemberOfAll(LocalPlayer player) {
        for (ProtectedRegion region : this.applicable) {
            if (region.isMember(player)) continue;
            return false;
        }
        return true;
    }

    private boolean internalGetState(StateFlag flag, LocalPlayer player, RegionGroupFlag groupFlag, LocalPlayer groupPlayer) {
        boolean found = false;
        boolean hasFlagDefined = false;
        boolean allowed = false;
        boolean def = flag.getDefault();
        if (this.globalRegion != null) {
            StateFlag.State globalState = (StateFlag.State)((Object)this.globalRegion.getFlag(flag));
            if (globalState != null) {
                def = player != null && this.globalRegion.hasMembersOrOwners() ? this.globalRegion.isMember(player) && globalState == StateFlag.State.ALLOW : globalState == StateFlag.State.ALLOW;
            } else if (player != null && this.globalRegion.hasMembersOrOwners()) {
                def = this.globalRegion.isMember(player);
            }
        }
        if (player == null) {
            allowed = def;
        }
        int lastPriority = Integer.MIN_VALUE;
        HashSet<ProtectedRegion> needsClear = new HashSet<ProtectedRegion>();
        HashSet<ProtectedRegion> hasCleared = new HashSet<ProtectedRegion>();
        for (ProtectedRegion region : this.applicable) {
            StateFlag.State v;
            if (hasFlagDefined && region.getPriority() < lastPriority) break;
            lastPriority = region.getPriority();
            if (player != null && region.getFlag(DefaultFlag.PASSTHROUGH) == StateFlag.State.ALLOW) continue;
            if (groupPlayer != null && groupFlag != null) {
                RegionGroupFlag.RegionGroup group = (RegionGroupFlag.RegionGroup)((Object)region.getFlag(groupFlag));
                if (group == null) {
                    group = groupFlag.getDefault();
                }
                if (!RegionGroupFlag.isMember(region, group, groupPlayer)) continue;
            }
            if ((v = (StateFlag.State)((Object)region.getFlag(flag))) == StateFlag.State.DENY) {
                return false;
            }
            if (v == StateFlag.State.ALLOW) {
                allowed = true;
                found = true;
                hasFlagDefined = true;
                continue;
            }
            if (player != null) {
                hasFlagDefined = true;
                if (!hasCleared.contains(region)) {
                    if (!region.isMember(player)) {
                        needsClear.add(region);
                    } else {
                        this.clearParents(needsClear, hasCleared, region);
                    }
                }
            }
            found = true;
        }
        return !found ? def : allowed || player != null && needsClear.size() == 0;
    }

    private void clearParents(Set<ProtectedRegion> needsClear, Set<ProtectedRegion> hasCleared, ProtectedRegion region) {
        for (ProtectedRegion parent = region.getParent(); parent != null; parent = parent.getParent()) {
            if (needsClear.remove(parent)) continue;
            hasCleared.add(parent);
        }
    }

    public <T extends Flag<V>, V> V getFlag(T flag) {
        if (flag instanceof StateFlag) {
            throw new IllegalArgumentException("Cannot use StateFlag with getFlag()");
        }
        int lastPriority = 0;
        boolean found = false;
        HashMap needsClear = new HashMap();
        HashSet<ProtectedRegion> hasCleared = new HashSet<ProtectedRegion>();
        for (ProtectedRegion region : this.applicable) {
            if (found && region.getPriority() < lastPriority) break;
            if (!hasCleared.contains(region) && region.getFlag(flag) != null) {
                this.clearParents(needsClear, hasCleared, region);
                needsClear.put(region, region.getFlag(flag));
                found = true;
            }
            lastPriority = region.getPriority();
        }
        try {
            return needsClear.values().iterator().next();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private void clearParents(Map<ProtectedRegion, ?> needsClear, Set<ProtectedRegion> hasCleared, ProtectedRegion region) {
        for (ProtectedRegion parent = region.getParent(); parent != null; parent = parent.getParent()) {
            if (needsClear.remove(parent) != null) continue;
            hasCleared.add(parent);
        }
    }

    public int size() {
        return this.applicable.size();
    }

    @Override
    public Iterator<ProtectedRegion> iterator() {
        return this.applicable.iterator();
    }
}

