/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection;

import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.BukkitUtil;
import com.sk89q.worldguard.bukkit.ConfigurationManager;
import com.sk89q.worldguard.bukkit.WorldConfiguration;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.databases.YAMLDatabase;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.FlatRegionManager;
import com.sk89q.worldguard.protection.managers.RegionManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GlobalRegionManager {
    private static final Logger logger = Logger.getLogger("Minecraft.WorldGuard");
    private WorldGuardPlugin plugin;
    private ConfigurationManager config;
    private HashMap<String, RegionManager> managers;
    private HashMap<String, Long> lastModified;

    public GlobalRegionManager(WorldGuardPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getGlobalStateManager();
        this.managers = new HashMap();
        this.lastModified = new HashMap();
    }

    public void unload() {
        this.managers.clear();
        this.lastModified.clear();
    }

    protected File getPath(String name) {
        return new File(this.plugin.getDataFolder(), "worlds" + File.separator + name + File.separator + "regions.yml");
    }

    public void unload(String name) {
        RegionManager manager = this.managers.get(name);
        if (manager != null) {
            this.managers.remove(name);
            this.lastModified.remove(name);
        }
    }

    public void unloadAll() {
        this.managers.clear();
        this.lastModified.clear();
    }

    public RegionManager load(World world) {
        String name = world.getName();
        File file = this.getPath(name);
        try {
            FlatRegionManager manager = new FlatRegionManager(new YAMLDatabase(file));
            this.managers.put(name, manager);
            manager.load();
            logger.info("WorldGuard: " + ((RegionManager)manager).getRegions().size() + " regions loaded for '" + name + "'");
            this.lastModified.put(name, file.lastModified());
            return manager;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            logger.warning("WorldGuard: Failed to load regions from file " + file.getAbsolutePath() + " : " + e.getMessage());
        }
        return null;
    }

    public void preload() {
        for (World world : this.plugin.getServer().getWorlds()) {
            this.load(world);
        }
    }

    public void reloadChanged() {
        for (String name : this.managers.keySet()) {
            File file = this.getPath(name);
            Long oldDate = this.lastModified.get(name);
            if (oldDate == null) {
                oldDate = 0L;
            }
            try {
                World world;
                if (file.lastModified() <= oldDate || (world = this.plugin.getServer().getWorld(name)) == null) continue;
                this.load(world);
            }
            catch (Exception e) {}
        }
    }

    public RegionManager get(World world) {
        RegionManager manager = this.managers.get(world.getName());
        if (manager == null) {
            manager = this.load(world);
        }
        return manager;
    }

    public boolean hasBypass(LocalPlayer player, World world) {
        return player.hasPermission("worldguard.region.bypass." + world.getName());
    }

    public boolean hasBypass(Player player, World world) {
        return this.plugin.hasPermission((CommandSender)player, "worldguard.region.bypass." + world.getName());
    }

    public boolean canBuild(Player player, Block block) {
        return this.canBuild(player, block.getLocation());
    }

    public boolean canBuild(Player player, Location loc) {
        RegionManager mgr;
        World world = loc.getWorld();
        WorldConfiguration worldConfig = this.config.get(world);
        if (!worldConfig.useRegions) {
            return true;
        }
        LocalPlayer localPlayer = this.plugin.wrapPlayer(player);
        return this.hasBypass(player, world) || (mgr = this.get(world)).getApplicableRegions(BukkitUtil.toVector(loc)).canBuild(localPlayer);
    }

    public boolean allows(StateFlag flag, Location loc) {
        World world = loc.getWorld();
        WorldConfiguration worldConfig = this.config.get(world);
        if (!worldConfig.useRegions) {
            return true;
        }
        RegionManager mgr = this.plugin.getGlobalRegionManager().get(world);
        return mgr.getApplicableRegions(BukkitUtil.toVector(loc)).allows(flag);
    }
}

