/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection.flags;

import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.InvalidFlagFormat;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import org.bukkit.command.CommandSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionGroupFlag
extends Flag<RegionGroup> {
    private RegionGroup def;

    public RegionGroupFlag(String name, char legacyCode, RegionGroup def) {
        super(name, legacyCode);
        this.def = def;
    }

    public RegionGroupFlag(String name, RegionGroup def) {
        super(name);
        this.def = def;
    }

    public RegionGroup getDefault() {
        return this.def;
    }

    @Override
    public RegionGroup parseInput(WorldGuardPlugin plugin, CommandSender sender, String input) throws InvalidFlagFormat {
        if ((input = input.trim()).equalsIgnoreCase("members") || input.equalsIgnoreCase("member")) {
            return RegionGroup.MEMBERS;
        }
        if (input.equalsIgnoreCase("owners") || input.equalsIgnoreCase("owner")) {
            return RegionGroup.OWNERS;
        }
        if (input.equalsIgnoreCase("nonowners") || input.equalsIgnoreCase("nonowner")) {
            return RegionGroup.NON_OWNERS;
        }
        if (input.equalsIgnoreCase("nonmembers") || input.equalsIgnoreCase("nonmember")) {
            return RegionGroup.NON_MEMBERS;
        }
        if (input.equalsIgnoreCase("everyone") || input.equalsIgnoreCase("anyone")) {
            return null;
        }
        throw new InvalidFlagFormat("Not none/allow/deny: " + input);
    }

    @Override
    public RegionGroup unmarshal(Object o) {
        String str = o.toString();
        if (str.equalsIgnoreCase("members")) {
            return RegionGroup.MEMBERS;
        }
        if (str.equalsIgnoreCase("owners")) {
            return RegionGroup.OWNERS;
        }
        if (str.equalsIgnoreCase("nonmembers")) {
            return RegionGroup.NON_MEMBERS;
        }
        if (str.equalsIgnoreCase("nonowners")) {
            return RegionGroup.NON_OWNERS;
        }
        return null;
    }

    @Override
    public Object marshal(RegionGroup o) {
        if (o == RegionGroup.MEMBERS) {
            return "members";
        }
        if (o == RegionGroup.OWNERS) {
            return "owners";
        }
        if (o == RegionGroup.NON_MEMBERS) {
            return "nonmembers";
        }
        if (o == RegionGroup.NON_OWNERS) {
            return "nonowners";
        }
        return null;
    }

    public static boolean isMember(ProtectedRegion region, RegionGroup group, LocalPlayer player) {
        return group == RegionGroup.OWNERS ? region.isOwner(player) : (group == RegionGroup.MEMBERS ? region.isMember(player) : (group == RegionGroup.NON_OWNERS ? !region.isOwner(player) : group == RegionGroup.NON_MEMBERS && !region.isMember(player)));
    }

    public static boolean isMember(ApplicableRegionSet set, RegionGroup group, LocalPlayer player) {
        return group == RegionGroup.OWNERS ? set.isOwnerOfAll(player) : (group == RegionGroup.MEMBERS ? set.isMemberOfAll(player) : (group == RegionGroup.NON_OWNERS ? !set.isOwnerOfAll(player) : group == RegionGroup.NON_MEMBERS && !set.isMemberOfAll(player)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RegionGroup {
        MEMBERS,
        OWNERS,
        NON_MEMBERS,
        NON_OWNERS;

    }
}

