/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.protection.regions;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.domains.DefaultDomain;
import com.sk89q.worldguard.protection.UnsupportedIntersectionException;
import com.sk89q.worldguard.protection.flags.Flag;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProtectedRegion
implements Comparable<ProtectedRegion> {
    private static final Pattern idPattern = Pattern.compile("^[A-Za-z0-9_,'\\-\\+/]{1,}$");
    private String id;
    private int priority = 0;
    private ProtectedRegion parent;
    private DefaultDomain owners = new DefaultDomain();
    private DefaultDomain members = new DefaultDomain();
    private Map<Flag<?>, Object> flags = new HashMap();

    public ProtectedRegion(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public abstract BlockVector getMinimumPoint();

    public abstract BlockVector getMaximumPoint();

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public ProtectedRegion getParent() {
        return this.parent;
    }

    public void setParent(ProtectedRegion parent) throws CircularInheritanceException {
        if (parent == null) {
            this.parent = null;
            return;
        }
        if (parent == this) {
            throw new CircularInheritanceException();
        }
        for (ProtectedRegion p = parent.getParent(); p != null; p = p.getParent()) {
            if (p != this) continue;
            throw new CircularInheritanceException();
        }
        this.parent = parent;
    }

    public DefaultDomain getOwners() {
        return this.owners;
    }

    public void setOwners(DefaultDomain owners) {
        this.owners = owners;
    }

    public DefaultDomain getMembers() {
        return this.members;
    }

    public void setMembers(DefaultDomain members) {
        this.members = members;
    }

    public boolean hasMembersOrOwners() {
        return this.owners.size() > 0 || this.members.size() > 0;
    }

    public boolean isOwner(LocalPlayer player) {
        if (this.owners.contains(player)) {
            return true;
        }
        for (ProtectedRegion curParent = this.getParent(); curParent != null; curParent = curParent.getParent()) {
            if (!curParent.getOwners().contains(player)) continue;
            return true;
        }
        return false;
    }

    public boolean isMember(LocalPlayer player) {
        if (this.owners.contains(player) || this.members.contains(player)) {
            return true;
        }
        for (ProtectedRegion curParent = this.getParent(); curParent != null; curParent = curParent.getParent()) {
            if (!curParent.getOwners().contains(player) && !curParent.getMembers().contains(player)) continue;
            return true;
        }
        return false;
    }

    public boolean isMemberOnly(LocalPlayer player) {
        if (this.members.contains(player)) {
            return true;
        }
        for (ProtectedRegion curParent = this.getParent(); curParent != null; curParent = curParent.getParent()) {
            if (!curParent.getMembers().contains(player)) continue;
            return true;
        }
        return false;
    }

    public <T extends Flag<V>, V> V getFlag(T flag) {
        Object obj = this.flags.get(flag);
        if (obj == null) {
            return null;
        }
        Object val = obj;
        return (V)val;
    }

    public <T extends Flag<V>, V> void setFlag(T flag, V val) {
        if (val == null) {
            this.flags.remove(flag);
        } else {
            this.flags.put(flag, val);
        }
    }

    public Map<Flag<?>, Object> getFlags() {
        return this.flags;
    }

    public void setFlags(Map<Flag<?>, Object> flags) {
        this.flags = flags;
    }

    public abstract int volume();

    public abstract boolean contains(Vector var1);

    @Override
    public int compareTo(ProtectedRegion other) {
        if (this.id.equals(other.id)) {
            return 0;
        }
        if (this.priority == other.priority) {
            return 1;
        }
        if (this.priority > other.priority) {
            return -1;
        }
        return 1;
    }

    public abstract String getTypeName();

    public abstract List<ProtectedRegion> getIntersectingRegions(List<ProtectedRegion> var1) throws UnsupportedIntersectionException;

    public static boolean isValidId(String id) {
        return idPattern.matcher(id).matches();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProtectedRegion)) {
            return false;
        }
        ProtectedRegion other = (ProtectedRegion)obj;
        return other.getId().equals(this.getId());
    }

    public static class CircularInheritanceException
    extends Exception {
        private static final long serialVersionUID = 7479613488496776022L;
    }
}

