/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldguard.util.yaml;

import com.sk89q.worldguard.util.yaml.ConfigurationException;
import com.sk89q.worldguard.util.yaml.ConfigurationNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.representer.Representer;

public class Configuration
extends ConfigurationNode {
    private Yaml yaml;
    private File file;
    private String header = null;

    public Configuration(File file) {
        super(new HashMap<String, Object>());
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.AUTO);
        this.yaml = new Yaml((BaseConstructor)new SafeConstructor(), new Representer(), options);
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.file);
            this.read(this.yaml.load((Reader)new UnicodeReader((InputStream)stream)));
        }
        catch (ConfigurationException e) {
            this.root = new HashMap();
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void setHeader(String ... headerLines) {
        StringBuilder header = new StringBuilder();
        for (String line : headerLines) {
            if (header.length() > 0) {
                header.append("\r\n");
            }
            header.append(line);
        }
        this.setHeader(header.toString());
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        FileOutputStream stream = null;
        File parent = this.file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try {
            stream = new FileOutputStream(this.file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            if (this.header != null) {
                writer.append(this.header);
                writer.append("\r\n");
            }
            this.yaml.dump((Object)this.root, (Writer)writer);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
        return false;
    }

    private void read(Object input) throws ConfigurationException {
        try {
            this.root = null == input ? new HashMap() : (Map)input;
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Root document must be an key-value structure");
        }
    }

    public static ConfigurationNode getEmptyNode() {
        return new ConfigurationNode(new HashMap<String, Object>());
    }
}

