/*
 * Decompiled with CFR 0.152.
 */
package net.TheDgtl.Stargate;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Scanner;
import java.util.logging.Level;
import net.TheDgtl.Stargate.Blox;
import net.TheDgtl.Stargate.Gate;
import net.TheDgtl.Stargate.RelativeBlockVector;
import net.TheDgtl.Stargate.SignPost;
import net.TheDgtl.Stargate.Stargate;
import net.TheDgtl.Stargate.event.StargateActivateEvent;
import net.TheDgtl.Stargate.event.StargateCloseEvent;
import net.TheDgtl.Stargate.event.StargateDeactivateEvent;
import net.TheDgtl.Stargate.event.StargateOpenEvent;
import net.TheDgtl.Stargate.iConomyHandler;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.StorageMinecart;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.material.Button;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Portal {
    private static final HashMap<Blox, Portal> lookupBlocks = new HashMap();
    private static final HashMap<Blox, Portal> lookupEntrances = new HashMap();
    private static final ArrayList<Portal> allPortals = new ArrayList();
    private static final HashMap<String, ArrayList<String>> allPortalsNet = new HashMap();
    private static final HashMap<String, HashMap<String, Portal>> lookupNamesNet = new HashMap();
    private Blox topLeft;
    private int modX;
    private int modZ;
    private float rotX;
    private SignPost id;
    private Blox button;
    private Blox[] frame;
    private Blox[] entrances;
    private String name;
    private String destination;
    private String network;
    private Gate gate;
    private String owner = "";
    private World world;
    private boolean verified;
    private boolean fixed;
    private boolean hidden = false;
    private boolean alwaysOn = false;
    private boolean priv = false;
    private boolean free = false;
    private boolean backwards = false;
    private Player player;
    private Player activePlayer;
    private ArrayList<String> destinations = new ArrayList();
    private boolean isOpen = false;
    private long openTime;

    private Portal(Blox topLeft, int modX, int modZ, float rotX, SignPost id, Blox button, String dest, String name, boolean verified, String network, Gate gate, String owner, boolean hidden, boolean alwaysOn, boolean priv, boolean free, boolean backwards) {
        this.topLeft = topLeft;
        this.modX = modX;
        this.modZ = modZ;
        this.rotX = rotX;
        this.id = id;
        this.destination = dest;
        this.button = button;
        this.verified = verified;
        this.network = network;
        this.name = name;
        this.gate = gate;
        this.owner = owner;
        this.hidden = hidden;
        this.alwaysOn = alwaysOn;
        this.priv = priv;
        this.free = free;
        this.backwards = backwards;
        this.world = topLeft.getWorld();
        boolean bl = this.fixed = dest.length() > 0;
        if (this.isAlwaysOn() && !this.isFixed()) {
            this.alwaysOn = false;
            Stargate.debug("Portal", "Can not create a non-fixed always-on gate. Setting AlwaysOn = false");
        }
        this.register();
        if (verified) {
            this.drawSign();
        }
    }

    public boolean isOpen() {
        return this.isOpen || this.isAlwaysOn();
    }

    public boolean isAlwaysOn() {
        return this.alwaysOn;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isPrivate() {
        return this.priv;
    }

    public boolean isFree() {
        return this.free;
    }

    public boolean isBackwards() {
        return this.backwards;
    }

    public float getRotation() {
        return this.rotX;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Portal.filterName(name);
        this.drawSign();
    }

    public Portal getDestination() {
        return Portal.getByName(this.destination, this.getNetwork());
    }

    public void setDestination(Portal destination) {
        this.setDestination(destination.getName());
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestinationName() {
        return this.destination;
    }

    public Gate getGate() {
        return this.gate;
    }

    public String getOwner() {
        return this.owner;
    }

    public Blox[] getEntrances() {
        if (this.entrances == null) {
            RelativeBlockVector[] space = this.gate.getEntrances();
            this.entrances = new Blox[space.length];
            int i = 0;
            RelativeBlockVector[] relativeBlockVectorArray = space;
            int n = space.length;
            int n2 = 0;
            while (n2 < n) {
                RelativeBlockVector vector = relativeBlockVectorArray[n2];
                this.entrances[i++] = this.getBlockAt(vector);
                ++n2;
            }
        }
        return this.entrances;
    }

    public Blox[] getFrame() {
        if (this.frame == null) {
            RelativeBlockVector[] border = this.gate.getBorder();
            this.frame = new Blox[border.length];
            int i = 0;
            RelativeBlockVector[] relativeBlockVectorArray = border;
            int n = border.length;
            int n2 = 0;
            while (n2 < n) {
                RelativeBlockVector vector = relativeBlockVectorArray[n2];
                this.frame[i++] = this.getBlockAt(vector);
                ++n2;
            }
        }
        return this.frame;
    }

    public World getWorld() {
        return this.world;
    }

    public boolean open(boolean force) {
        return this.open(null, force);
    }

    public boolean open(Player openFor, boolean force) {
        StargateOpenEvent event = new StargateOpenEvent(openFor, this, force);
        Stargate.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        force = event.getForce();
        if (this.isOpen() && !force) {
            return false;
        }
        this.getWorld().loadChunk(this.getWorld().getChunkAt(this.topLeft.getBlock()));
        Blox[] bloxArray = this.getEntrances();
        int n = bloxArray.length;
        int n2 = 0;
        while (n2 < n) {
            Blox inside = bloxArray[n2];
            inside.setType(this.gate.getPortalBlockOpen());
            ++n2;
        }
        this.isOpen = true;
        this.openTime = System.currentTimeMillis() / 1000L;
        Stargate.openList.add(this);
        Stargate.activeList.remove(this);
        if (!this.isAlwaysOn()) {
            this.player = openFor;
            Portal end = this.getDestination();
            if (!(end == null || end.isFixed() && !end.getDestinationName().equalsIgnoreCase(this.getName()) || end.isOpen())) {
                end.open(openFor, false);
                end.setDestination(this);
                if (end.isVerified()) {
                    end.drawSign();
                }
            }
        }
        return true;
    }

    public void close(boolean force) {
        Portal end;
        if (!this.isOpen) {
            return;
        }
        StargateCloseEvent event = new StargateCloseEvent(this, force);
        Stargate.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        force = event.getForce();
        if (this.isAlwaysOn() && !force) {
            return;
        }
        Blox[] bloxArray = this.getEntrances();
        int n = bloxArray.length;
        int n2 = 0;
        while (n2 < n) {
            Blox inside = bloxArray[n2];
            inside.setType(this.gate.getPortalBlockClosed());
            ++n2;
        }
        this.player = null;
        this.isOpen = false;
        Stargate.openList.remove(this);
        Stargate.activeList.remove(this);
        if (!this.isAlwaysOn() && (end = this.getDestination()) != null && end.isOpen()) {
            end.deactivate();
            end.close(false);
        }
        this.deactivate();
    }

    public boolean isOpenFor(Player player) {
        if (this.isAlwaysOn() || this.player == null) {
            return true;
        }
        return player != null && player.getName().equalsIgnoreCase(this.player.getName());
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isPowered() {
        RelativeBlockVector[] controls;
        RelativeBlockVector[] relativeBlockVectorArray = controls = this.gate.getControls();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            RelativeBlockVector vector = relativeBlockVectorArray[n2];
            MaterialData mat = this.getBlockAt(vector).getBlock().getState().getData();
            if (mat instanceof Button && ((Button)mat).isPowered()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void teleport(Player player, Portal origin, PlayerMoveEvent event) {
        Location traveller = player.getLocation();
        Location exit = this.getExit(traveller);
        int adjust = this.isBackwards() ? 0 : 180;
        exit.setYaw(origin.getRotation() - traveller.getYaw() + this.getRotation() + (float)adjust);
        event.setTo(exit);
    }

    public void teleport(Vehicle vehicle) {
        Location traveller = new Location(this.world, vehicle.getLocation().getX(), vehicle.getLocation().getY(), vehicle.getLocation().getZ());
        Location exit = this.getExit(traveller);
        double velocity = vehicle.getVelocity().length();
        vehicle.setVelocity(new Vector());
        final Vector newVelocity = new Vector();
        switch (this.id.getBlock().getData()) {
            case 2: {
                newVelocity.setZ(-1);
                break;
            }
            case 3: {
                newVelocity.setZ(1);
                break;
            }
            case 4: {
                newVelocity.setX(-1);
                break;
            }
            case 5: {
                newVelocity.setX(1);
            }
        }
        newVelocity.multiply(velocity);
        final Entity passenger = vehicle.getPassenger();
        if (passenger != null) {
            final Vehicle v = (Vehicle)exit.getWorld().spawn(exit, vehicle.getClass());
            vehicle.eject();
            vehicle.remove();
            passenger.teleport(exit);
            Stargate.server.getScheduler().scheduleSyncDelayedTask((Plugin)Stargate.stargate, new Runnable(){

                @Override
                public void run() {
                    v.setPassenger(passenger);
                    v.setVelocity(newVelocity);
                }
            }, 1L);
        } else {
            Vehicle mc = (Vehicle)exit.getWorld().spawn(exit, vehicle.getClass());
            if (mc instanceof StorageMinecart) {
                StorageMinecart smc = (StorageMinecart)mc;
                smc.getInventory().setContents(((StorageMinecart)vehicle).getInventory().getContents());
            }
            vehicle.remove();
        }
    }

    public Location getExit(Location traveller) {
        Location loc = null;
        if (this.gate.getExit() != null) {
            Blox exit = this.getBlockAt(this.gate.getExit());
            int back = this.isBackwards() ? -1 : 1;
            loc = exit.modRelativeLoc(0.0, 0.0, 1.0, traveller.getYaw(), traveller.getPitch(), this.modX * back, 1, this.modZ * back);
        } else {
            Stargate.log.log(Level.WARNING, "[Stargate] Missing destination point in .gate file " + this.gate.getFilename());
        }
        if (loc != null) {
            if (this.getWorld().getBlockTypeIdAt(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ()) == Material.STEP.getId()) {
                loc.setY(loc.getY() + 0.5);
            }
            loc.setPitch(traveller.getPitch());
            return loc;
        }
        return traveller;
    }

    public boolean isChunkLoaded() {
        return this.getWorld().isChunkLoaded(this.topLeft.getBlock().getChunk());
    }

    public void loadChunk() {
        this.getWorld().loadChunk(this.topLeft.getBlock().getChunk());
    }

    public boolean isVerified() {
        this.verified = true;
        RelativeBlockVector[] relativeBlockVectorArray = this.gate.getControls();
        int n = relativeBlockVectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            RelativeBlockVector control = relativeBlockVectorArray[n2];
            this.verified = this.verified && this.getBlockAt(control).getBlock().getTypeId() == this.gate.getControlBlock();
            ++n2;
        }
        return this.verified;
    }

    public boolean wasVerified() {
        return this.verified;
    }

    public boolean checkIntegrity() {
        return this.gate.matches(this.topLeft, this.modX, this.modZ);
    }

    public void activate(Player player) {
        StargateActivateEvent event = new StargateActivateEvent(this);
        Stargate.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.destinations.clear();
        this.destination = "";
        this.drawSign();
        Stargate.activeList.add(this);
        this.activePlayer = player;
        String network = this.getNetwork();
        for (String dest : allPortalsNet.get(network.toLowerCase())) {
            Portal portal = Portal.getByName(dest, network);
            if (portal.isAlwaysOn() || !Stargate.canAccessWorld(player, portal.getWorld().getName()) || dest.equalsIgnoreCase(this.getName()) || portal.isFixed() && !portal.getDestinationName().equalsIgnoreCase(this.getName()) || !Stargate.canSee(player, portal)) continue;
            this.destinations.add(portal.getName());
        }
    }

    public void deactivate() {
        StargateDeactivateEvent event = new StargateDeactivateEvent(this);
        Stargate.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        Stargate.activeList.remove(this);
        if (this.isFixed()) {
            return;
        }
        this.destinations.clear();
        this.destination = "";
        this.activePlayer = null;
        this.drawSign();
    }

    public boolean isActive() {
        return this.isFixed() || this.destinations.size() > 0;
    }

    public Player getActivePlayer() {
        return this.activePlayer;
    }

    public String getNetwork() {
        return this.network;
    }

    public long getOpenTime() {
        return this.openTime;
    }

    public void cycleDestination(Player player) {
        this.cycleDestination(player, 1);
    }

    public void cycleDestination(Player player, int dir) {
        if (!this.isActive() || this.getActivePlayer() != player) {
            this.activate(player);
        }
        if (this.destinations.size() > 0) {
            int index = this.destinations.indexOf(this.destination);
            if ((index += dir) >= this.destinations.size()) {
                index = 0;
            } else if (index < 0) {
                index = this.destinations.size() - 1;
            }
            this.destination = this.destinations.get(index);
        }
        this.openTime = System.currentTimeMillis() / 1000L;
        this.drawSign();
    }

    public final void drawSign() {
        this.id.setText(0, "--" + this.name + "--");
        int max = this.destinations.size() - 1;
        int done = 0;
        if (!this.isActive()) {
            this.id.setText(++done, "Right click to");
            this.id.setText(++done, "use the gate");
            this.id.setText(++done, " (" + this.network + ") ");
        } else if (this.isFixed()) {
            this.id.setText(++done, "To: " + this.destination);
            this.id.setText(++done, " (" + this.network + ") ");
            Portal dest = Portal.getByName(this.destination, this.network);
            if (dest == null) {
                this.id.setText(++done, "(Not Connected)");
            } else {
                this.id.setText(++done, "");
            }
        } else {
            boolean green;
            Portal dest;
            int index = this.destinations.indexOf(this.destination);
            if (index == max && max > 1 && ++done <= 3) {
                if (iConomyHandler.useiConomy() && iConomyHandler.freeGatesGreen) {
                    dest = Portal.getByName(this.destinations.get(index - 2), this.network);
                    green = Stargate.isFree(this.activePlayer, this, dest);
                    this.id.setText(done, (green ? ChatColor.DARK_GREEN : "") + this.destinations.get(index - 2));
                } else {
                    this.id.setText(done, this.destinations.get(index - 2));
                }
            }
            if (index > 0 && ++done <= 3) {
                if (iConomyHandler.useiConomy() && iConomyHandler.freeGatesGreen) {
                    dest = Portal.getByName(this.destinations.get(index - 1), this.network);
                    green = Stargate.isFree(this.activePlayer, this, dest);
                    this.id.setText(done, (green ? ChatColor.DARK_GREEN : "") + this.destinations.get(index - 1));
                } else {
                    this.id.setText(done, this.destinations.get(index - 1));
                }
            }
            if (++done <= 3) {
                if (iConomyHandler.useiConomy() && iConomyHandler.freeGatesGreen) {
                    dest = Portal.getByName(this.destination, this.network);
                    green = Stargate.isFree(this.activePlayer, this, dest);
                    this.id.setText(done, (green ? ChatColor.DARK_GREEN : "") + " >" + this.destination + "< ");
                } else {
                    this.id.setText(done, " >" + this.destination + "< ");
                }
            }
            if (max >= index + 1 && ++done <= 3) {
                if (iConomyHandler.useiConomy() && iConomyHandler.freeGatesGreen) {
                    dest = Portal.getByName(this.destinations.get(index + 1), this.network);
                    green = Stargate.isFree(this.activePlayer, this, dest);
                    this.id.setText(done, (green ? ChatColor.DARK_GREEN : "") + this.destinations.get(index + 1));
                } else {
                    this.id.setText(done, this.destinations.get(index + 1));
                }
            }
            if (max >= index + 2 && ++done <= 3) {
                if (iConomyHandler.useiConomy() && iConomyHandler.freeGatesGreen) {
                    dest = Portal.getByName(this.destinations.get(index + 2), this.network);
                    green = Stargate.isFree(this.activePlayer, this, dest);
                    this.id.setText(done, (green ? ChatColor.DARK_GREEN : "") + this.destinations.get(index + 2));
                } else {
                    this.id.setText(done, this.destinations.get(index + 2));
                }
            }
        }
        ++done;
        while (done <= 3) {
            this.id.setText(done, "");
            ++done;
        }
        this.id.update();
    }

    public void unregister(boolean removeAll) {
        Stargate.debug("Unregister", "Unregistering gate " + this.getName());
        this.close(true);
        lookupNamesNet.get(this.getNetwork().toLowerCase()).remove(this.getName().toLowerCase());
        Blox[] bloxArray = this.getFrame();
        int n = bloxArray.length;
        int n2 = 0;
        while (n2 < n) {
            Blox block = bloxArray[n2];
            lookupBlocks.remove(block);
            ++n2;
        }
        lookupBlocks.remove(new Blox(this.id.getBlock()));
        if (this.button != null) {
            lookupBlocks.remove(this.button);
        }
        bloxArray = this.getEntrances();
        n = bloxArray.length;
        n2 = 0;
        while (n2 < n) {
            Blox entrance = bloxArray[n2];
            lookupEntrances.remove(entrance);
            ++n2;
        }
        if (removeAll) {
            allPortals.remove(this);
        }
        allPortalsNet.get(this.getNetwork().toLowerCase()).remove(this.getName().toLowerCase());
        if (this.id.getBlock().getType() == Material.WALL_SIGN) {
            this.id.setText(0, this.getName());
            this.id.setText(1, "");
            this.id.setText(2, "");
            this.id.setText(3, "");
            this.id.update();
        }
        for (String originName : allPortalsNet.get(this.getNetwork().toLowerCase())) {
            Portal origin = Portal.getByName(originName, this.getNetwork());
            if (origin == null || !origin.getDestinationName().equalsIgnoreCase(this.getName()) || !origin.isVerified()) continue;
            if (origin.isFixed()) {
                origin.drawSign();
            }
            if (!origin.isAlwaysOn()) continue;
            origin.close(true);
        }
        Portal.saveAllGates(this.getWorld());
    }

    private Blox getBlockAt(RelativeBlockVector vector) {
        return this.topLeft.modRelative(vector.getRight(), vector.getDepth(), vector.getDistance(), this.modX, 1, this.modZ);
    }

    private void register() {
        if (!lookupNamesNet.containsKey(this.getNetwork().toLowerCase())) {
            Stargate.debug("register", "Network not in lookupNamesNet, adding");
            lookupNamesNet.put(this.getNetwork().toLowerCase(), new HashMap());
        }
        lookupNamesNet.get(this.getNetwork().toLowerCase()).put(this.getName().toLowerCase(), this);
        Blox[] bloxArray = this.getFrame();
        int n = bloxArray.length;
        int n2 = 0;
        while (n2 < n) {
            Blox block = bloxArray[n2];
            lookupBlocks.put(block, this);
            ++n2;
        }
        lookupBlocks.put(new Blox(this.id.getBlock()), this);
        if (this.button != null) {
            lookupBlocks.put(this.button, this);
        }
        bloxArray = this.getEntrances();
        n = bloxArray.length;
        n2 = 0;
        while (n2 < n) {
            Blox entrance = bloxArray[n2];
            lookupEntrances.put(entrance, this);
            ++n2;
        }
        allPortals.add(this);
        if (!allPortalsNet.containsKey(this.getNetwork().toLowerCase())) {
            Stargate.debug("register", "Network not in allPortalsNet, adding");
            allPortalsNet.put(this.getNetwork().toLowerCase(), new ArrayList());
        }
        allPortalsNet.get(this.getNetwork().toLowerCase()).add(this.getName().toLowerCase());
    }

    public static Portal createPortal(SignChangeEvent event, Player player) {
        Portal dest;
        String world22;
        Portal p;
        RelativeBlockVector[] vectors;
        boolean backwards;
        SignPost id = new SignPost(new Blox(event.getBlock()));
        Block idParent = id.getParent();
        if (idParent == null) {
            return null;
        }
        if (Gate.getGatesByControlBlock(idParent).length == 0) {
            return null;
        }
        if (Portal.getByBlock(idParent) != null) {
            Stargate.debug("createPortal", "idParent belongs to existing gate");
            return null;
        }
        Blox parent = new Blox(player.getWorld(), idParent.getX(), idParent.getY(), idParent.getZ());
        Blox topleft = null;
        String name = Portal.filterName(event.getLine(0));
        String destName = Portal.filterName(event.getLine(1));
        String network = Portal.filterName(event.getLine(2));
        String options = Portal.filterName(event.getLine(3));
        boolean hidden = options.indexOf(104) != -1 || options.indexOf(72) != -1;
        boolean alwaysOn = options.indexOf(97) != -1 || options.indexOf(65) != -1;
        boolean priv = options.indexOf(112) != -1 || options.indexOf(80) != -1;
        boolean free = options.indexOf(102) != -1 || options.indexOf(70) != -1;
        boolean bl = backwards = options.indexOf(98) != -1 || options.indexOf(66) != -1;
        if (!Stargate.canOption(player, "hidden")) {
            hidden = false;
        }
        if (!Stargate.canOption(player, "alwayson")) {
            alwaysOn = false;
        }
        if (!Stargate.canOption(player, "private")) {
            priv = false;
        }
        if (!Stargate.canOption(player, "free")) {
            free = false;
        }
        if (!Stargate.canOption(player, "backwards")) {
            backwards = false;
        }
        if (alwaysOn && destName.length() == 0) {
            alwaysOn = false;
        }
        int modX = 0;
        int modZ = 0;
        float rotX = 0.0f;
        int facing = 0;
        if (idParent.getX() > id.getBlock().getX()) {
            --modZ;
            rotX = 90.0f;
            facing = 2;
        } else if (idParent.getX() < id.getBlock().getX()) {
            ++modZ;
            rotX = 270.0f;
            facing = 1;
        } else if (idParent.getZ() > id.getBlock().getZ()) {
            ++modX;
            rotX = 180.0f;
            facing = 4;
        } else if (idParent.getZ() < id.getBlock().getZ()) {
            --modX;
            rotX = 0.0f;
            facing = 3;
        }
        Gate[] possibleGates = Gate.getGatesByControlBlock(idParent);
        Gate gate = null;
        RelativeBlockVector buttonVector = null;
        Gate[] gateArray = possibleGates;
        int n = possibleGates.length;
        int n2 = 0;
        while (n2 < n) {
            Gate possibility = gateArray[n2];
            if (gate == null && buttonVector == null) {
                vectors = possibility.getControls();
                RelativeBlockVector otherControl = null;
                RelativeBlockVector[] relativeBlockVectorArray = vectors;
                int n3 = vectors.length;
                int n4 = 0;
                while (n4 < n3) {
                    RelativeBlockVector vector = relativeBlockVectorArray[n4];
                    Blox tl = parent.modRelative(-vector.getRight(), -vector.getDepth(), -vector.getDistance(), modX, 1, modZ);
                    if (gate == null) {
                        if (possibility.matches(tl, modX, modZ)) {
                            gate = possibility;
                            topleft = tl;
                            if (otherControl != null) {
                                buttonVector = otherControl;
                            }
                        }
                    } else if (otherControl != null) {
                        buttonVector = vector;
                    }
                    otherControl = vector;
                    ++n4;
                }
            }
            ++n2;
        }
        if (gate == null || buttonVector == null) {
            Stargate.debug("createPortal", "Could not find matching gate layout");
            return null;
        }
        Stargate.debug("createPortal", "h = " + hidden + " a = " + alwaysOn + " p = " + priv + " f = " + free + " b = " + backwards);
        if (network.length() < 1 || network.length() > 11) {
            network = Stargate.getDefaultNetwork();
        }
        if (!Stargate.canCreate(player, network)) {
            Stargate.debug("createPortal", "Player doesn't have create permissions on network. Trying personal");
            network = player.getName();
            if (network.length() > 11) {
                network = network.substring(0, 11);
            }
            if (!Stargate.canCreate(player, network)) {
                Stargate.debug("createPortal", "Player does not have access to network");
                Stargate.sendMessage(player, "You do not have access to that network");
                return null;
            }
            Stargate.debug("createPortal", "Creating personal portal");
            Stargate.sendMessage(player, "Creating gate on personal network");
        }
        if (name.length() < 1 || name.length() > 11) {
            Stargate.debug("createPortal", "Name length error");
            Stargate.sendMessage(player, "Name too short or too long.");
            return null;
        }
        if (Portal.getByName(name, network) != null) {
            Stargate.debug("createPortal", "Name Error");
            Stargate.sendMessage(player, "A gate by that name already exists!");
            return null;
        }
        ArrayList<String> netList = allPortalsNet.get(network.toLowerCase());
        if (Stargate.maxGates > 0 && netList != null && netList.size() >= Stargate.maxGates) {
            Stargate.sendMessage(player, "This network is full.");
            return null;
        }
        if (destName.length() > 0 && (p = Portal.getByName(destName, network)) != null && !Stargate.canAccessWorld(player, world22 = p.getWorld().getName())) {
            Stargate.debug("canCreate", "Player does not have access to destination world");
            Stargate.sendMessage(player, "You do not have access to that world.");
            return null;
        }
        vectors = gate.getBorder();
        int n5 = vectors.length;
        int world22 = 0;
        while (world22 < n5) {
            RelativeBlockVector v = vectors[world22];
            Blox b = topleft.modRelative(v.getRight(), v.getDepth(), v.getDistance(), modX, 1, modZ);
            if (Portal.getByBlock(b.getBlock()) != null) {
                Stargate.debug("createPortal", "Gate conflicts with existing gate");
                return null;
            }
            ++world22;
        }
        int cost = Stargate.getCreateCost(player, gate);
        if (cost > 0 && !Stargate.chargePlayer(player, null, gate.getCreateCost())) {
            Stargate.sendMessage(player, "Insufficient Funds");
            Stargate.debug("createPortal", "Insufficient Funds");
            return null;
        }
        Portal portal = null;
        Blox button = null;
        if (!alwaysOn) {
            button = topleft.modRelative(buttonVector.getRight(), buttonVector.getDepth(), buttonVector.getDistance() + 1, modX, 1, modZ);
            button.setType(Material.STONE_BUTTON.getId());
            button.setData(facing);
        }
        if ((portal = new Portal(topleft, modX, modZ, rotX, id, button, destName, name, true, network, gate, player.getName(), hidden, alwaysOn, priv, free, backwards)).isAlwaysOn() && (dest = Portal.getByName(destName, portal.getNetwork())) != null) {
            portal.open(true);
            dest.drawSign();
        }
        for (String originName : allPortalsNet.get(portal.getNetwork().toLowerCase())) {
            Portal origin = Portal.getByName(originName, portal.getNetwork());
            if (origin == null || !origin.getDestinationName().equalsIgnoreCase(portal.getName()) || !origin.isVerified()) continue;
            if (origin.isFixed()) {
                origin.drawSign();
            }
            if (!origin.isAlwaysOn()) continue;
            origin.open(true);
        }
        Portal.saveAllGates(portal.getWorld());
        return portal;
    }

    public static Portal getByName(String name, String network) {
        if (!lookupNamesNet.containsKey(network.toLowerCase())) {
            return null;
        }
        return lookupNamesNet.get(network.toLowerCase()).get(name.toLowerCase());
    }

    public static Portal getByEntrance(Location location) {
        return Portal.getByEntrance(new Blox(location).getBlock());
    }

    public static Portal getByEntrance(Block block) {
        return lookupEntrances.get(new Blox(block));
    }

    public static Portal getByBlock(Block block) {
        return lookupBlocks.get(new Blox(block));
    }

    public static void saveAllGates(World world) {
        String loc = String.valueOf(Stargate.getSaveLocation()) + "/" + world.getName() + ".db";
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(loc, false));
            for (Portal portal : allPortals) {
                String wName = portal.world.getName();
                if (!wName.equalsIgnoreCase(world.getName())) continue;
                StringBuilder builder = new StringBuilder();
                Blox sign = new Blox(portal.id.getBlock());
                Blox button = portal.button;
                builder.append(portal.name);
                builder.append(':');
                builder.append(sign.toString());
                builder.append(':');
                builder.append(button != null ? button.toString() : "");
                builder.append(':');
                builder.append(portal.modX);
                builder.append(':');
                builder.append(portal.modZ);
                builder.append(':');
                builder.append(portal.rotX);
                builder.append(':');
                builder.append(portal.topLeft.toString());
                builder.append(':');
                builder.append(portal.gate.getFilename());
                builder.append(':');
                builder.append(portal.isFixed() ? portal.getDestinationName() : "");
                builder.append(':');
                builder.append(portal.getNetwork());
                builder.append(':');
                builder.append(portal.getOwner());
                builder.append(':');
                builder.append(portal.isHidden());
                builder.append(':');
                builder.append(portal.isAlwaysOn());
                builder.append(':');
                builder.append(portal.isPrivate());
                builder.append(':');
                builder.append(portal.world.getName());
                builder.append(':');
                builder.append(portal.isFree());
                builder.append(':');
                builder.append(portal.isBackwards());
                bw.append(builder.toString());
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception e) {
            Stargate.log.log(Level.SEVERE, "Exception while writing stargates to " + loc + ": " + e);
        }
    }

    public static void clearGates() {
        lookupBlocks.clear();
        lookupNamesNet.clear();
        lookupEntrances.clear();
        allPortals.clear();
        allPortalsNet.clear();
    }

    public static void loadAllGates(World world) {
        String location = Stargate.getSaveLocation();
        File db = new File(location, String.valueOf(world.getName()) + ".db");
        if (db.exists()) {
            int l = 0;
            int portalCount = 0;
            try {
                Scanner scanner = new Scanner(db);
                while (scanner.hasNextLine()) {
                    String network;
                    Gate gate;
                    ++l;
                    String line = scanner.nextLine().trim();
                    if (line.startsWith("#") || line.isEmpty()) continue;
                    String[] split = line.split(":");
                    if (split.length < 8) {
                        Stargate.log.info("[Stargate] Invalid line - " + l);
                        continue;
                    }
                    String name = split[0];
                    Blox s = new Blox(world, split[1]);
                    if (!(s.getBlock().getState() instanceof Sign)) {
                        Stargate.log.info("[Stargate] Sign on line " + l + " doesn't exist. BlockType = " + s.getBlock().getType());
                        continue;
                    }
                    SignPost sign = new SignPost(s);
                    Blox button = split[2].length() > 0 ? new Blox(world, split[2]) : null;
                    int modX = Integer.parseInt(split[3]);
                    int modZ = Integer.parseInt(split[4]);
                    float rotX = Float.parseFloat(split[5]);
                    Blox topLeft = new Blox(world, split[6]);
                    Gate gate2 = gate = split[7].contains(";") ? Gate.getGateByName("nethergate.gate") : Gate.getGateByName(split[7]);
                    if (gate == null) {
                        Stargate.log.info("[Stargate] Gate layout on line " + l + " does not exist [" + split[7] + "]");
                        continue;
                    }
                    String dest = split.length > 8 ? split[8] : "";
                    String string = network = split.length > 9 ? split[9] : Stargate.getDefaultNetwork();
                    if (network.isEmpty()) {
                        network = Stargate.getDefaultNetwork();
                    }
                    String owner = split.length > 10 ? split[10] : "";
                    boolean hidden = split.length > 11 ? split[11].equalsIgnoreCase("true") : false;
                    boolean alwaysOn = split.length > 12 ? split[12].equalsIgnoreCase("true") : false;
                    boolean priv = split.length > 13 ? split[13].equalsIgnoreCase("true") : false;
                    boolean free = split.length > 15 ? split[15].equalsIgnoreCase("true") : false;
                    boolean backwards = split.length > 16 ? split[16].equalsIgnoreCase("true") : false;
                    Portal portal = new Portal(topLeft, modX, modZ, rotX, sign, button, dest, name, false, network, gate, owner, hidden, alwaysOn, priv, free, backwards);
                    portal.close(true);
                }
                scanner.close();
                int OpenCount = 0;
                Iterator<Portal> iter = allPortals.iterator();
                while (iter.hasNext()) {
                    Portal dest;
                    Portal portal = iter.next();
                    if (portal == null) continue;
                    if (!portal.wasVerified()) {
                        if (!portal.isVerified() || !portal.checkIntegrity()) {
                            portal.unregister(false);
                            iter.remove();
                            Stargate.log.info("[Stargate] Destroying stargate at " + portal.toString());
                            continue;
                        }
                        portal.drawSign();
                        ++portalCount;
                    }
                    if (!portal.isFixed() || (dest = portal.getDestination()) == null) continue;
                    if (portal.isAlwaysOn()) {
                        portal.open(true);
                        ++OpenCount;
                    }
                    portal.drawSign();
                    dest.drawSign();
                }
                Stargate.log.info("[Stargate] {" + world.getName() + "} Loaded " + portalCount + " stargates with " + OpenCount + " set as always-on");
            }
            catch (Exception e) {
                Stargate.log.log(Level.SEVERE, "Exception while reading stargates from " + db.getName() + ": " + l);
                e.printStackTrace();
            }
        } else {
            Stargate.log.info("[Stargate] {" + world.getName() + "} No stargates for world ");
        }
    }

    public static void closeAllGates() {
        Stargate.log.info("Closing all stargates.");
        for (Portal p : allPortals) {
            if (p == null) continue;
            p.close(true);
        }
    }

    public static String filterName(String input) {
        return input.replaceAll("[\\|:#]", "").trim();
    }

    public String toString() {
        return String.format("Portal [id=%s, network=%s name=%s, type=%s]", this.id, this.network, this.name, this.gate.getFilename());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.network == null ? 0 : this.network.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Portal other = (Portal)obj;
        if (this.name == null ? other.name != null : !this.name.equalsIgnoreCase(other.name)) {
            return false;
        }
        return !(this.network == null ? other.network != null : !this.network.equalsIgnoreCase(other.network));
    }
}

