/*
 * Decompiled with CFR 0.152.
 */
package net.TheDgtl.Stargate;

import net.TheDgtl.Stargate.Blox;
import net.TheDgtl.Stargate.Stargate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.plugin.Plugin;

public class SignPost {
    private Blox parent;
    private Blox block;
    private World world;

    public SignPost(World world, Sign sign) {
        this.world = world;
        this.block = new Blox(world, sign.getX(), sign.getY(), sign.getZ());
    }

    public SignPost(Blox block) {
        this.block = block;
        this.world = block.getWorld();
    }

    public Block getParent() {
        if (this.parent == null) {
            this.findParent();
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getBlock();
    }

    public Block getBlock() {
        return this.block.getBlock();
    }

    public String getText(int index) {
        Sign sign = this.findSign();
        if (sign == null) {
            return "";
        }
        return sign.getLine(index);
    }

    public void setText(int index, String value) {
        Sign sign = this.findSign();
        if (sign == null) {
            return;
        }
        sign.setLine(index, value);
    }

    public String getIdText() {
        Sign sign = this.findSign();
        if (sign == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(this.getText(0));
        result.append("\n");
        result.append(this.getText(1));
        result.append("\n");
        result.append(this.getText(2));
        result.append("\n");
        result.append(this.getText(3));
        return result.toString().toLowerCase();
    }

    public void update() {
        final Sign sign = this.findSign();
        if (sign == null) {
            return;
        }
        Stargate.server.getScheduler().scheduleSyncDelayedTask((Plugin)Stargate.stargate, new Runnable(){

            @Override
            public void run() {
                sign.update();
            }
        });
    }

    private void findParent() {
        Sign sign = this.findSign();
        int offsetX = 0;
        int offsetY = 0;
        int offsetZ = 0;
        if (this.block.getBlock().getType() == Material.WALL_SIGN) {
            if (this.block.getData() == 2) {
                offsetZ = 1;
            } else if (this.block.getData() == 3) {
                offsetZ = -1;
            } else if (this.block.getData() == 4) {
                offsetX = 1;
            } else if (this.block.getData() == 5) {
                offsetX = -1;
            }
        } else if (this.block.getBlock().getType() == Material.SIGN_POST) {
            offsetY = -1;
        }
        if (sign == null) {
            Stargate.debug("findParent", "sign == null");
            return;
        }
        if (this.world == null) {
            Stargate.debug("findParent", "world == null");
            return;
        }
        this.parent = new Blox(this.world, sign.getX() + offsetX, sign.getY() + offsetY, sign.getZ() + offsetZ);
    }

    private Sign findSign() {
        try {
            BlockState sign = this.world.getBlockAt(this.block.getX(), this.block.getY(), this.block.getZ()).getState();
            if (sign instanceof Sign) {
                return (Sign)sign;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static SignPost getFromBlock(Block block) {
        BlockState state = block.getState();
        if (!(state instanceof Sign)) {
            return null;
        }
        return new SignPost(block.getWorld(), (Sign)state);
    }

    public static SignPost getFromLocation(Location location) {
        return SignPost.getFromBlock(location.getWorld().getBlockAt((int)location.getX(), (int)location.getY(), (int)location.getZ()));
    }
}

