/*
 * Decompiled with CFR 0.152.
 */
package net.TheDgtl.Stargate;

import com.iConomy.iConomy;
import com.nijikokun.bukkit.Permissions.Permissions;
import java.io.File;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.TheDgtl.Stargate.Gate;
import net.TheDgtl.Stargate.Portal;
import net.TheDgtl.Stargate.iConomyHandler;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockListener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityListener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.event.server.ServerListener;
import org.bukkit.event.vehicle.VehicleListener;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.world.WorldListener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.config.Configuration;

public class Stargate
extends JavaPlugin {
    private static Permissions permissions = null;
    private final bListener blockListener = new bListener();
    private final pListener playerListener = new pListener();
    private final vListener vehicleListener = new vListener();
    private final wListener worldListener = new wListener();
    private final eListener entityListener = new eListener();
    private final sListener serverListener = new sListener();
    public static Logger log;
    private Configuration config;
    private PluginManager pm;
    public static Server server;
    public static Stargate stargate;
    private static String portalFolder;
    private static String gateFolder;
    private static String teleMsg;
    private static String regMsg;
    private static String dmgMsg;
    private static String denyMsg;
    private static String invMsg;
    private static String blockMsg;
    private static String defNetwork;
    private static boolean destroyExplosion;
    public static int maxGates;
    private static int activeTime;
    private static int openTime;
    private static boolean debug;
    public static ConcurrentLinkedQueue<Portal> openList;
    public static ConcurrentLinkedQueue<Portal> activeList;

    static {
        teleMsg = "Teleported";
        regMsg = "Gate Created";
        dmgMsg = "Gate Destroyed";
        denyMsg = "Access Denied";
        invMsg = "Invalid Destination";
        blockMsg = "Destination Blocked";
        defNetwork = "central";
        destroyExplosion = false;
        maxGates = 0;
        activeTime = 10;
        openTime = 10;
        debug = false;
        openList = new ConcurrentLinkedQueue();
        activeList = new ConcurrentLinkedQueue();
    }

    public void onDisable() {
        Portal.closeAllGates();
        Portal.clearGates();
    }

    public void onEnable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        this.pm = this.getServer().getPluginManager();
        this.config = this.getConfiguration();
        log = Logger.getLogger("Minecraft");
        server = this.getServer();
        stargate = this;
        portalFolder = this.getDataFolder() + "/portals";
        gateFolder = this.getDataFolder() + "/gates/";
        log.info(String.valueOf(pdfFile.getName()) + " v." + pdfFile.getVersion() + " is enabled.");
        this.pm.registerEvent(Event.Type.BLOCK_FROMTO, (Listener)this.blockListener, Event.Priority.Normal, (Plugin)this);
        this.pm.registerEvent(Event.Type.BLOCK_PHYSICS, (Listener)this.blockListener, Event.Priority.Normal, (Plugin)this);
        this.reloadConfig();
        this.migrate();
        this.reloadGates();
        permissions = (Permissions)this.checkPlugin("Permissions");
        if (iConomyHandler.useiConomy) {
            iConomyHandler.iconomy = (iConomy)this.checkPlugin("iConomy");
        }
        this.pm.registerEvent(Event.Type.PLAYER_MOVE, (Listener)this.playerListener, Event.Priority.Normal, (Plugin)this);
        this.pm.registerEvent(Event.Type.PLAYER_INTERACT, (Listener)this.playerListener, Event.Priority.Normal, (Plugin)this);
        this.pm.registerEvent(Event.Type.BLOCK_BREAK, (Listener)this.blockListener, Event.Priority.Normal, (Plugin)this);
        this.pm.registerEvent(Event.Type.SIGN_CHANGE, (Listener)this.blockListener, Event.Priority.Normal, (Plugin)this);
        this.pm.registerEvent(Event.Type.VEHICLE_MOVE, (Listener)this.vehicleListener, Event.Priority.Normal, (Plugin)this);
        this.pm.registerEvent(Event.Type.WORLD_LOAD, (Listener)this.worldListener, Event.Priority.Normal, (Plugin)this);
        this.pm.registerEvent(Event.Type.ENTITY_EXPLODE, (Listener)this.entityListener, Event.Priority.Normal, (Plugin)this);
        this.pm.registerEvent(Event.Type.PLAYER_PORTAL, (Listener)this.playerListener, Event.Priority.Normal, (Plugin)this);
        this.pm.registerEvent(Event.Type.PLUGIN_ENABLE, (Listener)this.serverListener, Event.Priority.Monitor, (Plugin)this);
        this.pm.registerEvent(Event.Type.PLUGIN_DISABLE, (Listener)this.serverListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new SGThread(), 0L, 100L);
    }

    public void reloadConfig() {
        this.config.load();
        portalFolder = this.config.getString("portal-folder", portalFolder);
        gateFolder = this.config.getString("gate-folder", gateFolder);
        teleMsg = this.config.getString("teleport-message", teleMsg);
        regMsg = this.config.getString("portal-create-message", regMsg);
        dmgMsg = this.config.getString("portal-destroy-message", dmgMsg);
        denyMsg = this.config.getString("not-owner-message", denyMsg);
        invMsg = this.config.getString("not-selected-message", invMsg);
        blockMsg = this.config.getString("other-side-blocked-message", blockMsg);
        defNetwork = this.config.getString("default-gate-network", defNetwork).trim();
        destroyExplosion = this.config.getBoolean("destroyexplosion", destroyExplosion);
        maxGates = this.config.getInt("maxgates", maxGates);
        debug = this.config.getBoolean("debug", debug);
        iConomyHandler.useiConomy = this.config.getBoolean("useiconomy", iConomyHandler.useiConomy);
        iConomyHandler.createCost = this.config.getInt("createcost", iConomyHandler.createCost);
        iConomyHandler.destroyCost = this.config.getInt("destroycost", iConomyHandler.destroyCost);
        iConomyHandler.useCost = this.config.getInt("usecost", iConomyHandler.useCost);
        iConomyHandler.inFundMsg = this.config.getString("not-enough-money-message", iConomyHandler.inFundMsg);
        iConomyHandler.toOwner = this.config.getBoolean("toowner", iConomyHandler.toOwner);
        iConomyHandler.chargeFreeDestination = this.config.getBoolean("chargefreedestination", iConomyHandler.chargeFreeDestination);
        iConomyHandler.freeGatesGreen = this.config.getBoolean("freegatesgreen", iConomyHandler.freeGatesGreen);
        this.saveConfig();
    }

    public void saveConfig() {
        this.config.setProperty("portal-folder", (Object)portalFolder);
        this.config.setProperty("gate-folder", (Object)gateFolder);
        this.config.setProperty("teleport-message", (Object)teleMsg);
        this.config.setProperty("portal-create-message", (Object)regMsg);
        this.config.setProperty("portal-destroy-message", (Object)dmgMsg);
        this.config.setProperty("not-owner-message", (Object)denyMsg);
        this.config.setProperty("not-selected-message", (Object)invMsg);
        this.config.setProperty("other-side-blocked-message", (Object)blockMsg);
        this.config.setProperty("default-gate-network", (Object)defNetwork);
        this.config.setProperty("destroyexplosion", (Object)destroyExplosion);
        this.config.setProperty("maxgates", (Object)maxGates);
        this.config.setProperty("useiconomy", (Object)iConomyHandler.useiConomy);
        this.config.setProperty("createcost", (Object)iConomyHandler.createCost);
        this.config.setProperty("destroycost", (Object)iConomyHandler.destroyCost);
        this.config.setProperty("usecost", (Object)iConomyHandler.useCost);
        this.config.setProperty("not-enough-money-message", (Object)iConomyHandler.inFundMsg);
        this.config.setProperty("toowner", (Object)iConomyHandler.toOwner);
        this.config.setProperty("chargefreedestination", (Object)iConomyHandler.chargeFreeDestination);
        this.config.setProperty("freegatesgreen", (Object)iConomyHandler.freeGatesGreen);
        this.config.save();
    }

    public void reloadGates() {
        Gate.loadGates(gateFolder);
        if (Gate.getGateByName("nethergate.gate") == null || Gate.getGateByName("nethergate.gate").getExit() == null) {
            Gate.populateDefaults(gateFolder);
        }
        log.info("[Stargate] Loaded " + Gate.getGateCount() + " gate layouts");
        for (World world : this.getServer().getWorlds()) {
            Portal.loadAllGates(world);
        }
    }

    private void migrate() {
        File oldDir;
        File newFile;
        File newPortalDir = new File(portalFolder);
        if (!newPortalDir.exists()) {
            newPortalDir.mkdirs();
        }
        if (!(newFile = new File(portalFolder, String.valueOf(((World)this.getServer().getWorlds().get(0)).getName()) + ".db")).exists()) {
            newFile.getParentFile().mkdirs();
            File oldishFile = new File("plugins/Stargate/stargate.db");
            if (oldishFile.exists()) {
                log.info("[Stargate] Migrating existing stargate.db");
                oldishFile.renameTo(newFile);
            }
        }
        if ((oldDir = new File("stargates")).exists()) {
            File newDir = new File(gateFolder);
            if (!newDir.exists()) {
                newDir.mkdirs();
            }
            File[] fileArray = oldDir.listFiles(new Gate.StargateFilenameFilter());
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                log.info("[Stargate] Migrating existing gate " + file.getName());
                file.renameTo(new File(gateFolder, file.getName()));
                ++n2;
            }
        }
    }

    public static void debug(String rout, String msg) {
        if (debug) {
            log.info("[Stargate::" + rout + "] " + msg);
        } else {
            log.log(Level.FINEST, "[Stargate::" + rout + "] " + msg);
        }
    }

    public static void sendMessage(Player player, String message) {
        Stargate.sendMessage(player, message, true);
    }

    public static void sendMessage(Player player, String message, boolean error) {
        if (message.isEmpty()) {
            return;
        }
        if (error) {
            player.sendMessage(ChatColor.RED + "[Stargate] " + ChatColor.WHITE + message);
        } else {
            player.sendMessage(ChatColor.GREEN + "[Stargate] " + ChatColor.WHITE + message);
        }
    }

    public static String getSaveLocation() {
        return portalFolder;
    }

    public static String getDefaultNetwork() {
        return defNetwork;
    }

    public static String getTeleMsg() {
        return teleMsg;
    }

    public static String getRegMsg() {
        return regMsg;
    }

    public static String getDmgMsg() {
        return dmgMsg;
    }

    public static String getDenyMsg() {
        return denyMsg;
    }

    public static String getInvMsg() {
        return invMsg;
    }

    public static String getBlockMsg() {
        return blockMsg;
    }

    private void onButtonPressed(Player player, Portal portal) {
        Portal destination = portal.getDestination();
        if (portal.isAlwaysOn()) {
            return;
        }
        if (destination == null || destination == portal) {
            Stargate.sendMessage(player, invMsg);
            return;
        }
        if (portal.isOpen()) {
            if (portal.getActivePlayer() == player) {
                portal.close(false);
            }
            return;
        }
        if (!portal.isFixed() && portal.isActive() && portal.getActivePlayer() != player) {
            Stargate.sendMessage(player, denyMsg);
            return;
        }
        if (portal.isPrivate() && !Stargate.canPrivate(player, portal)) {
            Stargate.sendMessage(player, denyMsg);
            return;
        }
        if (destination.isOpen() && !destination.isAlwaysOn()) {
            Stargate.sendMessage(player, blockMsg);
            return;
        }
        portal.open(player, false);
    }

    public static boolean hasPerm(Player player, String perm) {
        if (permissions != null) {
            return permissions.getHandler().has(player, perm);
        }
        return player.hasPermission(perm);
    }

    public static boolean hasPermDeep(Player player, String perm) {
        if (permissions != null) {
            return permissions.getHandler().has(player, perm);
        }
        if (!player.isPermissionSet(perm)) {
            return true;
        }
        return player.hasPermission(perm);
    }

    public static boolean canAccessWorld(Player player, String world) {
        if (Stargate.hasPerm(player, "stargate.use")) {
            return true;
        }
        if (Stargate.hasPerm(player, "stargate.world")) {
            return Stargate.hasPermDeep(player, "stargate.world." + world);
        }
        return Stargate.hasPerm(player, "stargate.world." + world);
    }

    public static boolean canAccessNetwork(Player player, String network) {
        if (Stargate.hasPerm(player, "stargate.use")) {
            return true;
        }
        if (Stargate.hasPerm(player, "stargate.network")) {
            return Stargate.hasPermDeep(player, "stargate.network." + network);
        }
        return Stargate.hasPerm(player, "stargate.network." + network);
    }

    public static boolean isFree(Player player, Portal src, Portal dest) {
        if (src.isFree()) {
            return true;
        }
        if (Stargate.hasPerm(player, "stargate.free") || Stargate.hasPerm(player, "stargate.free.use")) {
            return true;
        }
        return !iConomyHandler.chargeFreeDestination && dest.isFree();
    }

    public static boolean canSee(Player player, Portal portal) {
        if (!portal.isHidden()) {
            return true;
        }
        if (Stargate.hasPerm(player, "stargate.admin") || Stargate.hasPerm(player, "stargate.admin.hidden")) {
            return true;
        }
        return portal.getOwner().equalsIgnoreCase(player.getName());
    }

    public static boolean canPrivate(Player player, Portal portal) {
        if (portal.getOwner().equalsIgnoreCase(player.getName())) {
            return true;
        }
        return Stargate.hasPerm(player, "stargate.admin") || Stargate.hasPerm(player, "stargate.admin.private");
    }

    public static boolean canOption(Player player, String option) {
        if (Stargate.hasPerm(player, "stargate.option")) {
            return true;
        }
        return Stargate.hasPerm(player, "stargate.option." + option);
    }

    public static boolean canCreate(Player player, String network) {
        if (Stargate.hasPerm(player, "stargate.create")) {
            return true;
        }
        if (Stargate.hasPerm(player, "stargate.create.network")) {
            return Stargate.hasPermDeep(player, "stargate.create.network." + network);
        }
        if (Stargate.hasPerm(player, "stargate.create.network." + network)) {
            return true;
        }
        String pNet = player.getName();
        if (pNet.length() > 11) {
            pNet = pNet.substring(0, 11);
        }
        return pNet.equalsIgnoreCase(network) && Stargate.hasPerm(player, "stargate.create.personal");
    }

    public static boolean canDestroy(Player player, Portal portal) {
        if (Stargate.hasPerm(player, "stargate.destroy")) {
            return true;
        }
        if (Stargate.hasPerm(player, "stargate.destroy.network")) {
            return Stargate.hasPermDeep(player, "stargate.destroy.network." + portal.getNetwork());
        }
        if (Stargate.hasPerm(player, "stargate.destroy.network." + portal.getNetwork())) {
            return true;
        }
        return player.getName().equalsIgnoreCase(portal.getOwner()) && Stargate.hasPerm(player, "stargate.destroy.personal");
    }

    public static boolean chargePlayer(Player player, String target, int cost) {
        if (cost == 0) {
            return true;
        }
        if (!iConomyHandler.useiConomy()) {
            return true;
        }
        return iConomyHandler.chargePlayer(player.getName(), target, cost);
    }

    public static int getUseCost(Player player, Portal src, Portal dest) {
        if (!iConomyHandler.useiConomy()) {
            return 0;
        }
        if (src.isFree()) {
            return 0;
        }
        if (!iConomyHandler.chargeFreeDestination && dest.isFree()) {
            return 0;
        }
        if (src.getGate().getToOwner().booleanValue() && src.getOwner().equalsIgnoreCase(player.getName())) {
            return 0;
        }
        if (Stargate.hasPerm(player, "stargate.free") || Stargate.hasPerm(player, "stargate.free.use")) {
            return 0;
        }
        return src.getGate().getUseCost();
    }

    public static int getCreateCost(Player player, Gate gate) {
        if (!iConomyHandler.useiConomy()) {
            return 0;
        }
        if (Stargate.hasPerm(player, "stargate.free") || Stargate.hasPerm(player, "stargate.free.create")) {
            return 0;
        }
        return gate.getDestroyCost();
    }

    public static int getDestroyCost(Player player, Gate gate) {
        if (!iConomyHandler.useiConomy()) {
            return 0;
        }
        if (Stargate.hasPerm(player, "stargate.free") || Stargate.hasPerm(player, "stargate.free.destroy")) {
            return 0;
        }
        return gate.getDestroyCost();
    }

    private Plugin checkPlugin(String p) {
        Plugin plugin = this.pm.getPlugin(p);
        return this.checkPlugin(plugin);
    }

    private Plugin checkPlugin(Plugin plugin) {
        if (plugin != null && plugin.isEnabled()) {
            log.info("[Stargate] Found " + plugin.getDescription().getName() + " (v" + plugin.getDescription().getVersion() + ")");
            return plugin;
        }
        return null;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Stargate.sendMessage((Player)sender, "Permission Denied");
            return true;
        }
        String cmd = command.getName();
        if (cmd.equalsIgnoreCase("sg")) {
            if (args.length != 1) {
                return false;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                activeList.clear();
                openList.clear();
                Portal.clearGates();
                Gate.clearGates();
                this.reloadConfig();
                this.reloadGates();
                return true;
            }
            return false;
        }
        return false;
    }

    private class SGThread
    implements Runnable {
        private SGThread() {
        }

        @Override
        public void run() {
            Portal p;
            long time = System.currentTimeMillis() / 1000L;
            Iterator<Portal> iter = openList.iterator();
            while (iter.hasNext()) {
                p = iter.next();
                if (p.isAlwaysOn() || !p.isOpen() || time <= p.getOpenTime() + (long)openTime) continue;
                p.close(false);
                iter.remove();
            }
            iter = activeList.iterator();
            while (iter.hasNext()) {
                p = iter.next();
                if (!p.isActive() || time <= p.getOpenTime() + (long)activeTime) continue;
                p.deactivate();
                iter.remove();
            }
        }
    }

    private class bListener
    extends BlockListener {
        private bListener() {
        }

        public void onSignChange(SignChangeEvent event) {
            Player player = event.getPlayer();
            Block block = event.getBlock();
            if (block.getType() != Material.WALL_SIGN) {
                return;
            }
            final Portal portal = Portal.createPortal(event, player);
            if (portal == null) {
                return;
            }
            Stargate.sendMessage(player, regMsg, false);
            Stargate.debug("onSignChange", "Initialized stargate: " + portal.getName());
            server.getScheduler().scheduleSyncDelayedTask((Plugin)stargate, new Runnable(){

                @Override
                public void run() {
                    portal.drawSign();
                }
            }, 1L);
        }

        public void onBlockBreak(BlockBreakEvent event) {
            if (event.isCancelled()) {
                return;
            }
            Block block = event.getBlock();
            Player player = event.getPlayer();
            if (block.getType() != Material.WALL_SIGN && block.getType() != Material.STONE_BUTTON && !Gate.isGateBlock(block.getTypeId())) {
                return;
            }
            Portal portal = Portal.getByBlock(block);
            if (portal == null) {
                return;
            }
            if (!Stargate.canDestroy(player, portal)) {
                Stargate.sendMessage(player, "Permission Denied");
                log.info("[Stargate] " + player.getName() + " tried to destroy gate");
                event.setCancelled(true);
                return;
            }
            int cost = Stargate.getDestroyCost(player, portal.getGate());
            if (cost != 0) {
                if (!Stargate.chargePlayer(player, null, cost)) {
                    Stargate.debug("onBlockBreak", "Insufficient Funds");
                    Stargate.sendMessage(player, iConomyHandler.inFundMsg);
                    event.setCancelled(true);
                    return;
                }
                if (cost > 0) {
                    Stargate.sendMessage(player, "Deducted " + iConomyHandler.format(cost), false);
                } else if (cost < 0) {
                    Stargate.sendMessage(player, "Refunded " + iConomyHandler.format(-cost), false);
                }
            }
            portal.unregister(true);
            Stargate.sendMessage(player, dmgMsg, false);
        }

        public void onBlockPhysics(BlockPhysicsEvent event) {
            Block block = event.getBlock();
            if (block.getType() == Material.PORTAL) {
                event.setCancelled(Portal.getByEntrance(block) != null);
            }
        }

        public void onBlockFromTo(BlockFromToEvent event) {
            Portal portal = Portal.getByEntrance(event.getBlock());
            if (portal != null) {
                event.setCancelled(event.getBlock().getY() == event.getToBlock().getY());
            }
        }
    }

    private class eListener
    extends EntityListener {
        private eListener() {
        }

        public void onEntityExplode(EntityExplodeEvent event) {
            if (event.isCancelled()) {
                return;
            }
            for (Block b : event.blockList()) {
                Portal portal;
                if (b.getType() != Material.WALL_SIGN && b.getType() != Material.STONE_BUTTON && !Gate.isGateBlock(b.getTypeId()) || (portal = Portal.getByBlock(b)) == null) continue;
                if (destroyExplosion) {
                    portal.unregister(true);
                    continue;
                }
                b.setType(b.getType());
                event.setCancelled(true);
            }
        }
    }

    private class pListener
    extends PlayerListener {
        private pListener() {
        }

        public void onPlayerPortal(PlayerPortalEvent event) {
            Location from = event.getFrom();
            World world = from.getWorld();
            int cX = from.getBlockX();
            int cY = from.getBlockY();
            int cZ = from.getBlockZ();
            int i = -2;
            while (i < 2) {
                int j = -2;
                while (j < 2) {
                    int k = -2;
                    while (k < 2) {
                        Portal portal;
                        Block b = world.getBlockAt(cX + i, cY + j, cZ + k);
                        if (b.getType() == Material.PORTAL && (portal = Portal.getByEntrance(b)) != null) {
                            event.setCancelled(true);
                            return;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }

        public void onPlayerMove(PlayerMoveEvent event) {
            Player player = event.getPlayer();
            Portal portal = Portal.getByEntrance(event.getTo());
            if (portal == null || !portal.isOpen()) {
                return;
            }
            if (!portal.isOpenFor(player)) {
                if (!denyMsg.isEmpty()) {
                    Stargate.sendMessage(player, denyMsg);
                }
                portal.teleport(player, portal, event);
                return;
            }
            Portal destination = portal.getDestination();
            if (destination == null) {
                return;
            }
            if (!Stargate.canAccessNetwork(player, portal.getNetwork())) {
                Stargate.sendMessage(player, denyMsg);
                portal.teleport(player, portal, event);
                portal.close(false);
                return;
            }
            if (!Stargate.canAccessWorld(player, destination.getWorld().getName())) {
                Stargate.sendMessage(player, denyMsg);
                portal.teleport(player, portal, event);
                portal.close(false);
                return;
            }
            int cost = Stargate.getUseCost(player, portal, destination);
            if (cost > 0) {
                Player p;
                String target;
                String string = target = portal.getGate().getToOwner() != false ? portal.getOwner() : null;
                if (!Stargate.chargePlayer(player, target, cost)) {
                    Stargate.sendMessage(player, "Insufficient Funds");
                    portal.close(false);
                    return;
                }
                Stargate.sendMessage(player, "Deducted " + iConomyHandler.format(cost), false);
                if (target != null && (p = server.getPlayer(target)) != null) {
                    Stargate.sendMessage(p, "Obtained " + iConomyHandler.format(cost) + " from Stargate " + portal.getName(), false);
                }
            }
            Stargate.sendMessage(player, teleMsg, false);
            destination.teleport(player, portal, event);
            portal.close(false);
        }

        public void onPlayerInteract(PlayerInteractEvent event) {
            Player player = event.getPlayer();
            Block block = event.getClickedBlock();
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                if (block.getType() == Material.WALL_SIGN) {
                    Portal portal = Portal.getByBlock(block);
                    if (portal == null) {
                        return;
                    }
                    event.setUseItemInHand(Event.Result.DENY);
                    event.setUseInteractedBlock(Event.Result.DENY);
                    if (!Stargate.canAccessNetwork(player, portal.getNetwork())) {
                        Stargate.sendMessage(player, denyMsg);
                        return;
                    }
                    if (!portal.isOpen() && !portal.isFixed()) {
                        portal.cycleDestination(player);
                    }
                    return;
                }
                if (block.getType() == Material.STONE_BUTTON) {
                    Portal portal = Portal.getByBlock(block);
                    if (portal == null) {
                        return;
                    }
                    if (!Stargate.canAccessNetwork(player, portal.getNetwork())) {
                        Stargate.sendMessage(player, denyMsg);
                        return;
                    }
                    Stargate.this.onButtonPressed(player, portal);
                }
                return;
            }
            if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
                if (block.getType() == Material.WALL_SIGN) {
                    Portal portal = Portal.getByBlock(block);
                    if (portal == null) {
                        return;
                    }
                    if (!Stargate.canAccessNetwork(player, portal.getNetwork())) {
                        Stargate.sendMessage(player, denyMsg);
                        return;
                    }
                    if (!portal.isOpen() && !portal.isFixed()) {
                        portal.cycleDestination(player, -1);
                    }
                    return;
                }
                if (block.getType() == Material.STONE_BUTTON) {
                    Portal portal = Portal.getByBlock(block);
                    if (portal == null) {
                        return;
                    }
                    if (!Stargate.canAccessNetwork(player, portal.getNetwork())) {
                        Stargate.sendMessage(player, denyMsg);
                        return;
                    }
                    Stargate.this.onButtonPressed(player, portal);
                }
            }
        }
    }

    private class sListener
    extends ServerListener {
        private sListener() {
        }

        public void onPluginEnable(PluginEnableEvent event) {
            if (iConomyHandler.useiConomy && iConomyHandler.iconomy == null && event.getPlugin().getDescription().getName().equalsIgnoreCase("iConomy")) {
                iConomyHandler.iconomy = (iConomy)Stargate.this.checkPlugin(event.getPlugin());
            }
            if (permissions == null && event.getPlugin().getDescription().getName().equalsIgnoreCase("Permissions")) {
                Stargate.permissions = (Permissions)Stargate.this.checkPlugin(event.getPlugin());
            }
        }

        public void onPluginDisable(PluginDisableEvent event) {
            if (iConomyHandler.useiConomy && event.getPlugin() == iConomyHandler.iconomy) {
                log.info("[Stargate] iConomy plugin lost.");
                iConomyHandler.iconomy = null;
            }
            if (event.getPlugin() == permissions) {
                log.info("[Stargate] Permissions plugin lost.");
                Stargate.permissions = null;
            }
        }
    }

    private class vListener
    extends VehicleListener {
        private vListener() {
        }

        public void onVehicleMove(VehicleMoveEvent event) {
            Entity passenger = event.getVehicle().getPassenger();
            Vehicle vehicle = event.getVehicle();
            Portal portal = Portal.getByEntrance(event.getTo());
            if (portal == null || !portal.isOpen()) {
                return;
            }
            if (passenger instanceof Player) {
                Player player = (Player)passenger;
                if (!portal.isOpenFor(player)) {
                    Stargate.sendMessage(player, denyMsg);
                    return;
                }
                Portal dest = portal.getDestination();
                if (dest == null) {
                    return;
                }
                if (!Stargate.canAccessNetwork(player, portal.getNetwork())) {
                    Stargate.sendMessage(player, denyMsg);
                    portal.close(false);
                    return;
                }
                if (!Stargate.canAccessWorld(player, dest.getWorld().getName())) {
                    Stargate.sendMessage(player, denyMsg);
                    portal.close(false);
                    return;
                }
                int cost = Stargate.getUseCost(player, portal, dest);
                if (cost > 0) {
                    Player p;
                    String target;
                    String string = target = portal.getGate().getToOwner() != false ? portal.getOwner() : null;
                    if (!Stargate.chargePlayer(player, target, cost)) {
                        Stargate.sendMessage(player, "Insufficient Funds");
                        portal.close(false);
                        return;
                    }
                    Stargate.sendMessage(player, "Deducted " + iConomyHandler.format(cost), false);
                    if (target != null && (p = server.getPlayer(target)) != null) {
                        Stargate.sendMessage(p, "Obtained " + iConomyHandler.format(cost) + " from Stargate " + portal.getName(), false);
                    }
                }
                Stargate.sendMessage(player, teleMsg, false);
                dest.teleport(vehicle);
                portal.close(false);
            } else {
                Portal dest = portal.getDestination();
                if (dest == null) {
                    return;
                }
                dest.teleport(vehicle);
            }
        }
    }

    private class wListener
    extends WorldListener {
        private wListener() {
        }

        public void onWorldLoad(WorldLoadEvent event) {
            World w = event.getWorld();
            if (w.getBlockAt(w.getSpawnLocation()).getWorld() != null) {
                Portal.loadAllGates(w);
            }
        }
    }
}

