/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.utils;

import com.gemo.utils.FlatFileData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;

public class FlatFile {
    private String FileName;
    public ArrayList<FlatFileData> Data;
    private BufferedReader reader;
    private Writer writer;
    private boolean isReading = false;
    private boolean isWriting = false;

    public FlatFile(String FileName, boolean read) throws IOException {
        this.FileName = FileName;
        this.Data = new ArrayList();
        if (read) {
            this.readFile();
        }
    }

    public void regenerateFile(String FileName) throws IOException {
        this.writer = new BufferedWriter(new FileWriter("plugins/" + FileName));
        this.writer.flush();
        this.writer.close();
    }

    public boolean readFile() throws IOException {
        boolean FileExisted = true;
        if (!new File("plugins/" + this.FileName).exists()) {
            this.regenerateFile(this.FileName);
            FileExisted = false;
        }
        FileInputStream fstream = new FileInputStream("plugins/" + this.FileName);
        DataInputStream in = new DataInputStream(fstream);
        this.reader = new BufferedReader(new InputStreamReader(in));
        String line = this.reader.readLine();
        while (line != null) {
            String[] split = line.split("=");
            if (split.length > 1) {
                this.Data.add(new FlatFileData(split[0], split[1]));
            }
            line = this.reader.readLine();
        }
        return FileExisted;
    }

    public void writeFile() throws IOException {
        this.writer = new BufferedWriter(new FileWriter("plugins/" + this.FileName));
        int i = 0;
        while (i < this.Data.size()) {
            this.writer.write(String.valueOf(this.Data.get((int)i).name) + "=" + this.Data.get((int)i).value + "\r\n");
            ++i;
        }
        this.writer.close();
    }

    public void clearAll() {
        this.Data.clear();
    }

    public void closeFile(boolean read) throws IOException {
        if (read) {
            if (this.isReading) {
                this.isReading = false;
            }
        } else if (this.isWriting) {
            this.writer.flush();
            this.writer.close();
            this.isWriting = false;
        }
    }

    public void addBoolean(String name, boolean value) {
        if (this.propertyExists(name)) {
            return;
        }
        this.Data.add(new FlatFileData(name, "" + value));
    }

    public void addInt(String name, int value) {
        if (this.propertyExists(name)) {
            return;
        }
        this.Data.add(new FlatFileData(name, "" + value));
    }

    public void addDouble(String name, double value) {
        if (this.propertyExists(name)) {
            return;
        }
        this.Data.add(new FlatFileData(name, "" + value));
    }

    public void addFloat(String name, float value) {
        if (this.propertyExists(name)) {
            return;
        }
        this.Data.add(new FlatFileData(name, "" + value));
    }

    public void addString(String name, String value) {
        if (this.propertyExists(name)) {
            return;
        }
        this.Data.add(new FlatFileData(name, value));
    }

    public void addBooleanArrayList(String name, ArrayList<Boolean> value, String delimiter) {
        if (this.propertyExists(name)) {
            return;
        }
        String str = "";
        int i = 0;
        while (i < value.size() - 1) {
            str = String.valueOf(str) + value.get(i) + delimiter;
            ++i;
        }
        if (value.size() > 0) {
            str = String.valueOf(str) + value.get(value.size() - 1);
        }
        this.Data.add(new FlatFileData(name, str));
    }

    public void addIntArrayList(String name, ArrayList<Integer> value, String delimiter) {
        if (this.propertyExists(name)) {
            return;
        }
        String str = "";
        int i = 0;
        while (i < value.size() - 1) {
            str = String.valueOf(str) + value.get(i) + delimiter;
            ++i;
        }
        if (value.size() > 0) {
            str = String.valueOf(str) + value.get(value.size() - 1);
        }
        this.Data.add(new FlatFileData(name, str));
    }

    public void addDoubleArrayList(String name, ArrayList<Double> value, String delimiter) {
        if (this.propertyExists(name)) {
            return;
        }
        String str = "";
        int i = 0;
        while (i < value.size() - 1) {
            str = String.valueOf(str) + value.get(i) + delimiter;
            ++i;
        }
        if (value.size() > 0) {
            str = String.valueOf(str) + value.get(value.size() - 1);
        }
        this.Data.add(new FlatFileData(name, str));
    }

    public void addFloatArrayList(String name, ArrayList<Float> value, String delimiter) {
        if (this.propertyExists(name)) {
            return;
        }
        String str = "";
        int i = 0;
        while (i < value.size() - 1) {
            str = String.valueOf(str) + value.get(i) + delimiter;
            ++i;
        }
        if (value.size() > 0) {
            str = String.valueOf(str) + value.get(value.size() - 1);
        }
        this.Data.add(new FlatFileData(name, str));
    }

    public void addStringArrayList(String name, ArrayList<String> value, String delimiter) {
        if (this.propertyExists(name)) {
            return;
        }
        String str = "";
        int i = 0;
        while (i < value.size() - 1) {
            str = String.valueOf(str) + value.get(i) + delimiter;
            ++i;
        }
        if (value.size() > 0) {
            str = String.valueOf(str) + value.get(value.size() - 1);
        }
        this.Data.add(new FlatFileData(name, str));
    }

    public boolean propertyExists(String name) {
        int i = 0;
        while (i < this.Data.size()) {
            if (this.Data.get((int)i).name.equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int getPropertyID(String name) {
        int i = 0;
        while (i < this.Data.size()) {
            if (this.Data.get((int)i).name.equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean setBoolean(String name, boolean value) {
        if (!this.propertyExists(name)) {
            this.addBoolean(name, value);
        }
        this.Data.get((int)this.getPropertyID((String)name)).value = "" + value;
        return value;
    }

    public int setInt(String name, int value) {
        if (!this.propertyExists(name)) {
            this.addInt(name, value);
        }
        this.Data.get((int)this.getPropertyID((String)name)).value = "" + value;
        return value;
    }

    public double setDouble(String name, double value) {
        if (!this.propertyExists(name)) {
            this.addDouble(name, value);
        }
        this.Data.get((int)this.getPropertyID((String)name)).value = "" + value;
        return value;
    }

    public float setFloat(String name, float value) {
        if (!this.propertyExists(name)) {
            this.addFloat(name, value);
        }
        this.Data.get((int)this.getPropertyID((String)name)).value = "" + value;
        return value;
    }

    public String setString(String name, String value) {
        if (!this.propertyExists(name)) {
            this.addString(name, value);
        }
        this.Data.get((int)this.getPropertyID((String)name)).value = value;
        return value;
    }

    public ArrayList<Boolean> setBooleanArrayList(String name, ArrayList<Boolean> value, String delimiter) {
        String str = "";
        int i = 0;
        while (i < value.size() - 1) {
            str = String.valueOf(str) + value.get(i) + delimiter;
            ++i;
        }
        if (value.size() > 0) {
            str = String.valueOf(str) + value.get(value.size() - 1);
        }
        if (!this.propertyExists(name)) {
            this.addBooleanArrayList(name, value, delimiter);
        }
        this.Data.get((int)this.getPropertyID((String)name)).value = str;
        return value;
    }

    public ArrayList<Integer> setIntArrayList(String name, ArrayList<Integer> value, String delimiter) {
        String str = "";
        int i = 0;
        while (i < value.size() - 1) {
            str = String.valueOf(str) + value.get(i) + delimiter;
            ++i;
        }
        if (value.size() > 0) {
            str = String.valueOf(str) + value.get(value.size() - 1);
        }
        if (!this.propertyExists(name)) {
            this.addIntArrayList(name, value, delimiter);
        }
        this.Data.get((int)this.getPropertyID((String)name)).value = str;
        return value;
    }

    public ArrayList<Double> setDoubleArrayList(String name, ArrayList<Double> value, String delimiter) {
        String str = "";
        int i = 0;
        while (i < value.size() - 1) {
            str = String.valueOf(str) + value.get(i) + delimiter;
            ++i;
        }
        if (value.size() > 0) {
            str = String.valueOf(str) + value.get(value.size() - 1);
        }
        if (!this.propertyExists(name)) {
            this.addDoubleArrayList(name, value, delimiter);
        }
        this.Data.get((int)this.getPropertyID((String)name)).value = str;
        return value;
    }

    public ArrayList<Float> setFloatArrayList(String name, ArrayList<Float> value, String delimiter) {
        String str = "";
        int i = 0;
        while (i < value.size() - 1) {
            str = String.valueOf(str) + value.get(i) + delimiter;
            ++i;
        }
        if (value.size() > 0) {
            str = String.valueOf(str) + value.get(value.size() - 1);
        }
        if (!this.propertyExists(name)) {
            this.addFloatArrayList(name, value, delimiter);
        }
        this.Data.get((int)this.getPropertyID((String)name)).value = str;
        return value;
    }

    public ArrayList<String> setStringArrayList(String name, ArrayList<String> value, String delimiter) {
        String str = "";
        int i = 0;
        while (i < value.size() - 1) {
            str = String.valueOf(str) + value.get(i) + delimiter;
            ++i;
        }
        if (value.size() > 0) {
            str = String.valueOf(str) + value.get(value.size() - 1);
        }
        if (!this.propertyExists(name)) {
            this.addStringArrayList(name, value, delimiter);
        }
        this.Data.get((int)this.getPropertyID((String)name)).value = str;
        return value;
    }

    public boolean getBoolean(String name, boolean standard) {
        if (!this.propertyExists(name)) {
            return standard;
        }
        return Boolean.valueOf(this.Data.get((int)this.getPropertyID((String)name)).value);
    }

    public int getInt(String name, int standard) {
        if (!this.propertyExists(name)) {
            return standard;
        }
        return Integer.valueOf(this.Data.get((int)this.getPropertyID((String)name)).value);
    }

    public double getDouble(String name, double standard) {
        if (!this.propertyExists(name)) {
            return standard;
        }
        return Double.valueOf(this.Data.get((int)this.getPropertyID((String)name)).value);
    }

    public float getFloat(String name, float standard) {
        if (!this.propertyExists(name)) {
            return standard;
        }
        return Float.valueOf(this.Data.get((int)this.getPropertyID((String)name)).value).floatValue();
    }

    public String getString(String name, String standard) {
        if (!this.propertyExists(name)) {
            return standard;
        }
        return this.Data.get((int)this.getPropertyID((String)name)).value;
    }

    public ArrayList<Boolean> getBooleanArrayList(String name, String delimiter) {
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        if (!this.propertyExists(name)) {
            this.addBooleanArrayList(name, list, delimiter);
            return list;
        }
        String[] data = this.Data.get((int)this.getPropertyID((String)name)).value.trim().split(delimiter);
        int i = 0;
        while (i < data.length) {
            data[i] = data[i].trim();
            list.add(Boolean.valueOf(data[i]));
            ++i;
        }
        return list;
    }

    public ArrayList<Integer> getIntArrayList(String name, String delimiter) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (!this.propertyExists(name)) {
            this.addIntArrayList(name, list, delimiter);
            return list;
        }
        String[] data = this.Data.get((int)this.getPropertyID((String)name)).value.trim().split(delimiter);
        int i = 0;
        while (i < data.length) {
            data[i] = data[i].trim();
            list.add(Integer.valueOf(data[i]));
            ++i;
        }
        return list;
    }

    public ArrayList<Double> getDoubleArrayList(String name, String delimiter) {
        ArrayList<Double> list = new ArrayList<Double>();
        if (!this.propertyExists(name)) {
            this.addDoubleArrayList(name, list, delimiter);
            return list;
        }
        String[] data = this.Data.get((int)this.getPropertyID((String)name)).value.trim().split(delimiter);
        int i = 0;
        while (i < data.length) {
            data[i] = data[i].trim();
            list.add(Double.valueOf(data[i]));
            ++i;
        }
        return list;
    }

    public ArrayList<Float> getFloatArrayList(String name, String delimiter) {
        ArrayList<Float> list = new ArrayList<Float>();
        if (!this.propertyExists(name)) {
            this.addFloatArrayList(name, list, delimiter);
            return list;
        }
        String[] data = this.Data.get((int)this.getPropertyID((String)name)).value.trim().split(delimiter);
        int i = 0;
        while (i < data.length) {
            data[i] = data[i].trim();
            list.add(Float.valueOf(data[i]));
            ++i;
        }
        return list;
    }

    public ArrayList<String> getStringArrayList(String name, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.propertyExists(name)) {
            this.addStringArrayList(name, list, delimiter);
            return list;
        }
        String[] data = this.Data.get((int)this.getPropertyID((String)name)).value.trim().split(delimiter);
        int i = 0;
        while (i < data.length) {
            list.add(data[i]);
            ++i;
        }
        return list;
    }
}

