/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.bukkit.migration;

import com.sk89q.bukkit.migration.PermissionsResolver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.util.config.Configuration;

public class ConfigurationPermissionsResolver
implements PermissionsResolver {
    private Configuration config;
    private Map<String, Set<String>> userPermissionsCache;
    private Set<String> defaultPermissionsCache;
    private Map<String, Set<String>> userGroups;

    public ConfigurationPermissionsResolver(Configuration config) {
        this.config = config;
    }

    public void load() {
        List userKeys;
        this.userGroups = new HashMap<String, Set<String>>();
        this.userPermissionsCache = new HashMap<String, Set<String>>();
        this.defaultPermissionsCache = new HashSet<String>();
        HashMap userGroupPermissions = new HashMap();
        List groupKeys = this.config.getKeys("permissions.groups");
        if (groupKeys != null) {
            for (String key : groupKeys) {
                List permissions = this.config.getStringList("permissions.groups." + key + ".permissions", null);
                if (permissions.size() <= 0) continue;
                HashSet groupPerms = new HashSet(permissions);
                userGroupPermissions.put(key, groupPerms);
                if (!key.equals("default")) continue;
                this.defaultPermissionsCache.addAll(permissions);
            }
        }
        if ((userKeys = this.config.getKeys("permissions.users")) != null) {
            for (String key : userKeys) {
                HashSet permsCache = new HashSet();
                List permissions = this.config.getStringList("permissions.users." + key + ".permissions", null);
                if (permissions.size() > 0) {
                    permsCache.addAll(permissions);
                }
                List groups = this.config.getStringList("permissions.users." + key + ".groups", null);
                groups.add("default");
                if (groups.size() > 0) {
                    for (String group : groups) {
                        Set groupPerms = (Set)userGroupPermissions.get(group);
                        if (groupPerms == null) continue;
                        permsCache.addAll(groupPerms);
                    }
                }
                this.userPermissionsCache.put(key.toLowerCase(), permsCache);
                this.userGroups.put(key.toLowerCase(), new HashSet(groups));
            }
        }
    }

    public boolean hasPermission(String player, String permission) {
        int dotPos = permission.lastIndexOf(".");
        if (dotPos > -1 && this.hasPermission(player, permission.substring(0, dotPos))) {
            return true;
        }
        Set<String> perms = this.userPermissionsCache.get(player.toLowerCase());
        if (perms == null) {
            return this.defaultPermissionsCache.contains(permission) || this.defaultPermissionsCache.contains("*");
        }
        return perms.contains("*") || perms.contains(permission);
    }

    public boolean inGroup(String player, String group) {
        Set<String> groups = this.userGroups.get(player.toLowerCase());
        if (groups == null) {
            return false;
        }
        return groups.contains(group);
    }

    public String[] getGroups(String player) {
        Set<String> groups = this.userGroups.get(player.toLowerCase());
        if (groups == null) {
            return new String[0];
        }
        return groups.toArray(new String[groups.size()]);
    }
}

