/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.bukkit.migration;

import com.sk89q.bukkit.migration.PermissionsProvider;
import com.sk89q.bukkit.migration.PermissionsResolverManager;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.event.server.ServerListener;
import org.bukkit.plugin.Plugin;

public class PermissionsResolverServerListener
extends ServerListener {
    private PermissionsResolverManager manager;

    public PermissionsResolverServerListener(PermissionsResolverManager manager) {
        this.manager = manager;
    }

    public void onPluginEnable(PluginEnableEvent event) {
        Plugin plugin = event.getPlugin();
        String name = plugin.getDescription().getName();
        if (plugin instanceof PermissionsProvider) {
            this.manager.setPluginPermissionsResolver(plugin);
        } else if (name.equalsIgnoreCase("GroupUsers") || name.equalsIgnoreCase("Permissions")) {
            this.manager.findResolver();
            this.manager.load();
        }
    }

    public void onPluginDisable(PluginDisableEvent event) {
        Plugin plugin = event.getPlugin();
        String name = plugin.getDescription().getName();
        if (plugin instanceof PermissionsProvider || name.equalsIgnoreCase("GroupUsers") || name.equalsIgnoreCase("Permissions")) {
            this.manager.findResolver();
            this.manager.load();
        }
    }

    public void register(Plugin plugin) {
        plugin.getServer().getPluginManager().registerEvent(Event.Type.PLUGIN_ENABLE, (Listener)this, Event.Priority.Normal, plugin);
        plugin.getServer().getPluginManager().registerEvent(Event.Type.PLUGIN_DISABLE, (Listener)this, Event.Priority.Normal, plugin);
    }
}

