/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.bags.BlockBagException;
import com.sk89q.worldedit.bags.OutOfBlocksException;
import com.sk89q.worldedit.bags.OutOfSpaceException;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BukkitPlayerBlockBag
extends BlockBag {
    private Player player;
    private ItemStack[] items;

    public BukkitPlayerBlockBag(Player player) {
        this.player = player;
    }

    private void loadInventory() {
        if (this.items == null) {
            this.items = this.player.getInventory().getContents();
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public void fetchBlock(int id) throws BlockBagException {
        if (id == 0) {
            throw new IllegalArgumentException("Can't fetch air block");
        }
        this.loadInventory();
        boolean found = false;
        for (int slot = 0; slot < this.items.length; ++slot) {
            ItemStack item = this.items[slot];
            if (item == null || item.getTypeId() != id) continue;
            int amount = item.getAmount();
            if (amount < 0) {
                return;
            }
            if (amount > 1) {
                item.setAmount(amount - 1);
                found = true;
                break;
            }
            this.items[slot] = null;
            found = true;
            break;
        }
        if (!found) {
            throw new OutOfBlocksException();
        }
    }

    public void storeBlock(int id) throws BlockBagException {
        if (id == 0) {
            throw new IllegalArgumentException("Can't store air block");
        }
        this.loadInventory();
        boolean found = false;
        int freeSlot = -1;
        for (int slot = 0; slot < this.items.length; ++slot) {
            ItemStack item = this.items[slot];
            if (item == null) {
                if (freeSlot != -1) continue;
                freeSlot = slot;
                continue;
            }
            if (item.getTypeId() != id) continue;
            int amount = item.getAmount();
            if (amount < 0) {
                return;
            }
            if (amount >= 64) continue;
            item.setAmount(amount + 1);
            found = true;
            break;
        }
        if (!found && freeSlot > -1) {
            this.items[freeSlot] = new ItemStack(id, 1);
            found = true;
        }
        if (!found) {
            throw new OutOfSpaceException(id);
        }
    }

    public void flushChanges() {
        if (this.items != null) {
            this.player.getInventory().setContents(this.items);
            this.items = null;
        }
    }

    public void addSourcePosition(Vector pos) {
    }

    public void addSingleSourcePosition(Vector pos) {
    }
}

