/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.selections;

import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.bukkit.selections.RegionSelection;
import com.sk89q.worldedit.regions.Polygonal2DRegion;
import com.sk89q.worldedit.regions.Polygonal2DRegionSelector;
import com.sk89q.worldedit.regions.RegionSelector;
import java.util.Collections;
import java.util.List;
import org.bukkit.World;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polygonal2DSelection
extends RegionSelection {
    protected Polygonal2DRegion poly2d;

    public Polygonal2DSelection(World world, RegionSelector sel, Polygonal2DRegion region) {
        super(world, sel, region);
        this.poly2d = region;
    }

    public Polygonal2DSelection(World world, List<BlockVector2D> points, int minY, int maxY) {
        super(world);
        minY = Math.min(Math.max(0, minY), 127);
        maxY = Math.min(Math.max(0, maxY), 127);
        Polygonal2DRegionSelector sel = new Polygonal2DRegionSelector();
        this.poly2d = sel.getIncompleteRegion();
        for (BlockVector2D pt : points) {
            if (pt == null) {
                throw new IllegalArgumentException("Null point not permitted");
            }
            this.poly2d.addPoint(pt);
        }
        this.poly2d.setMinimumY(minY);
        this.poly2d.setMaximumY(maxY);
        sel.learnChanges();
        this.setRegionSelector(sel);
        this.setRegion(this.poly2d);
    }

    public List<BlockVector2D> getNativePoints() {
        return Collections.unmodifiableList(this.poly2d.getPoints());
    }
}

