/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.patterns.Pattern;
import com.sk89q.worldedit.util.TreeGenerator;

public class GenerationCommands {
    @Command(aliases={"/hcyl"}, usage="<block> <radius> [height] ", desc="Generate a hollow cylinder", min=2, max=3)
    @CommandPermissions(value={"worldedit.generation.cylinder"})
    public static void hcyl(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Pattern block = we.getBlockPattern(player, args.getString(0));
        int radius = Math.max(1, args.getInteger(1));
        int height = args.argsLength() > 2 ? args.getInteger(2) : 1;
        Vector pos = session.getPlacementPosition(player);
        int affected = editSession.makeHollowCylinder(pos, block, radius, height);
        player.print(affected + " block(s) have been created.");
    }

    @Command(aliases={"/cyl"}, usage="<block> <radius> [height] ", desc="Generate a cylinder", min=2, max=3)
    @CommandPermissions(value={"worldedit.generation.cylinder"})
    public static void cyl(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Pattern block = we.getBlockPattern(player, args.getString(0));
        int radius = Math.max(1, args.getInteger(1));
        int height = args.argsLength() > 2 ? args.getInteger(2) : 1;
        Vector pos = session.getPlacementPosition(player);
        int affected = editSession.makeCylinder(pos, block, radius, height);
        player.print(affected + " block(s) have been created.");
    }

    @Command(aliases={"/hsphere"}, usage="<block> <radius> [raised?] ", desc="Generate a hollow sphere", min=2, max=3)
    @CommandPermissions(value={"worldedit.generation.sphere"})
    public static void hsphere(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Pattern block = we.getBlockPattern(player, args.getString(0));
        int radius = Math.max(1, args.getInteger(1));
        boolean raised = args.argsLength() > 2 ? args.getString(2).equalsIgnoreCase("true") || args.getString(2).equalsIgnoreCase("yes") : false;
        Vector pos = session.getPlacementPosition(player);
        if (raised) {
            pos = pos.add(0, radius, 0);
        }
        int affected = editSession.makeSphere(pos, block, radius, false);
        player.findFreePosition();
        player.print(affected + " block(s) have been created.");
    }

    @Command(aliases={"/sphere"}, usage="<block> <radius> [raised?] ", desc="Generate a filled sphere", min=2, max=3)
    @CommandPermissions(value={"worldedit.generation.sphere"})
    public static void sphere(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Pattern block = we.getBlockPattern(player, args.getString(0));
        int radius = Math.max(1, args.getInteger(1));
        boolean raised = args.argsLength() > 2 ? args.getString(2).equalsIgnoreCase("true") || args.getString(2).equalsIgnoreCase("yes") : false;
        Vector pos = session.getPlacementPosition(player);
        if (raised) {
            pos = pos.add(0, radius, 0);
        }
        int affected = editSession.makeSphere(pos, block, radius, true);
        player.findFreePosition();
        player.print(affected + " block(s) have been created.");
    }

    @Command(aliases={"forestgen"}, usage="[size] [type] [density]", desc="Generate a forest", min=0, max=3)
    @CommandPermissions(value={"worldedit.generation.forest"})
    public static void forestGen(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double density;
        TreeGenerator.TreeType type;
        int size = args.argsLength() > 0 ? Math.max(1, args.getInteger(0)) : 10;
        type = args.argsLength() > 1 ? (type = TreeGenerator.lookup(args.getString(1))) : TreeGenerator.TreeType.TREE;
        double d = density = args.argsLength() > 2 ? args.getDouble(2) / 100.0 : 0.05;
        if (type == null) {
            player.printError("Tree type '" + args.getString(1) + "' is unknown.");
            return;
        }
        int affected = editSession.makeForest(player.getPosition(), size, density, new TreeGenerator(type));
        player.print(affected + " trees created.");
    }

    @Command(aliases={"pumpkins"}, usage="[size]", desc="Generate pumpkin patches", min=0, max=1)
    @CommandPermissions(value={"worldedit.generation.pumpkins"})
    public static void pumpkins(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int size = args.argsLength() > 0 ? Math.max(1, args.getInteger(0)) : 10;
        int affected = editSession.makePumpkinPatches(player.getPosition(), size);
        player.print(affected + " pumpkin patches created.");
    }
}

