/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.WorldVector;

public class NavigationCommands {
    @Command(aliases={"unstuck"}, usage="", desc="Escape from being stuck inside a block", min=0, max=0)
    @CommandPermissions(value={"worldedit.navigation.unstuck"})
    public static void unstuck(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        player.print("There you go!");
        player.findFreePosition();
    }

    @Command(aliases={"ascend"}, usage="", desc="Go up a floor", min=0, max=0)
    @CommandPermissions(value={"worldedit.navigation.ascend"})
    public static void ascend(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        if (player.ascendLevel()) {
            player.print("Ascended a level.");
        } else {
            player.printError("No free spot above you found.");
        }
    }

    @Command(aliases={"descend"}, usage="", desc="Go down a floor", min=0, max=0)
    @CommandPermissions(value={"worldedit.navigation.descend"})
    public static void descend(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        if (player.descendLevel()) {
            player.print("Descended a level.");
        } else {
            player.printError("No free spot below you found.");
        }
    }

    @Command(aliases={"ceil"}, usage="[clearance]", desc="Go to the celing", min=0, max=1)
    @CommandPermissions(value={"worldedit.navigation.ceiling"})
    public static void ceiling(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int clearence;
        int n = clearence = args.argsLength() > 0 ? Math.max(0, args.getInteger(0)) : 0;
        if (player.ascendToCeiling(clearence)) {
            player.print("Whoosh!");
        } else {
            player.printError("No free spot above you found.");
        }
    }

    @Command(aliases={"thru"}, usage="", desc="Passthrough walls", min=0, max=0)
    @CommandPermissions(value={"worldedit.navigation.thru"})
    public static void thru(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        if (player.passThroughForwardWall(6)) {
            player.print("Whoosh!");
        } else {
            player.printError("No free spot ahead of you found.");
        }
    }

    @Command(aliases={"jumpto"}, usage="", desc="Teleport to a location", min=0, max=0)
    @CommandPermissions(value={"worldedit.navigation.jumpto"})
    public static void jumpTo(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        WorldVector pos = player.getSolidBlockTrace(300);
        if (pos != null) {
            player.findFreePosition(pos);
            player.print("Poof!");
        } else {
            player.printError("No block in sight!");
        }
    }

    @Command(aliases={"up"}, usage="<block>", desc="Go upwards some distance", min=1, max=1)
    @CommandPermissions(value={"worldedit.navigation.up"})
    public static void up(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int distance = args.getInteger(0);
        if (player.ascendUpwards(distance)) {
            player.print("Whoosh!");
        } else {
            player.printError("You would hit something above you.");
        }
    }
}

