/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import java.io.File;

public class ScriptingCommands {
    @Command(aliases={"cs"}, usage="<filename> [args...]", desc="Execute a CraftScript", min=1, max=-1)
    @CommandPermissions(value={"worldedit.scripting.execute"})
    public static void execute(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        String[] scriptArgs = args.getSlice(1);
        session.setLastScript(args.getString(0));
        File dir = we.getWorkingDirectoryFile(we.getConfiguration().scriptsDir);
        File f = we.getSafeOpenFile(player, dir, args.getString(0), "js", new String[]{"js"});
        we.runScript(player, f, scriptArgs);
    }

    @Command(aliases={".s"}, usage="[args...]", desc="Execute last CraftScript", min=0, max=-1)
    @CommandPermissions(value={"worldedit.scripting.execute"})
    public static void executeLast(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        String lastScript = session.getLastScript();
        if (lastScript == null) {
            player.printError("Use /cs with a script name first.");
            return;
        }
        String[] scriptArgs = args.getSlice(0);
        File dir = we.getWorkingDirectoryFile(we.getConfiguration().scriptsDir);
        File f = we.getSafeOpenFile(player, dir, lastScript, "js", new String[]{"js"});
        we.runScript(player, f, scriptArgs);
    }
}

