/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.snapshots;

import com.sk89q.worldedit.snapshots.InvalidSnapshotException;
import com.sk89q.worldedit.snapshots.ModificationTimerParser;
import com.sk89q.worldedit.snapshots.Snapshot;
import com.sk89q.worldedit.snapshots.SnapshotDateParser;
import com.sk89q.worldedit.snapshots.YYMMDDHHIISSParser;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotRepository {
    protected File dir;
    protected List<SnapshotDateParser> dateParsers = new ArrayList<SnapshotDateParser>();

    public SnapshotRepository(File dir) {
        this.dir = dir;
        this.dateParsers.add(new YYMMDDHHIISSParser());
        this.dateParsers.add(new ModificationTimerParser());
    }

    public SnapshotRepository(String dir) {
        this(new File(dir));
    }

    public List<Snapshot> getSnapshots(boolean newestFirst) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File f = new File(dir, name);
                return SnapshotRepository.this.isValidSnapshot(f);
            }
        };
        String[] snapshotNames = this.dir.list(filter);
        ArrayList<Snapshot> list = new ArrayList<Snapshot>(snapshotNames.length);
        for (String name : snapshotNames) {
            Snapshot snapshot = new Snapshot(this, name);
            this.detectDate(snapshot);
            list.add(snapshot);
        }
        if (newestFirst) {
            Collections.sort(list, Collections.reverseOrder());
        } else {
            Collections.sort(list);
        }
        return list;
    }

    public Snapshot getSnapshotAfter(Calendar date) {
        List<Snapshot> snapshots = this.getSnapshots(true);
        Snapshot last = null;
        for (Snapshot snapshot : snapshots) {
            if (snapshot.getDate() != null && snapshot.getDate().before(date)) {
                return last;
            }
            last = snapshot;
        }
        return last;
    }

    public Snapshot getSnapshotBefore(Calendar date) {
        List<Snapshot> snapshots = this.getSnapshots(false);
        Snapshot last = null;
        for (Snapshot snapshot : snapshots) {
            if (snapshot.getDate().after(date)) {
                return last;
            }
            last = snapshot;
        }
        return last;
    }

    protected void detectDate(Snapshot snapshot) {
        for (SnapshotDateParser parser : this.dateParsers) {
            Calendar date = parser.detectDate(snapshot.getFile());
            if (date == null) continue;
            snapshot.setDate(date);
            return;
        }
        snapshot.setDate(null);
    }

    public Snapshot getDefaultSnapshot() {
        List<Snapshot> snapshots = this.getSnapshots(true);
        if (snapshots.size() == 0) {
            return null;
        }
        return snapshots.get(0);
    }

    public boolean isValidSnapshotName(String snapshot) {
        return this.isValidSnapshot(new File(this.dir, snapshot));
    }

    public boolean isValidSnapshot(File f) {
        if (!f.getName().matches("^[A-Za-z0-9_\\- \\./\\\\'\\$@~!%\\^\\*\\(\\)\\[\\]\\+\\{\\},\\?]+$")) {
            return false;
        }
        return f.isDirectory() && new File(f, "level.dat").exists() || f.isFile() && (f.getName().toLowerCase().endsWith(".zip") || f.getName().toLowerCase().endsWith(".tar.bz2") || f.getName().toLowerCase().endsWith(".tar.gz") || f.getName().toLowerCase().endsWith(".tar"));
    }

    public Snapshot getSnapshot(String name) throws InvalidSnapshotException {
        if (!this.isValidSnapshotName(name)) {
            throw new InvalidSnapshotException();
        }
        return new Snapshot(this, name);
    }

    public File getDirectory() {
        return this.dir;
    }
}

