/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.tools.brushes;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.HeightMap;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.filtering.GaussianKernel;
import com.sk89q.worldedit.filtering.HeightMapFilter;
import com.sk89q.worldedit.patterns.Pattern;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.tools.brushes.Brush;

public class SmoothBrush
implements Brush {
    private int iterations;

    public SmoothBrush(int iterations) {
        this.iterations = iterations;
    }

    public void build(EditSession editSession, Vector pos, Pattern mat, int size) throws MaxChangedBlocksException {
        int rad = size;
        Vector min = pos.subtract(rad, rad, rad);
        Vector max = pos.add(rad, rad + 10, rad);
        CuboidRegion region = new CuboidRegion(min, max);
        HeightMap heightMap = new HeightMap(editSession, region);
        HeightMapFilter filter = new HeightMapFilter(new GaussianKernel(5, 1.0));
        heightMap.applyFilter(filter, this.iterations);
    }
}

