/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class TreeGenerator {
    private static Random rand = new Random();
    private TreeType type;

    public TreeGenerator(TreeType type) {
        this.type = type;
    }

    public boolean generate(EditSession editSession, Vector pos) throws MaxChangedBlocksException {
        return this.generate(this.type, editSession, pos);
    }

    private boolean generate(TreeType type, EditSession editSession, Vector pos) throws MaxChangedBlocksException {
        LocalWorld world = editSession.getWorld();
        switch (type) {
            case TREE: {
                return world.generateTree(editSession, pos);
            }
            case BIG_TREE: {
                return world.generateBigTree(editSession, pos);
            }
            case BIRCH: {
                return world.generateBirchTree(editSession, pos);
            }
            case REDWOOD: {
                return world.generateRedwoodTree(editSession, pos);
            }
            case TALL_REDWOOD: {
                return world.generateTallRedwoodTree(editSession, pos);
            }
            case PINE: {
                TreeGenerator.makePineTree(editSession, pos);
                return true;
            }
            case RANDOM_REDWOOD: {
                TreeType[] choices = new TreeType[]{TreeType.REDWOOD, TreeType.TALL_REDWOOD};
                TreeType realType = choices[rand.nextInt(choices.length)];
                return this.generate(realType, editSession, pos);
            }
            case RANDOM: {
                TreeType[] choices = new TreeType[]{TreeType.TREE, TreeType.BIG_TREE, TreeType.BIRCH, TreeType.REDWOOD, TreeType.TALL_REDWOOD, TreeType.PINE};
                TreeType realType = choices[rand.nextInt(choices.length)];
                return this.generate(realType, editSession, pos);
            }
        }
        return false;
    }

    private static void makePineTree(EditSession editSession, Vector basePos) throws MaxChangedBlocksException {
        int i;
        int trunkHeight = (int)Math.floor(Math.random() * 2.0) + 3;
        int height = (int)Math.floor(Math.random() * 5.0) + 8;
        BaseBlock logBlock = new BaseBlock(17);
        BaseBlock leavesBlock = new BaseBlock(18);
        for (i = 0; i < trunkHeight; ++i) {
            if (editSession.setBlockIfAir(basePos.add(0, i, 0), logBlock)) continue;
            return;
        }
        basePos = basePos.add(0, trunkHeight, 0);
        for (i = 0; i < height; ++i) {
            int j;
            editSession.setBlockIfAir(basePos.add(0, i, 0), logBlock);
            double chance = i == 0 || i == height - 1 ? 0.6 : 1.0;
            editSession.setChanceBlockIfAir(basePos.add(-1, i, 0), leavesBlock, chance);
            editSession.setChanceBlockIfAir(basePos.add(1, i, 0), leavesBlock, chance);
            editSession.setChanceBlockIfAir(basePos.add(0, i, -1), leavesBlock, chance);
            editSession.setChanceBlockIfAir(basePos.add(0, i, 1), leavesBlock, chance);
            editSession.setChanceBlockIfAir(basePos.add(1, i, 1), leavesBlock, chance);
            editSession.setChanceBlockIfAir(basePos.add(-1, i, 1), leavesBlock, chance);
            editSession.setChanceBlockIfAir(basePos.add(1, i, -1), leavesBlock, chance);
            editSession.setChanceBlockIfAir(basePos.add(-1, i, -1), leavesBlock, chance);
            if (i == 0 || i == height - 1) continue;
            for (j = -2; j <= 2; ++j) {
                editSession.setChanceBlockIfAir(basePos.add(-2, i, j), leavesBlock, 0.6);
            }
            for (j = -2; j <= 2; ++j) {
                editSession.setChanceBlockIfAir(basePos.add(2, i, j), leavesBlock, 0.6);
            }
            for (j = -2; j <= 2; ++j) {
                editSession.setChanceBlockIfAir(basePos.add(j, i, -2), leavesBlock, 0.6);
            }
            for (j = -2; j <= 2; ++j) {
                editSession.setChanceBlockIfAir(basePos.add(j, i, 2), leavesBlock, 0.6);
            }
        }
        editSession.setBlockIfAir(basePos.add(0, height, 0), leavesBlock);
    }

    public static TreeType lookup(String type) {
        return TreeType.lookup(type);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TreeType {
        TREE("Regular tree", new String[]{"tree", "regular"}),
        BIG_TREE("Big tree", new String[]{"big", "bigtree"}),
        REDWOOD("Redwood", new String[]{"redwood", "sequoia", "sequoioideae"}),
        TALL_REDWOOD("Tall redwood", new String[]{"tallredwood", "tallsequoia", "tallsequoioideae"}),
        BIRCH("Birch", new String[]{"birch", "white", "whitebark"}),
        PINE("Pine", new String[]{"pine"}),
        RANDOM_REDWOOD("Random redwood", new String[]{"randredwood", "randomredwood", "anyredwood"}),
        RANDOM("Random", new String[]{"rand", "random"});

        private static final Map<String, TreeType> lookup;
        private final String name;
        private final String[] lookupKeys;

        private TreeType(String name, String lookupKey) {
            this.name = name;
            this.lookupKeys = new String[]{lookupKey};
        }

        private TreeType(String name, String[] lookupKeys) {
            this.name = name;
            this.lookupKeys = lookupKeys;
        }

        public String getName() {
            return this.name;
        }

        public static TreeType lookup(String name) {
            return lookup.get(name.toLowerCase());
        }

        static {
            lookup = new HashMap<String, TreeType>();
            for (TreeType type : EnumSet.allOf(TreeType.class)) {
                for (String key : type.lookupKeys) {
                    lookup.put(key, type);
                }
            }
        }
    }
}

