/*
 * Decompiled with CFR 0.152.
 */
package net.TheDgtl.Stargate;

import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public class Blox {
    private int x;
    private int y;
    private int z;
    private World world;

    public Blox(World world, int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.world = world;
    }

    public Blox(Block block) {
        this.x = block.getX();
        this.y = block.getY();
        this.z = block.getZ();
        this.world = block.getWorld();
    }

    public Blox(Location location) {
        this.x = location.getBlockX();
        this.y = location.getBlockY();
        this.z = location.getBlockZ();
        this.world = location.getWorld();
    }

    public Blox(World world, String string) {
        String[] split = string.split(",");
        this.x = Integer.parseInt(split[0]);
        this.y = Integer.parseInt(split[1]);
        this.z = Integer.parseInt(split[2]);
        this.world = world;
    }

    public Blox makeRelative(int x, int y, int z) {
        return new Blox(this.world, this.x + x, this.y + y, this.z + z);
    }

    public Location makeRelativeLoc(double x, double y, double z, float rotX, float rotY) {
        return new Location(this.world, (double)this.x + x, (double)this.y + y, (double)this.z + z, rotX, rotY);
    }

    public Blox modRelative(int right, int depth, int distance, int modX, int modY, int modZ) {
        return this.makeRelative(-right * modX + distance * modZ, -depth * modY, -right * modZ + -distance * modX);
    }

    public Location modRelativeLoc(double right, double depth, double distance, float rotX, float rotY, int modX, int modY, int modZ) {
        return this.makeRelativeLoc(0.5 + -right * (double)modX + distance * (double)modZ, depth, 0.5 + -right * (double)modZ + -distance * (double)modX, rotX, 0.0f);
    }

    public void setType(int type) {
        this.world.getBlockAt(this.x, this.y, this.z).setTypeId(type);
    }

    public int getType() {
        return this.world.getBlockAt(this.x, this.y, this.z).getTypeId();
    }

    public void setData(int data) {
        this.world.getBlockAt(this.x, this.y, this.z).setData((byte)data);
    }

    public int getData() {
        return this.world.getBlockAt(this.x, this.y, this.z).getData();
    }

    public Block getBlock() {
        return this.world.getBlockAt(this.x, this.y, this.z);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public World getWorld() {
        return this.world;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.x);
        builder.append(',');
        builder.append(this.y);
        builder.append(',');
        builder.append(this.z);
        return builder.toString();
    }

    public int hashCode() {
        int result = 18;
        result = result * 27 + this.x;
        result = result * 27 + this.y;
        result = result * 27 + this.z;
        result = result * 27 + this.world.getName().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Blox blox = (Blox)obj;
        return this.x == blox.x && this.y == blox.y && this.z == blox.z && this.world.getName().equals(blox.world.getName());
    }
}

