/*
 * Decompiled with CFR 0.152.
 */
package net.TheDgtl.Stargate;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;
import java.util.logging.Level;
import net.TheDgtl.Stargate.Blox;
import net.TheDgtl.Stargate.RelativeBlockVector;
import net.TheDgtl.Stargate.Stargate;
import net.TheDgtl.Stargate.iConomyHandler;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class Gate {
    public static final int ANYTHING = -1;
    public static final int ENTRANCE = -2;
    public static final int CONTROL = -3;
    public static final int EXIT = -4;
    private static HashMap<String, Gate> gates = new HashMap();
    private static HashMap<Integer, ArrayList<Gate>> controlBlocks = new HashMap();
    private static HashSet<Integer> frameBlocks = new HashSet();
    private String filename;
    private Character[][] layout;
    private HashMap<Character, Integer> types;
    private HashMap<Character, Integer> metadata;
    private RelativeBlockVector[] entrances = new RelativeBlockVector[0];
    private RelativeBlockVector[] border = new RelativeBlockVector[0];
    private RelativeBlockVector[] controls = new RelativeBlockVector[0];
    private RelativeBlockVector exitBlock = null;
    private HashMap<RelativeBlockVector, Integer> exits = new HashMap();
    private int portalBlockOpen = Material.PORTAL.getId();
    private int portalBlockClosed = Material.AIR.getId();
    private int useCost = -1;
    private int createCost = -1;
    private int destroyCost = -1;
    private boolean toOwner = false;

    private Gate(String filename, Character[][] layout, HashMap<Character, Integer> types, HashMap<Character, Integer> metadata) {
        this.filename = filename;
        this.layout = layout;
        this.metadata = metadata;
        this.types = types;
        this.populateCoordinates();
    }

    private void populateCoordinates() {
        ArrayList<RelativeBlockVector> entranceList = new ArrayList<RelativeBlockVector>();
        ArrayList<RelativeBlockVector> borderList = new ArrayList<RelativeBlockVector>();
        ArrayList<RelativeBlockVector> controlList = new ArrayList<RelativeBlockVector>();
        RelativeBlockVector[] relativeExits = new RelativeBlockVector[this.layout[0].length];
        int[] exitDepths = new int[this.layout[0].length];
        RelativeBlockVector lastExit = null;
        int y = 0;
        while (y < this.layout.length) {
            int x = 0;
            while (x < this.layout[y].length) {
                Integer id = this.types.get(this.layout[y][x]);
                if (this.layout[y][x].charValue() == '-') {
                    controlList.add(new RelativeBlockVector(x, y, 0));
                }
                if (id == -2 || id == -4) {
                    entranceList.add(new RelativeBlockVector(x, y, 0));
                    exitDepths[x] = y;
                    if (id == -4) {
                        this.exitBlock = new RelativeBlockVector(x, y, 0);
                    }
                } else if (id != -1) {
                    borderList.add(new RelativeBlockVector(x, y, 0));
                }
                ++x;
            }
            ++y;
        }
        int x = 0;
        while (x < exitDepths.length) {
            relativeExits[x] = new RelativeBlockVector(x, exitDepths[x], 0);
            ++x;
        }
        x = relativeExits.length - 1;
        while (x >= 0) {
            if (relativeExits[x] != null) {
                lastExit = relativeExits[x];
            } else {
                relativeExits[x] = lastExit;
            }
            if (exitDepths[x] > 0) {
                this.exits.put(relativeExits[x], x);
            }
            --x;
        }
        this.entrances = entranceList.toArray(this.entrances);
        this.border = borderList.toArray(this.border);
        this.controls = controlList.toArray(this.controls);
    }

    public void save(String gateFolder) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(String.valueOf(gateFolder) + this.filename));
            this.writeConfig(bw, "portal-open", this.portalBlockOpen);
            this.writeConfig(bw, "portal-closed", this.portalBlockClosed);
            if (this.useCost != -1) {
                this.writeConfig(bw, "usecost", this.useCost);
            }
            if (this.createCost != -1) {
                this.writeConfig(bw, "createcost", this.createCost);
            }
            if (this.destroyCost != -1) {
                this.writeConfig(bw, "destroycost", this.destroyCost);
            }
            this.writeConfig(bw, "toowner", this.toOwner);
            for (Character type : this.types.keySet()) {
                Integer value = this.types.get(type);
                if (value < 0) continue;
                bw.append(type.charValue());
                bw.append('=');
                bw.append(value.toString());
                Integer mData = this.metadata.get(type);
                if (mData != null) {
                    bw.append(':');
                    bw.append(mData.toString());
                }
                bw.newLine();
            }
            bw.newLine();
            int y = 0;
            while (y < this.layout.length) {
                int x = 0;
                while (x < this.layout[y].length) {
                    Character symbol = this.layout[y][x];
                    bw.append(symbol.charValue());
                    ++x;
                }
                bw.newLine();
                ++y;
            }
            bw.close();
        }
        catch (IOException ex) {
            Stargate.log.log(Level.SEVERE, "Could not save Gate " + this.filename + " - " + ex.getMessage());
        }
    }

    private void writeConfig(BufferedWriter bw, String key, int value) throws IOException {
        bw.append(String.format("%s=%d", key, value));
        bw.newLine();
    }

    private void writeConfig(BufferedWriter bw, String key, boolean value) throws IOException {
        bw.append(String.format("%s=%b", key, value));
        bw.newLine();
    }

    public Character[][] getLayout() {
        return this.layout;
    }

    public RelativeBlockVector[] getEntrances() {
        return this.entrances;
    }

    public RelativeBlockVector[] getBorder() {
        return this.border;
    }

    public RelativeBlockVector[] getControls() {
        return this.controls;
    }

    public HashMap<RelativeBlockVector, Integer> getExits() {
        return this.exits;
    }

    public RelativeBlockVector getExit() {
        return this.exitBlock;
    }

    public int getControlBlock() {
        return this.types.get(Character.valueOf('-'));
    }

    public String getFilename() {
        return this.filename;
    }

    public int getPortalBlockOpen() {
        return this.portalBlockOpen;
    }

    public int getPortalBlockClosed() {
        return this.portalBlockClosed;
    }

    public int getUseCost() {
        if (this.useCost < 0) {
            return iConomyHandler.useCost;
        }
        return this.useCost;
    }

    public Integer getCreateCost() {
        if (this.createCost < 0) {
            return iConomyHandler.createCost;
        }
        return this.createCost;
    }

    public Integer getDestroyCost() {
        if (this.destroyCost < 0) {
            return iConomyHandler.destroyCost;
        }
        return this.destroyCost;
    }

    public Boolean getToOwner() {
        return this.toOwner;
    }

    public boolean matches(Block topleft, int modX, int modZ) {
        return this.matches(new Blox(topleft), modX, modZ);
    }

    public boolean matches(Blox topleft, int modX, int modZ) {
        int y = 0;
        while (y < this.layout.length) {
            int x = 0;
            while (x < this.layout[y].length) {
                int id = this.types.get(this.layout[y][x]);
                if (id == -2 || id == -4) {
                    int type = topleft.modRelative(x, y, 0, modX, 1, modZ).getType();
                    if (type != this.portalBlockClosed && type != this.portalBlockOpen) {
                        return false;
                    }
                } else if (id != -1) {
                    if (topleft.modRelative(x, y, 0, modX, 1, modZ).getType() != id) {
                        return false;
                    }
                    Integer mData = this.metadata.get(this.layout[y][x]);
                    if (mData != null && topleft.modRelative(x, y, 0, modX, 1, modZ).getData() != mData.intValue()) {
                        return false;
                    }
                }
                ++x;
            }
            ++y;
        }
        return true;
    }

    private static void registerGate(Gate gate) {
        gates.put(gate.getFilename(), gate);
        int blockID = gate.getControlBlock();
        if (!controlBlocks.containsKey(blockID)) {
            controlBlocks.put(blockID, new ArrayList());
        }
        controlBlocks.get(blockID).add(gate);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Gate loadGate(File file) {
        block17: {
            scanner = null;
            designing = false;
            design = new ArrayList<ArrayList<E>>();
            types = new HashMap<Character, Integer>();
            metadata = new HashMap<Character, Integer>();
            config = new HashMap<String, String>();
            cols = 0;
            types.put(Character.valueOf('.'), -2);
            types.put(Character.valueOf('*'), -4);
            types.put(Character.valueOf(' '), -1);
            scanner = new Scanner(file);
            while (scanner.hasNextLine()) {
                line = scanner.nextLine();
                if (!designing) ** GOTO lbl-1000
                row = new ArrayList<Character>();
                if (line.length() > cols) {
                    cols = line.length();
                }
                var13_19 = line.toCharArray();
                var12_17 = var13_19.length;
                var11_14 = 0;
                if (true) ** GOTO lbl57
lbl-1000:
                // 1 sources

                {
                    if (line.isEmpty() || !line.contains("=")) {
                        designing = true;
                        continue;
                    }
                    split = line.split("=");
                    key = split[0].trim();
                    value = split[1].trim();
                    if (key.length() == 1) {
                        symbol = Character.valueOf(key.charAt(0));
                        if (value.contains(":")) {
                            split = value.split(":");
                            value = split[0].trim();
                            mData = split[1].trim();
                            metadata.put(symbol, Integer.parseInt(mData));
                        }
                        id = Integer.parseInt(value);
                        types.put(symbol, id);
                        Gate.frameBlocks.add(id);
                        continue;
                    }
                    config.put(key, value);
                    continue;
                    do {
                        if ((symbol = Character.valueOf(var13_19[var11_14])).equals(Character.valueOf('?')) || !types.containsKey(symbol)) {
                            Stargate.log.log(Level.SEVERE, "Could not load Gate " + file.getName() + " - Unknown symbol '" + symbol + "' in diagram");
                            return null;
                        }
                        ** try [egrp 2[TRYBLOCK] [1 : 243->450)] { 
lbl54:
                        // 1 sources

                        row.add(symbol);
                        ++var11_14;
lbl57:
                        // 2 sources

                    } while (var11_14 < var12_17);
                    design.add(row);
                }
            }
            break block17;
lbl-1000:
            // 2 sources

            {
                catch (Exception ex) {
                    Stargate.log.log(Level.SEVERE, "Could not load Gate " + file.getName() + " - Invalid block ID given");
                    return null;
                    break;
                }
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        layout = new Character[design.size()][cols];
        y = 0;
        while (y < design.size()) {
            row = (ArrayList)design.get(y);
            result = new Character[cols];
            x = 0;
            while (x < cols) {
                result[x] = x < row.size() ? (Character)row.get(x) : Character.valueOf(' ');
                ++x;
            }
            layout[y] = result;
            ++y;
        }
        gate = new Gate(file.getName(), layout, types, metadata);
        gate.portalBlockOpen = Gate.readConfig(config, gate, file, "portal-open", gate.portalBlockOpen);
        gate.portalBlockClosed = Gate.readConfig(config, gate, file, "portal-closed", gate.portalBlockClosed);
        gate.useCost = Gate.readConfig(config, gate, file, "usecost", -1);
        gate.destroyCost = Gate.readConfig(config, gate, file, "destroycost", -1);
        gate.createCost = Gate.readConfig(config, gate, file, "createcost", -1);
        v0 = gate.toOwner = config.containsKey("toowner") != false ? Boolean.valueOf(config.get("toowner")) : iConomyHandler.toOwner;
        if (gate.getControls().length != 2) {
            Stargate.log.log(Level.SEVERE, "Could not load Gate " + file.getName() + " - Gates must have exactly 2 control points.");
            return null;
        }
        gate.save(String.valueOf(file.getParent()) + "/");
        return gate;
    }

    private static int readConfig(HashMap<String, String> config, Gate gate, File file, String key, int def) {
        if (config.containsKey(key)) {
            try {
                return Integer.parseInt(config.get(key));
            }
            catch (NumberFormatException ex) {
                Stargate.log.log(Level.WARNING, String.format("%s reading %s: %s is not numeric", ex.getClass().getName(), file, key));
            }
        }
        return def;
    }

    public static void loadGates(String gateFolder) {
        File dir = new File(gateFolder);
        File[] files = dir.exists() ? dir.listFiles(new StargateFilenameFilter()) : new File[]{};
        if (files.length == 0) {
            dir.mkdir();
            Gate.populateDefaults(gateFolder);
        } else {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                Gate gate = Gate.loadGate(file);
                if (gate != null) {
                    Gate.registerGate(gate);
                }
                ++n2;
            }
        }
    }

    public static void populateDefaults(String gateFolder) {
        int Obsidian = Material.OBSIDIAN.getId();
        Character[][] layout = new Character[][]{{Character.valueOf(' '), Character.valueOf('X'), Character.valueOf('X'), Character.valueOf(' ')}, {Character.valueOf('X'), Character.valueOf('.'), Character.valueOf('.'), Character.valueOf('X')}, {Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('.'), Character.valueOf('-')}, {Character.valueOf('X'), Character.valueOf('*'), Character.valueOf('.'), Character.valueOf('X')}, {Character.valueOf(' '), Character.valueOf('X'), Character.valueOf('X'), Character.valueOf(' ')}};
        HashMap<Character, Integer> types = new HashMap<Character, Integer>();
        types.put(Character.valueOf('.'), -2);
        types.put(Character.valueOf('*'), -4);
        types.put(Character.valueOf(' '), -1);
        types.put(Character.valueOf('X'), Obsidian);
        types.put(Character.valueOf('-'), Obsidian);
        HashMap<Character, Integer> metadata = new HashMap<Character, Integer>();
        Gate gate = new Gate("nethergate.gate", layout, types, metadata);
        gate.save(gateFolder);
        Gate.registerGate(gate);
    }

    public static Gate[] getGatesByControlBlock(Block block) {
        return Gate.getGatesByControlBlock(block.getTypeId());
    }

    public static Gate[] getGatesByControlBlock(int type) {
        Gate[] result = new Gate[]{};
        ArrayList<Gate> lookup = controlBlocks.get(type);
        if (lookup != null) {
            result = lookup.toArray(result);
        }
        return result;
    }

    public static Gate getGateByName(String name) {
        return gates.get(name);
    }

    public static int getGateCount() {
        return gates.size();
    }

    public static boolean isGateBlock(int type) {
        return frameBlocks.contains(type);
    }

    public static void clearGates() {
        gates.clear();
        controlBlocks.clear();
        frameBlocks.clear();
    }

    static class StargateFilenameFilter
    implements FilenameFilter {
        StargateFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".gate");
        }
    }
}

