/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.Cart;

import com.gemo.FalseBook.Cart.FalseBookCartCore;
import com.gemo.utils.FlatFile;
import java.io.File;
import java.io.IOException;

public class CartWorldSettings {
    private FlatFile config;
    private double maxSpeed = 0.7;
    private double launchSpeed = 3.0;
    private double constantSpeed = 0.2;
    private boolean doFrictionFix = true;
    private boolean setSlowWhenEmpty = false;
    private int BoosterBlock2x = 14;
    private int BoosterBlock8x = 41;
    private int ConstantSpeedBlock = 42;
    private int StationBlock = 49;
    private int EjectBlock = 16;
    private int BrakeBlock25x = 13;
    private int BrakeBlock50x = 88;
    private int ReverseBlock = 7;
    private int CollectDepositBlock = 15;
    private int SortBlock = 87;
    private int EmitterBlock = 21;
    private int BoosterBlock2xValue = 0;
    private int BoosterBlock8xValue = 0;
    private int ConstantSpeedBlockValue = 0;
    private int StationBlockValue = 0;
    private int EjectBlockValue = 0;
    private int BrakeBlock25xValue = 0;
    private int BrakeBlock50xValue = 0;
    private int ReverseBlockValue = 0;
    private int CollectDepositBlockValue = 0;
    private int SortBlockValue = 0;
    private int EmitterBlockValue = 0;
    private boolean useSimpleCartSystem = false;
    private boolean removeCartOnExit = false;
    private boolean killCartsOnCollision = false;

    public CartWorldSettings(String FileName, String worldName) {
        this.loadSettings(FileName, worldName);
    }

    public FlatFile getConfig() {
        return this.config;
    }

    public void setConfig(FlatFile config) {
        this.config = config;
    }

    public boolean saveSettings(String FileName, String worldName) {
        File folder = new File("plugins/FalseBook");
        folder.mkdirs();
        folder = new File("plugins/FalseBook/" + worldName);
        folder.mkdirs();
        try {
            this.config = new FlatFile("FalseBook/" + worldName + "/" + FileName, false);
            this.config.setInt("BoosterBlock2x", this.BoosterBlock2x);
            this.config.setInt("BoosterBlock2xValue", this.BoosterBlock2xValue);
            this.config.setInt("BoosterBlock8x", this.BoosterBlock8x);
            this.config.setInt("BoosterBlock8xValue", this.BoosterBlock8xValue);
            this.config.setInt("ConstantSpeedBlock", this.ConstantSpeedBlock);
            this.config.setInt("ConstantSpeedBlockValue", this.ConstantSpeedBlockValue);
            this.config.setInt("StationBlock", this.StationBlock);
            this.config.setInt("StationBlockValue", this.StationBlockValue);
            this.config.setInt("EjectBlock", this.EjectBlock);
            this.config.setInt("EjectBlockValue", this.EjectBlockValue);
            this.config.setInt("BrakeBlock25x", this.BrakeBlock25x);
            this.config.setInt("BrakeBlock25xValue", this.BrakeBlock25xValue);
            this.config.setInt("BrakeBlock50x", this.BrakeBlock50x);
            this.config.setInt("BrakeBlock50xValue", this.BrakeBlock50xValue);
            this.config.setInt("ReverseBlock", this.ReverseBlock);
            this.config.setInt("ReverseBlockValue", this.ReverseBlockValue);
            this.config.setInt("CollectDepositBlock", this.CollectDepositBlock);
            this.config.setInt("CollectDepositBlockValue", this.CollectDepositBlockValue);
            this.config.setInt("SortBlock", this.SortBlock);
            this.config.setInt("SortBlockValue", this.SortBlockValue);
            this.config.setInt("EmitterBlock", this.EmitterBlock);
            this.config.setInt("EmitterBlockValue", this.EmitterBlockValue);
            this.config.setDouble("maxSpeed", this.maxSpeed);
            this.config.setDouble("launchSpeed", this.launchSpeed);
            this.config.setDouble("constantSpeed", this.constantSpeed);
            this.config.setBoolean("doFrictionFix", this.doFrictionFix);
            this.config.setBoolean("setSlowWhenEmpty", this.setSlowWhenEmpty);
            this.config.setBoolean("useSimpleCartSystem", this.useSimpleCartSystem);
            this.config.setBoolean("removeCartOnExit", this.removeCartOnExit);
            this.config.setBoolean("killCartsOnCollision", this.killCartsOnCollision);
            this.config.writeFile();
            return true;
        }
        catch (IOException e) {
            FalseBookCartCore.printInConsole("Error while saving file: plugins/FalseBook/" + worldName + "/" + FileName);
            e.printStackTrace();
            return false;
        }
    }

    public boolean loadSettings(String FileName, String worldName) {
        File folder = new File("plugins/FalseBook");
        folder.mkdirs();
        folder = new File("plugins/FalseBook/" + worldName);
        folder.mkdirs();
        try {
            this.config = new FlatFile("FalseBook/" + worldName + "/" + FileName, false);
            if (this.config.readFile()) {
                this.BoosterBlock2x = this.config.getInt("BoosterBlock2x", this.BoosterBlock2x);
                this.BoosterBlock8x = this.config.getInt("BoosterBlock8x", this.BoosterBlock8x);
                this.ConstantSpeedBlock = this.config.getInt("ConstantSpeedBlock", this.ConstantSpeedBlock);
                this.StationBlock = this.config.getInt("StationBlock", this.StationBlock);
                this.EjectBlock = this.config.getInt("EjectBlock", this.EjectBlock);
                this.BrakeBlock25x = this.config.getInt("BrakeBlock25x", this.BrakeBlock25x);
                this.BrakeBlock50x = this.config.getInt("BrakeBlock50x", this.BrakeBlock50x);
                this.ReverseBlock = this.config.getInt("ReverseBlock", this.ReverseBlock);
                this.CollectDepositBlock = this.config.getInt("CollectDepositBlock", this.CollectDepositBlock);
                this.SortBlock = this.config.getInt("SortBlock", this.SortBlock);
                this.EmitterBlock = this.config.getInt("EmitterBlock", this.EmitterBlock);
                this.BoosterBlock2xValue = this.config.getInt("BoosterBlock2xValue", this.BoosterBlock2xValue);
                this.BoosterBlock8xValue = this.config.getInt("BoosterBlock8xValue", this.BoosterBlock8xValue);
                this.ConstantSpeedBlockValue = this.config.getInt("ConstantSpeedBlockValue", this.ConstantSpeedBlockValue);
                this.StationBlockValue = this.config.getInt("StationBlockValue", this.StationBlockValue);
                this.EjectBlockValue = this.config.getInt("EjectBlockValue", this.EjectBlockValue);
                this.BrakeBlock25xValue = this.config.getInt("BrakeBlock25xValue", this.BrakeBlock25xValue);
                this.BrakeBlock50xValue = this.config.getInt("BrakeBlock50xValue", this.BrakeBlock50xValue);
                this.ReverseBlockValue = this.config.getInt("ReverseBlockValue", this.ReverseBlockValue);
                this.CollectDepositBlockValue = this.config.getInt("CollectDepositBlockValue", this.CollectDepositBlockValue);
                this.SortBlockValue = this.config.getInt("SortBlockValue", this.SortBlockValue);
                this.EmitterBlockValue = this.config.getInt("EmitterBlockValue", this.EmitterBlockValue);
                this.maxSpeed = this.config.getDouble("maxSpeed", this.maxSpeed);
                this.launchSpeed = this.config.getDouble("launchSpeed", this.launchSpeed);
                this.constantSpeed = this.config.getDouble("constantSpeed", this.constantSpeed);
                this.doFrictionFix = this.config.getBoolean("doFrictionFix", this.doFrictionFix);
                this.setSlowWhenEmpty = this.config.getBoolean("setSlowWhenEmpty", this.setSlowWhenEmpty);
                this.useSimpleCartSystem = this.config.getBoolean("useSimpleCartSystem", this.useSimpleCartSystem);
                this.removeCartOnExit = this.config.getBoolean("removeCartOnExit", this.removeCartOnExit);
                this.killCartsOnCollision = this.config.getBoolean("killCartsOnCollision", this.killCartsOnCollision);
                this.saveSettings(FileName, worldName);
            } else {
                this.saveSettings(FileName, worldName);
            }
            return true;
        }
        catch (Exception e) {
            try {
                FalseBookCartCore.printInConsole("Error while reading file: plugins/FalseBook/" + worldName + "/" + FileName);
                this.config.regenerateFile("FalseBook/" + worldName + "/" + FileName);
                this.saveSettings(FileName, worldName);
                FalseBookCartCore.printInConsole("recreated file: plugins/FalseBook/" + worldName + "/" + FileName);
                return true;
            }
            catch (IOException e1) {
                FalseBookCartCore.printInConsole("Error while reading file: plugins/FalseBook/" + worldName + "/" + FileName);
                return false;
            }
        }
    }

    public double getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(double maxSpeed) {
        this.maxSpeed = maxSpeed;
    }

    public double getLaunchSpeed() {
        return this.launchSpeed;
    }

    public void setLaunchSpeed(double launchSpeed) {
        this.launchSpeed = launchSpeed;
    }

    public double getConstantSpeed() {
        return this.constantSpeed;
    }

    public void setConstantSpeed(double constantSpeed) {
        this.constantSpeed = constantSpeed;
    }

    public boolean isDoFrictionFix() {
        return this.doFrictionFix;
    }

    public void setDoFrictionFix(boolean doFrictionFix) {
        this.doFrictionFix = doFrictionFix;
    }

    public boolean isSetSlowWhenEmpty() {
        return this.setSlowWhenEmpty;
    }

    public void setSetSlowWhenEmpty(boolean setSlowWhenEmpty) {
        this.setSlowWhenEmpty = setSlowWhenEmpty;
    }

    public int getBoosterBlock2x() {
        return this.BoosterBlock2x;
    }

    public void setBoosterBlock2x(int boosterBlock2x) {
        this.BoosterBlock2x = boosterBlock2x;
    }

    public int getBoosterBlock8x() {
        return this.BoosterBlock8x;
    }

    public void setBoosterBlock8x(int boosterBlock8x) {
        this.BoosterBlock8x = boosterBlock8x;
    }

    public int getConstantSpeedBlock() {
        return this.ConstantSpeedBlock;
    }

    public void setConstantSpeedBlock(int constantSpeedBlock) {
        this.ConstantSpeedBlock = constantSpeedBlock;
    }

    public int getStationBlock() {
        return this.StationBlock;
    }

    public void setStationBlock(int stationBlock) {
        this.StationBlock = stationBlock;
    }

    public int getEjectBlock() {
        return this.EjectBlock;
    }

    public void setEjectBlock(int ejectBlock) {
        this.EjectBlock = ejectBlock;
    }

    public int getBrakeBlock25x() {
        return this.BrakeBlock25x;
    }

    public void setBrakeBlock25x(int brakeBlock25x) {
        this.BrakeBlock25x = brakeBlock25x;
    }

    public int getBrakeBlock50x() {
        return this.BrakeBlock50x;
    }

    public void setBrakeBlock50x(int brakeBlock50x) {
        this.BrakeBlock50x = brakeBlock50x;
    }

    public int getReverseBlock() {
        return this.ReverseBlock;
    }

    public void setReverseBlock(int reverseBlock) {
        this.ReverseBlock = reverseBlock;
    }

    public int getCollectDepositBlock() {
        return this.CollectDepositBlock;
    }

    public void setCollectDepositBlock(int collectDepositBlock) {
        this.CollectDepositBlock = collectDepositBlock;
    }

    public int getSortBlock() {
        return this.SortBlock;
    }

    public void setSortBlock(int sortBlock) {
        this.SortBlock = sortBlock;
    }

    public int getEmitterBlock() {
        return this.EmitterBlock;
    }

    public void setEmitterBlock(int emitterBlock) {
        this.EmitterBlock = emitterBlock;
    }

    public int getBoosterBlock2xValue() {
        return this.BoosterBlock2xValue;
    }

    public void setBoosterBlock2xValue(int boosterBlock2xValue) {
        this.BoosterBlock2xValue = boosterBlock2xValue;
    }

    public int getBoosterBlock8xValue() {
        return this.BoosterBlock8xValue;
    }

    public void setBoosterBlock8xValue(int boosterBlock8xValue) {
        this.BoosterBlock8xValue = boosterBlock8xValue;
    }

    public int getConstantSpeedBlockValue() {
        return this.ConstantSpeedBlockValue;
    }

    public void setConstantSpeedBlockValue(int constantSpeedBlockValue) {
        this.ConstantSpeedBlockValue = constantSpeedBlockValue;
    }

    public int getStationBlockValue() {
        return this.StationBlockValue;
    }

    public void setStationBlockValue(int stationBlockValue) {
        this.StationBlockValue = stationBlockValue;
    }

    public int getEjectBlockValue() {
        return this.EjectBlockValue;
    }

    public void setEjectBlockValue(int ejectBlockValue) {
        this.EjectBlockValue = ejectBlockValue;
    }

    public int getBrakeBlock25xValue() {
        return this.BrakeBlock25xValue;
    }

    public void setBrakeBlock25xValue(int brakeBlock25xValue) {
        this.BrakeBlock25xValue = brakeBlock25xValue;
    }

    public int getBrakeBlock50xValue() {
        return this.BrakeBlock50xValue;
    }

    public void setBrakeBlock50xValue(int brakeBlock50xValue) {
        this.BrakeBlock50xValue = brakeBlock50xValue;
    }

    public int getReverseBlockValue() {
        return this.ReverseBlockValue;
    }

    public void setReverseBlockValue(int reverseBlockValue) {
        this.ReverseBlockValue = reverseBlockValue;
    }

    public int getCollectDepositBlockValue() {
        return this.CollectDepositBlockValue;
    }

    public void setCollectDepositBlockValue(int collectDepositBlockValue) {
        this.CollectDepositBlockValue = collectDepositBlockValue;
    }

    public int getSortBlockValue() {
        return this.SortBlockValue;
    }

    public void setSortBlockValue(int sortBlockValue) {
        this.SortBlockValue = sortBlockValue;
    }

    public int getEmitterBlockValue() {
        return this.EmitterBlockValue;
    }

    public void setEmitterBlockValue(int emitterBlockValue) {
        this.EmitterBlockValue = emitterBlockValue;
    }

    public boolean isUseSimpleCartSystem() {
        return this.useSimpleCartSystem;
    }

    public void setUseSimpleCartSystem(boolean useSimpleCartSystem) {
        this.useSimpleCartSystem = useSimpleCartSystem;
    }

    public boolean isRemoveCartOnExit() {
        return this.removeCartOnExit;
    }

    public void setRemoveCartOnExit(boolean removeCartOnExit) {
        this.removeCartOnExit = removeCartOnExit;
    }

    public void setKillCartsOnCollision(boolean killCartsOnCollision) {
        this.killCartsOnCollision = killCartsOnCollision;
    }

    public boolean isKillCartsOnCollision() {
        return this.killCartsOnCollision;
    }
}

