/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.Cart;

import com.gemo.FalseBook.Cart.Blocks.Launcher;
import com.gemo.FalseBook.Cart.Blocks.Sort;
import com.gemo.FalseBook.Cart.CartWorldSettings;
import com.gemo.FalseBook.Cart.FalseBookCartCore;
import com.gemo.utils.UtilPermissions;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.PoweredMinecart;
import org.bukkit.entity.StorageMinecart;
import org.bukkit.event.block.BlockListener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.ItemStack;

public class FalseBookCartBlockListener
extends BlockListener {
    public static FalseBookCartCore plugin;

    public FalseBookCartBlockListener(FalseBookCartCore instance) {
        plugin = instance;
    }

    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Block under = block.getRelative(0, -1, 0);
        byte newData = 0;
        if (under.getTypeId() == Material.WOOL.getId() || under.getTypeId() == Material.LOG.getId() || under.getTypeId() == Material.LEAVES.getId() || under.getTypeId() == Material.STEP.getId()) {
            newData = under.getData();
        }
        if (block.getTypeId() == Material.RAILS.getId() || block.getTypeId() == Material.DETECTOR_RAIL.getId() || block.getTypeId() == Material.POWERED_RAIL.getId()) {
            CartWorldSettings thisSettings;
            if (!FalseBookCartCore.getSettings().containsKey(block.getWorld().getName())) {
                FalseBookCartCore.getSettings().put(block.getWorld().getName(), new CartWorldSettings("FalseBookCart.properties", block.getWorld().getName()));
            }
            if (newData == (thisSettings = FalseBookCartCore.getSettings().get(block.getWorld().getName())).getBoosterBlock2xValue() && under.getTypeId() == thisSettings.getBoosterBlock2x()) {
                if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.cart.booster2x")) {
                    FalseBookCartBlockListener.cancelCreation(event, "You are not allowed to build Booster2x-Blocks.");
                    return;
                }
                player.sendMessage(ChatColor.GOLD + "2x BoosterBlock created.");
            } else if (newData == thisSettings.getBoosterBlock8xValue() && under.getTypeId() == thisSettings.getBoosterBlock8x()) {
                if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.cart.booster8x")) {
                    FalseBookCartBlockListener.cancelCreation(event, "You are not allowed to build Booster8x-Blocks.");
                    return;
                }
                player.sendMessage(ChatColor.GOLD + "8x BoosterBlock created.");
            } else if (newData == thisSettings.getBrakeBlock25xValue() && under.getTypeId() == thisSettings.getBrakeBlock25x()) {
                if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.cart.brake25x")) {
                    FalseBookCartBlockListener.cancelCreation(event, "You are not allowed to build Brake25x-Blocks.");
                    return;
                }
                player.sendMessage(ChatColor.GOLD + "25x BrakeBlock created.");
            } else if (newData == thisSettings.getBrakeBlock50xValue() && under.getTypeId() == thisSettings.getBrakeBlock50x()) {
                if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.cart.brake50x")) {
                    FalseBookCartBlockListener.cancelCreation(event, "You are not allowed to build Brake50x-Blocks.");
                    return;
                }
                player.sendMessage(ChatColor.GOLD + "50x BrakeBlock created.");
            } else if (newData == thisSettings.getConstantSpeedBlockValue() && under.getTypeId() == thisSettings.getConstantSpeedBlock()) {
                if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.cart.constantspeed")) {
                    FalseBookCartBlockListener.cancelCreation(event, "You are not allowed to build ConstantSpeed-Blocks.");
                    return;
                }
                player.sendMessage(ChatColor.GOLD + "ConstantSpeedBlock created.");
            } else if (newData == thisSettings.getEjectBlockValue() && under.getTypeId() == thisSettings.getEjectBlock()) {
                if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.cart.eject")) {
                    FalseBookCartBlockListener.cancelCreation(event, "You are not allowed to build Eject-Blocks.");
                    return;
                }
                player.sendMessage(ChatColor.GOLD + "EjectBlock created.");
            } else if (newData == thisSettings.getReverseBlockValue() && under.getTypeId() == thisSettings.getReverseBlock()) {
                if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.cart.reverse")) {
                    FalseBookCartBlockListener.cancelCreation(event, "You are not allowed to build Reverse-Blocks.");
                    return;
                }
                player.sendMessage(ChatColor.GOLD + "ReverseBlock created.");
            } else if (newData == thisSettings.getStationBlockValue() && under.getTypeId() == thisSettings.getStationBlock()) {
                if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.cart.station")) {
                    FalseBookCartBlockListener.cancelCreation(event, "You are not allowed to build Station-Blocks.");
                    return;
                }
                player.sendMessage(ChatColor.GOLD + "StationBlock created.");
                player.sendMessage(ChatColor.GRAY + "Wire it up and place a station sign under it.");
            } else if (newData == thisSettings.getCollectDepositBlockValue() && under.getTypeId() == thisSettings.getCollectDepositBlock()) {
                if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.cart.collectanddeposit")) {
                    FalseBookCartBlockListener.cancelCreation(event, "You are not allowed to build Collect/Deposit-Blocks.");
                    return;
                }
                player.sendMessage(ChatColor.GOLD + "Collect/Deposit-Block created.");
                player.sendMessage(ChatColor.GRAY + "Place a sign with the ID on the 3rd line under it.");
            } else if (newData == thisSettings.getSortBlockValue() && under.getTypeId() == thisSettings.getSortBlock()) {
                if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.cart.sort")) {
                    FalseBookCartBlockListener.cancelCreation(event, "You are not allowed to build Sort-Blocks.");
                    return;
                }
                player.sendMessage(ChatColor.GOLD + "Sort-Block created.");
                player.sendMessage(ChatColor.GRAY + "Place a sign with the Sort-Criteria under it.");
            } else if (newData == thisSettings.getEmitterBlockValue() && under.getTypeId() == thisSettings.getEmitterBlock()) {
                if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.cart.emitter")) {
                    FalseBookCartBlockListener.cancelCreation(event, "You are not allowed to build Emitter-Blocks.");
                    return;
                }
                player.sendMessage(ChatColor.GOLD + "Emitter-Block created.");
                player.sendMessage(ChatColor.GRAY + "Place a sign with [Print] in Line 1 and the message under it.");
            } else {
                return;
            }
        }
    }

    public void onSignChange(SignChangeEvent event) {
        Player player = event.getPlayer();
        if (event.getLine(1).equalsIgnoreCase("[Station]")) {
            if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.cart.station")) {
                FalseBookCartBlockListener.cancelCreation(event, "You are not allowed to build stationsigns.");
                return;
            }
            if (event.getBlock().getData() != 0 && event.getBlock().getData() != 4 && event.getBlock().getData() != 8 && event.getBlock().getData() != 12) {
                event.setCancelled(true);
                event.getBlock().setTypeId(0);
                ItemStack item = new ItemStack(Material.SIGN, 1);
                player.getInventory().addItem(new ItemStack[]{item});
                player.sendMessage(ChatColor.RED + "Station signs may only be created at specific angles (90 degrees).");
                return;
            }
            event.setLine(1, "[Station]");
            player.sendMessage(ChatColor.GOLD + "Stationsign created.");
        } else if (event.getLine(1).equalsIgnoreCase("[Deposit]")) {
            if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.cart.collectanddeposit")) {
                FalseBookCartBlockListener.cancelCreation(event, "You are not allowed to build depositsigns.");
                return;
            }
            event.setLine(1, "[Deposit]");
            player.sendMessage(ChatColor.GOLD + "Depositsign created.");
        } else if (event.getLine(1).equalsIgnoreCase("[Collect]")) {
            if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.cart.collectanddeposit")) {
                FalseBookCartBlockListener.cancelCreation(event, "You are not allowed to build collectorsigns.");
                return;
            }
            event.setLine(1, "[Collect]");
            player.sendMessage(ChatColor.GOLD + "Collectsign created.");
        } else if (event.getLine(1).equalsIgnoreCase("[Eject]")) {
            if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.cart.eject")) {
                FalseBookCartBlockListener.cancelCreation(event, "You are not allowed to build ejectsigns.");
                return;
            }
            event.setLine(1, "[Eject]");
            player.sendMessage(ChatColor.GOLD + "Ejectsign created.");
        } else if (event.getLine(1).equalsIgnoreCase("[Sort]")) {
            if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.cart.sort")) {
                FalseBookCartBlockListener.cancelCreation(event, "You are not allowed to build sortsigns.");
                return;
            }
            if (Sort.getSortCommand(event.getLine(2)) < 0 && Sort.getSortCommand(event.getLine(3)) < 0) {
                FalseBookCartBlockListener.cancelCreation(event, "Sort-Criteria not found.");
                return;
            }
            event.setLine(1, "[Sort]");
            player.sendMessage(ChatColor.GOLD + "Sortsign created.");
        } else if (event.getLine(0).equalsIgnoreCase("[Print]")) {
            if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.cart.emitter")) {
                FalseBookCartBlockListener.cancelCreation(event, "You are not allowed to build emittersigns.");
                return;
            }
            event.setLine(0, "[Print]");
            player.sendMessage(ChatColor.GOLD + "Emittersign created.");
        }
    }

    public static void cancelCreation(SignChangeEvent event, String reason) {
        event.setCancelled(true);
        event.getBlock().setType(Material.AIR);
        ItemStack item = new ItemStack(Material.SIGN, 1);
        event.getPlayer().getInventory().addItem(new ItemStack[]{item});
        event.getPlayer().sendMessage(ChatColor.RED + reason);
    }

    public static void cancelCreation(BlockPlaceEvent event, String reason) {
        event.setCancelled(true);
        event.getBlock().setType(Material.AIR);
        ItemStack item = new ItemStack(Material.SIGN, 1);
        event.getPlayer().getInventory().addItem(new ItemStack[]{item});
        event.getPlayer().sendMessage(ChatColor.RED + reason);
    }

    public void onBlockRedstoneChange(BlockRedstoneEvent event) {
        if (event.getNewCurrent() == event.getOldCurrent()) {
            return;
        }
        Block block = event.getBlock();
        Location loc = block.getLocation();
        loc.setY(loc.getY() + 1.0);
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        if (!FalseBookCartCore.getSettings().containsKey(block.getWorld().getName())) {
            FalseBookCartCore.getSettings().put(block.getWorld().getName(), new CartWorldSettings("FalseBookCart.properties", block.getWorld().getName()));
        }
        CartWorldSettings thisSettings = FalseBookCartCore.getSettings().get(block.getWorld().getName());
        if (block.getWorld().getBlockAt(x + 1, y, z).getType().getId() == thisSettings.getStationBlock() && block.getWorld().getBlockAt(x + 1, y, z).getData() == thisSettings.getStationBlockValue() || block.getWorld().getBlockAt(x + 1, y, z).getType().equals((Object)Material.RAILS)) {
            this.launcherEvent(block.getWorld(), x + 1, y, z, event);
        }
        if (block.getWorld().getBlockAt(x - 1, y, z).getType().getId() == thisSettings.getStationBlock() && block.getWorld().getBlockAt(x - 1, y, z).getData() == thisSettings.getStationBlockValue() || block.getWorld().getBlockAt(x - 1, y, z).getType().equals((Object)Material.RAILS)) {
            this.launcherEvent(block.getWorld(), x - 1, y, z, event);
        }
        if (block.getWorld().getBlockAt(x, y, z + 1).getType().getId() == thisSettings.getStationBlock() && block.getWorld().getBlockAt(x, y, z + 1).getData() == thisSettings.getStationBlockValue() || block.getWorld().getBlockAt(x, y, z + 1).getType().equals((Object)Material.RAILS)) {
            this.launcherEvent(block.getWorld(), x, y, z + 1, event);
        }
        if (block.getWorld().getBlockAt(x, y, z - 1).getType().getId() == thisSettings.getStationBlock() && block.getWorld().getBlockAt(x, y, z - 1).getData() == thisSettings.getStationBlockValue() || block.getWorld().getBlockAt(x, y, z - 1).getType().equals((Object)Material.RAILS)) {
            this.launcherEvent(block.getWorld(), x, y, z - 1, event);
        }
        if (block.getWorld().getBlockAt(x, y + 1, z).getType().getId() == thisSettings.getStationBlock() && block.getWorld().getBlockAt(x, y + 1, z).getData() == thisSettings.getStationBlockValue() || block.getWorld().getBlockAt(x, y + 1, z).getType().equals((Object)Material.RAILS)) {
            this.launcherEvent(block.getWorld(), x, y + 1, z, event);
        }
        if (block.getWorld().getBlockAt(x + 1, y, z).getType().equals((Object)Material.CHEST)) {
            this.cartDepositEvent(block.getWorld(), x + 1, y, z, event);
        }
        if (block.getWorld().getBlockAt(x - 1, y, z).getType().equals((Object)Material.CHEST)) {
            this.cartDepositEvent(block.getWorld(), x - 1, y, z, event);
        }
        if (block.getWorld().getBlockAt(x, y, z + 1).getType().equals((Object)Material.CHEST)) {
            this.cartDepositEvent(block.getWorld(), x, y, z + 1, event);
        }
        if (block.getWorld().getBlockAt(x, y, z - 1).getType().equals((Object)Material.CHEST)) {
            this.cartDepositEvent(block.getWorld(), x, y, z - 1, event);
        }
    }

    public void cartDepositEvent(World w, int x, int y, int z, BlockRedstoneEvent event) {
        if (event.getNewCurrent() == 0) {
            return;
        }
        Block block = w.getBlockAt(x, y, z);
        Block underBlock = w.getBlockAt(x, y - 1, z);
        Block signBlock = w.getBlockAt(x, y - 2, z);
        if (!FalseBookCartCore.getSettings().containsKey(block.getWorld().getName())) {
            FalseBookCartCore.getSettings().put(block.getWorld().getName(), new CartWorldSettings("FalseBookCart.properties", block.getWorld().getName()));
        }
        CartWorldSettings thisSettings = FalseBookCartCore.getSettings().get(block.getWorld().getName());
        if (underBlock.getTypeId() == thisSettings.getCollectDepositBlock() && underBlock.getData() == thisSettings.getCollectDepositBlockValue() && signBlock.getType().equals((Object)Material.SIGN_POST)) {
            Sign sign = (Sign)signBlock.getState();
            if (!(sign.getLine(1).equalsIgnoreCase("[Cart]") || sign.getLine(1).equalsIgnoreCase("[PoweredCart]") || sign.getLine(1).equalsIgnoreCase("[StorageCart]"))) {
                return;
            }
            int type = 328;
            if (sign.getLine(1).equalsIgnoreCase("[StorageCart]")) {
                type = 342;
            }
            if (sign.getLine(1).equalsIgnoreCase("[PoweredCart]")) {
                type = 343;
            }
            int newZ = 0;
            int newX = 0;
            if (sign.getRawData() == 0) {
                newZ = -2;
            } else if (sign.getRawData() == 4) {
                newX = 2;
            } else if (sign.getRawData() == 8) {
                newZ = 2;
            } else if (sign.getRawData() == 12) {
                newX = -2;
            } else {
                return;
            }
            Location loc = new Location(w, (double)(x + newX) + 0.5, (double)y + 0.5, (double)(z + newZ) + 0.5);
            if (!(loc.getBlock().getType().equals((Object)Material.RAILS) || loc.getBlock().getType().equals((Object)Material.POWERED_RAIL) || loc.getBlock().getType().equals((Object)Material.DETECTOR_RAIL))) {
                return;
            }
            Chest chest = (Chest)block.getState();
            int cartAmount = 0;
            ArrayList<ItemStack> otherItems = new ArrayList<ItemStack>();
            int i = 0;
            while (i < chest.getInventory().getSize()) {
                if (chest.getInventory().getItem(i).getTypeId() == type) {
                    cartAmount += chest.getInventory().getItem(i).getAmount();
                } else if (chest.getInventory().getItem(i).getTypeId() > 0) {
                    otherItems.add(chest.getInventory().getItem(i));
                }
                ++i;
            }
            if (cartAmount == 0) {
                return;
            }
            chest.getInventory().clear();
            i = 0;
            while (i < otherItems.size()) {
                chest.getInventory().addItem(new ItemStack[]{(ItemStack)otherItems.get(i)});
                ++i;
            }
            ItemStack newCarts = null;
            newCarts = new ItemStack(Material.MINECART, cartAmount - 1);
            if (type == 342) {
                newCarts = new ItemStack(Material.STORAGE_MINECART, cartAmount - 1);
            } else if (type == 343) {
                newCarts = new ItemStack(Material.POWERED_MINECART, cartAmount - 1);
            }
            if (cartAmount - 1 > 0) {
                chest.getInventory().addItem(new ItemStack[]{newCarts});
            }
            if (type == 328) {
                w.spawn(loc, Minecart.class);
            }
            if (type == 342) {
                w.spawn(loc, StorageMinecart.class);
            }
            if (type == 343) {
                w.spawn(loc, PoweredMinecart.class);
            }
        }
    }

    public void launcherEvent(World w, int x, int y, int z, BlockRedstoneEvent event) {
        if (event.getNewCurrent() == 0) {
            return;
        }
        Block block = w.getBlockAt(x, y, z);
        Block underBlock = w.getBlockAt(x, y - 1, z);
        Block railBlock = w.getBlockAt(x, y + 1, z);
        if (!FalseBookCartCore.getSettings().containsKey(block.getWorld().getName())) {
            FalseBookCartCore.getSettings().put(block.getWorld().getName(), new CartWorldSettings("FalseBookCart.properties", block.getWorld().getName()));
        }
        CartWorldSettings thisSettings = FalseBookCartCore.getSettings().get(block.getWorld().getName());
        if (underBlock.getTypeId() == thisSettings.getStationBlock() && underBlock.getData() == thisSettings.getStationBlockValue() && block.getType().equals((Object)Material.RAILS)) {
            this.launcherEvent(w, x, y - 1, z, event);
        } else if (block.getTypeId() == thisSettings.getStationBlock() && block.getData() == thisSettings.getStationBlockValue() && railBlock.getType().equals((Object)Material.RAILS)) {
            Block signBlock = w.getBlockAt(x, y - 1, z);
            if (!signBlock.getType().equals((Object)Material.SIGN_POST)) {
                return;
            }
            if (!((Sign)signBlock.getState()).getLine(1).equalsIgnoreCase("[Station]")) {
                return;
            }
            if (thisSettings.isUseSimpleCartSystem() && !((Boolean)Launcher.isCartOnBlock(signBlock).get(0)).booleanValue() && ((Boolean)Launcher.isPlayerOnBlock(signBlock).get(0)).booleanValue()) {
                Location loc = signBlock.getLocation();
                loc.setY(loc.getY() + 2.0);
                Minecart cart = (Minecart)signBlock.getWorld().spawn(loc, Minecart.class);
                cart.setPassenger((Entity)Launcher.isPlayerOnBlock(signBlock).get(1));
            }
            List ent = w.getEntities();
            int i = 0;
            while (i < ent.size()) {
                if ((ent.get(i) instanceof Minecart || ent.get(i) instanceof StorageMinecart || ent.get(i) instanceof PoweredMinecart) && ((Entity)ent.get(i)).getLocation().getBlockX() == x && ((Entity)ent.get(i)).getLocation().getBlockZ() == z && ((Entity)ent.get(i)).getLocation().getBlockY() == railBlock.getY()) {
                    Launcher.Execute((Minecart)ent.get(i), signBlock);
                    return;
                }
                ++i;
            }
        }
    }
}

