/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.Chat;

import com.gemo.FalseBook.Chat.FalseBookChatCore;
import java.io.Serializable;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class Channel
implements Serializable {
    private static final long serialVersionUID = -7549940836094807746L;
    private ChatColor prefixColor = ChatColor.BLUE;
    private ChatColor textColor = ChatColor.GRAY;
    private ChatColor broadcastColor = ChatColor.GOLD;
    private String Name;
    private String Password;
    private String ChannelOwner;
    private boolean isVisible = true;
    private boolean showAllMessages = true;
    private ArrayList<String> PlayerList = new ArrayList();

    public ArrayList<String> getPlayerList() {
        return this.PlayerList;
    }

    public Channel(String channelName, String PW, Player O) {
        this.Name = channelName;
        this.setPassword(PW);
        this.setChannelOwner(O.getName());
    }

    public boolean isPlayerInRoom(Player player) {
        int i = 0;
        while (i < this.PlayerList.size()) {
            if (this.PlayerList.get(i).equalsIgnoreCase(player.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void sendMessage(String player, String message) {
        Player[] pList = FalseBookChatCore.server.getOnlinePlayers();
        int i = 0;
        while (i < pList.length) {
            if (pList[i].getName().equalsIgnoreCase(player)) {
                pList[i].sendMessage(this.broadcastColor + message);
                break;
            }
            ++i;
        }
    }

    public void broadcast(String message) {
        Player[] pList = FalseBookChatCore.server.getOnlinePlayers();
        int i = 0;
        while (i < pList.length) {
            int j = 0;
            while (j < this.PlayerList.size()) {
                if (pList[i].getName().equalsIgnoreCase(this.PlayerList.get(j))) {
                    pList[i].sendMessage(this.broadcastColor + message);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public void PlayerChat(String sender, String message) {
        Player[] pList = FalseBookChatCore.server.getOnlinePlayers();
        int i = 0;
        while (i < pList.length) {
            int j = 0;
            while (j < this.PlayerList.size()) {
                if (pList[i].getName().equalsIgnoreCase(this.PlayerList.get(j))) {
                    pList[i].sendMessage(this.prefixColor + sender + ": " + this.textColor + message);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public boolean PlayerInChannel(String player) {
        return this.PlayerList.contains(player);
    }

    public void closeChannel() {
        int i = 0;
        while (i < this.PlayerList.size()) {
            this.PlayerLeave(this.PlayerList.get(i));
            ++i;
        }
        this.broadcast("Channel was closed!");
    }

    public boolean PlayerJoin(String player) {
        if (this.PlayerInChannel(player)) {
            this.sendMessage(player, "You are already in the Channel '" + this.Name + "'.");
            return false;
        }
        this.broadcast("'" + player + "' has joined the Channel.");
        this.sendMessage(player, this.broadcastColor + "You joined the Channel '" + this.Name + "'.");
        this.PlayerList.add(player);
        return true;
    }

    public boolean PlayerLeave(String player) {
        if (!this.PlayerInChannel(player)) {
            return false;
        }
        this.sendMessage(player, "You quit the Channel '" + this.Name + "'.");
        int i = 0;
        while (i < this.PlayerList.size()) {
            if (this.PlayerList.get(i).equalsIgnoreCase(player)) {
                this.PlayerList.remove(this.PlayerList.get(i));
            }
            ++i;
        }
        this.broadcast("'" + player + "' has quit the Channel.");
        return true;
    }

    public String getName() {
        return this.Name;
    }

    public boolean toggleVisible() {
        this.isVisible = !this.isVisible;
        return this.isVisible();
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setPassword(String password) {
        this.Password = password;
    }

    public String getPassword() {
        return this.Password;
    }

    public void setChannelOwner(String channelOwner) {
        this.ChannelOwner = channelOwner;
    }

    public String getChannelOwner() {
        return this.ChannelOwner;
    }

    public boolean isShowAllMessages() {
        return this.showAllMessages;
    }

    public void setShowAllMessages(boolean showAllMessages) {
        this.showAllMessages = showAllMessages;
    }
}

