/*
 * Decompiled with CFR 0.152.
 */
package com.gemo.FalseBook.Chat;

import com.gemo.FalseBook.Chat.Channel;
import com.gemo.FalseBook.Chat.FalseBookChatPlayerListener;
import com.gemo.FalseBook.Core.FalseBookCore;
import com.gemo.utils.UtilPermissions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class FalseBookChatCore
extends JavaPlugin {
    private FalseBookCore core;
    public static Server server;
    private FalseBookChatPlayerListener playerListener;
    private static String pluginName;

    public void printInConsole(String str) {
        System.out.println("[FalseBook Chat] " + str);
    }

    public void onDisable() {
        if (this.searchCore()) {
            this.saveChannels();
            System.out.println(String.valueOf(pluginName) + " disabled");
        }
    }

    public void onEnable() {
        if (!this.searchCore()) {
            this.printInConsole(">>>>> FalseBookCore.jar not found! FalseBookChat.jar is being disabled!");
            return;
        }
        this.loadVersion();
        server = this.getServer();
        new UtilPermissions(server);
        this.playerListener = new FalseBookChatPlayerListener(this);
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvent(Event.Type.PLAYER_CHAT, (Listener)this.playerListener, Event.Priority.Lowest, (Plugin)this);
        this.loadChannels();
        System.out.println(String.valueOf(pluginName) + " enabled");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (FalseBookChatPlayerListener.getOn() && sender instanceof Player) {
            Player player = (Player)sender;
            if (FalseBookChatPlayerListener.isPlayerInAnyChannel(player) && (label.equalsIgnoreCase("all") || label.equalsIgnoreCase("a")) && args.length > 0) {
                String txt = "";
                int i = 0;
                while (i < args.length) {
                    txt = String.valueOf(txt) + args[i] + " ";
                    ++i;
                }
                Player[] pList = server.getOnlinePlayers();
                int i2 = 0;
                while (i2 < pList.length) {
                    if (!FalseBookChatPlayerListener.isPlayerInAnyChannel(pList[i2])) {
                        pList[i2].sendMessage(ChatColor.DARK_GRAY + player.getName() + ": " + ChatColor.WHITE + txt);
                    } else if (this.playerListener.getCurrentChannel(pList[i2]).isShowAllMessages()) {
                        pList[i2].sendMessage(ChatColor.DARK_GRAY + player.getName() + ": " + ChatColor.WHITE + txt);
                    }
                    ++i2;
                }
            } else if (label.equalsIgnoreCase("ch") && args.length > 0) {
                if (args[0].equalsIgnoreCase("showAllMsg") && this.playerListener.getCurrentChannel(player) != null) {
                    if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.chat.create")) {
                        player.sendMessage(ChatColor.RED + "You are not allowed to change channelsettings!");
                        return false;
                    }
                    if (this.playerListener.getCurrentChannel(player).getChannelOwner().equalsIgnoreCase(player.getName()) || player.isOp()) {
                        this.playerListener.getCurrentChannel(player).setShowAllMessages(!this.playerListener.getCurrentChannel(player).isShowAllMessages());
                        player.sendMessage(ChatColor.GOLD + "Showing all Messages is now set to: " + this.playerListener.getCurrentChannel(player).isShowAllMessages());
                    } else {
                        player.sendMessage(ChatColor.RED + "You are not the Channelowner!");
                    }
                } else if (args[0].equalsIgnoreCase("isVisible") && this.playerListener.getCurrentChannel(player) != null) {
                    if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.chat.create")) {
                        player.sendMessage(ChatColor.RED + "You are not allowed to change channelsettings!");
                        return false;
                    }
                    if (this.playerListener.getCurrentChannel(player).getChannelOwner().equalsIgnoreCase(player.getName()) || player.isOp()) {
                        this.playerListener.getCurrentChannel(player).toggleVisible();
                        player.sendMessage(ChatColor.GOLD + "Channel visibility is now set to: " + this.playerListener.getCurrentChannel(player).isVisible());
                    } else {
                        player.sendMessage(ChatColor.RED + "You are not the Channelowner!");
                    }
                } else if (args[0].equalsIgnoreCase("list")) {
                    if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.chat.list")) {
                        player.sendMessage(ChatColor.RED + "You are not allowed to list all channels!");
                        return false;
                    }
                    player.sendMessage(ChatColor.GOLD + "List of Channels:");
                    String txt = "";
                    int i = 0;
                    while (i < FalseBookChatPlayerListener.getChannelList().size()) {
                        if (FalseBookChatPlayerListener.getChannelList().get(i).isVisible()) {
                            txt = String.valueOf(txt) + FalseBookChatPlayerListener.getChannelList().get(i).getName();
                            if (i < FalseBookChatPlayerListener.getChannelList().size() - 1) {
                                txt = String.valueOf(txt) + " ";
                            }
                        }
                        ++i;
                    }
                    player.sendMessage(ChatColor.GRAY + txt);
                } else if (args[0].equalsIgnoreCase("create") && (args.length == 2 || args.length == 3)) {
                    if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.chat.create")) {
                        player.sendMessage(ChatColor.RED + "You are not allowed to create new channels!");
                        return false;
                    }
                    String pw = "";
                    if (args.length == 3) {
                        pw = args[2];
                    }
                    if (!FalseBookChatPlayerListener.ChannelExists(args[1])) {
                        FalseBookChatPlayerListener.getChannelList().add(new Channel(args[1], pw, player));
                        if (args.length == 2) {
                            player.sendMessage(ChatColor.GOLD + "Created Channel: " + args[1]);
                        } else {
                            player.sendMessage(ChatColor.GOLD + "Created protected Channel: " + args[1]);
                        }
                    } else {
                        player.sendMessage(ChatColor.RED + "This Channel already exists!");
                    }
                } else if (args[0].equalsIgnoreCase("join") && (args.length == 2 || args.length == 3)) {
                    if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.chat.join")) {
                        player.sendMessage(ChatColor.RED + "You are not allowed to use channels!");
                        return false;
                    }
                    if (FalseBookChatPlayerListener.ChannelExists(args[1])) {
                        String pw = "";
                        if (args.length == 3) {
                            pw = args[2];
                        }
                        if (pw.equals(FalseBookChatPlayerListener.getChannelList().get(FalseBookChatPlayerListener.getChannelID(args[1])).getPassword())) {
                            if (FalseBookChatPlayerListener.isPlayerInAnyChannel(player)) {
                                this.playerListener.getCurrentChannel(player).PlayerLeave(player.getName());
                            }
                            FalseBookChatPlayerListener.getChannelList().get(FalseBookChatPlayerListener.getChannelID(args[1])).PlayerJoin(player.getName());
                            if (args.length < 3) {
                                this.broadcastOnLobby(ChatColor.GOLD + "'" + player.getName() + "' joined the Channel: " + args[1]);
                            } else {
                                this.broadcastOnLobby(ChatColor.GOLD + "'" + player.getName() + "' joined a private Channel.");
                            }
                            this.listChannelUser(player);
                        } else {
                            player.sendMessage(ChatColor.RED + "Wrong password!");
                        }
                    } else {
                        player.sendMessage(ChatColor.RED + "There is no Channel named '" + args[1] + "'");
                    }
                } else if (args[0].equalsIgnoreCase("leave") && args.length == 1) {
                    if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.chat.use")) {
                        player.sendMessage(ChatColor.RED + "You are not allowed to use channels!");
                        return false;
                    }
                    if (FalseBookChatPlayerListener.isPlayerInAnyChannel(player)) {
                        this.broadcastOnLobby(ChatColor.GOLD + "'" + player.getName() + "' joined the Lobby.");
                        if (FalseBookChatPlayerListener.isPlayerInAnyChannel(player)) {
                            this.playerListener.getCurrentChannel(player).PlayerLeave(player.getName());
                        }
                    } else {
                        player.sendMessage(ChatColor.RED + "You're not in a Channel.");
                    }
                } else if (args[0].equalsIgnoreCase("who") && args.length == 1) {
                    if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.chat.use")) {
                        player.sendMessage(ChatColor.RED + "You are not allowed to use channels!");
                        return false;
                    }
                    this.listChannelUser(player);
                } else if (args[0].equalsIgnoreCase("remove") && args.length == 2) {
                    if (!UtilPermissions.playerCanUseCommand((Player)player, (String)"falsebook.chat.create")) {
                        player.sendMessage(ChatColor.RED + "You are not allowed to delete channels!");
                        return false;
                    }
                    if (FalseBookChatPlayerListener.ChannelExists(args[1])) {
                        int oldID = FalseBookChatPlayerListener.getChannelID(args[1]);
                        if (FalseBookChatPlayerListener.getChannelList().get(oldID).getChannelOwner().equalsIgnoreCase(player.getName()) || player.isOp()) {
                            FalseBookChatPlayerListener.getChannelList().get(oldID).closeChannel();
                            FalseBookChatPlayerListener.getChannelList().remove(oldID);
                            player.sendMessage(ChatColor.GOLD + "Channel '" + args[1] + "' removed.");
                        } else {
                            player.sendMessage(ChatColor.RED + "You are not the allowed to delete this Channel!");
                        }
                    } else {
                        player.sendMessage(ChatColor.RED + "There is no Channel named '" + args[1] + "'");
                    }
                }
            }
        }
        return true;
    }

    public void broadcastOnLobby(String message) {
        Player[] pList = server.getOnlinePlayers();
        int i = 0;
        while (i < pList.length) {
            if (!FalseBookChatPlayerListener.isPlayerInAnyChannel(pList[i])) {
                pList[i].sendMessage(message);
            }
            ++i;
        }
    }

    public void listChannelUser(Player player) {
        if (FalseBookChatPlayerListener.isPlayerInAnyChannel(player)) {
            Channel current = this.playerListener.getCurrentChannel(player);
            String inChannel = "";
            int i = 0;
            while (i < current.getPlayerList().size()) {
                inChannel = String.valueOf(inChannel) + current.getPlayerList().get(i);
                if (i < current.getPlayerList().size() - 1) {
                    inChannel = String.valueOf(inChannel) + ", ";
                }
                ++i;
            }
            player.sendMessage(ChatColor.GOLD + "Users in this Channel: ");
            player.sendMessage(ChatColor.GRAY + inChannel);
        } else {
            player.sendMessage(ChatColor.RED + "You're not in a Channel.");
        }
    }

    private boolean searchCore() {
        PluginManager pm = this.getServer().getPluginManager();
        if (pm.getPlugin("FalseBookCore") != null) {
            if (pm.getPlugin("FalseBookCore").isEnabled()) {
                this.setCore((FalseBookCore)pm.getPlugin("FalseBookCore"));
                return true;
            }
            this.setCore((FalseBookCore)pm.getPlugin("FalseBookCore"));
            return true;
        }
        return false;
    }

    public void setCore(FalseBookCore core) {
        this.core = core;
    }

    public FalseBookCore getCore() {
        return this.core;
    }

    public void loadVersion() {
        PluginDescriptionFile pdfFile = this.getDescription();
        pluginName = String.valueOf(pdfFile.getName()) + " v" + pdfFile.getVersion() + " by GeMo";
    }

    public void saveChannels() {
        File folder = new File("plugins/FalseBook");
        folder.mkdirs();
        try {
            ObjectOutputStream objOut2 = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream("plugins/FalseBook/ChatRooms.db")));
            objOut2.writeObject(FalseBookChatPlayerListener.getChannelList());
            objOut2.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean loadChannels() {
        File f = new File("plugins/FalseBook/ChatRooms.db");
        if (!f.exists()) {
            this.printInConsole("No ChatRooms loaded.");
            return false;
        }
        try {
            ObjectInputStream objIn2 = new ObjectInputStream(new BufferedInputStream(new FileInputStream("plugins/FalseBook/ChatRooms.db")));
            FalseBookChatPlayerListener.setChannelList((ArrayList)objIn2.readObject());
            objIn2.close();
            this.printInConsole(String.valueOf(FalseBookChatPlayerListener.getChannelList().size()) + " ChatRooms loaded.");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.printInConsole("Error while reading plugins/FalseBook/ChatRooms.db");
            return false;
        }
    }
}

