/*
 * Decompiled with CFR 0.152.
 */
package de.fgtech.pomo4ka.AuthMe;

import de.fgtech.pomo4ka.AuthMe.DataController.DataController;
import de.fgtech.pomo4ka.AuthMe.DataController.DataSource.DataSource;
import de.fgtech.pomo4ka.AuthMe.DataController.DataSource.FlatfileData;
import de.fgtech.pomo4ka.AuthMe.DataController.DataSource.MySQLData;
import de.fgtech.pomo4ka.AuthMe.InventoryCache.FlatfileCache;
import de.fgtech.pomo4ka.AuthMe.InventoryCache.InventoryArmour;
import de.fgtech.pomo4ka.AuthMe.Listener.AuthMeBlockListener;
import de.fgtech.pomo4ka.AuthMe.Listener.AuthMeEntityListener;
import de.fgtech.pomo4ka.AuthMe.Listener.AuthMePlayerListener;
import de.fgtech.pomo4ka.AuthMe.LoginTimeout.LoginTimeout;
import de.fgtech.pomo4ka.AuthMe.MessageHandler.MessageHandler;
import de.fgtech.pomo4ka.AuthMe.Parameters.Messages;
import de.fgtech.pomo4ka.AuthMe.Parameters.Settings;
import de.fgtech.pomo4ka.AuthMe.PlayerCache.PlayerCache;
import de.fgtech.pomo4ka.AuthMe.Sessions.SessionHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class AuthMe
extends JavaPlugin {
    private final AuthMePlayerListener playerListener = new AuthMePlayerListener(this);
    private final AuthMeBlockListener blockListener = new AuthMeBlockListener(this);
    private final AuthMeEntityListener entityListener = new AuthMeEntityListener(this);
    public Settings settings;
    public Messages messages;
    public PlayerCache playercache;
    public DataController datacontroller;
    public FlatfileCache invcache;
    public SessionHandler sessionhandler;
    public DataSource datas;

    public void onEnable() {
        File configFile;
        File folder = new File(Settings.PLUGIN_FOLDER);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(configFile = new File(Settings.PLUGIN_FOLDER, "config.yml")).exists()) {
            this.extractDefaultFile("config.yml");
            configFile = new File(Settings.PLUGIN_FOLDER, "config.yml");
        }
        this.settings = new Settings(configFile);
        File messagesFile = new File(Settings.PLUGIN_FOLDER, "messages.yml");
        if (!messagesFile.exists()) {
            messagesFile = new File(Settings.PLUGIN_FOLDER, "messages.yml");
        }
        this.messages = new Messages(messagesFile);
        this.playercache = new PlayerCache();
        this.invcache = new FlatfileCache();
        int maxTimePeriod = this.settings.MaximalTimePeriod();
        boolean IPCheck = this.settings.SessionIPCheckEnabled();
        this.sessionhandler = new SessionHandler(maxTimePeriod, IPCheck);
        long before = System.currentTimeMillis();
        if (this.settings.DataSource().equals("mysql")) {
            MessageHandler.showInfo("Using MySQL as datasource!");
            String host = this.settings.MySQLConnectionHost();
            int port = this.settings.MySQLConnectionPort();
            String database = this.settings.MySQLConnectionDatabase();
            String username = this.settings.MySQLConnectionUsername();
            String password = this.settings.MySQLConnectionPassword();
            String tableName = this.settings.MySQLCustomTableName();
            String columnName = this.settings.MySQLCustomColumnName();
            String columnPassword = this.settings.MySQLCustomColumnPassword();
            this.datas = new MySQLData(host, port, database, username, password, tableName, columnName, columnPassword);
        } else {
            MessageHandler.showInfo("Using flatfile as datasource!");
            this.datas = new FlatfileData();
        }
        boolean caching = this.settings.CachingEnabled();
        this.datacontroller = new DataController(this.datas, caching);
        float timeDiff = System.currentTimeMillis() - before;
        timeDiff /= 1000.0f;
        if (caching) {
            MessageHandler.showInfo("Cache for registrations is enabled!");
            MessageHandler.showInfo(String.valueOf(this.datacontroller.getRegisteredPlayerAmount()) + " registered players loaded in " + timeDiff + " seconds!");
        } else {
            MessageHandler.showInfo("Cache for registrations is disabled!");
            MessageHandler.showInfo("There are " + this.datacontroller.getRegisteredPlayerAmount() + " registered players in database!");
        }
        MessageHandler.showInfo("Version " + this.getDescription().getVersion() + " is enabled!");
        if (this.getServer().getOnlinePlayers().length > 0) {
            this.onAuthMeReload();
        }
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvent(Event.Type.PLAYER_COMMAND_PREPROCESS, (Listener)this.playerListener, Event.Priority.Lowest, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_CHAT, (Listener)this.playerListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_MOVE, (Listener)this.playerListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_LOGIN, (Listener)this.playerListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_JOIN, (Listener)this.playerListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_QUIT, (Listener)this.playerListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_KICK, (Listener)this.playerListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_PICKUP_ITEM, (Listener)this.playerListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.PLAYER_INTERACT, (Listener)this.playerListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_PLACE, (Listener)this.blockListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.BLOCK_BREAK, (Listener)this.blockListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.ENTITY_DAMAGE, (Listener)this.entityListener, Event.Priority.Normal, (Plugin)this);
        pm.registerEvent(Event.Type.ENTITY_TARGET, (Listener)this.entityListener, Event.Priority.Normal, (Plugin)this);
    }

    public void onAuthMeReload() {
        Player[] playerArray = this.getServer().getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            boolean regged = this.datacontroller.isPlayerRegistered(player.getName());
            this.playercache.createCache(player, regged, false);
            player.sendMessage(this.messages.getMessage("Alert.PluginReloaded"));
            ++n2;
        }
        MessageHandler.showInfo("AuthMe restored the player cache!");
    }

    public void onDisable() {
        MessageHandler.showInfo("Version " + this.getDescription().getVersion() + " is disabled!");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        Player player;
        if (commandLabel.equalsIgnoreCase("register")) {
            if (!(sender instanceof Player)) {
                return false;
            }
            Player player2 = (Player)sender;
            if (!this.settings.RegisterEnabled()) {
                player2.sendMessage("Registrations are currently disabled!");
                return false;
            }
            if (this.playercache.isPlayerRegistered(player2)) {
                player2.sendMessage(this.messages.getMessage("Error.AlreadyRegistered"));
                return false;
            }
            Map<String, String> customFields = this.settings.getCustomInformationFields();
            HashMap<String, String> customInformation = new HashMap<String, String>();
            if (customFields.size() > 0 && this.settings.DataSource().equals("mysql")) {
                if (args.length != customFields.size() + 1) {
                    String usageCustomFields = "";
                    for (String key : customFields.keySet()) {
                        usageCustomFields = String.valueOf(usageCustomFields) + "<" + key + "> ";
                    }
                    player2.sendMessage("Usage: /register <password> " + usageCustomFields);
                    return false;
                }
                int counter = 1;
                for (String key : customFields.keySet()) {
                    if (!args[counter].matches(customFields.get(key))) {
                        player2.sendMessage(this.messages.getMessage("Command.RegisterExtraInfoCheckFailed", key));
                        return false;
                    }
                    customInformation.put(key, args[counter]);
                    ++counter;
                }
            } else if (args.length != 1) {
                player2.sendMessage("Usage: /register <password>");
                return false;
            }
            String password = args[0];
            String salt = Long.toHexString(Double.doubleToLongBits(Math.random()));
            boolean executed = this.datacontroller.saveAuth(player2.getName(), this.secureCrypt(password, salt), customInformation);
            if (!executed) {
                player2.sendMessage(this.messages.getMessage("Error.DatasourceError"));
                MessageHandler.showError("Failed to save an auth due to an error in the datasource!");
                return false;
            }
            this.playercache.setPlayerAuthenticated(player2, true);
            this.playercache.setPlayerRegistered(player2, true);
            player2.sendMessage(this.messages.getMessage("Command.RegisterResponse", password));
            MessageHandler.showInfo("Player " + player2.getName() + " is now registered!");
            return true;
        }
        if (commandLabel.equalsIgnoreCase("login") || commandLabel.equalsIgnoreCase("l")) {
            if (!(sender instanceof Player)) {
                return false;
            }
            Player player3 = (Player)sender;
            if (!this.settings.LoginEnabled()) {
                player3.sendMessage("Logins are currently disabled!");
                return false;
            }
            if (args.length != 1) {
                player3.sendMessage("Usage: /login <password>");
                return false;
            }
            String playername = player3.getName();
            String password = args[0];
            if (!this.playercache.isPlayerRegistered(player3)) {
                player3.sendMessage(this.messages.getMessage("Error.NotRegistered"));
                return false;
            }
            if (this.playercache.isPlayerAuthenticated(player3)) {
                player3.sendMessage(this.messages.getMessage("Error.AlreadyLoggedIn"));
                return false;
            }
            String realPassword = this.datacontroller.getHash(playername);
            if (!this.comparePassword(password, realPassword)) {
                if (this.settings.KickOnWrongPassword()) {
                    player3.kickPlayer(this.messages.getMessage("Error.InvalidPassword"));
                } else {
                    player3.sendMessage(this.messages.getMessage("Error.InvalidPassword"));
                }
                MessageHandler.showInfo("Player " + player3.getName() + " tried to login with a wrong password!");
                return false;
            }
            LoginTimeout.removeLoginTimeout(this, player3);
            this.performPlayerLogin(player3);
            player3.sendMessage(this.messages.getMessage("Command.LoginResponse"));
            MessageHandler.showInfo("Player " + player3.getName() + " logged in!");
            return true;
        }
        if (commandLabel.equalsIgnoreCase("changepassword")) {
            if (!(sender instanceof Player)) {
                return false;
            }
            player = (Player)sender;
            if (!this.settings.ChangePasswordEnabled()) {
                player.sendMessage("Changing passwords is currently disabled!");
                return false;
            }
            if (!this.playercache.isPlayerRegistered(player)) {
                player.sendMessage(this.messages.getMessage("Error.NotRegistered"));
                return false;
            }
            if (!this.playercache.isPlayerAuthenticated(player)) {
                player.sendMessage(this.messages.getMessage("Error.NotLogged"));
                return false;
            }
            if (args.length != 2) {
                player.sendMessage("Usage: /changepassword <oldpassword> <newpassword>");
                return false;
            }
            if (!this.comparePassword(args[0], this.datacontroller.getHash(player.getName()))) {
                player.sendMessage(this.messages.getMessage("Error.WrongPassword"));
                return false;
            }
            String salt = Long.toHexString(Double.doubleToLongBits(Math.random()));
            boolean executed = this.datacontroller.updateAuth(player.getName(), this.secureCrypt(args[1], salt));
            if (!executed) {
                player.sendMessage(this.messages.getMessage("Error.DatasourceError"));
                MessageHandler.showError("Failed to update an auth due to an error in the datasource!");
                return false;
            }
            player.sendMessage(this.messages.getMessage("Command.ChangePasswordResponse"));
            MessageHandler.showInfo("Player " + player.getName() + " changed his password!");
        }
        if (commandLabel.equalsIgnoreCase("logout")) {
            if (!(sender instanceof Player)) {
                return false;
            }
            player = (Player)sender;
            if (!this.settings.LogoutEnabled()) {
                player.sendMessage("Logging out is currently disabled!");
                return false;
            }
            if (!this.playercache.isPlayerAuthenticated(player)) {
                player.sendMessage(this.messages.getMessage("Error.NotLogged"));
                return false;
            }
            this.playercache.setPlayerAuthenticated(player, false);
            player.sendMessage(this.messages.getMessage("Command.LogoutResponse"));
            MessageHandler.showInfo("Player " + player.getName() + " logged out!");
        }
        if (commandLabel.equalsIgnoreCase("unregister")) {
            if (!(sender instanceof Player)) {
                return false;
            }
            player = (Player)sender;
            if (!this.settings.UnregisterEnabled()) {
                player.sendMessage("Unregistering is currently disabled!");
                return false;
            }
            if (!this.playercache.isPlayerRegistered(player)) {
                player.sendMessage(this.messages.getMessage("Error.NotRegistered"));
                return false;
            }
            if (!this.playercache.isPlayerAuthenticated(player)) {
                player.sendMessage(this.messages.getMessage("Error.NotLogged"));
                return false;
            }
            if (args.length != 1) {
                player.sendMessage("Usage: /unregister <password>");
                return false;
            }
            if (!this.comparePassword(args[0], this.datacontroller.getHash(player.getName()))) {
                player.sendMessage(this.messages.getMessage("Error.WrongPassword"));
                return false;
            }
            boolean executed = this.datacontroller.removeAuth(player.getName());
            if (!executed) {
                player.sendMessage(this.messages.getMessage("Error.DatasourceError"));
                MessageHandler.showError("Failed to remove an auth due to an error in the datasource!");
                return false;
            }
            this.playercache.recreateCache(player);
            player.sendMessage(this.messages.getMessage("Command.UnregisterResponse"));
            MessageHandler.showInfo("Player " + player.getName() + " is now unregistered!");
        }
        if (commandLabel.equalsIgnoreCase("authme")) {
            String pre = "";
            if (sender instanceof Player) {
                Player player4 = (Player)sender;
                if (!player4.isOp()) {
                    player4.sendMessage("You dont have permission to do this!");
                    return false;
                }
                if (!this.playercache.isPlayerAuthenticated(player4)) {
                    player4.sendMessage(this.messages.getMessage("Error.NotLogged"));
                    return false;
                }
                pre = "/";
            }
            if (args.length == 0) {
                sender.sendMessage("Usage: " + pre + "authme <reloadconfig | reloadcache | toggleregs | deleteauth>");
                return false;
            }
            if (args[0].equals("deleteauth") && args.length != 2) {
                sender.sendMessage("Usage: " + pre + "authme deleteauth <playername>");
                return false;
            }
            if (args[0].equals("reloadcache")) {
                if (!this.settings.ReloadEnabled()) {
                    sender.sendMessage("Reloading authentications is currently disabled!");
                    return false;
                }
                if (!this.settings.CachingEnabled()) {
                    sender.sendMessage(ChatColor.RED + "Error: There is no need to reload the authentication cache. Caching is disabled in config anyway!");
                    return false;
                }
                this.datacontroller = new DataController(this.datas, true);
                sender.sendMessage(ChatColor.GREEN + "AuthMe has successfully reloaded all authentications!");
                MessageHandler.showInfo("Authentication cache reloaded by command!");
            }
            if (args[0].equals("reloadconfig")) {
                File configFile = new File(Settings.PLUGIN_FOLDER, "config.yml");
                if (!configFile.exists()) {
                    this.extractDefaultFile("config.yml");
                    configFile = new File(Settings.PLUGIN_FOLDER, "config.yml");
                }
                this.settings = new Settings(configFile);
                sender.sendMessage(ChatColor.GREEN + "AuthMe has successfully reloaded it's config file!");
                MessageHandler.showInfo("Config file reloaded by command!");
            }
            if (args[0].equals("toggleregs")) {
                String key = "Commands.Users.RegisterEnabled";
                if (this.settings.getBoolean(key, true)) {
                    this.settings.setProperty(key, false);
                    sender.sendMessage(ChatColor.GREEN + "AuthMe has successfully disabled registrations!");
                } else {
                    this.settings.setProperty(key, true);
                    sender.sendMessage(ChatColor.GREEN + "AuthMe has successfully enabled registrations!");
                }
            }
            if (args[0].equals("deleteauth")) {
                if (!this.settings.ResetEnabled()) {
                    sender.sendMessage("Reseting a authentication is currently disabled!");
                    return false;
                }
                if (!this.datacontroller.isPlayerRegistered(args[1])) {
                    sender.sendMessage(this.messages.getMessage("Error.PlayerNotRegistered"));
                    return false;
                }
                boolean executed = this.datacontroller.removeAuth(args[1]);
                if (!executed) {
                    sender.sendMessage(this.messages.getMessage("Error.DatasourceError"));
                    MessageHandler.showError("Failed to remove an auth due to an error in the datasource!");
                    return false;
                }
                Player delPlayer = this.getServer().getPlayer(args[1]);
                if (delPlayer != null) {
                    this.playercache.recreateCache(delPlayer);
                }
                sender.sendMessage(ChatColor.GREEN + "This player is now unregistered!");
                MessageHandler.showInfo("Account of " + args[1] + " got deleted by command!");
            }
        }
        return false;
    }

    public boolean checkAuth(Player player) {
        if (this.playercache.isPlayerAuthenticated(player)) {
            return true;
        }
        int alertInterval = this.settings.alertInterval();
        if (this.playercache.isPlayerRegistered(player)) {
            if (this.playercache.isAlertNeeded(player, alertInterval)) {
                player.sendMessage(this.messages.getMessage("Alert.Login"));
            }
            return false;
        }
        if (this.settings.ForceRegistration()) {
            if (this.playercache.isAlertNeeded(player, alertInterval)) {
                player.sendMessage(this.messages.getMessage("Alert.Registration"));
            }
            return false;
        }
        return true;
    }

    public boolean checkUnrestrictedAccess(Player player) {
        List<Object> players = this.settings.AllowPlayerUnrestrictedAccess();
        if (!players.isEmpty()) {
            for (Object playernameObj : players) {
                String playername = (String)playernameObj;
                if (!player.getName().equalsIgnoreCase(playername) && !player.getDisplayName().equalsIgnoreCase(playername)) continue;
                return true;
            }
        }
        return false;
    }

    public void performPlayerLogin(Player player) {
        this.playercache.setPlayerAuthenticated(player, true);
        if (this.invcache.doesCacheExist(player.getName())) {
            InventoryArmour invarm = this.invcache.readCache(player.getName());
            ItemStack[] invstackbackup = invarm.getInventory();
            player.getInventory().setContents(invstackbackup);
            ItemStack[] armStackBackup = invarm.getArmour();
            if (armStackBackup[3] != null && armStackBackup[3].getAmount() != 0) {
                player.getInventory().setHelmet(armStackBackup[3]);
            }
            if (armStackBackup[2] != null && armStackBackup[2].getAmount() != 0) {
                player.getInventory().setChestplate(armStackBackup[2]);
            }
            if (armStackBackup[1] != null && armStackBackup[1].getAmount() != 0) {
                player.getInventory().setLeggings(armStackBackup[1]);
            }
            if (armStackBackup[0] != null && armStackBackup[0].getAmount() != 0) {
                player.getInventory().setBoots(armStackBackup[0]);
            }
            this.invcache.removeCache(player.getName());
        }
    }

    private boolean comparePassword(String password, String hash) {
        if (hash.contains("$")) {
            String[] data = hash.split("\\$");
            if (data.length > 3 && data[1].equals("SHA")) {
                return hash.equals(this.secureCrypt(password, data[2]));
            }
            return false;
        }
        return hash.equals(this.digestToMD5(password));
    }

    private String secureCrypt(String password, String salt) {
        return "$SHA$" + salt + "$" + this.digestToSHA256(String.valueOf(this.digestToSHA256(password)) + salt);
    }

    private String digestToSHA256(String message) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.reset();
            md.update(message.getBytes("UTF-8"));
            byte[] digest = md.digest();
            BigInteger i = new BigInteger(1, digest);
            return String.format("%0" + (digest.length << 1) + "x", i);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return "";
    }

    public String digestToMD5(String string) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            byte[] bytes = string.getBytes();
            m.update(bytes, 0, bytes.length);
            BigInteger i = new BigInteger(1, m.digest());
            return String.format("%1$032X", i).toLowerCase();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void extractDefaultFile(String name) {
        InputStream input;
        File actual = new File(Settings.PLUGIN_FOLDER, name);
        if (!actual.exists() && (input = ((Object)((Object)this)).getClass().getResourceAsStream("/default/" + name)) != null) {
            FileOutputStream output = null;
            try {
                try {
                    output = new FileOutputStream(actual);
                    byte[] buf = new byte[8192];
                    int length = 0;
                    while ((length = input.read(buf)) > 0) {
                        output.write(buf, 0, length);
                    }
                    MessageHandler.showInfo("Default file written: " + name);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }
}

