/*
 * Decompiled with CFR 0.152.
 */
package de.fgtech.pomo4ka.AuthMe.DataController.DataSource;

import de.fgtech.pomo4ka.AuthMe.DataController.DataSource.DataSource;
import de.fgtech.pomo4ka.AuthMe.DataController.RegistrationCache.RegistrationCache;
import de.fgtech.pomo4ka.AuthMe.DataController.RegistrationCache.RegistrationData;
import de.fgtech.pomo4ka.AuthMe.MessageHandler.MessageHandler;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;

public class MySQLData
extends DataSource {
    private Connection connection = null;
    private Statement statement = null;
    private PreparedStatement preparedStatement = null;
    private ResultSet resultSet = null;
    private String host;
    private int port;
    private String database;
    private String username;
    private String password;
    private String tableName;
    private String columnName;
    private String columnPassword;

    public MySQLData(String host, int port, String database, String username, String password, String tableName, String columnName, String columnPassword) {
        this.host = host;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
        this.tableName = tableName;
        this.columnName = columnName;
        this.columnPassword = columnPassword;
        this.connect();
        this.setup();
    }

    public void connect() {
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            this.connection = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?" + "user=" + this.username + "&password=" + this.password);
            this.statement = this.connection.createStatement();
        }
        catch (Exception e) {
            MessageHandler.showError("[MySQL] Unable to establish a connection to your MySQL database!");
            System.out.println(e);
        }
    }

    public void setup() {
        try {
            if (this.connection.isClosed()) {
                this.connect();
            }
            this.preparedStatement = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.tableName + " (id INT NOT NULL AUTO_INCREMENT PRIMARY KEY, " + this.columnName + " VARCHAR(20) NOT NULL, " + this.columnPassword + " VARCHAR(36) NOT NULL);");
            this.preparedStatement.executeUpdate();
            this.preparedStatement = this.connection.prepareStatement("ALTER TABLE " + this.tableName + " MODIFY " + this.columnPassword + " VARCHAR(100);");
            this.preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            MessageHandler.showError("[MySQL] Couldn't create a '" + this.tableName + "' table in your MySQL database!");
        }
    }

    private void close() {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.statement != null) {
                this.statement.close();
            }
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public RegistrationCache loadAllAuths() {
        RegistrationCache regcache = new RegistrationCache();
        try {
            if (this.connection.isClosed()) {
                this.connect();
            }
            this.preparedStatement = this.connection.prepareStatement("SELECT * FROM " + this.tableName);
            this.resultSet = this.preparedStatement.executeQuery();
            String user = "";
            String password = "";
            while (this.resultSet.next()) {
                user = this.resultSet.getString(this.columnName);
                password = this.resultSet.getString(this.columnPassword);
                if (user == "" || password == "") continue;
                regcache.insert(new RegistrationData(user, password));
                user = "";
                password = "";
            }
        }
        catch (Exception e) {
            MessageHandler.showError("[MySQL] Unable to load authentications!");
        }
        return regcache;
    }

    @Override
    public boolean saveAuth(String playername, String hash, Map<String, String> customInformation) {
        try {
            if (this.connection.isClosed()) {
                this.connect();
            }
            String addCustomInfo = "";
            if (!customInformation.isEmpty()) {
                for (String key : customInformation.keySet()) {
                    addCustomInfo = ", " + key + "='" + customInformation.get(key) + "'";
                }
            }
            this.preparedStatement = this.connection.prepareStatement("INSERT INTO " + this.tableName + " SET " + this.columnName + "=?, " + this.columnPassword + "=?" + addCustomInfo);
            this.preparedStatement.setString(1, playername);
            this.preparedStatement.setString(2, hash);
            this.preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            MessageHandler.showError("[MySQL] Unable to save an authentication!");
            return false;
        }
        return true;
    }

    @Override
    public boolean updateAuth(String playername, String hash) {
        try {
            if (this.connection.isClosed()) {
                this.connect();
            }
            this.preparedStatement = this.connection.prepareStatement("UPDATE " + this.tableName + " SET " + this.columnPassword + " = ? WHERE " + this.columnName + " = ?");
            this.preparedStatement.setString(1, hash);
            this.preparedStatement.setString(2, playername);
            this.preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            MessageHandler.showError("[MySQL] Unable to update an authentication!");
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAuth(String playername) {
        try {
            if (this.connection.isClosed()) {
                this.connect();
            }
            this.preparedStatement = this.connection.prepareStatement("DELETE FROM " + this.tableName + " WHERE " + this.columnName + " = ?");
            this.preparedStatement.setString(1, playername);
            this.preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            MessageHandler.showError("[MySQL] Unable to remove an authentication!");
            return false;
        }
        return true;
    }

    @Override
    public String loadHash(String playername) {
        try {
            if (this.connection.isClosed()) {
                this.connect();
            }
            this.preparedStatement = this.connection.prepareStatement("SELECT " + this.columnPassword + " FROM " + this.tableName + " WHERE " + this.columnName + " = ?");
            this.preparedStatement.setString(1, playername);
            this.resultSet = this.preparedStatement.executeQuery();
            if (this.resultSet.next()) {
                return this.resultSet.getString(1);
            }
        }
        catch (Exception e) {
            MessageHandler.showError("[MySQL] Unable to load an authentication!");
        }
        return null;
    }

    @Override
    public boolean isPlayerRegistered(String playername) {
        try {
            if (this.connection.isClosed()) {
                this.connect();
            }
            this.preparedStatement = this.connection.prepareStatement("SELECT COUNT(*) FROM " + this.tableName + " WHERE " + this.columnName + " = ?");
            this.preparedStatement.setString(1, playername);
            this.resultSet = this.preparedStatement.executeQuery();
            if (this.resultSet.next()) {
                return this.resultSet.getInt(1) > 0;
            }
        }
        catch (Exception e) {
            MessageHandler.showError("[MySQL] Unable to check an authentication!");
        }
        return false;
    }

    @Override
    public int getRegisteredPlayerAmount() {
        try {
            if (this.connection.isClosed()) {
                this.connect();
            }
            this.preparedStatement = this.connection.prepareStatement("SELECT COUNT(*) FROM " + this.tableName);
            this.resultSet = this.preparedStatement.executeQuery();
            if (this.resultSet.next()) {
                return this.resultSet.getInt(1);
            }
        }
        catch (Exception e) {
            MessageHandler.showError("[MySQL] Unable to count authentications!");
        }
        return 0;
    }
}

