/*
 * Decompiled with CFR 0.152.
 */
package de.fgtech.pomo4ka.AuthMe.Sessions;

import de.fgtech.pomo4ka.AuthMe.Sessions.Session;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

public class SessionHandler {
    private Map<String, Session> sessionTable = new HashMap<String, Session>();
    private int maxSessionTime;
    private boolean ipCheck;

    public SessionHandler(int maxSessionTime, boolean ipCheck) {
        this.maxSessionTime = maxSessionTime;
        this.ipCheck = ipCheck;
    }

    public void createSession(Player player) {
        long curTime = System.currentTimeMillis();
        String recentHost = player.getAddress().getHostName();
        Session newSession = new Session(curTime, recentHost);
        this.removeSession(player);
        this.sessionTable.put(player.getName().toLowerCase(), newSession);
    }

    public void removeSession(Player player) {
        if (this.sessionTable.containsKey(player.getName().toLowerCase())) {
            this.sessionTable.remove(player.getName().toLowerCase());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSessionValid(Player player) {
        if (!this.sessionTable.containsKey(player.getName().toLowerCase())) {
            return false;
        }
        String recentHost = player.getAddress().getHostName();
        Session session = this.sessionTable.get(player.getName().toLowerCase());
        long timeSpan = System.currentTimeMillis() - session.getTime();
        if (timeSpan < (long)(this.maxSessionTime * 1000)) {
            if (!this.ipCheck) return true;
            if (!session.getAddress().equals(recentHost)) return false;
            return true;
        }
        this.removeSession(player);
        return false;
    }
}

