/*
 * Decompiled with CFR 0.152.
 */
package sh.cereal.bukkit.plugin.AutoSave;

import com.nijiko.permissions.PermissionHandler;
import com.nijikokun.bukkit.Permissions.Permissions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import sh.cereal.bukkit.plugin.AutoSave.AutoSaveConfig;
import sh.cereal.bukkit.plugin.AutoSave.AutoSaveThread;
import sh.cereal.bukkit.plugin.AutoSave.CommandHelper;

public class AutoSave
extends JavaPlugin {
    protected final Logger log = Logger.getLogger("Minecraft");
    public static PermissionHandler PERMISSIONS = null;
    private static final String CONFIG_FILE_NAME = "plugins/AutoSave/config.properties";
    private PluginDescriptionFile pdfFile = null;
    private AutoSaveThread saveThread = null;
    private AutoSaveConfig config = new AutoSaveConfig();

    public void onDisable() {
        this.stopSaveThread();
        this.writeConfigFile();
        this.log.info(String.format("[%s] Version %s is disabled!", this.pdfFile.getName(), this.pdfFile.getVersion()));
    }

    public void onEnable() {
        this.pdfFile = this.getDescription();
        this.log.info(String.format("[%s] Version %s is enabled!", this.pdfFile.getName(), this.pdfFile.getVersion()));
        File file = new File("plugins/AutoSave");
        file.mkdir();
        this.loadConfigFile();
        this.startSaveThread();
    }

    public void obtainPermissions() {
        if (this.config.permissions) {
            Plugin plugin = this.getServer().getPluginManager().getPlugin("Permissions");
            if (PERMISSIONS == null) {
                if (plugin != null) {
                    PERMISSIONS = ((Permissions)plugin).getHandler();
                    this.log.info(String.format("[%s] %s", this.pdfFile.getName(), "Permission system acquired."));
                } else {
                    this.log.info(String.format("[%s] %s", this.pdfFile.getName(), "Permission system not enabled. Disabling plugin."));
                    this.getServer().getPluginManager().disablePlugin((Plugin)this);
                    return;
                }
            }
        }
    }

    public void writeConfigFile() {
        this.log.info(String.format("[%s] Saving config file", this.pdfFile.getName()));
        Properties properties = new Properties();
        properties.setProperty("broadcast.message", this.config.broadcastMessage);
        properties.setProperty("broadcast.enable", String.valueOf(this.config.broadcast));
        properties.setProperty("interval", String.valueOf(this.config.interval));
        properties.setProperty("permissions", String.valueOf(this.config.permissions));
        properties.setProperty("command.insufficentpermissions", this.config.commandInsufficientPermissions);
        properties.setProperty("command.save", this.config.commandSave);
        properties.setProperty("command.starting", this.config.commandStarting);
        properties.setProperty("command.statusfail", this.config.commandStatusFail);
        properties.setProperty("command.statusoff", this.config.commandStatusOff);
        properties.setProperty("command.statussuccess", this.config.commandStatusSuccess);
        properties.setProperty("command.stopping", this.config.commandStopping);
        properties.setProperty("command.intervalnotanumber", this.config.commandIntervalNotANnumber);
        properties.setProperty("command.intervalchangesuccess", this.config.commandIntervalChangeSuccess);
        properties.setProperty("command.intervallookup", this.config.commandIntervalLookup);
        properties.setProperty("command.broadcastchangesuccess", this.config.commandBroadcastChangeSuccess);
        properties.setProperty("command.broadcastlookup", this.config.commandBroadcastLookup);
        properties.setProperty("command.on", this.config.commandOn);
        properties.setProperty("command.off", this.config.commandOff);
        properties.setProperty("command.broadcastnotvalid", this.config.commandBroadcastNotValid);
        properties.setProperty("command.version", this.config.commandVersion);
        try {
            properties.storeToXML(new FileOutputStream(CONFIG_FILE_NAME), null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log.info(String.format("[%s] FileNotFoundException while saving config file", this.pdfFile.getName()));
        }
        catch (IOException iOException) {
            this.log.info(String.format("[%s] IOException while saving config file", this.pdfFile.getName()));
        }
    }

    public void loadConfigFile() {
        this.log.info(String.format("[%s] Loading config file", this.pdfFile.getName()));
        File file = new File(CONFIG_FILE_NAME);
        if (!file.exists()) {
            this.writeConfigFile();
        }
        Properties properties = new Properties();
        try {
            properties.loadFromXML(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log.info(String.format("[%s] FileNotFoundException while loading config file", this.pdfFile.getName()));
        }
        catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
            this.log.info(String.format("[%s] InvalidPropertieFormatException while loading config file", this.pdfFile.getName()));
        }
        catch (IOException iOException) {
            this.log.info(String.format("[%s] IOException while loading config file", this.pdfFile.getName()));
        }
        this.config.interval = Integer.parseInt(properties.getProperty("interval", String.valueOf(this.config.interval)));
        this.config.broadcastMessage = properties.getProperty("announce.message", this.config.broadcastMessage);
        this.config.broadcast = Boolean.parseBoolean(properties.getProperty("broadcast.enable", String.valueOf(this.config.broadcast)));
        this.config.permissions = Boolean.parseBoolean(properties.getProperty("permissions", String.valueOf(this.config.permissions)));
        this.config.commandInsufficientPermissions = properties.getProperty("command.insufficentpermissions", this.config.commandInsufficientPermissions);
        this.config.commandSave = properties.getProperty("command.save", this.config.commandSave);
        this.config.commandStarting = properties.getProperty("command.starting", this.config.commandStarting);
        this.config.commandStatusFail = properties.getProperty("command.statusfail", this.config.commandStatusFail);
        this.config.commandStatusOff = properties.getProperty("command.statusoff", this.config.commandStatusOff);
        this.config.commandStatusSuccess = properties.getProperty("command.statussuccess", this.config.commandStatusSuccess);
        this.config.commandStopping = properties.getProperty("command.stopping", this.config.commandStopping);
        this.config.commandIntervalNotANnumber = properties.getProperty("command.intervalnotanumber", this.config.commandIntervalNotANnumber);
        this.config.commandIntervalChangeSuccess = properties.getProperty("command.intervalchangesuccess", this.config.commandIntervalChangeSuccess);
        this.config.commandIntervalLookup = properties.getProperty("command.intervallookup", this.config.commandIntervalLookup);
        this.config.commandBroadcastChangeSuccess = properties.getProperty("command.broadcastchangesuccess", this.config.commandBroadcastChangeSuccess);
        this.config.commandBroadcastLookup = properties.getProperty("command.broadcastlookup", this.config.commandBroadcastLookup);
        this.config.commandOn = properties.getProperty("command.on", this.config.commandOn);
        this.config.commandOff = properties.getProperty("command.off", this.config.commandOff);
        this.config.commandBroadcastNotValid = properties.getProperty("command.broadcastnotvalid", this.config.commandBroadcastNotValid);
        this.config.commandVersion = properties.getProperty("command.version", this.config.commandVersion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            return false;
        }
        String string2 = command.getName().toLowerCase();
        Player player = (Player)commandSender;
        if (!string2.equals("save")) return false;
        if (stringArray.length == 0) {
            if (this.config.permissions) {
                this.obtainPermissions();
                if (!PERMISSIONS.has(player, "autosave.save")) {
                    commandSender.sendMessage(String.format("%s%s", ChatColor.RED, this.config.commandInsufficientPermissions));
                    return false;
                }
            }
            commandSender.sendMessage(String.format("%s%s", ChatColor.BLUE, this.config.commandSave));
            return this.save();
        }
        if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("toggle")) {
            if (this.config.permissions) {
                this.obtainPermissions();
                if (!PERMISSIONS.has(player, "autosave.toggle")) {
                    commandSender.sendMessage(String.format("%s%s", ChatColor.RED, this.config.commandInsufficientPermissions));
                    return false;
                }
            }
            if (this.saveThread == null) {
                commandSender.sendMessage(String.format("%s%s", ChatColor.BLUE, this.config.commandStarting));
                return this.startSaveThread();
            }
            commandSender.sendMessage(String.format("%s%s", ChatColor.BLUE, this.config.commandStopping));
            return this.stopSaveThread();
        }
        if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("status")) {
            if (this.config.permissions) {
                this.obtainPermissions();
                if (!PERMISSIONS.has(player, "autosave.status")) {
                    commandSender.sendMessage(String.format("%s%s", ChatColor.RED, this.config.commandInsufficientPermissions));
                    return false;
                }
            }
            if (this.saveThread == null) {
                commandSender.sendMessage(String.format("%s%s", ChatColor.BLUE, this.config.commandStatusOff));
                return false;
            }
            if (!this.saveThread.isAlive()) {
                commandSender.sendMessage(String.format("%s%s", ChatColor.BLUE, this.config.commandStatusFail));
                return true;
            }
            Date date = this.saveThread.getLastSave();
            if (date == null) {
                commandSender.sendMessage(String.format("%s%s", ChatColor.BLUE, this.config.commandStatusNotRun));
                return true;
            }
            commandSender.sendMessage(String.format("%s%s", ChatColor.BLUE, this.config.commandStatusSuccess.replaceAll("\\{%DATE%\\}", date.toString())));
            return true;
        }
        if (stringArray.length >= 1 && stringArray[0].equalsIgnoreCase("interval")) {
            if (this.config.permissions) {
                this.obtainPermissions();
                if (!PERMISSIONS.has(player, "autosave.interval")) {
                    commandSender.sendMessage(String.format("%s%s", ChatColor.RED, this.config.commandInsufficientPermissions));
                    return false;
                }
            }
            if (stringArray.length == 1) {
                commandSender.sendMessage(String.format("%s%s", ChatColor.BLUE, this.config.commandIntervalLookup.replaceAll("\\{%INTERVAL%\\}", String.valueOf(this.config.interval))));
                return true;
            }
            if (stringArray.length != 2) return false;
            try {
                int n;
                this.config.interval = n = Integer.parseInt(stringArray[1]);
                commandSender.sendMessage(String.format("%s%s", ChatColor.BLUE, this.config.commandIntervalChangeSuccess.replaceAll("\\{%INTERVAL%\\}", String.valueOf(this.config.interval))));
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                commandSender.sendMessage(String.format("%s%s", ChatColor.RED, this.config.commandIntervalNotANnumber));
                return false;
            }
        }
        if (stringArray.length >= 1 && stringArray[0].equalsIgnoreCase("broadcast")) {
            if (this.config.permissions) {
                this.obtainPermissions();
                if (!PERMISSIONS.has(player, "autosave.broadcast")) {
                    commandSender.sendMessage(String.format("%s%s", ChatColor.RED, this.config.commandInsufficientPermissions));
                    return false;
                }
            }
            if (stringArray.length == 1) {
                commandSender.sendMessage(String.format("%s%s", ChatColor.BLUE, this.config.commandBroadcastLookup.replaceAll("\\{%BROADCAST%\\}", String.valueOf(this.config.broadcast ? this.config.commandOn : this.config.commandOff))));
                return true;
            }
            if (stringArray.length != 2) return false;
            boolean bl = false;
            if (stringArray[1].equalsIgnoreCase(this.config.commandOn)) {
                bl = true;
            } else {
                if (!stringArray[1].equalsIgnoreCase(this.config.commandOff)) {
                    commandSender.sendMessage(String.format("%s%s", ChatColor.RED, this.config.commandBroadcastNotValid.replaceAll("\\{%ON%\\}", this.config.commandOn).replaceAll("\\{%OFF%\\}", this.config.commandOff)));
                    return false;
                }
                bl = false;
            }
            this.config.broadcast = bl;
            commandSender.sendMessage(String.format("%s%s", ChatColor.BLUE, this.config.commandBroadcastChangeSuccess.replaceAll("\\{%BROADCAST%\\}", String.valueOf(this.config.broadcast ? this.config.commandOn : this.config.commandOff))));
            return true;
        }
        if (stringArray.length != 1) return false;
        if (!stringArray[0].equalsIgnoreCase("version")) return false;
        if (this.config.permissions) {
            this.obtainPermissions();
            if (!PERMISSIONS.has(player, "autosave.version")) {
                commandSender.sendMessage(String.format("%s%s", ChatColor.RED, this.config.commandInsufficientPermissions));
                return false;
            }
        }
        commandSender.sendMessage(String.format("%s%s", ChatColor.BLUE, this.config.commandVersion.replaceAll("\\{%VERSION%\\}", this.pdfFile.getVersion())));
        return true;
    }

    public boolean startSaveThread() {
        this.saveThread = new AutoSaveThread(this, this.config);
        this.saveThread.start();
        return true;
    }

    public boolean stopSaveThread() {
        this.saveThread.setRun(false);
        try {
            this.saveThread.join(5000L);
            this.saveThread = null;
            return true;
        }
        catch (InterruptedException interruptedException) {
            this.log.info("Could not stop AutoSaveThread");
            return false;
        }
    }

    public boolean save() {
        return CommandHelper.queueConsoleCommand(this.getServer(), "save-all");
    }
}

