/*
 * Decompiled with CFR 0.152.
 */
package fr.crafter.tickleman.RealPlugin;

import fr.crafter.tickleman.RealPlugin.RealPlugin;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;

public class RealLog {
    private final Logger globalLog = Logger.getLogger("Minecraft");
    private final RealPlugin plugin;
    private final String logFile;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public RealLog(RealPlugin plugin) {
        this.plugin = plugin;
        this.logFile = "plugins/" + plugin.name + "/" + plugin.name.toLowerCase() + ".log";
    }

    private String date() {
        return this.dateFormat.format(new Date());
    }

    public void debug(String text) {
        this.log("DEBUG", text);
    }

    public void debug(String text, boolean global) {
        this.log("DEBUG", text, global);
    }

    public void error(String text) {
        this.log("ERROR", text);
    }

    public void error(String text, boolean global) {
        this.log("ERROR", text, global);
    }

    public void info(String text) {
        this.log("INFO", text);
    }

    public void info(String text, boolean global) {
        this.log("INFO", text, global);
    }

    public void severe(String text) {
        this.log("SEVERE", text, true);
    }

    public void severe(String text, boolean global) {
        this.log("SEVERE", text, global);
    }

    public void warning(String text) {
        this.log("WARNING", text);
    }

    public void warning(String text, boolean global) {
        this.log("WARNING", text, global);
    }

    private void log(String mark, String text) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.logFile, true));
            writer.write(String.valueOf(this.date()) + " [" + mark + "] " + text + "\n");
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            this.globalLog.severe("[" + this.plugin.name + "] Could not write into log file " + this.logFile + " file : [" + mark + "] " + text);
        }
    }

    private void log(String mark, String text, boolean global) {
        this.log(mark, text);
        if (global) {
            if (mark.equals("INFO")) {
                this.globalLog.info("[" + this.plugin.name + "] " + text);
            } else if (mark.equals("WARNING")) {
                this.globalLog.warning("[" + this.plugin.name + "] " + text);
            } else if (mark.equals("SEVERE")) {
                this.globalLog.severe("[" + this.plugin.name + "] " + text);
            } else if (mark.equals("ERROR")) {
                this.globalLog.info("[ERROR] [" + this.plugin.name + "] " + text);
            } else if (mark.equals("DEBUG")) {
                this.globalLog.info("[DEBUG] [" + this.plugin.name + "] " + text);
            }
        }
    }
}

