/*
 * Decompiled with CFR 0.152.
 */
package fr.crafter.tickleman.RealTeleporter;

import fr.crafter.tickleman.RealTeleporter.RealTeleporter;
import fr.crafter.tickleman.RealTeleporter.RealTeleporterPlugin;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class RealTeleportersFile {
    private final RealTeleporterPlugin plugin;
    private final String fileName = "teleporters";
    public HashMap<String, RealTeleporter> byLocation = new HashMap();
    public HashMap<String, RealTeleporter> byName = new HashMap();

    public RealTeleportersFile(RealTeleporterPlugin plugin) {
        this.plugin = plugin;
    }

    public RealTeleportersFile load() {
        this.byLocation = new HashMap();
        this.byName = new HashMap();
        try {
            String buffer;
            this.plugin.log.info("load plugins/" + this.plugin.name + "/" + "teleporters" + ".txt");
            BufferedReader reader = new BufferedReader(new FileReader("plugins/" + this.plugin.name + "/" + "teleporters" + ".txt"));
            while ((buffer = reader.readLine()) != null) {
                String[] line = buffer.split(",");
                if (line.length <= 6 || buffer.charAt(0) == '#') continue;
                try {
                    String name = line[0].trim();
                    String worldName = line[1].trim();
                    long x = Long.parseLong(line[2].trim());
                    long y = Long.parseLong(line[3].trim());
                    long z = Long.parseLong(line[4].trim());
                    String targetName = line[5].trim();
                    char direction = line[6].trim().length() > 0 ? (char)line[6].trim().charAt(0) : (char)'N';
                    String key = String.valueOf(worldName) + ";" + x + ";" + y + ";" + z;
                    RealTeleporter teleporter = new RealTeleporter(name, worldName, x, y, z, targetName, direction);
                    this.byLocation.put(key, teleporter);
                    this.byName.put(name, teleporter);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            reader.close();
        }
        catch (Exception e) {
            this.plugin.log.warning("Needs plugins/" + this.plugin.name + "/" + "teleporters" + ".txt file (will auto-create)");
        }
        this.solve();
        return this;
    }

    public void save() {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter("plugins/" + this.plugin.name + "/" + "teleporters" + ".txt"));
            writer.write("#name,world,x,y,z,target,direction\n");
            for (RealTeleporter teleporter : this.byName.values()) {
                writer.write(String.valueOf(teleporter.name) + "," + teleporter.worldName + "," + teleporter.x + "," + teleporter.y + "," + teleporter.z + "," + teleporter.targetName + "," + teleporter.direction + "\n");
            }
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            this.plugin.log.severe("Could not save plugins/" + this.plugin.name + "/" + "teleporters" + ".txt file");
        }
    }

    public void solve() {
        for (RealTeleporter teleporter : this.byName.values()) {
            if (teleporter.target != null) continue;
            teleporter.target = this.byName.get(teleporter.targetName);
        }
    }

    public RealTeleporter teleporterAt(Player player) {
        Location location = player.getLocation();
        return this.teleporterAt(player.getWorld().getName(), Math.round(Math.floor(location.getX())), Math.round(Math.floor(location.getY())), Math.round(Math.floor(location.getZ())));
    }

    public RealTeleporter teleporterAt(String worldName, long x, long y, long z) {
        String key = String.valueOf(worldName) + ";" + x + ";" + y + ";" + z;
        return this.byLocation.get(key);
    }
}

