package com.nappo.bukkit;

import java.util.HashMap;

import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event.Priority;
import org.bukkit.event.Event.Type;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityListener;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.java.JavaPlugin;

import com.nijikokun.bukkit.Permissions.Permissions;

/**
 * @author Thomas Nappo
 */
public class IBICF extends JavaPlugin {

	/**
	 * Encapsulates active players who are using the set speed.
	 */
	private final HashMap<Player,Double> active = new HashMap<Player,Double>();

	@Override
	public void onDisable() {
		active.clear();
		System.out.println("IBICF has been disabled.");
	}
	
	public boolean permission(Player player, String permission) {
		return Permissions.Security.permission(player, permission);
	}

	@Override
	public void onEnable() {
		getCommand("fly").setExecutor(new CommandExecutor() {

			@Override
			public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
				if (!(sender instanceof Player)) return false;
				Player player = (Player) sender; // Convert sender to a player
				if (!permission(player,"IBICF.fly")) {
					player.sendMessage("You do not have permissions to fly!");
					return true;
				}
				double speed = 0.5;
				if(args.length > 0) speed = Double.parseDouble(args[0]);
				if (speed > 10) {
					sender.sendMessage("Maximum speed is 10!");
					return true;
				}
				if (!active.containsKey(player)) active.put(player, speed);
				else {
					active.remove(player);
					active.put(player, speed);
				}
				player.sendMessage("You are now flying!");
				return true;
			}

		});
		getCommand("land").setExecutor(new CommandExecutor() {

			@Override
			public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
				if (!(sender instanceof Player)) return false;
				Player player = (Player) sender;
				if (!active.containsKey(player)) return true;
				active.remove(player);
				player.sendMessage("You have stopped flying!");
				return true;
			}

		});

		PL pl = new PL();
		
		getServer().getPluginManager().registerEvent(Type.PLAYER_MOVE, pl, Priority.High, this);
		getServer().getPluginManager().registerEvent(Type.PLAYER_RESPAWN, pl, Priority.Highest, this);
		getServer().getPluginManager().registerEvent(Type.ENTITY_DAMAGE, new EntityListener() {
			@Override
			public void onEntityDamage(EntityDamageEvent event) {
				if (event.getEntity() instanceof Player) {
					Player p = (Player) event.getEntity();
					if (active.containsKey(p)) event.setCancelled(true);
				}
			}
		}, Priority.Highest, this);

		System.out.println("IBICF is properly working.");
	}
	
	private class PL extends PlayerListener {
		
		@Override
		public void onPlayerRespawn(PlayerRespawnEvent event) {
			active.remove(event.getPlayer());
		}
		
		@Override
		public void onPlayerMove(PlayerMoveEvent event) {
			Player player = event.getPlayer();
			if (!active.containsKey(player) || !player.isSneaking()) return;
			player.setVelocity(player.getLocation().getDirection().multiply(active.get(player)));
		}
		
	}

}