package com.rawcritics.TyrOvC.OreObfuscationPlugin;

import java.util.ArrayList;

import net.minecraft.server.EnumSkyBlock;

import org.bukkit.Location;
import org.bukkit.block.*;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockListener;
import org.bukkit.inventory.ItemStack;

public class OreObfuscateBlockListener extends BlockListener {
	private final OreObfuscationPluginMain plugin;
	public static byte enginespecificcheck=127;
	
	public OreObfuscateBlockListener(OreObfuscationPluginMain instance) {
		plugin = instance;
	}
	
	@Override
	public void onBlockBreak(BlockBreakEvent event) {
		if(event.isCancelled())return;
		if(event.getPlayer()==null)return;//This way blocks removed by plugins i.e. world edit won't be processed
		
		//Fix for the lighting, don't let blocks that release light have an ore update radius of more then 1
		int oreupdateradius=plugin.oreupdateradius;
		if(event.getBlock().getTypeId()==50 || event.getBlock().getTypeId()==89){oreupdateradius=1;}
		
		CraftBlock blockRemoved = (CraftBlock) event.getBlock();
		int removedx=blockRemoved.getX();
		int removedy=blockRemoved.getY();
		int removedz=blockRemoved.getZ();
		
		ArrayList<CraftPlayer> nearbyplayers=new ArrayList<CraftPlayer>();
		for(Player nearbyplayer : event.getPlayer().getWorld().getPlayers()){
			Location playerlocation=nearbyplayer.getLocation();
			int distancex=(int)(removedx-playerlocation.getX());
			int distancez=(int)(removedz-playerlocation.getZ());
			distancex= distancex < 0 ? -distancex : distancex;
			distancez= distancez < 0 ? -distancez : distancez;
			//Max chunk send out radius to clients without errors in server and clients is 10 anyway, so go 160 plus one chunk blocks
			if(distancex < 176 && distancez < 176){
				nearbyplayers.add((CraftPlayer)nearbyplayer);
			}
		}
		
		int xuntil=removedx+oreupdateradius;
		int yuntil=removedy-oreupdateradius;
		int zuntil=removedz+oreupdateradius;
		for(int x=removedx-oreupdateradius;x<=xuntil;x++){
			for(int z=removedz-oreupdateradius;z<=zuntil;z++){
				for(int y=removedy+oreupdateradius;y>=yuntil;y--){
					if(x==removedx && z==removedz && y==removedy)continue;
					forceblockupdate(blockRemoved.getWorld().getBlockAt(x, y, z), nearbyplayers);
			}
		  }
		}
/*
	if(oreupdateradius>1){
		//Lightingfix
		byte highestlightlevelfound=1;
		byte temp=0;
		if(blockRemoved.getRelative(BlockFace.UP).getTypeId()==0)
			temp=blockRemoved.getRelative(BlockFace.UP).getLightLevel();
		if(temp>highestlightlevelfound)
			highestlightlevelfound=temp;
		if(blockRemoved.getRelative(BlockFace.DOWN).getTypeId()==0)
			temp=blockRemoved.getRelative(BlockFace.DOWN).getLightLevel();
		if(temp>highestlightlevelfound)
			highestlightlevelfound=temp;
		if(blockRemoved.getRelative(BlockFace.NORTH).getTypeId()==0)
			temp=blockRemoved.getRelative(BlockFace.NORTH).getLightLevel();
		if(temp>highestlightlevelfound)
			highestlightlevelfound=temp;
		if(blockRemoved.getRelative(BlockFace.SOUTH).getTypeId()==0)	
			temp=blockRemoved.getRelative(BlockFace.SOUTH).getLightLevel();
		if(temp>highestlightlevelfound)
			highestlightlevelfound=temp;
		if(blockRemoved.getRelative(BlockFace.EAST).getTypeId()==0)
			temp=blockRemoved.getRelative(BlockFace.EAST).getLightLevel();
		if(temp>highestlightlevelfound)
			highestlightlevelfound=temp;				
		if(blockRemoved.getRelative(BlockFace.WEST).getTypeId()==0)
			temp=blockRemoved.getRelative(BlockFace.WEST).getLightLevel();
		if(temp>highestlightlevelfound)
			highestlightlevelfound=temp;
		
		if(highestlightlevelfound>0)
			highestlightlevelfound-=1;
		
		((CraftWorld)blockRemoved.getWorld()).getHandle().b(EnumSkyBlock.BLOCK, removedx, removedy, removedz, highestlightlevelfound);
	}*/
		
	}

	@Override
	public void onBlockDamage(BlockDamageEvent event) {
		if(event.isCancelled())return;
		if(event.getPlayer()==null)return;
		
		//Fix for the lighting fix, don't let blocks that release light have an ore update radius of more then 1
		int oreupdateradius=plugin.oreupdateradius;
		if(event.getBlock().getTypeId()==50 || event.getBlock().getTypeId()==89){oreupdateradius=1;}
		
		CraftBlock blockRemoved = (CraftBlock) event.getBlock();
		int removedx=blockRemoved.getX();
		int removedy=blockRemoved.getY();
		int removedz=blockRemoved.getZ();
		
		ArrayList<CraftPlayer> nearbyplayers=new ArrayList<CraftPlayer>();
		for(Player nearbyplayer : event.getPlayer().getWorld().getPlayers()){
			Location playerlocation=nearbyplayer.getLocation();
			int distancex=(int)(removedx-playerlocation.getX());
			int distancez=(int)(removedz-playerlocation.getZ());
			distancex= distancex < 0 ? -distancex : distancex;
			distancez= distancez < 0 ? -distancez : distancez;
			//Max chunk send out radius to clients without errors in server and clients is 10 anyway, so go 160 plus one chunk blocks
			if(distancex < 176 && distancez < 176){
				nearbyplayers.add((CraftPlayer)nearbyplayer);
			}
		}
		
		int xuntil=removedx+oreupdateradius;
		int yuntil=removedy-oreupdateradius;
		int zuntil=removedz+oreupdateradius;
		for(int x=removedx-oreupdateradius;x<xuntil;x++){
			for(int z=removedz-oreupdateradius;z<zuntil;z++){
				for(int y=removedy+oreupdateradius;y>yuntil;y--){
					if(x==removedx && z==removedz && y==removedy)continue;
					forceblockupdate(blockRemoved.getWorld().getBlockAt(x, y, z), nearbyplayers);
			}
		  }
		}
	}
	
	/*
	 * Little requested API method 
	 * block force update helper for other plugins.
	 */
	
	public static void forceBlockUpdate(Block block) {
		
		//Fix for the lighting fix, don't let blocks that release light have an ore update radius of more then 1
		int oreupdateradius=OreObfuscationPluginMain.oreobfuscationpluginbukkit.oreupdateradius;
		if(block.getTypeId()==50 || block.getTypeId()==89){oreupdateradius=1;}
		
		//CraftBlock blockRemoved = (CraftBlock) block.getBlock();
		int removedx=block.getX();
		int removedy=block.getY();
		int removedz=block.getZ();
		
		ArrayList<CraftPlayer> nearbyplayers=new ArrayList<CraftPlayer>();
		for(Player nearbyplayer : block.getWorld().getPlayers()){
			Location playerlocation=nearbyplayer.getLocation();
			int distancex=(int)(removedx-playerlocation.getX());
			int distancez=(int)(removedz-playerlocation.getZ());
			distancex= distancex < 0 ? -distancex : distancex;
			distancez= distancez < 0 ? -distancez : distancez;
			//Max chunk send out radius to clients without errors in server and clients is 10 anyway, so go 160 plus one chunk blocks
			if(distancex < 176 && distancez < 176){
				nearbyplayers.add((CraftPlayer)nearbyplayer);
			}
		}
		
		int xuntil=removedx+oreupdateradius;
		int yuntil=removedy-oreupdateradius;
		int zuntil=removedz+oreupdateradius;
		for(int x=removedx-oreupdateradius;x<xuntil;x++){
			for(int z=removedz-oreupdateradius;z<zuntil;z++){
				for(int y=removedy+oreupdateradius;y>yuntil;y--){
					if(x==removedx && z==removedz && y==removedy)continue;
					block=block.getWorld().getBlockAt(x, y, z);
					if(block==null)return;
					byte typeid=(byte) block.getTypeId();
					if(typeid==56 || typeid==14 || typeid==15 || typeid==16 || typeid==73 || typeid==21 || typeid==enginespecificcheck){
						for(CraftPlayer player: nearbyplayers){
							player.sendBlockChange(block.getLocation(), typeid, block.getData());
						}
						return;
					}	
					if(typeid==54  && OreObfuscationPluginMain.oreobfuscationpluginbukkit.hidechests){
						Chest chest=(Chest)block.getState();
						if(chest.getBlock().getRelative(BlockFace.UP).getTypeId()!=63 && chest.getBlock().getRelative(BlockFace.NORTH).getTypeId()!=68 && chest.getBlock().getRelative(BlockFace.WEST).getTypeId()!=68&& chest.getBlock().getRelative(BlockFace.SOUTH).getTypeId()!=68&& chest.getBlock().getRelative(BlockFace.EAST).getTypeId()!=68){
							for(CraftPlayer player: nearbyplayers){
								player.sendBlockChange(block.getLocation(), typeid, block.getData());
							}
							return;
						}
					}
			}
		  }
		}
	}
	
	/*
	 * This function causes the real block type of an obfuscated 
	 * block to be sent to the client.
	 */
	
	private void forceblockupdate(Block block, ArrayList<CraftPlayer> nearbyplayers){
		if(block==null)return;
		byte typeid=(byte) block.getTypeId();
		if(typeid==56 || typeid==14 || typeid==15 || typeid==16 || typeid==73 || typeid==21 || typeid==enginespecificcheck){
			for(CraftPlayer player: nearbyplayers){
				player.sendBlockChange(block.getLocation(), typeid, block.getData());
			}
			return;
		}	
		if(typeid==54  && plugin.hidechests){
			Chest chest=(Chest)block.getState();
			if(chest.getBlock().getRelative(BlockFace.UP).getTypeId()!=63 && chest.getBlock().getRelative(BlockFace.NORTH).getTypeId()!=68 && chest.getBlock().getRelative(BlockFace.WEST).getTypeId()!=68&& chest.getBlock().getRelative(BlockFace.SOUTH).getTypeId()!=68&& chest.getBlock().getRelative(BlockFace.EAST).getTypeId()!=68){
				for(CraftPlayer player: nearbyplayers){
					player.sendBlockChange(block.getLocation(), typeid, block.getData());
				}
				return;
			}
		}
	}
	
}
